<?php

use App\Http\Controllers\Admin\Brief\WebBriefController;
use App\Http\Controllers\Admin\Brief\BriefController;
use App\Http\Controllers\Admin\Brief\SemBriefController;
use App\Http\Controllers\Admin\Brief\SmmBriefController;
use App\Http\Controllers\Admin\Brief\VideoBriefController;
use App\Http\Controllers\Admin\Brief\MobileAppBriefController;
use App\Http\Controllers\Admin\CouponBriefcaseController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\StaffController;
use App\Http\Controllers\Payment\PaymentController;
use App\Http\Controllers\Payment\PaynowController;
use App\Http\Controllers\Payment\StripeController;
use App\Http\Controllers\Payment\PayPalController;
use App\Models\Setting;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('admin.login');
})->name('home');

Route::get('/staff/login', function () {
    $brand_settings = Arr::pluck(Setting::get(), 'value', 'key');

    return Inertia::render('Login', [
        'brand_settings' => $brand_settings,
    ]);
})->name('staff.login');

Route::get('/request-password', function () {
    $brand_settings = Arr::pluck(Setting::get(), 'value', 'key');

    return Inertia::render('RequestPassword', [
        'brand_settings' => $brand_settings,
    ]);
})->name('request.password');

Route::post('/request/password/verify', [StaffController::class, 'requestPasswordVerify'])->name('request.password.verify');

Auth::routes();

//Stripe routes
Route::controller(StripeController::class)->group(function () {
    // Stripe - Single shot
    Route::get('/payment/stripe/{token?}', 'index')->name('payment.stripe')->middleware(['verifyPaymentToken']);
    Route::any('/payment/stripe/createPaymentMethod', 'createPaymentMethod')->name('payment.stripe.createPaymentMethod')->middleware(['StripePaymentMiddleware']);
    Route::post('/payment/stripe/paymentIntent_3d', 'paymentIntent_3d')->name('payment.stripe.paymentIntent_3d');

    // Stripe - Three step
    Route::get('/payment/stripe/three_step/{token?}', 'three_step')->name('payment.stripe_three_step')->middleware(['verifyPaymentToken']);
    Route::post('/payment/stripe/paymentIntentThreeStep_3d', 'paymentIntentThreeStep_3d')->name('payment.stripe.paymentIntentThreeStep_3d');
    Route::any('/payment/stripe/createThreeStepPaymentMethod', 'createThreeStepPaymentMethod')->name('payment.stripe.createThreeStepPaymentMethod');
    Route::post('/payment/stripe/PaymentIntent_succeeded', 'PaymentIntent_succeeded')->name('payment.stripe.PaymentIntent_succeeded');

    Route::any('/payment/storePaymentApi', 'success')->name('payment.store.checkout');
});

Route::controller(PaymentController::class)->group(function () {
    Route::get('/payment/success/{token?}', 'success')->name('payment.success');
    Route::get('/payment/failed/{token?}', 'failed')->name('payment.failed');
    Route::get('/payment/expired', 'expired')->name('payment.expired');
    // Route::any('/payment/storePaymentApi', 'storePaymentApi')->name('payment.store.checkout');
    Route::any('/payment/redeemCoupon', 'redeemCoupon')->name('payment.redeem.coupon');
    Route::post('/payment/sendEmailToClient', 'sendEmailToClient')->name('payment.sendEmailToClient');
    Route::get('/payment/previous/{token?}', 'previousData')->name('payment.previousData')->middleware(['verifyPaymentToken']);

    Route::get('/testing', 'checkout')->name('payment.checkout');
    Route::get('/payment/paynow', 'paynow')->name('payment.paynow');
});


Route::controller(PaynowController::class)->group(function () {
    // Stripe - Single shot
    Route::get('/paynow/stripe/{token?}', 'index')->name('paynow.stripe')->middleware(['verifyPaymentToken']);
    Route::post('/paynow/stripe/customer', 'createCustomer')->name('paynow.stripe.createCustomer')->middleware(['PaymentMiddleware', 'isBlockedCustomer', 'custom.radar']);
    Route::post('/paynow/stripe/payment-method', 'createPaymentMethod')->name('paynow.stripe.createPaymentMethod')->middleware(['PaymentMiddleware']);
    Route::post('/paynow/stripe/afterpay', 'chargeAfterPay')->name('paynow.stripe.afterpay')->middleware(['PaymentMiddleware']);
    Route::post('/paynow/stripe/verify-payment', 'verifyPayment')->name('paynow.stripe.verifyPayment')->middleware(['PaymentMiddleware']);
    Route::get('/paynow/stripe/afterpay/success', 'successAfterPay')->name('paynow.stripe.afterpay.success');

    Route::post('/paynow/stripe/verify-threeD-secure', 'verify3DSecure')->name('paynow.stripe.verify.3DSecure');

    // paypal routes
    Route::get('/paynow/paypal/card/{token?}', 'indexPaypalCheckout')->name('paynow.card.paypal')->middleware(['verifyPaymentToken']);
    Route::get('/paynow/paypal/{token?}', 'indexPaypalCheckout')->name('paynow.paypal')->middleware(['verifyPaymentToken']);
    //  Route::post('/paynow/paypal/customer', 'createlocalPaypalCustomer')->name('paynow.paypal.createPaypalCustomer');
    Route::get('/paynow/paypal/success/{token?}', 'successByPaypal')->name('paynow.paypal.success');

    // Stripe - Three step
    Route::get('/paynow/stripe/three_step/{token?}', 'three_step')->name('paynow.stripe_three_step')->middleware(['verifyPaymentToken']);
    Route::post('/paynow/stripe/paymentIntentThreeStep_3d', 'paymentIntentThreeStep_3d')->name('paynow.stripe.paymentIntentThreeStep_3d');
    Route::any('/paynow/stripe/createThreeStepPaymentMethod', 'createThreeStepPaymentMethod')->name('paynow.stripe.createThreeStepPaymentMethod');
    Route::post('/paynow/stripe/PaymentIntent_succeeded', 'PaymentIntent_succeeded')->name('paynow.stripe.PaymentIntent_succeeded');

    Route::any('/paynow/storePaymentApi', 'success')->name('paynow.store.checkout');

    Route::get('/paynow/previous/{token}', 'previousData')->name('paynow.previousData')->middleware(['verifyPaymentToken']);

    Route::get('/paynow/success/{token?}', 'success')->name('paynow.success');
    Route::get('/paynow/failed/{token?}', 'failed')->name('paynow.failed');
});

// paypal route for saving data in db
Route::post('save-payment-data', [PayPalController::class, 'savePaymentData'])->name('paypal.savepayment');
Route::post('paypal/card/checkout', [PayPalController::class, 'paypalCardCheckout'])->name('paypal.card.checkout')->middleware(['PaymentMiddleware']);

Route::controller(InvoiceController::class)->group(function () {
    Route::get('/invoice/download/{id}', 'downloadInvoice')->name('public.invoice.download');
});

Route::controller(CouponController::class)->group(function () {
    Route::post('/coupon/redeem', 'redeemCoupon')->name('coupon.redeem');
});

Route::controller(BriefController::class)->prefix('brief')->group(function () {
    Route::post('/form/submit', 'store')->name('brief.submit');
    // Route::get('/form/{id?}', 'form')->name('brief.form');
    Route::get('/view/{id}', 'view')->name('frontend.brief.view');
    Route::get('/success', 'success')->name('brief.success');
    Route::post('/view/activity', 'viewActivity')->name('brief.view.activity');
});

Route::controller(WebBriefController::class)->prefix('/web-brief')->group(function () {
    Route::post('/form/submit', 'store')->name('web.brief.submit');
    // Route::get('/form/{id?}', 'form')->name('web.brief.form');
    Route::get('/success', 'success')->name('web.brief.success');
    Route::get('/view/{id?}', 'view')->name('frontend.web.brief.view');
});

Route::controller(VideoBriefController::class)->prefix('/video-brief')->group(function () {
    Route::post('/form/submit', 'store')->name('video.brief.submit');
    Route::get('/success', 'success')->name('video.brief.success');
    Route::get('/view/{id?}', 'view')->name('frontend.video.brief.view');
});


Route::get('paypal-redirected', [PayPalController::class, 'successReturn'])->name('paypal.redirected');

Route::controller(SmmBriefController::class)->prefix('/smm-brief')->group(function () {
    Route::post('/form/submit', 'store')->name('smm.brief.submit');
    Route::get('/success', 'success')->name('smm.brief.success');
    Route::get('/view/{id?}', 'view')->name('frontend.smm.brief.view');
});
Route::get('paypal-redirected-cansel', function (Request $request) {
    dd($request->all());
})->name('paypal.redirected.cansel');

// Paypal Routes
Route::post('/paypal/initiate', [PayPalController::class, 'createOrder'])->name('paypal.order.create')->middleware(['PaymentMiddleware']);
Route::post('/paypal/capture/{orderId}', [PayPalController::class, 'captureOrder'])->name('paypal.order.capture');
Route::get('/paypal/success/{client_token}/{paymentID}', [PayPalController::class, 'onSuccess'])->name('paypal.order.success');
Route::get('/paypal/failed/{client_token}/{paymentID}', [PayPalController::class, 'onFailed'])->name('paypal.order.failed');




Route::get('paypal-redirected', [PayPalController::class, 'successReturn'])->name('paypal.redirected');

Route::get('paypal-redirected-cansel', function (Request $request) {
    dd($request->all());
})->name('paypal.redirected.cansel');

// Paypal Routes
Route::post('/paypal/initiate', [PayPalController::class, 'createOrder'])->name('paypal.order.create')->middleware(['PaymentMiddleware']);
Route::post('/paypal/capture/{orderId}', [PayPalController::class, 'captureOrder'])->name('paypal.order.capture');
Route::get('/paypal/success/{client_token}/{paymentID}/{type?}', [PayPalController::class, 'onSuccess'])->name('paypal.order.success');
//Route::get('/paypal/failed/{client_token}/{paymentID}', [PayPalController::class, 'onFailed'])->name('paypal.order.failed');
Route::match(['get', 'post'], '/paypal/failed/{client_token}/{paymentID}', [PayPalController::class, 'onFailed'])->name('paypal.order.failed');

Route::controller(SemBriefController::class)->prefix('/sem-brief')->group(function () {
    Route::post('/form/submit', 'store')->name('sem.brief.submit');
    Route::get('/success', 'success')->name('sem.brief.success');
    Route::get('/view/{id?}', 'view')->name('frontend.sem.brief.view');
});

Route::controller(MobileAppBriefController::class)->prefix('/mobile-app')->group(function () {
    Route::post('/form/submit', 'store')->name('app.brief.submit');
    Route::get('/success', 'success')->name('app.brief.success');
    Route::get('/view/{id?}', 'view')->name('frontend.app.brief.view');
});
