<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Payment Successful | {{ (!empty($data['itemprice']) ? "Amount: ".$data['currency'].$data['itemprice'] : "") }} {{ (!empty($data['itemname']) ? ' | Item Name: ' . $data['itemname'] : '') }}</title>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ (!empty($brand_settings['favicon']) ? asset($brand_settings['favicon']) : asset('backend/assets/images/default/no-image.jpg')) }}">
    
    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,400i&amp;display=swap" rel="stylesheet">
    <link href="{{ asset('frontend/assets/payment/css/style.css?1') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
    <style>

    :root {
            --default-color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }};
            /*--bg-color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '#000000' }};*/
            --bg-color: #f5f4f4;
            --nav-bg-color: {{ isset($brand_settings['secondary_color']) ? $brand_settings['secondary_color'] : '#000000' }};
            --border-radius: 5px;
            --menu-padding: 20px 15px;
            --bg-shadow: rgba(0, 0, 0, 0.06) 1px 1px 0px 1px;
            --bg-padding: 20px;
            --heading-font-size: 24px;
            --container-width: 1170px;
            --default-fontFamily: "Poppins", sans-serif;
            --header-fontFamily: "Poppins", sans-serif;
            --header-fontColor: #ffffff;
        }
        
        .loader-bg { position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, .6); border-radius: calc(var(--border-radius) * 2); z-index: 10000; transition: all .3s; opacity: 0; visibility: hidden; display: flex; justify-content: center; align-items: center; }
        .header { background: {{ isset($brand_settings['secondary_color']) ? $brand_settings['secondary_color'] : '' }}; }
        .header { border: 1px solid {{ isset($brand_settings['secondary_color']) ? $brand_settings['secondary_color'] : '' }};}
        .header { position: relative;  width: 100%; padding: 7px 0 9px 0; z-index: 100;  transition: all .5s; }
        .bg-light {background-color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }}!important;}
        .section-heading {background-color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }}; }
        .section-heading{padding: 3px 10px 3px 3px; border-radius: 5px; color: #fff;}
        .generalClass .section-heading,.generalClass .btn-primary, .generalClass .btn-primary:not(:disabled):not(.disabled).active, .generalClass .btn-primary:not(:disabled):not(.disabled):active, .generalClass .show>.btn-primary.dropdown-toggle {background-color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }}; border-color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }};}
        .generalClass .badge-secondary { color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }}; }
        .generalClass .badge-secondary { padding: .25em 0.6em; font-size: 100%; }
        .badge-secondary { color: {{ isset($brand_settings['primary_color']) ? $brand_settings['primary_color'] : '' }}; }
        .badge-secondary { background-color: #ffffff; margin-right: 10px; border-radius: .25rem 0 0 .25rem; }
        .company_number{ color: #ffffff;}


        .alertmessage{
            border-bottom: 3px solid #5cb85c;
            border-radius: 0;
            box-shadow: 3px 3px 16px -3px #ccc;

        }
        .alertmessage .alertmaindiv{
            display: flex;
            align-items: center;
        }
        .alertmessage .crossicon > a{
            color: #5cb85c;
            text-decoration: none;
            font-size: 40px;
        }
        .alertmessage h5{
            color: #5cb85c;
            margin: 0;
            font-weight: 700;
        }
        .alertmessage p{
            color: #505050;
            line-height: 1.2;
            margin-bottom: 4px;
            font-size: 14px;
            margin-top: 5px;
        }
        .alertmessage .crossicon{
            margin-right: 15px;
            margin-top: -5px;
        }
        .alertmessage .errorcontent a{
            /* margin-left: 41px; */
            color: #5cb85c;
            text-decoration: none;
            font-weight: 600;
        }
    </style>

    <!-- Start of digital3106 Zendesk Widget script -->
    <script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=69d6e9e5-4f5d-498b-8c1c-b209bb31e4ea"> </script>
    <!-- End of digital3106 Zendesk Widget script -->
</head>

<body>

    <header class="header">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-3">
                    <div class="header-logo">
                        <a href="{{ route('home') }}">
                            <img loading="lazy" src="{{ (!empty($brand_settings['logo']) ? asset($brand_settings['logo']) : '') }}" alt="Logo" />
                        </a>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="header-menu">
                        <ul>
                            <li>
                                <a href="tel:{{ !empty($brand_settings['company_phone']) ? $brand_settings['company_phone'] : '' }}"><i class="fa fa-phone">&nbsp;</i>{{ !empty($brand_settings['company_phone']) ? $brand_settings['company_phone'] : '' }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <section class="form-area">
        <div class="container">
            <div class="row mob-reverse">
                <div class="col-md-8">
                        <div class="loader-bg">
                            <i class="fa fa-spinner fa-spin loader-spin" aria-hidden="true"></i>
                        </div>
                        <div class="alert alert-success alertmessage" role="alert">
                        <div class="alertmaindiv">
                            <div class="crossicon">
                                <a href="#"><i class="fa fa-check-circle" aria-hidden="true"></i></a>
                            </div>
                            <div class="errorcontent">
                                <h5>Transaction Successful!</h5>
                                <p>Thank you for choosing our services! We are delighted to inform you that your transaction has been successfully processed. Your satisfaction is our top priority, and we look forward to serving you again in the future.</p>
                            </div>
                        </div>
                    </div>
                     <input type="hidden" id="invoice_id" name="invoice_id" value="{{ (!empty($data['invoice_id']) ? $data['invoice_id'] : '') }}">        
                </div>

                <div class="col-md-4">
                    <div class="details-area">
                        <div class="details-heading">
                            <span class="desktop-num">3</span>
                            <span class="mobile-num">1</span>
                            <h2>Billing Invoice</h2>
                        </div>
                        
                        @php
                            $currencyObj = json_decode($data["currency"]);
                            $currencySymbol = $currencyObj?->symbol;
                            $currencyCode = $currencyObj?->code;
                        @endphp

                        <ul class="packageDetails">
                            <li>
                                <h5>{{ (!empty($data["itemname"]) ? $data["itemname"] : "") }}</h5>
                            </li>
                            <li>
                                <span class="thickfont">Item Price</span>
                                <b>{{ $currencySymbol }} {{ (!empty($data["itemprice"]) ? $data["itemprice"] : "") }}</b>
                            </li>
            
                            <li>
                                <span>Total ({{ $currencyCode }})</span>
                                <strong>{{ $currencySymbol }} {{ (!empty($data["itemprice"]) ? $data["itemprice"] : "") }}</strong>
                            </li>
                            <!-- <li class="list-group-item d-flex justify-content-center">
                                <a href="route('client.payment.download.invoice',['id'=>$data['payment_id'],'download'=>'pdf'])" class="btn btn-success">Download Invoice</a>
                            </li> -->
                        </ul>

                        <div class="complete">
                            <img src="{{ asset('frontend/assets/payment/img/4.jpg') }}" alt="moneyback" />
                            <img src="{{ asset('frontend/assets/payment/img/5.png') }}" alt="moneyback" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.15/js/intlTelInput.min.js"></script>

    <script>
        /* var invoice_id = $("#invoice_id").val();
        $.ajax({
            type: "POST",
            url: '{{ route("payment.sendEmailToClient") }}',
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            data: {invoice_id:invoice_id},                     
            success: function(result) {
           
            if(result == true) {
                console.log("Sent.");
            } else {
                console.log(result.data.message);
            }
            
       }}); */
        
    </script>

</body>
</html>