<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-sidebar-visibility="show" data-layout-style="default" data-layout-mode="light" data-layout-width="fluid" data-layout-position="fixed">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="{{ asset('backend/js/layout.js') }}"></script>
  <!-- Bootstrap Css -->
  <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
  <link href="{{ asset('backend/fonts/SegoeUI/style.css') }}" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="{{ asset('backend/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
  <style>
    body {
        font-family: apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    }
   .main-div{
    background-color: #ebebeb;
    height: 100%;
    width: 100%;
    padding: 2.5rem 1rem;
}

.sections-div{
    margin: auto;
    max-width: 50rem;
}

.border-top{
    border: none;
    padding: 0;
    height: 1.45rem;
    background-color: #625afa;
    margin-top: -31px;
    width: 800px;
    margin-left: -16px;
}
.section{
    background-color: white;
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 0.5rem;
    /* overflow: hidden; */
    }
.break-page {
    page-break-inside: avoid;
}
.header-section{
    padding-top: 2rem;
    overflow: hidden;
}

.heading{
    font-weight: 600;
    color: #525252;
    margin-bottom: 0;
}

 .header-heading{
    margin-bottom: 1rem;
}

.header-description{
    margin: 10px 0;
}

.description{
    font-size: 14px;
    color: #666;
    line-height: 0.75rem;
}

.input-fieldset{
    margin-bottom: 1rem;
    display: flex;
    flex-direction: column;
    width: 100%;
    flex-basis: 50%;
    border: 1px solid rgba(0, 0, 0, 0);
}

.input-label{
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 0;
}

.label-description{
    font-size: 12px;
    color: #666;
    margin-top: -0.25rem;
}

.mb-2{
    vertical-align: 0.5rem;
}

.input{
    min-height: 15px;
    height: auto;
    padding: 0.6rem;
    border-radius: 6px;
    border: 0;
    font-size: 12px;
    border: 2px solid #e5e5e5;
    width: 94%;
    margin-top: 0.3rem;
}

.input:focus{
    outline: none;
}

.checkbox_label{
    margin-left: 0.5rem;
    cursor: pointer;
}

.checkbox_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.checkbox_row label{
    margin-bottom: 0;
    vertical-align: 5px;
}
.checkbox-grid{
    display: flex;
    flex-wrap: wrap;
    width: 40rem;
}

.checkbox-image-container{
    text-align: left;
    width: 100%;
}

.checkbox_image_label{
    display: inline-block;
    width: 45%;
    box-sizing: border-box;
    padding: 0.6rem;
    vertical-align: top;
    text-align: center;
    margin-bottom: 1rem;
}

.checkbox-image-option{
    width: 100%;
    height: auto;
}

.checkbox_image_label:has( input:checked) > .checkbox-image-option {
    border-color: #625afa;
}

.checkbox-description{
    text-align: left;
}

.checkbox-image-input {
    margin-right: 0.2rem;
}

.checkbox-image-input{
    align-self: self-start;
    margin-top: 0.25rem;
    scale: 1.25;
}
.checkbox-description span{
    vertical-align: 5px;
}

.radio_text{
    margin-left: 0.5rem;
    cursor: pointer;
}

.radio_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.radio_row label{
    margin-bottom: 0;
    vertical-align: 3px;
}
.submit-btn{
    display: block;
    width: 100%;
    background-color: #625afa;
    border: none;
    color: white;
    border-radius: 0.25rem;
    padding: 0.5rem 0;
    font-weight: 600;
}

.text-red{
    color: red;;
}

.asterisk{
    color: red;
    font-size: 1.25rem;
}


@media (max-width: 576px) {
    .checkbox_image_label {
        flex-basis: 100%;
    }
}
  </style>
</head>

<body>
    
    <div class="main-div">
        <div class="sections-div">
            <section class="section header-section">
                <div class="border-top"></div>
                <h1 class="header-heading heading">Web Design Questionnaire</h1>
                <p class="header-description description">All correspondence and documents provided will be treated as confidential between the client and the designer, unless consent has been granted by both parties involved.</p>
                <p class="header-description description">
                    <b>NOTE:
                        <ul>
                            <li>
                                Your contact information is safe with us and are never shared with any third party.
                            </li>
                            <li>
                                <span class="asterisk">*</span> Indicates required question.
                            </li>
                        </ul>
                    </b>
                </p>
            </section>

            <form class="form">
                    @if($formData["email"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="email" class="input-label">Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Email" name="email" class="input email-input" value="{{ $formData["email"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["name"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="name" class="input-label">Full Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Name" name="name" class="input name-input" value="{{ $formData["name"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["phone"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="phone" class="input-label">Mobile No <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Mobile Number" name="phone" class="input phone-input" value="{{ $formData["phone"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_name" class="input-label">Business Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Name" name="business_name" class="input business-name-input" value="{{ $formData["business_name"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_address" class="input-label mb-2">Business Address (If Available)</label>
                            <input type="text" placeholder="Enter Your Business Address" name="business_address" class="input business-address-input" value="{{ $formData["business_address"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_phone" class="input-label mb-2">Business Contact Number (If Available)</label>
                            <input type="text" placeholder="Enter Your Business Contact Number" name="business_phone" class="input business-phone-input" value="{{ $formData["business_phone"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_email" class="input-label mb-2">Business Email (If Available)</label>
                            <input type="text" placeholder="Enter Your Business Email" name="business_email" class="input business-email-input" value="{{ $formData["business_email"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="social_media_handles" class="input-label mb-2">Social Media Handles URL (Those you would like to connect to your website)</label>
                            <input type="text" placeholder="Enter Your Social Media Handles" name="social_media_handles" class="input social-media-handles-input" value="{{ $formData["social_media_handles"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website" class="input-label mb-2">Current Website URL (applicable if you have a live business website)</label>
                            <input type="text" placeholder="Enter Your Business Website" name="website" class="input website-input" value="{{ $formData["website"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="web_hosting" class="input-label mb-2">Current Web Hosting Company (if applicable)</label>
                            <input type="text" placeholder="Enter Website's Hosting Company" name="web_hosting" class="input webhosting-input" value="{{ $formData["web_hosting"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="current_domain_address" class="input-label mb-2">Current Domain Address (if applicable)</label>
                            <input type="text" placeholder="Enter Website's Current Domain" name="current_domain_address" class="input current-domain-input" value="{{ $formData["current_domain_address"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="organization_operations" class="input-label mb-2">Please describe your organization's operations in a few sentences. <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Organization Steps" name="organization_operations" class="input organization-steps-input" value="{{ $formData["organization_operations"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Purpose of your website: <span class="asterisk">*</span></legend>
                            <div class="radio_row">
                                <input type="radio" id="business_information" name="website_purpose" value="business_information" {{ $formData["website_purpose"] == 'business_information' ? 'checked' : '' }}>
                                <label for="Relaying information about your business" class="radio_text">Relaying information about your business</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="selling_buying" name="website_purpose" value="selling_buying" {{ $formData["website_purpose"] == 'selling_buying' ? 'checked' : '' }}>
                                <label for="Selling (or buying) Online" class="radio_text">Selling (or buying) Online</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="welfare" name="website_purpose" value="welfare" {{ $formData["website_purpose"] == 'welfare' ? 'checked' : '' }}>
                                <label for="Non-profit/Welfare" class="radio_text">Non-profit/Welfare</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="personal_blogging" name="website_purpose" value="personal_blogging" {{ $formData["website_purpose"] == 'personal_blogging' ? 'checked' : '' }}>
                                <label for="Personal Blogging" class="radio_text">Personal Blogging</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="portfolio_showcasing" name="website_purpose" value="portfolio_showcasing" {{ $formData["website_purpose"] == 'portfolio_showcasing' ? 'checked' : '' }}>
                                <label for="Portfolio Showcasing" class="radio_text">Portfolio Showcasing</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Overall feeling that you would like to portray with your new website: <span class="asterisk">*</span></legend>
                            <div class="checkbox_row">
                                <input type="checkbox" id="corporate" name="portray[]" value="corporate" {{ in_array('corporate', $formData["portray"]) ? 'checked' : '' }}>
                                <label for="corporate" class="checkbox_label">Corporate</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="fun" name="portray[]" value="fun" {{ in_array('fun', $formData["portray"]) ? 'checked' : '' }}>
                                <label for="fun" class="checkbox_label">Fun</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="high-tech" name="portray[]" value="high-tech" {{ in_array('high-tech', $formData["portray"]) ? 'checked' : '' }}>
                                <label for="high-tech" class="checkbox_label">High-tech</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="modern" name="portray[]" value="modern" {{ in_array('modern', $formData["portray"]) ? 'checked' : '' }}>
                                <label for="modern" class="checkbox_label">Modern</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="classic" name="portray[]" value="classic" {{ in_array('classic', $formData["portray"]) ? 'checked' : '' }}>
                                <label for="classic" class="checkbox_label">Classis (Vintage)</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="audience" class="input-label mb-2">Target audience</label>
                            <input type="text" placeholder="Enter Targeted Audience" name="audience" class="input audience-input" value="{{ $formData["audience"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="pages" class="input-label mb-2">Pages you require (except the homepage), e.g. About Us, Services/Products, Contact Us</label>
                            <input type="text" placeholder="Website Pages" name="pages" class="input pages-input" value="{{ $formData["pages"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="competitors" class="input-label mb-2">Similar businesses/competitors</label>
                            <input type="text" placeholder="Enter Your Brand's Competitors" name="competitors" class="input competitors-input" value="{{ $formData["competitors"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website1_url" class="input-label mb-2">Website #1 URL</label>
                            <input type="text" placeholder="Enter Website's #1 URL" name="website1_url" class="input website-url-input" value="{{ $formData["website1_url"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website1_comments" class="input-label mb-2">Website # 1 Comments</label>
                            <input type="text" placeholder="Enter Website # 1 Comments" name="website1_comments" class="input website-comment-input" value="{{ $formData["website1_comments"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website2_url" class="input-label mb-2">Website #2 URL</label>
                            <input type="text" placeholder="Enter Website's #2 URL" name="website2_url" class="input website-url-input" value="{{ $formData["website2_url"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website2_comments" class="input-label mb-2">Website # 2 Comments</label>
                            <input type="text" placeholder="Enter Website # 2 Comments" name="website2_comments" class="input website-comment-input" value="{{ $formData["website2_comments"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website3_url" class="input-label mb-2">Website #3 URL</label>
                            <input type="text" placeholder="Enter Website's #3 URL" name="website3_url" class="input website-url-input" value="{{ $formData["website3_url"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website3_comments" class="input-label mb-2">Website # 3 Comments</label>
                            <input type="text" placeholder="Enter Website # 3 Comments" name="website3_comments" class="input website-comment-input" value="{{ $formData["website3_comments"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_features" class="input-label mb-2">Any specific features/plugins that you plan to incorporate into your website?</label>
                            <input type="text" placeholder="Enter Website Feature" name="website_features" class="input feature-input" value="{{ $formData["website_features"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="maintenance_team" class="input-label mb-2">Do you plan to hire a maintenance team to update your website</label>
                            <input type="text" placeholder="Enter Your Answer" name="maintenance_team" class="input maintenance-input" value="{{ $formData["maintenance_team"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Do you currently have content that you want to use on your new website? <span class="asterisk">*</span></legend>
                            <div class="radio_row">
                                <input type="radio" id="yes" name="website_content" value="yes" {{ $formData["website_content"] == 'yes' ? 'checked' : '' }}>
                                <label for="Yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="no" name="website_content" value="no" {{ $formData["website_content"] == 'no' ? 'checked' : '' }}>
                                <label for="No" class="radio_text">No</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="slogan" class="input-label mb-2">Do you have a tagline/slogan?</label>
                            <input type="text" placeholder="Enter Your Business's Slogan" name="slogan" class="input slogan-input" value="{{ $formData["slogan"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Do you have a high-resolution logo? <span class="asterisk">*</span></legend>
                            <div class="radio_row">
                                <input type="radio" id="yes" name="have_logo" value="yes" {{ $formData["have_logo"] == 'yes' ? 'checked' : '' }}>
                                <label for="Yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="no" name="have_logo" value="no" {{ $formData["have_logo"] == 'no' ? 'checked' : '' }}>
                                <label for="No" class="radio_text">No</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Have you considered redesigning your logo? <span class="asterisk">*</span></legend>
                            <div class="radio_row">
                                <input type="radio" id="yes" name="redesign_logo" value="yes" {{ $formData["redesign_logo"] == 'yes' ? 'checked' : '' }}>
                                <label for="Yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="no" name="redesign_logo" value="no" {{ $formData["redesign_logo"] == 'no' ? 'checked' : '' }}>
                                <label for="No" class="radio_text">No</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_fonts" class="input-label mb-2">What fonts do you typically use?</label>
                            <input type="text" placeholder="Enter Your Preferred Fonts" name="website_fonts" class="input fonts-input" value="{{ $formData["website_fonts"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_colors" class="input-label mb-2">Are there any colors that you want incorporated into the website?</label>
                            <input type="text" placeholder="Enter Your Preferred Colors" name="website_colors" class="input colors-input" value="{{ $formData["website_colors"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="anything_else" class="input-label mb-2">If there is anything else that you would like to add, feel free to use the space below</label>
                            <input type="text" placeholder="Enter Your Answer" name="anything_else" class="input comments-input" value="{{ $formData["anything_else"] }}" >
                        </fieldset>
                    </section>
            </form>
        </div>
    </div>

  <!-- JAVASCRIPT -->
  <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/libs/simplebar/simplebar.min.js') }}"></script>
  <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
  <script src="{{ asset('backend/libs/feather-icons/feather.min.js') }}"></script>
  
  <script src="{{ asset(mix('js/app.js')) }}"></script>