<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-sidebar-visibility="show" data-layout-style="default" data-layout-mode="light" data-layout-width="fluid" data-layout-position="fixed">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="{{ asset('backend/js/layout.js') }}"></script>
  <!-- Bootstrap Css -->
  <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
  <link href="{{ asset('backend/fonts/SegoeUI/style.css') }}" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="{{ asset('backend/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
  <style>
    body {
        font-family: apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    }
   .main-div{
    background-color: #ebebeb;
    height: 97%;
    width: 100%;
    padding: 2.5rem 1rem;
}

.sections-div{
    margin: auto;
    max-width: 50rem;
}

.border-top{
    border: none;
    padding: 0;
    height: 1.45rem;
    background-color: #625afa;
    margin-top: -31px;
    width: 800px;
    margin-left: -16px;
}
.section{
    background-color: white;
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 0.5rem;
    /* overflow: hidden; */
    }
.break-page {
    page-break-inside: avoid;
}
.header-section{
    padding-top: 2rem;
    overflow: hidden;
}

.heading{
    font-weight: 600;
    color: #525252;
    margin-bottom: 0;
}

 .header-heading{
    margin-bottom: 1rem;
}

.header-description{
    margin: 10px 0;
}

.description{
    font-size: 14px;
    color: #666;
    line-height: 0.75rem;
}

.input-fieldset{
    margin-bottom: 1rem;
    display: flex;
    flex-direction: column;
    width: 100%;
    flex-basis: 50%;
    border: 1px solid rgba(0, 0, 0, 0);
}

.input-label{
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 0;
}

.label-description{
    font-size: 12px;
    color: #666;
    margin-top: -0.25rem;
}

.mb-2{
    vertical-align: 0.5rem;
}

.input{
    min-height: 15px;
    height: auto;
    padding: 0.6rem;
    border-radius: 6px;
    border: 0;
    font-size: 12px;
    border: 2px solid #e5e5e5;
    width: 94%;
    margin-top: 0.3rem;
}

.input:focus{
    outline: none;
}

.checkbox_label{
    margin-left: 0.5rem;
    cursor: pointer;
}

.checkbox_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.checkbox_row label{
    margin-bottom: 0;
    vertical-align: 5px;
}
.checkbox-grid{
    display: flex;
    flex-wrap: wrap;
    width: 40rem;
}

.checkbox-image-container{
    text-align: left;
    width: 100%;
}

.checkbox_image_label{
    display: inline-block;
    width: 45%;
    box-sizing: border-box;
    padding: 0.6rem;
    vertical-align: top;
    text-align: center;
    margin-bottom: 1rem;
}

.checkbox-image-option{
    width: 100%;
    height: auto;
}

.checkbox_image_label:has( input:checked) > .checkbox-image-option {
    border-color: #625afa;
}

.checkbox-description{
    text-align: left;
}

.checkbox-image-input {
    margin-right: 0.2rem;
}

.checkbox-image-input{
    align-self: self-start;
    margin-top: 0.25rem;
    scale: 1.25;
}
.checkbox-description span{
    vertical-align: 5px;
}

.radio_text{
    margin-left: 0.5rem;
    cursor: pointer;
}

.radio_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.radio_row label{
    margin-bottom: 0;
    vertical-align: 3px;
}
.submit-btn{
    display: block;
    width: 100%;
    background-color: #625afa;
    border: none;
    color: white;
    border-radius: 0.25rem;
    padding: 0.5rem 0;
    font-weight: 600;
}

.text-red{
    color: red;;
}

.asterisk{
    color: red;
    font-size: 1.25rem;
}


@media (max-width: 576px) {
    .checkbox_image_label {
        flex-basis: 100%;
    }
}
  </style>
</head>

<body>
    
    <div class="main-div">
        <div class="sections-div">
            <section class="section header-section">
                <div class="border-top"></div>
                <h1 class="header-heading heading">SEM Brief Questionnaire</h1>
                <p class="header-description description">Please take your time on the submission below. We will be needing your contact details to deliver your completed work and/or contact you if we have any questions.</p>
                <p class="header-description description">
                    <b>NOTE:
                        <ul>
                            <li>
                                Your contact information is safe with us and are never shared with any third party.
                            </li>
                            <li>
                                <span class="asterisk">*</span> Indicates required question.
                            </li>
                        </ul>
                    </b>
                </p>
            </section>

            <form class="form">
                    @if($formData["email"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="email" class="input-label">Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Email" name="email" class="input email-input" value="{{ $formData["email"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["name"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="name" class="input-label">Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Name" name="name" class="input name-input" value="{{ $formData["name"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="designation" class="input-label">Designation <span class="asterisk">*</span></label>
                            <span class="label-description mb-2">for example, Owner, CEO, Manager, Director, etc</span>
                            <input type="text" placeholder="Enter Your Designation" name="designation" class="input designation-input" value="{{ $formData["designation"] }}" >
                        </fieldset>
                    </section>
                    @if($formData["phone"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="phone" class="input-label">Mobile No <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Mobile Number" name="phone" class="input phone-input" value="{{ $formData["phone"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_name" class="input-label mb-2">Registered Business Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Name" name="business_name" class="input business-name-input" value="{{ $formData["business_name"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_idea" class="input-label mb-2">What is your business idea? (product/service) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Idea" name="business_idea" class="input business-idea-input" value="{{ $formData["business_idea"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="competitors" class="input-label mb-2">List all your competitors <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter competitors" name="competitors" class="input competitors-input" value="{{ $formData["competitors"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="product_strengths" class="input-label mb-2">What are the strengths of your product/service? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter your answer" name="product_strengths" class="input product-strengths-input" value="{{ $formData["product_strengths"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="product_weaknesses" class="input-label mb-2">What are the weaknesses of your product/service? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter your answer" name="product_weaknesses" class="input product-weaknesses-input" value="{{ $formData["product_weaknesses"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="actions" class="input-label mb-2">What actions do you want visitors to take on your website? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter your answer" name="actions" class="input actions-input" value="{{ $formData["actions"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">What purpose you wish to solve or achieve from this campaign? <span class="asterisk">*</span></legend>
                            <div class="radio_row">
                                <input type="radio" id="build_brand_awareness" name="campaign_purpose" value="build_brand_awareness" {{ $formData["campaign_purpose"] == 'build_brand_awareness' ? 'checked' : '' }}>
                                <label for="Build Brand Awareness" class="radio_text">Build Brand Awareness</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="drive_leads" name="campaign_purpose" value="drive_leads" {{ $formData["campaign_purpose"] == 'drive_leads' ? 'checked' : '' }}>
                                <label for="Drive Leads" class="radio_text">Drive Leads</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="content_downloads" name="campaign_purpose" value="content_downloads" {{ $formData["campaign_purpose"] == 'content_downloads' ? 'checked' : '' }}>
                                <label for="Content Downloads" class="radio_text">Content Downloads</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="sign_ups" name="campaign_purpose" value="sign_ups" {{ $formData["campaign_purpose"] == 'sign_ups' ? 'checked' : '' }}>
                                <label for="Sign Ups" class="radio_text">Sign Ups</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="increase_website_traffic" name="campaign_purpose" value="increase_website_traffic" {{ $formData["campaign_purpose"] == 'increase_website_traffic' ? 'checked' : '' }}>
                                <label for="Increase Website Traffic" class="radio_text">Increase Website Traffic</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="generate_revenue" name="campaign_purpose" value="generate_revenue" {{ $formData["campaign_purpose"] == 'generate_revenue' ? 'checked' : '' }}>
                                <label for="Generate Revenue" class="radio_text">Generate Revenue</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="landing_pages" class="input-label mb-2">What landing pages do you want to target? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter your answer" name="landing_pages" class="input landing-pages-input" value="{{ $formData["landing_pages"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="u_s_p" class="input-label mb-2">What makes you different from your competitors? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter your unique selling points" name="u_s_p" class="input u-s-p-input" value="{{ $formData["u_s_p"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="target_places" class="input-label mb-2">List the cities or states, or counties that you want to target <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter your answer" name="target_places" class="input target-places-input" value="{{ $formData["target_places"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Please specify the amount you wish to spend on this campaign monthly. <span class="asterisk">*</span></legend>
                            <div class="checkbox_row">
                                <input type="checkbox" id="USD_500" name="budget[]" value="USD_500" {{ in_array('USD_500', $formData["budget"]) ? 'checked' : '' }}>
                                <label for="USD_500" class="checkbox_label">USD - 500</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="USD_600" name="budget[]" value="USD_600" {{ in_array('USD_600', $formData["budget"]) ? 'checked' : '' }}>
                                <label for="USD_600" class="checkbox_label">USD - 600</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="USD_700" name="budget[]" value="USD_700" {{ in_array('USD_700', $formData["budget"]) ? 'checked' : '' }}>
                                <label for="USD_700" class="checkbox_label">USD - 700</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="USD_800" name="budget[]" value="USD_800" {{ in_array('USD_800', $formData["budget"]) ? 'checked' : '' }}>
                                <label for="USD_800" class="checkbox_label">USD - 800</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="more_than_USD_800" name="budget[]" value="more_than_USD_800" {{ in_array('more_than_USD_800', $formData["budget"]) ? 'checked' : '' }}>
                                <label for="more_than_USD_800" class="checkbox_label">More than USD - 800</label>
                            </div>
                        </fieldset>
                    </section> 
            </form>
        </div>
    </div>

  <!-- JAVASCRIPT -->
  <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/libs/simplebar/simplebar.min.js') }}"></script>
  <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
  <script src="{{ asset('backend/libs/feather-icons/feather.min.js') }}"></script>
  
  <script src="{{ asset(mix('js/app.js')) }}"></script>