@extends('admin.layouts.main')
@section('page')
<!-- start page title -->
<div class="row">
  <div class="col-12">
    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
      <h4 class="mb-sm-0">Products</h4>

      <div class="page-title-right">
        <ol class="breadcrumb m-0">
          <!-- <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li> -->
          <li class="breadcrumb-item active">Products</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<!-- end page title -->

<div class="row">
  <div class="col-lg-12">
    <div class="card">
      <div class="card-header pt-0 pb-0">
        <div class="row align-items-center">
          <div class="col-md-6">
            <ul class="nav nav-tabs nav-tabs-custom nav-success border-0" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#all-products" role="tab">
                  All products
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#coupons" role="tab">
                  Coupons
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#shipping-rates" role="tab">
                  Shipping rates
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tax-rates" role="tab">
                  Tax rates
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#pricing-tables" role="tab">
                  Pricing tables
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-6">
            <div class="btn-group float-end margin-between">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="ri-add-line align-bottom me-1"></i>
                Add product
              </button>
            </div>
            <div class="btn-group float-end white-background-btns margin-between">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i data-feather="upload"></i>
                Export
              </button>
            </div>
            <div class="btn-group float-end white-background-btns margin-between">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="ri-flask-fill align-bottom me-1"></i>
                Filter
              </button>
            </div>
          </div>
        </div>
      </div>
      <div class="card-body">
        <div class="tab-content text-muted">
          <div class="tab-pane active" id="all-products" role="tabpanel">
            <ul class="payment-top-filters">
              <li>
                <button type="button" class="btn active">
                  <span>All</span>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Available</span>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Archived</span>
                </button>
              </li>
            </ul>
            <table id="scroll-horizontal" class="table nowrap align-middle productsTables" style="width: 100%">
              <thead>
                <tr>
                  <th scope="col" style="width: 10px">
                  </th>
                  <th>Name</th>
                  <th style="width: 10px">Created</th>
                  <th style="width: 10px">Updated</th>
                  <th style="width: 10px"></th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th scope="row" style="width: 10px">
                    <img src="https://stripe-camo.global.ssl.fastly.net/600ca418808e8a919c8b8c0bda0ebe2d61594c36ef53da5a89f5485ad5cdae67/68747470733a2f2f66696c65732e7374726970652e636f6d2f6c696e6b732f4d44423859574e6a64463878546c64434d4642435a575a744d3231695457453266475a735833526c6333526664476c32526b3959596c4a506158525261564e32613274454e554e495157637a30305578504244484364">
                  </th>
                  <td>
                    <p>Webdesign</p>
                    <span>$300.00 USD</span>
                  </td>
                  <td>Aug 21</td>
                  <td>Aug 21</td>
                  <td>
                    <ul class="payment-actionListUl">
                      <li>
                        <div class="dropdown d-inline-block">
                          <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-fill align-middle"></i>
                          </button>
                          <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                              <a href="#!" class="dropdown-item">
                                Edit product
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Archive product
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item text-red">
                                Delete product
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </td>
                </tr>
                <tr>
                  <th scope="row" style="width: 10px">
                    <img src="https://stripe-camo.global.ssl.fastly.net/600ca418808e8a919c8b8c0bda0ebe2d61594c36ef53da5a89f5485ad5cdae67/68747470733a2f2f66696c65732e7374726970652e636f6d2f6c696e6b732f4d44423859574e6a64463878546c64434d4642435a575a744d3231695457453266475a735833526c6333526664476c32526b3959596c4a506158525261564e32613274454e554e495157637a30305578504244484364">
                  </th>
                  <td>
                    <p>Logo Design</p>
                    <span>$12.00 USD</span>
                  </td>
                  <td>Aug 2</td>
                  <td>Aug 2</td>
                  <td>
                    <ul class="payment-actionListUl">
                      <li>
                        <div class="dropdown d-inline-block">
                          <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-fill align-middle"></i>
                          </button>
                          <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                              <a href="#!" class="dropdown-item">
                                Edit product
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Archive product
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item text-red">
                                Delete product
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--end col-->
</div>
<!--end row-->
@endsection