@extends('admin.layouts.main')
@section('page')
<!-- start page title -->
<div class="row">
  <div class="col-12">
    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
      <h4 class="mb-sm-0">Customers</h4>

      <div class="page-title-right">
        <ol class="breadcrumb m-0">
          <!-- <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li> -->
          <li class="breadcrumb-item active">Customers</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<!-- end page title -->

<div class="row">
  <div class="col-lg-12">
    <div class="card">
      <div class="card-header pt-0 pb-0">
        <div class="row align-items-center">
          <div class="col-md-6">
            <ul class="nav nav-tabs nav-tabs-custom nav-success border-0" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#overview" role="tab">
                  Overview
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#remaining-balances" role="tab">
                  Remaining balances
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-6">
            <div class="btn-group float-end create-payment-btn">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm dropdown-toggle">
                <i class="ri-add-line align-bottom me-1"></i>
                Add Customer
              </button>
            </div>
          </div>
        </div>
      </div>
      <div class="card-body">
        <div class="tab-content text-muted">
          <div class="tab-pane active" id="overview" role="tabpanel">
            <div class="row align-items-center">
              <div class="col-md-6">
                <ul class="payment-second-filter">
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Email
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Email</label>
                          </div>
                          <div class="dropdown-next-area mb-2">
                            <div class="text-nowrap">
                              is equal to
                            </div>
                            <input type="number" />
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Card
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Card</label>
                          </div>
                          <div class="mb-2">
                            <select>
                              <option value="true">
                                has an active card
                              </option>
                              <option value="false">
                                does not have an active card
                              </option>
                            </select>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Created Date
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Created Date</label>
                          </div>
                          <div class="mb-2">
                            <select>
                              <option value="inTheLast">
                                is in the last
                              </option>
                              <option value="equals">
                                is equal to
                              </option>
                              <option value="between">
                                is between
                              </option>
                              <option value="isAfter">
                                is after
                              </option>
                              <option value="isAfterOrOn">
                                is on or after
                              </option>
                              <option value="isBefore">
                                is before
                              </option>
                              <option value="isBeforeOrOn">
                                is before or on
                              </option>
                            </select>
                          </div>
                          <div class="dropdown-next-area mb-2">
                            <div class="next">
                              <i class="bx bx-subdirectory-right"></i>
                            </div>
                            <input type="number" />
                            <select>
                              <option value="days">days</option>
                              <option value="months">months</option>
                            </select>
                          </div>
                          <div class="dropdown-next-area mb-2">
                            <div class="text-nowrap">
                              Time zone:
                            </div>
                            <div class="form-check form-radio-primary">
                              <input class="form-check-input" type="radio" name="formradiocolor1" id="gtm-2" checked>
                              <label class="form-check-label" for="gtm-2">
                                GTM+2
                              </label>
                            </div>
                            <div class="form-check form-radio-primary">
                              <input class="form-check-input" type="radio" name="formradiocolor1" id="utc" checked>
                              <label class="form-check-label" for="utc">
                                UTC
                              </label>
                            </div>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Type
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Type</label>
                          </div>
                          <div class="mb-2">
                            <select>
                              <option value="customer">
                                Customer account
                              </option>
                              <option value="guest">
                                Guest
                              </option>
                            </select>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
              <div class="col-md-6">
                <ul class="payment-columns-filter">
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light">
                        <i class="ri-file-copy-2-line"></i>
                        Copy
                      </button>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light">
                        <i data-feather="upload"></i>
                        Export
                      </button>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-settings-5-fill"></i>
                        Edit columns
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form class="activeColumnsForm">
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">FIXED COLUMNS</label>
                            <ul class="activeColumnsUl">
                              <li>Name</li>
                            </ul>
                          </div>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">ACTIVE COLUMNS</label>
                            <ul class="activeColumnsUl">
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns1" checked />
                                  <label class="form-check-label" for="activeColumns1">
                                    Email
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns2" checked />
                                  <label class="form-check-label" for="activeColumns2">
                                    Default payment method
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns3" checked />
                                  <label class="form-check-label" for="activeColumns3">
                                    Created
                                  </label>
                                </div>
                              </li>
                            </ul>
                          </div>
                          <div>
                            <label class="form-label" for="exampleDropdownFormEmail">AVAILABLE COLUMNS</label>
                            <ul class="activeColumnsUl">
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns4" />
                                  <label class="form-check-label" for="activeColumns4">
                                    Cardholder name
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns5" />
                                  <label class="form-check-label" for="activeColumns5">
                                    Customer
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns6" />
                                  <label class="form-check-label" for="activeColumns6">
                                    Customer ID
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns7" />
                                  <label class="form-check-label" for="activeColumns7">
                                    Description
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns8" />
                                  <label class="form-check-label" for="activeColumns8">
                                    Subscription
                                  </label>
                                </div>
                              </li>
                            </ul>
                          </div>
                        </form>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <table id="scroll-horizontal" class="table nowrap align-middle" style="width: 100%">
              <thead>
                <tr>
                  <th scope="col" style="width: 10px">
                    <div class="form-check">
                      <input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option" />
                    </div>
                  </th>
                  <th style="width: 10px">Name</th>
                  <th style="width: 10px"></th>
                  <th style="width: 10px">Email</th>
                  <th style="width: 10px">Default payment method</th>
                  <th style="width: 10px">Created</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th scope="row">
                    <div class="form-check">
                      <input class="form-check-input fs-15" type="checkbox" name="checkAll" value="option1" />
                    </div>
                  </th>
                  <td><b>John Doe</b></td>
                  <td></td>
                  <td>shawn.logoorbit@gmail.com</td>
                  <td></td>
                  <td>Aug 2, 8:02 AM</td>
                  <td></td>
                </tr>
                <tr>
                  <th scope="row">
                    <div class="form-check">
                      <input class="form-check-input fs-15" type="checkbox" name="checkAll" value="option1" />
                    </div>
                  </th>
                  <td><b>John Doe</b></td>
                  <td></td>
                  <td>shawn.logoorbit@gmail.com</td>
                  <td></td>
                  <td>Aug 2, 8:02 AM</td>
                  <td></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--end col-->
</div>
<!--end row-->
@endsection