@extends('admin.layouts.main')

@section('page')
<!-- start page title -->
<div class="row">
  <div class="col-12">
    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
      <h4 class="mb-sm-0">Billing</h4>

      <div class="page-title-right">
        <ol class="breadcrumb m-0">
          <!-- <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li> -->
          <li class="breadcrumb-item active">Billing</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<!-- end page title -->

<div class="row">
  <div class="col-lg-12">
    <div class="card">
      <div class="card-header pt-0 pb-0">
        <div class="row align-items-center">
          <div class="col-md-6">
            <ul class="nav nav-tabs nav-tabs-custom nav-success border-0" role="tablist">
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#overview" role="tab">
                  Overview
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#invoices" role="tab">
                  Invoices
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#subscriptions" role="tab">
                  Subscriptions
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#quotes" role="tab">
                  Quotes
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#test-clocks" role="tab">
                  Test clocks
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-6">
            <div class="btn-group float-end margin-between">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" onclick="window.location = `{{ route('admin.billing.invoice') }}`">
                <i class="ri-add-line align-bottom me-1"></i>
                Create test invoice
              </button>
            </div>
            <div class="btn-group float-end white-background-btns margin-between">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i data-feather="upload"></i>
                Export
              </button>
            </div>
            <div class="btn-group float-end white-background-btns margin-between">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="ri-flask-fill align-bottom me-1"></i>
                Filter
              </button>
            </div>
          </div>
        </div>
      </div>
      <div class="card-body">
        <div class="tab-content text-muted">
          <div class="tab-pane active" id="invoices" role="tabpanel">
            <ul class="payment-top-filters">
              <li>
                <button type="button" class="btn active">
                  <span>All invoices</span>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Draft</span>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Outstanding</span>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Past due</span>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Paid</span>
                </button>
              </li>
            </ul>
            <table id="scroll-horizontal" class="table nowrap align-middle productsTables" style="width: 100%">
              <thead>
                <tr>
                  <th style="width: 10px">Amount</th>
                  <th style="width: 10px"></th>
                  <th style="width: 10px"></th>
                  <th style="width: 10px">Invoice Number</th>
                  <th>Customer</th>
                  <th style="width: 10px">Due</th>
                  <th style="width: 10px">Created</th>
                  <th style="width: 10px"></th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><b>$2,222.00</b></td>
                  <td>USD</td>
                  <td>
                    <span class="badge badge-soft-success">
                      Succeeded
                      <i class="ri-check-line"></i>
                    </span>
                  </td>
                  <td>D326854C-DRAFT</td>
                  <td>inhouseteam502@gmail.com</td>
                  <td>Nov 7</td>
                  <td>Oct 8, 7:22 PM</td>
                  <td>
                    <ul class="payment-actionListUl">
                      <li>
                        <div class="dropdown d-inline-block">
                          <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-fill align-middle"></i>
                          </button>
                          <ul class="dropdown-menu dropdown-menu-end drop-down-colors">
                            <li class="dropHead">
                              <a href="#!" class="dropdown-item">Actions</a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Download PDF
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Edit invoice
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Duplicate invoice
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item text-red">
                                Delete draft
                              </a>
                            </li>
                            <li class="dropHead">
                              <a href="#!" class="dropdown-item">
                                Connections
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                View customer
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--end col-->
</div>
<!--end row-->
@endsection