import "../../../../../css/toast.css";
import { h } from "vue";
import { toast } from "vue3-toastify";

export function useRefundNotification(setting = {}) {
    const isEmptyConfig = Object.keys(setting).length === 0;

    if (isEmptyConfig) {
        setting = {
            autoClose: 3000,
            theme: "dark",
            type: "success",
            position: "bottom-center",
        };
    }
    function renderToast(message, btnText, callback, successCount, failCount, cancelCount) {
        return h('div', {
            style: {
                display: 'flex',
                width: '100%',
                justifyContent: 'space-between',
                alignItems: 'center',
            }
        }, [
            h('div', [
                h('p', {
                    style: {
                        marginBottom: '0px',
                    }
                }, message),
                h('small', {
                    style: {
                        marginBottom: '0px',
                        fontWeight: '500',
                        color: '#bababa',
                    }
                }, `${successCount} successful, ${failCount} failed, ${cancelCount} Cancelled`),
            ]),
    
            h('span', {
                style: {
                    borderLeft: '1px solid gray',
                    height: '4rem',
                    margin: '-1rem 0rem',
                    paddingLeft: '0.5rem',
                    placeContent: 'center',
                },
                onClick: (event) => {
                    event.stopPropagation();
                    callback();
                }
            }, btnText)
        ]);
    }

    function showToast(type, message, btnText, callback, successCount, failCount, cancelCount) {
        let options = {
            position: setting.position,
            theme: setting.theme,
            autoClose: setting.autoClose,
            closeButton: false,
            type: type
        };
        console.log(options);
        let toastId = toast({
            render: () => renderToast(message, btnText, callback, successCount, failCount, cancelCount)
        }, options);
        
        return toastId;
    }

    function loading(message, btnText, callback, successCount, failCount, cancelCount) {
        let options = {
            position: setting.position,
            theme: setting.theme,
            autoClose: setting.autoClose,
            closeButton: false,
        };
        
        let toastId = toast.loading({
            render: () => renderToast(message, btnText, callback, successCount, failCount, cancelCount)
        }, options);
        
        return toastId;
    }

    function update(toastId, type, message, btnText, callback, successCount, failCount, cancelCount) {
        toast.update(toastId, {
            render: () => {
                return renderToast(message, btnText, callback, successCount, failCount, cancelCount);
            },
            type: 'loading',
            autoClose: setting.autoClose,
            closeButton: false,
            position: setting.position,
            theme: setting.theme,
        });
    }

    function success(message, btnText, callback, successCount, failCount, cancelCount) {
        let options = {
            position: setting.position,
            theme: setting.theme,
            autoClose: setting.autoClose,
            closeButton: false,
        };
        
        let toastId = toast.success({
            render: () => renderToast(message, btnText, callback, successCount, failCount, cancelCount)
        }, options);
        
        return toastId;
    }

    function remove(toastID) {
        toast.remove(toastID);
    }

    function initialMessage(message, btnText, callback) {
        return h('div', {
            style: {
                display: 'flex',
                width: '100%',
                justifyContent: 'space-between',
                alignItems: 'center',
            }
        }, [
            h('p', {
                style: {
                    marginBottom: '0px',
                }
            }, message),
            h('span', {
                style: {
                    borderLeft: '1px solid gray',
                    height: '4rem',
                    margin: '-1rem 0rem',
                    paddingLeft: '0.5rem',
                    display: 'flex', // Added display property
                    alignItems: 'center', // Added alignItems property
                },
                onClick: (event) => {
                    event.stopPropagation();
                    callback();
                }
            }, btnText) // Moved btnText as a child of the span element
        ]);
    }

    function custom(message, btnText, callback) {
        const toastId = toast.loading({
            render: () => initialMessage(message, btnText, callback)
        }, {
            position: setting.position,
            theme: setting.theme,
            autoClose: setting.autoClose,
            closeButton: false,
            type: toast.TYPE.DEFAULT
        });

        return toastId;
    }

    return {
        loading,
        success,
        remove,
        update,
        showToast,
        custom
    }
}
