import { computed } from "vue";

export const findByID = (arr, id) => {
  if(arr.length > 0) {
    return arr.find(item => id == item.id);
  } else {
    return {};
  }
};

export const isJsonString = (str) => {
  try {
    return JSON.parse(str);
  } catch (e) {
      return false;
  }
};

export const siteURL = computed(() => process.env.MIX_BRAND_URL);

export const capitalizeWords = (words) => {
  return words.toLowerCase().replace(/(^\w{1})|(\s+\w{1})/g, letter => letter.toUpperCase());
};

export const formatText = (text) => {
    return text.split(/[_ ]/).map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ');
};

export const checkDiscount = (discountType, discount, price = null) => {
    const numericRegex = /^[0-9]+$/;

    if (discount[0] === "0") {
        discount = discount.slice(1);
    }

    if (!numericRegex.test(discount)) {
        discount = 0;
    } else {
        discount = parseInt(discount);
        if (discountType === "percent") {
            if (discount > 100) {
                discount = 100;
            } else if (discount < 0) {
                discount = 0;
            }
        } else {
            if (discount > price) {
                discount = price;
            } else if (discount < 0) {
                discount = 0;
            }
        }
    }

    return {
        discount,
        discountType,
        price,
    };
};
