import { downloadFile } from "../downloadFile";
import { useNotification } from "../useNotification";

export function useDownload() {
  const { success: notifySuccess, error: notifyError } = useNotification();

  const download = (paymentID, invoice_no) => {
    downloadFile(route("admin.invoice.download", { id: paymentID }), invoice_no)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);  
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  const downloadPublicInvoice = (paymentID, invoice_no) => {
    downloadFile(route("public.invoice.download", { id: paymentID }), invoice_no)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);  
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  return {
    download,
    downloadPublicInvoice
  }
}
