(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_Pages_Admin_Customer_Detail_vue"],{

/***/ "./node_modules/@fingerprintjs/fingerprintjs/dist/fp.esm.js":
/*!******************************************************************!*\
  !*** ./node_modules/@fingerprintjs/fingerprintjs/dist/fp.esm.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   componentsToDebugString: () => (/* binding */ componentsToDebugString),
/* harmony export */   "default": () => (/* binding */ index),
/* harmony export */   getFullscreenElement: () => (/* binding */ getFullscreenElement),
/* harmony export */   getUnstableAudioFingerprint: () => (/* binding */ getUnstableAudioFingerprint),
/* harmony export */   getUnstableCanvasFingerprint: () => (/* binding */ getUnstableCanvasFingerprint),
/* harmony export */   getUnstableScreenFrame: () => (/* binding */ getUnstableScreenFrame),
/* harmony export */   getUnstableScreenResolution: () => (/* binding */ getUnstableScreenResolution),
/* harmony export */   getWebGLContext: () => (/* binding */ getWebGLContext),
/* harmony export */   hashComponents: () => (/* binding */ hashComponents),
/* harmony export */   isAndroid: () => (/* binding */ isAndroid),
/* harmony export */   isChromium: () => (/* binding */ isChromium),
/* harmony export */   isDesktopWebKit: () => (/* binding */ isDesktopWebKit),
/* harmony export */   isEdgeHTML: () => (/* binding */ isEdgeHTML),
/* harmony export */   isGecko: () => (/* binding */ isGecko),
/* harmony export */   isTrident: () => (/* binding */ isTrident),
/* harmony export */   isWebKit: () => (/* binding */ isWebKit),
/* harmony export */   load: () => (/* binding */ load),
/* harmony export */   loadSources: () => (/* binding */ loadSources),
/* harmony export */   murmurX64Hash128: () => (/* binding */ murmurX64Hash128),
/* harmony export */   prepareForSources: () => (/* binding */ prepareForSources),
/* harmony export */   sources: () => (/* binding */ sources),
/* harmony export */   transformSource: () => (/* binding */ transformSource),
/* harmony export */   withIframe: () => (/* binding */ withIframe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.mjs");
/**
 * FingerprintJS v4.5.0 - Copyright (c) FingerprintJS, Inc, 2024 (https://fingerprint.com)
 *
 * Licensed under Business Source License 1.1 https://mariadb.com/bsl11/
 * Licensor: FingerprintJS, Inc.
 * Licensed Work: FingerprintJS browser fingerprinting library
 * Additional Use Grant: None
 * Change Date: Four years from first release for the specific version.
 * Change License: MIT, text at https://opensource.org/license/mit/ with the following copyright notice:
 * Copyright 2015-present FingerprintJS, Inc.
 */



var version = "4.5.0";

function wait(durationMs, resolveWith) {
    return new Promise(function (resolve) { return setTimeout(resolve, durationMs, resolveWith); });
}
/**
 * Allows asynchronous actions and microtasks to happen.
 */
function releaseEventLoop() {
    // Don't use setTimeout because Chrome throttles it in some cases causing very long agent execution:
    // https://stackoverflow.com/a/6032591/1118709
    // https://github.com/chromium/chromium/commit/0295dd09496330f3a9103ef7e543fa9b6050409b
    // Reusing a MessageChannel object gives no noticeable benefits
    return new Promise(function (resolve) {
        var channel = new MessageChannel();
        channel.port1.onmessage = function () { return resolve(); };
        channel.port2.postMessage(null);
    });
}
function requestIdleCallbackIfAvailable(fallbackTimeout, deadlineTimeout) {
    if (deadlineTimeout === void 0) { deadlineTimeout = Infinity; }
    var requestIdleCallback = window.requestIdleCallback;
    if (requestIdleCallback) {
        // The function `requestIdleCallback` loses the binding to `window` here.
        // `globalThis` isn't always equal `window` (see https://github.com/fingerprintjs/fingerprintjs/issues/683).
        // Therefore, an error can occur. `call(window,` prevents the error.
        return new Promise(function (resolve) { return requestIdleCallback.call(window, function () { return resolve(); }, { timeout: deadlineTimeout }); });
    }
    else {
        return wait(Math.min(fallbackTimeout, deadlineTimeout));
    }
}
function isPromise(value) {
    return !!value && typeof value.then === 'function';
}
/**
 * Calls a maybe asynchronous function without creating microtasks when the function is synchronous.
 * Catches errors in both cases.
 *
 * If just you run a code like this:
 * ```
 * console.time('Action duration')
 * await action()
 * console.timeEnd('Action duration')
 * ```
 * The synchronous function time can be measured incorrectly because another microtask may run before the `await`
 * returns the control back to the code.
 */
function awaitIfAsync(action, callback) {
    try {
        var returnedValue = action();
        if (isPromise(returnedValue)) {
            returnedValue.then(function (result) { return callback(true, result); }, function (error) { return callback(false, error); });
        }
        else {
            callback(true, returnedValue);
        }
    }
    catch (error) {
        callback(false, error);
    }
}
/**
 * If you run many synchronous tasks without using this function, the JS main loop will be busy and asynchronous tasks
 * (e.g. completing a network request, rendering the page) won't be able to happen.
 * This function allows running many synchronous tasks such way that asynchronous tasks can run too in background.
 */
function mapWithBreaks(items, callback, loopReleaseInterval) {
    if (loopReleaseInterval === void 0) { loopReleaseInterval = 16; }
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var results, lastLoopReleaseTime, i, now;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0:
                    results = Array(items.length);
                    lastLoopReleaseTime = Date.now();
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < items.length)) return [3 /*break*/, 4];
                    results[i] = callback(items[i], i);
                    now = Date.now();
                    if (!(now >= lastLoopReleaseTime + loopReleaseInterval)) return [3 /*break*/, 3];
                    lastLoopReleaseTime = now;
                    return [4 /*yield*/, releaseEventLoop()];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    ++i;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/, results];
            }
        });
    });
}
/**
 * Makes the given promise never emit an unhandled promise rejection console warning.
 * The promise will still pass errors to the next promises.
 * Returns the input promise for convenience.
 *
 * Otherwise, promise emits a console warning unless it has a `catch` listener.
 */
function suppressUnhandledRejectionWarning(promise) {
    promise.then(undefined, function () { return undefined; });
    return promise;
}

/*
 * This file contains functions to work with pure data only (no browser features, DOM, side effects, etc).
 */
/**
 * Does the same as Array.prototype.includes but has better typing
 */
function includes(haystack, needle) {
    for (var i = 0, l = haystack.length; i < l; ++i) {
        if (haystack[i] === needle) {
            return true;
        }
    }
    return false;
}
/**
 * Like `!includes()` but with proper typing
 */
function excludes(haystack, needle) {
    return !includes(haystack, needle);
}
/**
 * Be careful, NaN can return
 */
function toInt(value) {
    return parseInt(value);
}
/**
 * Be careful, NaN can return
 */
function toFloat(value) {
    return parseFloat(value);
}
function replaceNaN(value, replacement) {
    return typeof value === 'number' && isNaN(value) ? replacement : value;
}
function countTruthy(values) {
    return values.reduce(function (sum, value) { return sum + (value ? 1 : 0); }, 0);
}
function round(value, base) {
    if (base === void 0) { base = 1; }
    if (Math.abs(base) >= 1) {
        return Math.round(value / base) * base;
    }
    else {
        // Sometimes when a number is multiplied by a small number, precision is lost,
        // for example 1234 * 0.0001 === 0.12340000000000001, and it's more precise divide: 1234 / (1 / 0.0001) === 0.1234.
        var counterBase = 1 / base;
        return Math.round(value * counterBase) / counterBase;
    }
}
/**
 * Parses a CSS selector into tag name with HTML attributes.
 * Only single element selector are supported (without operators like space, +, >, etc).
 *
 * Multiple values can be returned for each attribute. You decide how to handle them.
 */
function parseSimpleCssSelector(selector) {
    var _a, _b;
    var errorMessage = "Unexpected syntax '".concat(selector, "'");
    var tagMatch = /^\s*([a-z-]*)(.*)$/i.exec(selector);
    var tag = tagMatch[1] || undefined;
    var attributes = {};
    var partsRegex = /([.:#][\w-]+|\[.+?\])/gi;
    var addAttribute = function (name, value) {
        attributes[name] = attributes[name] || [];
        attributes[name].push(value);
    };
    for (;;) {
        var match = partsRegex.exec(tagMatch[2]);
        if (!match) {
            break;
        }
        var part = match[0];
        switch (part[0]) {
            case '.':
                addAttribute('class', part.slice(1));
                break;
            case '#':
                addAttribute('id', part.slice(1));
                break;
            case '[': {
                var attributeMatch = /^\[([\w-]+)([~|^$*]?=("(.*?)"|([\w-]+)))?(\s+[is])?\]$/.exec(part);
                if (attributeMatch) {
                    addAttribute(attributeMatch[1], (_b = (_a = attributeMatch[4]) !== null && _a !== void 0 ? _a : attributeMatch[5]) !== null && _b !== void 0 ? _b : '');
                }
                else {
                    throw new Error(errorMessage);
                }
                break;
            }
            default:
                throw new Error(errorMessage);
        }
    }
    return [tag, attributes];
}
/**
 * Converts a string to UTF8 bytes
 */
function getUTF8Bytes(input) {
    // Benchmark: https://jsbench.me/b6klaaxgwq/1
    // If you want to just count bytes, see solutions at https://jsbench.me/ehklab415e/1
    var result = new Uint8Array(input.length);
    for (var i = 0; i < input.length; i++) {
        // `charCode` is faster than encoding, so we prefer that when it's possible
        var charCode = input.charCodeAt(i);
        // In case of non-ASCII symbols we use proper encoding
        if (charCode > 127) {
            return new TextEncoder().encode(input);
        }
        result[i] = charCode;
    }
    return result;
}

/*
 * Based on https://github.com/karanlyons/murmurHash3.js/blob/a33d0723127e2e5415056c455f8aed2451ace208/murmurHash3.js
 */
/**
 * Adds two 64-bit values (provided as tuples of 32-bit values)
 * and updates (mutates) first value to write the result
 */
function x64Add(m, n) {
    var m0 = m[0] >>> 16, m1 = m[0] & 0xffff, m2 = m[1] >>> 16, m3 = m[1] & 0xffff;
    var n0 = n[0] >>> 16, n1 = n[0] & 0xffff, n2 = n[1] >>> 16, n3 = n[1] & 0xffff;
    var o0 = 0, o1 = 0, o2 = 0, o3 = 0;
    o3 += m3 + n3;
    o2 += o3 >>> 16;
    o3 &= 0xffff;
    o2 += m2 + n2;
    o1 += o2 >>> 16;
    o2 &= 0xffff;
    o1 += m1 + n1;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o0 += m0 + n0;
    o0 &= 0xffff;
    m[0] = (o0 << 16) | o1;
    m[1] = (o2 << 16) | o3;
}
/**
 * Multiplies two 64-bit values (provided as tuples of 32-bit values)
 * and updates (mutates) first value to write the result
 */
function x64Multiply(m, n) {
    var m0 = m[0] >>> 16, m1 = m[0] & 0xffff, m2 = m[1] >>> 16, m3 = m[1] & 0xffff;
    var n0 = n[0] >>> 16, n1 = n[0] & 0xffff, n2 = n[1] >>> 16, n3 = n[1] & 0xffff;
    var o0 = 0, o1 = 0, o2 = 0, o3 = 0;
    o3 += m3 * n3;
    o2 += o3 >>> 16;
    o3 &= 0xffff;
    o2 += m2 * n3;
    o1 += o2 >>> 16;
    o2 &= 0xffff;
    o2 += m3 * n2;
    o1 += o2 >>> 16;
    o2 &= 0xffff;
    o1 += m1 * n3;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o1 += m2 * n2;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o1 += m3 * n1;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o0 += m0 * n3 + m1 * n2 + m2 * n1 + m3 * n0;
    o0 &= 0xffff;
    m[0] = (o0 << 16) | o1;
    m[1] = (o2 << 16) | o3;
}
/**
 * Provides left rotation of the given int64 value (provided as tuple of two int32)
 * by given number of bits. Result is written back to the value
 */
function x64Rotl(m, bits) {
    var m0 = m[0];
    bits %= 64;
    if (bits === 32) {
        m[0] = m[1];
        m[1] = m0;
    }
    else if (bits < 32) {
        m[0] = (m0 << bits) | (m[1] >>> (32 - bits));
        m[1] = (m[1] << bits) | (m0 >>> (32 - bits));
    }
    else {
        bits -= 32;
        m[0] = (m[1] << bits) | (m0 >>> (32 - bits));
        m[1] = (m0 << bits) | (m[1] >>> (32 - bits));
    }
}
/**
 * Provides a left shift of the given int32 value (provided as tuple of [0, int32])
 * by given number of bits. Result is written back to the value
 */
function x64LeftShift(m, bits) {
    bits %= 64;
    if (bits === 0) {
        return;
    }
    else if (bits < 32) {
        m[0] = m[1] >>> (32 - bits);
        m[1] = m[1] << bits;
    }
    else {
        m[0] = m[1] << (bits - 32);
        m[1] = 0;
    }
}
/**
 * Provides a XOR of the given int64 values(provided as tuple of two int32).
 * Result is written back to the first value
 */
function x64Xor(m, n) {
    m[0] ^= n[0];
    m[1] ^= n[1];
}
var F1 = [0xff51afd7, 0xed558ccd];
var F2 = [0xc4ceb9fe, 0x1a85ec53];
/**
 * Calculates murmurHash3's final x64 mix of that block and writes result back to the input value.
 * (`[0, h[0] >>> 1]` is a 33 bit unsigned right shift. This is the
 * only place where we need to right shift 64bit ints.)
 */
function x64Fmix(h) {
    var shifted = [0, h[0] >>> 1];
    x64Xor(h, shifted);
    x64Multiply(h, F1);
    shifted[1] = h[0] >>> 1;
    x64Xor(h, shifted);
    x64Multiply(h, F2);
    shifted[1] = h[0] >>> 1;
    x64Xor(h, shifted);
}
var C1 = [0x87c37b91, 0x114253d5];
var C2 = [0x4cf5ad43, 0x2745937f];
var M$1 = [0, 5];
var N1 = [0, 0x52dce729];
var N2 = [0, 0x38495ab5];
/**
 * Given a string and an optional seed as an int, returns a 128 bit
 * hash using the x64 flavor of MurmurHash3, as an unsigned hex.
 * All internal functions mutates passed value to achieve minimal memory allocations and GC load
 *
 * Benchmark https://jsbench.me/p4lkpaoabi/1
 */
function x64hash128(input, seed) {
    var key = getUTF8Bytes(input);
    seed = seed || 0;
    var length = [0, key.length];
    var remainder = length[1] % 16;
    var bytes = length[1] - remainder;
    var h1 = [0, seed];
    var h2 = [0, seed];
    var k1 = [0, 0];
    var k2 = [0, 0];
    var i;
    for (i = 0; i < bytes; i = i + 16) {
        k1[0] = key[i + 4] | (key[i + 5] << 8) | (key[i + 6] << 16) | (key[i + 7] << 24);
        k1[1] = key[i] | (key[i + 1] << 8) | (key[i + 2] << 16) | (key[i + 3] << 24);
        k2[0] = key[i + 12] | (key[i + 13] << 8) | (key[i + 14] << 16) | (key[i + 15] << 24);
        k2[1] = key[i + 8] | (key[i + 9] << 8) | (key[i + 10] << 16) | (key[i + 11] << 24);
        x64Multiply(k1, C1);
        x64Rotl(k1, 31);
        x64Multiply(k1, C2);
        x64Xor(h1, k1);
        x64Rotl(h1, 27);
        x64Add(h1, h2);
        x64Multiply(h1, M$1);
        x64Add(h1, N1);
        x64Multiply(k2, C2);
        x64Rotl(k2, 33);
        x64Multiply(k2, C1);
        x64Xor(h2, k2);
        x64Rotl(h2, 31);
        x64Add(h2, h1);
        x64Multiply(h2, M$1);
        x64Add(h2, N2);
    }
    k1[0] = 0;
    k1[1] = 0;
    k2[0] = 0;
    k2[1] = 0;
    var val = [0, 0];
    switch (remainder) {
        case 15:
            val[1] = key[i + 14];
            x64LeftShift(val, 48);
            x64Xor(k2, val);
        // fallthrough
        case 14:
            val[1] = key[i + 13];
            x64LeftShift(val, 40);
            x64Xor(k2, val);
        // fallthrough
        case 13:
            val[1] = key[i + 12];
            x64LeftShift(val, 32);
            x64Xor(k2, val);
        // fallthrough
        case 12:
            val[1] = key[i + 11];
            x64LeftShift(val, 24);
            x64Xor(k2, val);
        // fallthrough
        case 11:
            val[1] = key[i + 10];
            x64LeftShift(val, 16);
            x64Xor(k2, val);
        // fallthrough
        case 10:
            val[1] = key[i + 9];
            x64LeftShift(val, 8);
            x64Xor(k2, val);
        // fallthrough
        case 9:
            val[1] = key[i + 8];
            x64Xor(k2, val);
            x64Multiply(k2, C2);
            x64Rotl(k2, 33);
            x64Multiply(k2, C1);
            x64Xor(h2, k2);
        // fallthrough
        case 8:
            val[1] = key[i + 7];
            x64LeftShift(val, 56);
            x64Xor(k1, val);
        // fallthrough
        case 7:
            val[1] = key[i + 6];
            x64LeftShift(val, 48);
            x64Xor(k1, val);
        // fallthrough
        case 6:
            val[1] = key[i + 5];
            x64LeftShift(val, 40);
            x64Xor(k1, val);
        // fallthrough
        case 5:
            val[1] = key[i + 4];
            x64LeftShift(val, 32);
            x64Xor(k1, val);
        // fallthrough
        case 4:
            val[1] = key[i + 3];
            x64LeftShift(val, 24);
            x64Xor(k1, val);
        // fallthrough
        case 3:
            val[1] = key[i + 2];
            x64LeftShift(val, 16);
            x64Xor(k1, val);
        // fallthrough
        case 2:
            val[1] = key[i + 1];
            x64LeftShift(val, 8);
            x64Xor(k1, val);
        // fallthrough
        case 1:
            val[1] = key[i];
            x64Xor(k1, val);
            x64Multiply(k1, C1);
            x64Rotl(k1, 31);
            x64Multiply(k1, C2);
            x64Xor(h1, k1);
        // fallthrough
    }
    x64Xor(h1, length);
    x64Xor(h2, length);
    x64Add(h1, h2);
    x64Add(h2, h1);
    x64Fmix(h1);
    x64Fmix(h2);
    x64Add(h1, h2);
    x64Add(h2, h1);
    return (('00000000' + (h1[0] >>> 0).toString(16)).slice(-8) +
        ('00000000' + (h1[1] >>> 0).toString(16)).slice(-8) +
        ('00000000' + (h2[0] >>> 0).toString(16)).slice(-8) +
        ('00000000' + (h2[1] >>> 0).toString(16)).slice(-8));
}

/**
 * Converts an error object to a plain object that can be used with `JSON.stringify`.
 * If you just run `JSON.stringify(error)`, you'll get `'{}'`.
 */
function errorToObject(error) {
    var _a;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({ name: error.name, message: error.message, stack: (_a = error.stack) === null || _a === void 0 ? void 0 : _a.split('\n') }, error);
}
function isFunctionNative(func) {
    return /^function\s.*?\{\s*\[native code]\s*}$/.test(String(func));
}

function isFinalResultLoaded(loadResult) {
    return typeof loadResult !== 'function';
}
/**
 * Loads the given entropy source. Returns a function that gets an entropy component from the source.
 *
 * The result is returned synchronously to prevent `loadSources` from
 * waiting for one source to load before getting the components from the other sources.
 */
function loadSource(source, sourceOptions) {
    var sourceLoadPromise = suppressUnhandledRejectionWarning(new Promise(function (resolveLoad) {
        var loadStartTime = Date.now();
        // `awaitIfAsync` is used instead of just `await` in order to measure the duration of synchronous sources
        // correctly (other microtasks won't affect the duration).
        awaitIfAsync(source.bind(null, sourceOptions), function () {
            var loadArgs = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                loadArgs[_i] = arguments[_i];
            }
            var loadDuration = Date.now() - loadStartTime;
            // Source loading failed
            if (!loadArgs[0]) {
                return resolveLoad(function () { return ({ error: loadArgs[1], duration: loadDuration }); });
            }
            var loadResult = loadArgs[1];
            // Source loaded with the final result
            if (isFinalResultLoaded(loadResult)) {
                return resolveLoad(function () { return ({ value: loadResult, duration: loadDuration }); });
            }
            // Source loaded with "get" stage
            resolveLoad(function () {
                return new Promise(function (resolveGet) {
                    var getStartTime = Date.now();
                    awaitIfAsync(loadResult, function () {
                        var getArgs = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            getArgs[_i] = arguments[_i];
                        }
                        var duration = loadDuration + Date.now() - getStartTime;
                        // Source getting failed
                        if (!getArgs[0]) {
                            return resolveGet({ error: getArgs[1], duration: duration });
                        }
                        // Source getting succeeded
                        resolveGet({ value: getArgs[1], duration: duration });
                    });
                });
            });
        });
    }));
    return function getComponent() {
        return sourceLoadPromise.then(function (finalizeSource) { return finalizeSource(); });
    };
}
/**
 * Loads the given entropy sources. Returns a function that collects the entropy components.
 *
 * The result is returned synchronously in order to allow start getting the components
 * before the sources are loaded completely.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function loadSources(sources, sourceOptions, excludeSources, loopReleaseInterval) {
    var includedSources = Object.keys(sources).filter(function (sourceKey) { return excludes(excludeSources, sourceKey); });
    // Using `mapWithBreaks` allows asynchronous sources to complete between synchronous sources
    // and measure the duration correctly
    var sourceGettersPromise = suppressUnhandledRejectionWarning(mapWithBreaks(includedSources, function (sourceKey) { return loadSource(sources[sourceKey], sourceOptions); }, loopReleaseInterval));
    return function getComponents() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
            var sourceGetters, componentPromises, componentArray, components, index;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, sourceGettersPromise];
                    case 1:
                        sourceGetters = _a.sent();
                        return [4 /*yield*/, mapWithBreaks(sourceGetters, function (sourceGetter) { return suppressUnhandledRejectionWarning(sourceGetter()); }, loopReleaseInterval)];
                    case 2:
                        componentPromises = _a.sent();
                        return [4 /*yield*/, Promise.all(componentPromises)
                            // Keeping the component keys order the same as the source keys order
                        ];
                    case 3:
                        componentArray = _a.sent();
                        components = {};
                        for (index = 0; index < includedSources.length; ++index) {
                            components[includedSources[index]] = componentArray[index];
                        }
                        return [2 /*return*/, components];
                }
            });
        });
    };
}
/**
 * Modifies an entropy source by transforming its returned value with the given function.
 * Keeps the source properties: sync/async, 1/2 stages.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function transformSource(source, transformValue) {
    var transformLoadResult = function (loadResult) {
        if (isFinalResultLoaded(loadResult)) {
            return transformValue(loadResult);
        }
        return function () {
            var getResult = loadResult();
            if (isPromise(getResult)) {
                return getResult.then(transformValue);
            }
            return transformValue(getResult);
        };
    };
    return function (options) {
        var loadResult = source(options);
        if (isPromise(loadResult)) {
            return loadResult.then(transformLoadResult);
        }
        return transformLoadResult(loadResult);
    };
}

/*
 * Functions to help with features that vary through browsers
 */
/**
 * Checks whether the browser is based on Trident (the Internet Explorer engine) without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isTrident() {
    var w = window;
    var n = navigator;
    // The properties are checked to be in IE 10, IE 11 and not to be in other browsers in October 2020
    return (countTruthy([
        'MSCSSMatrix' in w,
        'msSetImmediate' in w,
        'msIndexedDB' in w,
        'msMaxTouchPoints' in n,
        'msPointerEnabled' in n,
    ]) >= 4);
}
/**
 * Checks whether the browser is based on EdgeHTML (the pre-Chromium Edge engine) without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isEdgeHTML() {
    // Based on research in October 2020
    var w = window;
    var n = navigator;
    return (countTruthy(['msWriteProfilerMark' in w, 'MSStream' in w, 'msLaunchUri' in n, 'msSaveBlob' in n]) >= 3 &&
        !isTrident());
}
/**
 * Checks whether the browser is based on Chromium without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isChromium() {
    // Based on research in October 2020. Tested to detect Chromium 42-86.
    var w = window;
    var n = navigator;
    return (countTruthy([
        'webkitPersistentStorage' in n,
        'webkitTemporaryStorage' in n,
        n.vendor.indexOf('Google') === 0,
        'webkitResolveLocalFileSystemURL' in w,
        'BatteryManager' in w,
        'webkitMediaStream' in w,
        'webkitSpeechGrammar' in w,
    ]) >= 5);
}
/**
 * Checks whether the browser is based on mobile or desktop Safari without using user-agent.
 * All iOS browsers use WebKit (the Safari engine).
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isWebKit() {
    // Based on research in August 2024
    var w = window;
    var n = navigator;
    return (countTruthy([
        'ApplePayError' in w,
        'CSSPrimitiveValue' in w,
        'Counter' in w,
        n.vendor.indexOf('Apple') === 0,
        'RGBColor' in w,
        'WebKitMediaKeys' in w,
    ]) >= 4);
}
/**
 * Checks whether this WebKit browser is a desktop browser.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isDesktopWebKit() {
    // Checked in Safari and DuckDuckGo
    var w = window;
    var HTMLElement = w.HTMLElement, Document = w.Document;
    return (countTruthy([
        'safari' in w,
        !('ongestureend' in w),
        !('TouchEvent' in w),
        !('orientation' in w),
        HTMLElement && !('autocapitalize' in HTMLElement.prototype),
        Document && 'pointerLockElement' in Document.prototype,
    ]) >= 4);
}
/**
 * Checks whether this WebKit browser is Safari.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * Warning! The function works properly only for Safari version 15.4 and newer.
 */
function isSafariWebKit() {
    // Checked in Safari, Chrome, Firefox, Yandex, UC Browser, Opera, Edge and DuckDuckGo.
    // iOS Safari and Chrome were checked on iOS 11-18. DuckDuckGo was checked on iOS 17 and macOS 14.
    // Desktop Safari versions 12-18 were checked.
    // The other browsers were checked on iOS 17 and 18; there was no chance to check them on the other OS versions.
    var w = window;
    return (
    // Filters-out Chrome, Yandex, DuckDuckGo (macOS and iOS), Edge
    isFunctionNative(w.print) &&
        // Doesn't work in Safari < 15.4
        String(w.browser) === '[object WebPageNamespace]');
}
/**
 * Checks whether the browser is based on Gecko (Firefox engine) without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isGecko() {
    var _a, _b;
    var w = window;
    // Based on research in September 2020
    return (countTruthy([
        'buildID' in navigator,
        'MozAppearance' in ((_b = (_a = document.documentElement) === null || _a === void 0 ? void 0 : _a.style) !== null && _b !== void 0 ? _b : {}),
        'onmozfullscreenchange' in w,
        'mozInnerScreenX' in w,
        'CSSMozDocumentRule' in w,
        'CanvasCaptureMediaStream' in w,
    ]) >= 4);
}
/**
 * Checks whether the browser is based on Chromium version ≥86 without using user-agent.
 * It doesn't check that the browser is based on Chromium, there is a separate function for this.
 */
function isChromium86OrNewer() {
    // Checked in Chrome 85 vs Chrome 86 both on desktop and Android
    var w = window;
    return (countTruthy([
        !('MediaSettingsRange' in w),
        'RTCEncodedAudioFrame' in w,
        '' + w.Intl === '[object Intl]',
        '' + w.Reflect === '[object Reflect]',
    ]) >= 3);
}
/**
 * Checks whether the browser is based on WebKit version ≥606 (Safari ≥12) without using user-agent.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * @see https://en.wikipedia.org/wiki/Safari_version_history#Release_history Safari-WebKit versions map
 */
function isWebKit606OrNewer() {
    // Checked in Safari 9–17
    var w = window;
    return (countTruthy([
        'DOMRectList' in w,
        'RTCPeerConnectionIceEvent' in w,
        'SVGGeometryElement' in w,
        'ontransitioncancel' in w,
    ]) >= 3);
}
/**
 * Checks whether the browser is based on WebKit version ≥616 (Safari ≥17) without using user-agent.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * @see https://developer.apple.com/documentation/safari-release-notes/safari-17-release-notes Safari 17 release notes
 * @see https://tauri.app/v1/references/webview-versions/#webkit-versions-in-safari Safari-WebKit versions map
 */
function isWebKit616OrNewer() {
    var w = window;
    var n = navigator;
    var CSS = w.CSS, HTMLButtonElement = w.HTMLButtonElement;
    return (countTruthy([
        !('getStorageUpdates' in n),
        HTMLButtonElement && 'popover' in HTMLButtonElement.prototype,
        'CSSCounterStyleRule' in w,
        CSS.supports('font-size-adjust: ex-height 0.5'),
        CSS.supports('text-transform: full-width'),
    ]) >= 4);
}
/**
 * Checks whether the device is an iPad.
 * It doesn't check that the engine is WebKit and that the WebKit isn't desktop.
 */
function isIPad() {
    // Checked on:
    // Safari on iPadOS (both mobile and desktop modes): 8, 11-17
    // Chrome on iPadOS (both mobile and desktop modes): 11-17
    // Safari on iOS (both mobile and desktop modes): 9-17
    // Chrome on iOS (both mobile and desktop modes): 9-17
    // Before iOS 13. Safari tampers the value in "request desktop site" mode since iOS 13.
    if (navigator.platform === 'iPad') {
        return true;
    }
    var s = screen;
    var screenRatio = s.width / s.height;
    return (countTruthy([
        'MediaSource' in window,
        !!Element.prototype.webkitRequestFullscreen,
        // iPhone 4S that runs iOS 9 matches this, but it is not supported
        screenRatio > 0.65 && screenRatio < 1.53,
    ]) >= 2);
}
/**
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getFullscreenElement() {
    var d = document;
    return d.fullscreenElement || d.msFullscreenElement || d.mozFullScreenElement || d.webkitFullscreenElement || null;
}
function exitFullscreen() {
    var d = document;
    // `call` is required because the function throws an error without a proper "this" context
    return (d.exitFullscreen || d.msExitFullscreen || d.mozCancelFullScreen || d.webkitExitFullscreen).call(d);
}
/**
 * Checks whether the device runs on Android without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isAndroid() {
    var isItChromium = isChromium();
    var isItGecko = isGecko();
    var w = window;
    var n = navigator;
    var c = 'connection';
    // Chrome removes all words "Android" from `navigator` when desktop version is requested
    // Firefox keeps "Android" in `navigator.appVersion` when desktop version is requested
    if (isItChromium) {
        return (countTruthy([
            !('SharedWorker' in w),
            // `typechange` is deprecated, but it's still present on Android (tested on Chrome Mobile 117)
            // Removal proposal https://bugs.chromium.org/p/chromium/issues/detail?id=699892
            // Note: this expression returns true on ChromeOS, so additional detectors are required to avoid false-positives
            n[c] && 'ontypechange' in n[c],
            !('sinkId' in new window.Audio()),
        ]) >= 2);
    }
    else if (isItGecko) {
        return countTruthy(['onorientationchange' in w, 'orientation' in w, /android/i.test(navigator.appVersion)]) >= 2;
    }
    else {
        // Only 2 browser engines are presented on Android.
        // Actually, there is also Android 4.1 browser, but it's not worth detecting it at the moment.
        return false;
    }
}

/**
 * A deep description: https://fingerprint.com/blog/audio-fingerprinting/
 * Inspired by and based on https://github.com/cozylife/audio-fingerprint
 *
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 * Audio signal is noised in private mode of Safari 17, so audio fingerprinting is skipped in Safari 17.
 */
function getAudioFingerprint() {
    if (doesBrowserPerformAntifingerprinting$1()) {
        return -4 /* SpecialFingerprint.KnownForAntifingerprinting */;
    }
    return getUnstableAudioFingerprint();
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableAudioFingerprint() {
    var w = window;
    var AudioContext = w.OfflineAudioContext || w.webkitOfflineAudioContext;
    if (!AudioContext) {
        return -2 /* SpecialFingerprint.NotSupported */;
    }
    // In some browsers, audio context always stays suspended unless the context is started in response to a user action
    // (e.g. a click or a tap). It prevents audio fingerprint from being taken at an arbitrary moment of time.
    // Such browsers are old and unpopular, so the audio fingerprinting is just skipped in them.
    // See a similar case explanation at https://stackoverflow.com/questions/46363048/onaudioprocess-not-called-on-ios11#46534088
    if (doesBrowserSuspendAudioContext()) {
        return -1 /* SpecialFingerprint.KnownForSuspending */;
    }
    var hashFromIndex = 4500;
    var hashToIndex = 5000;
    var context = new AudioContext(1, hashToIndex, 44100);
    var oscillator = context.createOscillator();
    oscillator.type = 'triangle';
    oscillator.frequency.value = 10000;
    var compressor = context.createDynamicsCompressor();
    compressor.threshold.value = -50;
    compressor.knee.value = 40;
    compressor.ratio.value = 12;
    compressor.attack.value = 0;
    compressor.release.value = 0.25;
    oscillator.connect(compressor);
    compressor.connect(context.destination);
    oscillator.start(0);
    var _a = startRenderingAudio(context), renderPromise = _a[0], finishRendering = _a[1];
    // Suppresses the console error message in case when the fingerprint fails before requested
    var fingerprintPromise = suppressUnhandledRejectionWarning(renderPromise.then(function (buffer) { return getHash(buffer.getChannelData(0).subarray(hashFromIndex)); }, function (error) {
        if (error.name === "timeout" /* InnerErrorName.Timeout */ || error.name === "suspended" /* InnerErrorName.Suspended */) {
            return -3 /* SpecialFingerprint.Timeout */;
        }
        throw error;
    }));
    return function () {
        finishRendering();
        return fingerprintPromise;
    };
}
/**
 * Checks if the current browser is known for always suspending audio context
 */
function doesBrowserSuspendAudioContext() {
    // Mobile Safari 11 and older
    return isWebKit() && !isDesktopWebKit() && !isWebKit606OrNewer();
}
/**
 * Checks if the current browser is known for applying anti-fingerprinting measures in all or some critical modes
 */
function doesBrowserPerformAntifingerprinting$1() {
    // Safari 17
    return isWebKit() && isWebKit616OrNewer() && isSafariWebKit();
}
/**
 * Starts rendering the audio context.
 * When the returned function is called, the render process starts finishing.
 */
function startRenderingAudio(context) {
    var renderTryMaxCount = 3;
    var renderRetryDelay = 500;
    var runningMaxAwaitTime = 500;
    var runningSufficientTime = 5000;
    var finalize = function () { return undefined; };
    var resultPromise = new Promise(function (resolve, reject) {
        var isFinalized = false;
        var renderTryCount = 0;
        var startedRunningAt = 0;
        context.oncomplete = function (event) { return resolve(event.renderedBuffer); };
        var startRunningTimeout = function () {
            setTimeout(function () { return reject(makeInnerError("timeout" /* InnerErrorName.Timeout */)); }, Math.min(runningMaxAwaitTime, startedRunningAt + runningSufficientTime - Date.now()));
        };
        var tryRender = function () {
            try {
                var renderingPromise = context.startRendering();
                // `context.startRendering` has two APIs: Promise and callback, we check that it's really a promise just in case
                if (isPromise(renderingPromise)) {
                    // Suppresses all unhandled rejections in case of scheduled redundant retries after successful rendering
                    suppressUnhandledRejectionWarning(renderingPromise);
                }
                switch (context.state) {
                    case 'running':
                        startedRunningAt = Date.now();
                        if (isFinalized) {
                            startRunningTimeout();
                        }
                        break;
                    // Sometimes the audio context doesn't start after calling `startRendering` (in addition to the cases where
                    // audio context doesn't start at all). A known case is starting an audio context when the browser tab is in
                    // background on iPhone. Retries usually help in this case.
                    case 'suspended':
                        // The audio context can reject starting until the tab is in foreground. Long fingerprint duration
                        // in background isn't a problem, therefore the retry attempts don't count in background. It can lead to
                        // a situation when a fingerprint takes very long time and finishes successfully. FYI, the audio context
                        // can be suspended when `document.hidden === false` and start running after a retry.
                        if (!document.hidden) {
                            renderTryCount++;
                        }
                        if (isFinalized && renderTryCount >= renderTryMaxCount) {
                            reject(makeInnerError("suspended" /* InnerErrorName.Suspended */));
                        }
                        else {
                            setTimeout(tryRender, renderRetryDelay);
                        }
                        break;
                }
            }
            catch (error) {
                reject(error);
            }
        };
        tryRender();
        finalize = function () {
            if (!isFinalized) {
                isFinalized = true;
                if (startedRunningAt > 0) {
                    startRunningTimeout();
                }
            }
        };
    });
    return [resultPromise, finalize];
}
function getHash(signal) {
    var hash = 0;
    for (var i = 0; i < signal.length; ++i) {
        hash += Math.abs(signal[i]);
    }
    return hash;
}
function makeInnerError(name) {
    var error = new Error(name);
    error.name = name;
    return error;
}

/**
 * Creates and keeps an invisible iframe while the given function runs.
 * The given function is called when the iframe is loaded and has a body.
 * The iframe allows to measure DOM sizes inside itself.
 *
 * Notice: passing an initial HTML code doesn't work in IE.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function withIframe(action, initialHtml, domPollInterval) {
    var _a, _b, _c;
    if (domPollInterval === void 0) { domPollInterval = 50; }
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var d, iframe;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_d) {
            switch (_d.label) {
                case 0:
                    d = document;
                    _d.label = 1;
                case 1:
                    if (!!d.body) return [3 /*break*/, 3];
                    return [4 /*yield*/, wait(domPollInterval)];
                case 2:
                    _d.sent();
                    return [3 /*break*/, 1];
                case 3:
                    iframe = d.createElement('iframe');
                    _d.label = 4;
                case 4:
                    _d.trys.push([4, , 10, 11]);
                    return [4 /*yield*/, new Promise(function (_resolve, _reject) {
                            var isComplete = false;
                            var resolve = function () {
                                isComplete = true;
                                _resolve();
                            };
                            var reject = function (error) {
                                isComplete = true;
                                _reject(error);
                            };
                            iframe.onload = resolve;
                            iframe.onerror = reject;
                            var style = iframe.style;
                            style.setProperty('display', 'block', 'important'); // Required for browsers to calculate the layout
                            style.position = 'absolute';
                            style.top = '0';
                            style.left = '0';
                            style.visibility = 'hidden';
                            if (initialHtml && 'srcdoc' in iframe) {
                                iframe.srcdoc = initialHtml;
                            }
                            else {
                                iframe.src = 'about:blank';
                            }
                            d.body.appendChild(iframe);
                            // WebKit in WeChat doesn't fire the iframe's `onload` for some reason.
                            // This code checks for the loading state manually.
                            // See https://github.com/fingerprintjs/fingerprintjs/issues/645
                            var checkReadyState = function () {
                                var _a, _b;
                                // The ready state may never become 'complete' in Firefox despite the 'load' event being fired.
                                // So an infinite setTimeout loop can happen without this check.
                                // See https://github.com/fingerprintjs/fingerprintjs/pull/716#issuecomment-986898796
                                if (isComplete) {
                                    return;
                                }
                                // Make sure iframe.contentWindow and iframe.contentWindow.document are both loaded
                                // The contentWindow.document can miss in JSDOM (https://github.com/jsdom/jsdom).
                                if (((_b = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document) === null || _b === void 0 ? void 0 : _b.readyState) === 'complete') {
                                    resolve();
                                }
                                else {
                                    setTimeout(checkReadyState, 10);
                                }
                            };
                            checkReadyState();
                        })];
                case 5:
                    _d.sent();
                    _d.label = 6;
                case 6:
                    if (!!((_b = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document) === null || _b === void 0 ? void 0 : _b.body)) return [3 /*break*/, 8];
                    return [4 /*yield*/, wait(domPollInterval)];
                case 7:
                    _d.sent();
                    return [3 /*break*/, 6];
                case 8: return [4 /*yield*/, action(iframe, iframe.contentWindow)];
                case 9: return [2 /*return*/, _d.sent()];
                case 10:
                    (_c = iframe.parentNode) === null || _c === void 0 ? void 0 : _c.removeChild(iframe);
                    return [7 /*endfinally*/];
                case 11: return [2 /*return*/];
            }
        });
    });
}
/**
 * Creates a DOM element that matches the given selector.
 * Only single element selector are supported (without operators like space, +, >, etc).
 */
function selectorToElement(selector) {
    var _a = parseSimpleCssSelector(selector), tag = _a[0], attributes = _a[1];
    var element = document.createElement(tag !== null && tag !== void 0 ? tag : 'div');
    for (var _i = 0, _b = Object.keys(attributes); _i < _b.length; _i++) {
        var name_1 = _b[_i];
        var value = attributes[name_1].join(' ');
        // Changing the `style` attribute can cause a CSP error, therefore we change the `style.cssText` property.
        // https://github.com/fingerprintjs/fingerprintjs/issues/733
        if (name_1 === 'style') {
            addStyleString(element.style, value);
        }
        else {
            element.setAttribute(name_1, value);
        }
    }
    return element;
}
/**
 * Adds CSS styles from a string in such a way that doesn't trigger a CSP warning (unsafe-inline or unsafe-eval)
 */
function addStyleString(style, source) {
    // We don't use `style.cssText` because browsers must block it when no `unsafe-eval` CSP is presented: https://csplite.com/csp145/#w3c_note
    // Even though the browsers ignore this standard, we don't use `cssText` just in case.
    for (var _i = 0, _a = source.split(';'); _i < _a.length; _i++) {
        var property = _a[_i];
        var match = /^\s*([\w-]+)\s*:\s*(.+?)(\s*!([\w-]+))?\s*$/.exec(property);
        if (match) {
            var name_2 = match[1], value = match[2], priority = match[4];
            style.setProperty(name_2, value, priority || ''); // The last argument can't be undefined in IE11
        }
    }
}
/**
 * Returns true if the code runs in an iframe, and any parent page's origin doesn't match the current origin
 */
function isAnyParentCrossOrigin() {
    var currentWindow = window;
    for (;;) {
        var parentWindow = currentWindow.parent;
        if (!parentWindow || parentWindow === currentWindow) {
            return false; // The top page is reached
        }
        try {
            if (parentWindow.location.origin !== currentWindow.location.origin) {
                return true;
            }
        }
        catch (error) {
            // The error is thrown when `origin` is accessed on `parentWindow.location` when the parent is cross-origin
            if (error instanceof Error && error.name === 'SecurityError') {
                return true;
            }
            throw error;
        }
        currentWindow = parentWindow;
    }
}

// We use m or w because these two characters take up the maximum width.
// And we use a LLi so that the same matching fonts can get separated.
var testString = 'mmMwWLliI0O&1';
// We test using 48px font size, we may use any size. I guess larger the better.
var textSize = '48px';
// A font will be compared against all the three default fonts.
// And if for any default fonts it doesn't match, then that font is available.
var baseFonts = ['monospace', 'sans-serif', 'serif'];
var fontList = [
    // This is android-specific font from "Roboto" family
    'sans-serif-thin',
    'ARNO PRO',
    'Agency FB',
    'Arabic Typesetting',
    'Arial Unicode MS',
    'AvantGarde Bk BT',
    'BankGothic Md BT',
    'Batang',
    'Bitstream Vera Sans Mono',
    'Calibri',
    'Century',
    'Century Gothic',
    'Clarendon',
    'EUROSTILE',
    'Franklin Gothic',
    'Futura Bk BT',
    'Futura Md BT',
    'GOTHAM',
    'Gill Sans',
    'HELV',
    'Haettenschweiler',
    'Helvetica Neue',
    'Humanst521 BT',
    'Leelawadee',
    'Letter Gothic',
    'Levenim MT',
    'Lucida Bright',
    'Lucida Sans',
    'Menlo',
    'MS Mincho',
    'MS Outlook',
    'MS Reference Specialty',
    'MS UI Gothic',
    'MT Extra',
    'MYRIAD PRO',
    'Marlett',
    'Meiryo UI',
    'Microsoft Uighur',
    'Minion Pro',
    'Monotype Corsiva',
    'PMingLiU',
    'Pristina',
    'SCRIPTINA',
    'Segoe UI Light',
    'Serifa',
    'SimHei',
    'Small Fonts',
    'Staccato222 BT',
    'TRAJAN PRO',
    'Univers CE 55 Medium',
    'Vrinda',
    'ZWAdobeF',
];
// kudos to http://www.lalit.org/lab/javascript-css-font-detect/
function getFonts() {
    var _this = this;
    // Running the script in an iframe makes it not affect the page look and not be affected by the page CSS. See:
    // https://github.com/fingerprintjs/fingerprintjs/issues/592
    // https://github.com/fingerprintjs/fingerprintjs/issues/628
    return withIframe(function (_, _a) {
        var document = _a.document;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(_this, void 0, void 0, function () {
            var holder, spansContainer, defaultWidth, defaultHeight, createSpan, createSpanWithFonts, initializeBaseFontsSpans, initializeFontsSpans, isFontAvailable, baseFontsSpans, fontsSpans, index;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_b) {
                holder = document.body;
                holder.style.fontSize = textSize;
                spansContainer = document.createElement('div');
                spansContainer.style.setProperty('visibility', 'hidden', 'important');
                defaultWidth = {};
                defaultHeight = {};
                createSpan = function (fontFamily) {
                    var span = document.createElement('span');
                    var style = span.style;
                    style.position = 'absolute';
                    style.top = '0';
                    style.left = '0';
                    style.fontFamily = fontFamily;
                    span.textContent = testString;
                    spansContainer.appendChild(span);
                    return span;
                };
                createSpanWithFonts = function (fontToDetect, baseFont) {
                    return createSpan("'".concat(fontToDetect, "',").concat(baseFont));
                };
                initializeBaseFontsSpans = function () {
                    return baseFonts.map(createSpan);
                };
                initializeFontsSpans = function () {
                    // Stores {fontName : [spans for that font]}
                    var spans = {};
                    var _loop_1 = function (font) {
                        spans[font] = baseFonts.map(function (baseFont) { return createSpanWithFonts(font, baseFont); });
                    };
                    for (var _i = 0, fontList_1 = fontList; _i < fontList_1.length; _i++) {
                        var font = fontList_1[_i];
                        _loop_1(font);
                    }
                    return spans;
                };
                isFontAvailable = function (fontSpans) {
                    return baseFonts.some(function (baseFont, baseFontIndex) {
                        return fontSpans[baseFontIndex].offsetWidth !== defaultWidth[baseFont] ||
                            fontSpans[baseFontIndex].offsetHeight !== defaultHeight[baseFont];
                    });
                };
                baseFontsSpans = initializeBaseFontsSpans();
                fontsSpans = initializeFontsSpans();
                // add all the spans to the DOM
                holder.appendChild(spansContainer);
                // get the default width for the three base fonts
                for (index = 0; index < baseFonts.length; index++) {
                    defaultWidth[baseFonts[index]] = baseFontsSpans[index].offsetWidth; // width for the default font
                    defaultHeight[baseFonts[index]] = baseFontsSpans[index].offsetHeight; // height for the default font
                }
                // check available fonts
                return [2 /*return*/, fontList.filter(function (font) { return isFontAvailable(fontsSpans[font]); })];
            });
        });
    });
}

function getPlugins() {
    var rawPlugins = navigator.plugins;
    if (!rawPlugins) {
        return undefined;
    }
    var plugins = [];
    // Safari 10 doesn't support iterating navigator.plugins with for...of
    for (var i = 0; i < rawPlugins.length; ++i) {
        var plugin = rawPlugins[i];
        if (!plugin) {
            continue;
        }
        var mimeTypes = [];
        for (var j = 0; j < plugin.length; ++j) {
            var mimeType = plugin[j];
            mimeTypes.push({
                type: mimeType.type,
                suffixes: mimeType.suffixes,
            });
        }
        plugins.push({
            name: plugin.name,
            description: plugin.description,
            mimeTypes: mimeTypes,
        });
    }
    return plugins;
}

/**
 * @see https://www.browserleaks.com/canvas#how-does-it-work
 *
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 * Canvas image is noised in private mode of Safari 17, so image rendering is skipped in Safari 17.
 */
function getCanvasFingerprint() {
    return getUnstableCanvasFingerprint(doesBrowserPerformAntifingerprinting());
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableCanvasFingerprint(skipImages) {
    var _a;
    var winding = false;
    var geometry;
    var text;
    var _b = makeCanvasContext(), canvas = _b[0], context = _b[1];
    if (!isSupported(canvas, context)) {
        geometry = text = "unsupported" /* ImageStatus.Unsupported */;
    }
    else {
        winding = doesSupportWinding(context);
        if (skipImages) {
            geometry = text = "skipped" /* ImageStatus.Skipped */;
        }
        else {
            _a = renderImages(canvas, context), geometry = _a[0], text = _a[1];
        }
    }
    return { winding: winding, geometry: geometry, text: text };
}
function makeCanvasContext() {
    var canvas = document.createElement('canvas');
    canvas.width = 1;
    canvas.height = 1;
    return [canvas, canvas.getContext('2d')];
}
function isSupported(canvas, context) {
    return !!(context && canvas.toDataURL);
}
function doesSupportWinding(context) {
    // https://web.archive.org/web/20170825024655/http://blogs.adobe.com/webplatform/2013/01/30/winding-rules-in-canvas/
    // https://github.com/Modernizr/Modernizr/blob/master/feature-detects/canvas/winding.js
    context.rect(0, 0, 10, 10);
    context.rect(2, 2, 6, 6);
    return !context.isPointInPath(5, 5, 'evenodd');
}
function renderImages(canvas, context) {
    renderTextImage(canvas, context);
    var textImage1 = canvasToString(canvas);
    var textImage2 = canvasToString(canvas); // It's slightly faster to double-encode the text image
    // Some browsers add a noise to the canvas: https://github.com/fingerprintjs/fingerprintjs/issues/791
    // The canvas is excluded from the fingerprint in this case
    if (textImage1 !== textImage2) {
        return ["unstable" /* ImageStatus.Unstable */, "unstable" /* ImageStatus.Unstable */];
    }
    // Text is unstable:
    // https://github.com/fingerprintjs/fingerprintjs/issues/583
    // https://github.com/fingerprintjs/fingerprintjs/issues/103
    // Therefore it's extracted into a separate image.
    renderGeometryImage(canvas, context);
    var geometryImage = canvasToString(canvas);
    return [geometryImage, textImage1];
}
function renderTextImage(canvas, context) {
    // Resizing the canvas cleans it
    canvas.width = 240;
    canvas.height = 60;
    context.textBaseline = 'alphabetic';
    context.fillStyle = '#f60';
    context.fillRect(100, 1, 62, 20);
    context.fillStyle = '#069';
    // It's important to use explicit built-in fonts in order to exclude the affect of font preferences
    // (there is a separate entropy source for them).
    context.font = '11pt "Times New Roman"';
    // The choice of emojis has a gigantic impact on rendering performance (especially in FF).
    // Some newer emojis cause it to slow down 50-200 times.
    // There must be no text to the right of the emoji, see https://github.com/fingerprintjs/fingerprintjs/issues/574
    // A bare emoji shouldn't be used because the canvas will change depending on the script encoding:
    // https://github.com/fingerprintjs/fingerprintjs/issues/66
    // Escape sequence shouldn't be used too because Terser will turn it into a bare unicode.
    var printedText = "Cwm fjordbank gly ".concat(String.fromCharCode(55357, 56835) /* 😃 */);
    context.fillText(printedText, 2, 15);
    context.fillStyle = 'rgba(102, 204, 0, 0.2)';
    context.font = '18pt Arial';
    context.fillText(printedText, 4, 45);
}
function renderGeometryImage(canvas, context) {
    // Resizing the canvas cleans it
    canvas.width = 122;
    canvas.height = 110;
    // Canvas blending
    // https://web.archive.org/web/20170826194121/http://blogs.adobe.com/webplatform/2013/01/28/blending-features-in-canvas/
    // http://jsfiddle.net/NDYV8/16/
    context.globalCompositeOperation = 'multiply';
    for (var _i = 0, _a = [
        ['#f2f', 40, 40],
        ['#2ff', 80, 40],
        ['#ff2', 60, 80],
    ]; _i < _a.length; _i++) {
        var _b = _a[_i], color = _b[0], x = _b[1], y = _b[2];
        context.fillStyle = color;
        context.beginPath();
        context.arc(x, y, 40, 0, Math.PI * 2, true);
        context.closePath();
        context.fill();
    }
    // Canvas winding
    // https://web.archive.org/web/20130913061632/http://blogs.adobe.com/webplatform/2013/01/30/winding-rules-in-canvas/
    // http://jsfiddle.net/NDYV8/19/
    context.fillStyle = '#f9c';
    context.arc(60, 60, 60, 0, Math.PI * 2, true);
    context.arc(60, 60, 20, 0, Math.PI * 2, true);
    context.fill('evenodd');
}
function canvasToString(canvas) {
    return canvas.toDataURL();
}
/**
 * Checks if the current browser is known for applying anti-fingerprinting measures in all or some critical modes
 */
function doesBrowserPerformAntifingerprinting() {
    // Safari 17
    return isWebKit() && isWebKit616OrNewer() && isSafariWebKit();
}

/**
 * This is a crude and primitive touch screen detection. It's not possible to currently reliably detect the availability
 * of a touch screen with a JS, without actually subscribing to a touch event.
 *
 * @see http://www.stucox.com/blog/you-cant-detect-a-touchscreen/
 * @see https://github.com/Modernizr/Modernizr/issues/548
 */
function getTouchSupport() {
    var n = navigator;
    var maxTouchPoints = 0;
    var touchEvent;
    if (n.maxTouchPoints !== undefined) {
        maxTouchPoints = toInt(n.maxTouchPoints);
    }
    else if (n.msMaxTouchPoints !== undefined) {
        maxTouchPoints = n.msMaxTouchPoints;
    }
    try {
        document.createEvent('TouchEvent');
        touchEvent = true;
    }
    catch (_a) {
        touchEvent = false;
    }
    var touchStart = 'ontouchstart' in window;
    return {
        maxTouchPoints: maxTouchPoints,
        touchEvent: touchEvent,
        touchStart: touchStart,
    };
}

function getOsCpu() {
    return navigator.oscpu;
}

function getLanguages() {
    var n = navigator;
    var result = [];
    var language = n.language || n.userLanguage || n.browserLanguage || n.systemLanguage;
    if (language !== undefined) {
        result.push([language]);
    }
    if (Array.isArray(n.languages)) {
        // Starting from Chromium 86, there is only a single value in `navigator.language` in Incognito mode:
        // the value of `navigator.language`. Therefore the value is ignored in this browser.
        if (!(isChromium() && isChromium86OrNewer())) {
            result.push(n.languages);
        }
    }
    else if (typeof n.languages === 'string') {
        var languages = n.languages;
        if (languages) {
            result.push(languages.split(','));
        }
    }
    return result;
}

function getColorDepth() {
    return window.screen.colorDepth;
}

function getDeviceMemory() {
    // `navigator.deviceMemory` is a string containing a number in some unidentified cases
    return replaceNaN(toFloat(navigator.deviceMemory), undefined);
}

/**
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 * The window resolution is always the document size in private mode of Safari 17,
 * so the window resolution is not used in Safari 17.
 */
function getScreenResolution() {
    if (isWebKit() && isWebKit616OrNewer() && isSafariWebKit()) {
        return undefined;
    }
    return getUnstableScreenResolution();
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableScreenResolution() {
    var s = screen;
    // Some browsers return screen resolution as strings, e.g. "1200", instead of a number, e.g. 1200.
    // I suspect it's done by certain plugins that randomize browser properties to prevent fingerprinting.
    // Some browsers even return  screen resolution as not numbers.
    var parseDimension = function (value) { return replaceNaN(toInt(value), null); };
    var dimensions = [parseDimension(s.width), parseDimension(s.height)];
    dimensions.sort().reverse();
    return dimensions;
}

var screenFrameCheckInterval = 2500;
var roundingPrecision = 10;
// The type is readonly to protect from unwanted mutations
var screenFrameBackup;
var screenFrameSizeTimeoutId;
/**
 * Starts watching the screen frame size. When a non-zero size appears, the size is saved and the watch is stopped.
 * Later, when `getScreenFrame` runs, it will return the saved non-zero size if the current size is null.
 *
 * This trick is required to mitigate the fact that the screen frame turns null in some cases.
 * See more on this at https://github.com/fingerprintjs/fingerprintjs/issues/568
 */
function watchScreenFrame() {
    if (screenFrameSizeTimeoutId !== undefined) {
        return;
    }
    var checkScreenFrame = function () {
        var frameSize = getCurrentScreenFrame();
        if (isFrameSizeNull(frameSize)) {
            screenFrameSizeTimeoutId = setTimeout(checkScreenFrame, screenFrameCheckInterval);
        }
        else {
            screenFrameBackup = frameSize;
            screenFrameSizeTimeoutId = undefined;
        }
    };
    checkScreenFrame();
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableScreenFrame() {
    var _this = this;
    watchScreenFrame();
    return function () { return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(_this, void 0, void 0, function () {
        var frameSize;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0:
                    frameSize = getCurrentScreenFrame();
                    if (!isFrameSizeNull(frameSize)) return [3 /*break*/, 2];
                    if (screenFrameBackup) {
                        return [2 /*return*/, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__spreadArray)([], screenFrameBackup, true)];
                    }
                    if (!getFullscreenElement()) return [3 /*break*/, 2];
                    // Some browsers set the screen frame to zero when programmatic fullscreen is on.
                    // There is a chance of getting a non-zero frame after exiting the fullscreen.
                    // See more on this at https://github.com/fingerprintjs/fingerprintjs/issues/568
                    return [4 /*yield*/, exitFullscreen()];
                case 1:
                    // Some browsers set the screen frame to zero when programmatic fullscreen is on.
                    // There is a chance of getting a non-zero frame after exiting the fullscreen.
                    // See more on this at https://github.com/fingerprintjs/fingerprintjs/issues/568
                    _a.sent();
                    frameSize = getCurrentScreenFrame();
                    _a.label = 2;
                case 2:
                    if (!isFrameSizeNull(frameSize)) {
                        screenFrameBackup = frameSize;
                    }
                    return [2 /*return*/, frameSize];
            }
        });
    }); };
}
/**
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 *
 * Sometimes the available screen resolution changes a bit, e.g. 1900x1440 → 1900x1439. A possible reason: macOS Dock
 * shrinks to fit more icons when there is too little space. The rounding is used to mitigate the difference.
 *
 * The frame width is always 0 in private mode of Safari 17, so the frame is not used in Safari 17.
 */
function getScreenFrame() {
    var _this = this;
    if (isWebKit() && isWebKit616OrNewer() && isSafariWebKit()) {
        return function () { return Promise.resolve(undefined); };
    }
    var screenFrameGetter = getUnstableScreenFrame();
    return function () { return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(_this, void 0, void 0, function () {
        var frameSize, processSize;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, screenFrameGetter()];
                case 1:
                    frameSize = _a.sent();
                    processSize = function (sideSize) { return (sideSize === null ? null : round(sideSize, roundingPrecision)); };
                    // It might look like I don't know about `for` and `map`.
                    // In fact, such code is used to avoid TypeScript issues without using `as`.
                    return [2 /*return*/, [processSize(frameSize[0]), processSize(frameSize[1]), processSize(frameSize[2]), processSize(frameSize[3])]];
            }
        });
    }); };
}
function getCurrentScreenFrame() {
    var s = screen;
    // Some browsers return screen resolution as strings, e.g. "1200", instead of a number, e.g. 1200.
    // I suspect it's done by certain plugins that randomize browser properties to prevent fingerprinting.
    //
    // Some browsers (IE, Edge ≤18) don't provide `screen.availLeft` and `screen.availTop`. The property values are
    // replaced with 0 in such cases to not lose the entropy from `screen.availWidth` and `screen.availHeight`.
    return [
        replaceNaN(toFloat(s.availTop), null),
        replaceNaN(toFloat(s.width) - toFloat(s.availWidth) - replaceNaN(toFloat(s.availLeft), 0), null),
        replaceNaN(toFloat(s.height) - toFloat(s.availHeight) - replaceNaN(toFloat(s.availTop), 0), null),
        replaceNaN(toFloat(s.availLeft), null),
    ];
}
function isFrameSizeNull(frameSize) {
    for (var i = 0; i < 4; ++i) {
        if (frameSize[i]) {
            return false;
        }
    }
    return true;
}

function getHardwareConcurrency() {
    // sometimes hardware concurrency is a string
    return replaceNaN(toInt(navigator.hardwareConcurrency), undefined);
}

function getTimezone() {
    var _a;
    var DateTimeFormat = (_a = window.Intl) === null || _a === void 0 ? void 0 : _a.DateTimeFormat;
    if (DateTimeFormat) {
        var timezone = new DateTimeFormat().resolvedOptions().timeZone;
        if (timezone) {
            return timezone;
        }
    }
    // For browsers that don't support timezone names
    // The minus is intentional because the JS offset is opposite to the real offset
    var offset = -getTimezoneOffset();
    return "UTC".concat(offset >= 0 ? '+' : '').concat(offset);
}
function getTimezoneOffset() {
    var currentYear = new Date().getFullYear();
    // The timezone offset may change over time due to daylight saving time (DST) shifts.
    // The non-DST timezone offset is used as the result timezone offset.
    // Since the DST season differs in the northern and the southern hemispheres,
    // both January and July timezones offsets are considered.
    return Math.max(
    // `getTimezoneOffset` returns a number as a string in some unidentified cases
    toFloat(new Date(currentYear, 0, 1).getTimezoneOffset()), toFloat(new Date(currentYear, 6, 1).getTimezoneOffset()));
}

function getSessionStorage() {
    try {
        return !!window.sessionStorage;
    }
    catch (error) {
        /* SecurityError when referencing it means it exists */
        return true;
    }
}

// https://bugzilla.mozilla.org/show_bug.cgi?id=781447
function getLocalStorage() {
    try {
        return !!window.localStorage;
    }
    catch (e) {
        /* SecurityError when referencing it means it exists */
        return true;
    }
}

function getIndexedDB() {
    // IE and Edge don't allow accessing indexedDB in private mode, therefore IE and Edge will have different
    // visitor identifier in normal and private modes.
    if (isTrident() || isEdgeHTML()) {
        return undefined;
    }
    try {
        return !!window.indexedDB;
    }
    catch (e) {
        /* SecurityError when referencing it means it exists */
        return true;
    }
}

function getOpenDatabase() {
    return !!window.openDatabase;
}

function getCpuClass() {
    return navigator.cpuClass;
}

function getPlatform() {
    // Android Chrome 86 and 87 and Android Firefox 80 and 84 don't mock the platform value when desktop mode is requested
    var platform = navigator.platform;
    // iOS mocks the platform value when desktop version is requested: https://github.com/fingerprintjs/fingerprintjs/issues/514
    // iPad uses desktop mode by default since iOS 13
    // The value is 'MacIntel' on M1 Macs
    // The value is 'iPhone' on iPod Touch
    if (platform === 'MacIntel') {
        if (isWebKit() && !isDesktopWebKit()) {
            return isIPad() ? 'iPad' : 'iPhone';
        }
    }
    return platform;
}

function getVendor() {
    return navigator.vendor || '';
}

/**
 * Checks for browser-specific (not engine specific) global variables to tell browsers with the same engine apart.
 * Only somewhat popular browsers are considered.
 */
function getVendorFlavors() {
    var flavors = [];
    for (var _i = 0, _a = [
        // Blink and some browsers on iOS
        'chrome',
        // Safari on macOS
        'safari',
        // Chrome on iOS (checked in 85 on 13 and 87 on 14)
        '__crWeb',
        '__gCrWeb',
        // Yandex Browser on iOS, macOS and Android (checked in 21.2 on iOS 14, macOS and Android)
        'yandex',
        // Yandex Browser on iOS (checked in 21.2 on 14)
        '__yb',
        '__ybro',
        // Firefox on iOS (checked in 32 on 14)
        '__firefox__',
        // Edge on iOS (checked in 46 on 14)
        '__edgeTrackingPreventionStatistics',
        'webkit',
        // Opera Touch on iOS (checked in 2.6 on 14)
        'oprt',
        // Samsung Internet on Android (checked in 11.1)
        'samsungAr',
        // UC Browser on Android (checked in 12.10 and 13.0)
        'ucweb',
        'UCShellJava',
        // Puffin on Android (checked in 9.0)
        'puffinDevice',
        // UC on iOS and Opera on Android have no specific global variables
        // Edge for Android isn't checked
    ]; _i < _a.length; _i++) {
        var key = _a[_i];
        var value = window[key];
        if (value && typeof value === 'object') {
            flavors.push(key);
        }
    }
    return flavors.sort();
}

/**
 * navigator.cookieEnabled cannot detect custom or nuanced cookie blocking configurations. For example, when blocking
 * cookies via the Advanced Privacy Settings in IE9, it always returns true. And there have been issues in the past with
 * site-specific exceptions. Don't rely on it.
 *
 * @see https://github.com/Modernizr/Modernizr/blob/master/feature-detects/cookies.js Taken from here
 */
function areCookiesEnabled() {
    var d = document;
    // Taken from here: https://github.com/Modernizr/Modernizr/blob/master/feature-detects/cookies.js
    // navigator.cookieEnabled cannot detect custom or nuanced cookie blocking configurations. For example, when blocking
    // cookies via the Advanced Privacy Settings in IE9, it always returns true. And there have been issues in the past
    // with site-specific exceptions. Don't rely on it.
    // try..catch because some in situations `document.cookie` is exposed but throws a
    // SecurityError if you try to access it; e.g. documents created from data URIs
    // or in sandboxed iframes (depending on flags/context)
    try {
        // Create cookie
        d.cookie = 'cookietest=1; SameSite=Strict;';
        var result = d.cookie.indexOf('cookietest=') !== -1;
        // Delete cookie
        d.cookie = 'cookietest=1; SameSite=Strict; expires=Thu, 01-Jan-1970 00:00:01 GMT';
        return result;
    }
    catch (e) {
        return false;
    }
}

/**
 * Only single element selector are supported (no operators like space, +, >, etc).
 * `embed` and `position: fixed;` will be considered as blocked anyway because it always has no offsetParent.
 * Avoid `iframe` and anything with `[src=]` because they produce excess HTTP requests.
 *
 * The "inappropriate" selectors are obfuscated. See https://github.com/fingerprintjs/fingerprintjs/issues/734.
 * A function is used instead of a plain object to help tree-shaking.
 *
 * The function code is generated automatically. See docs/content_blockers.md to learn how to make the list.
 */
function getFilters() {
    var fromB64 = atob; // Just for better minification
    return {
        abpIndo: [
            '#Iklan-Melayang',
            '#Kolom-Iklan-728',
            '#SidebarIklan-wrapper',
            '[title="ALIENBOLA" i]',
            fromB64('I0JveC1CYW5uZXItYWRz'),
        ],
        abpvn: ['.quangcao', '#mobileCatfish', fromB64('LmNsb3NlLWFkcw=='), '[id^="bn_bottom_fixed_"]', '#pmadv'],
        adBlockFinland: [
            '.mainostila',
            fromB64('LnNwb25zb3JpdA=='),
            '.ylamainos',
            fromB64('YVtocmVmKj0iL2NsaWNrdGhyZ2guYXNwPyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hcHAucmVhZHBlYWsuY29tL2FkcyJd'),
        ],
        adBlockPersian: [
            '#navbar_notice_50',
            '.kadr',
            'TABLE[width="140px"]',
            '#divAgahi',
            fromB64('YVtocmVmXj0iaHR0cDovL2cxLnYuZndtcm0ubmV0L2FkLyJd'),
        ],
        adBlockWarningRemoval: [
            '#adblock-honeypot',
            '.adblocker-root',
            '.wp_adblock_detect',
            fromB64('LmhlYWRlci1ibG9ja2VkLWFk'),
            fromB64('I2FkX2Jsb2NrZXI='),
        ],
        adGuardAnnoyances: [
            '.hs-sosyal',
            '#cookieconsentdiv',
            'div[class^="app_gdpr"]',
            '.as-oil',
            '[data-cypress="soft-push-notification-modal"]',
        ],
        adGuardBase: [
            '.BetterJsPopOverlay',
            fromB64('I2FkXzMwMFgyNTA='),
            fromB64('I2Jhbm5lcmZsb2F0MjI='),
            fromB64('I2NhbXBhaWduLWJhbm5lcg=='),
            fromB64('I0FkLUNvbnRlbnQ='),
        ],
        adGuardChinese: [
            fromB64('LlppX2FkX2FfSA=='),
            fromB64('YVtocmVmKj0iLmh0aGJldDM0LmNvbSJd'),
            '#widget-quan',
            fromB64('YVtocmVmKj0iLzg0OTkyMDIwLnh5eiJd'),
            fromB64('YVtocmVmKj0iLjE5NTZobC5jb20vIl0='),
        ],
        adGuardFrench: [
            '#pavePub',
            fromB64('LmFkLWRlc2t0b3AtcmVjdGFuZ2xl'),
            '.mobile_adhesion',
            '.widgetadv',
            fromB64('LmFkc19iYW4='),
        ],
        adGuardGerman: ['aside[data-portal-id="leaderboard"]'],
        adGuardJapanese: [
            '#kauli_yad_1',
            fromB64('YVtocmVmXj0iaHR0cDovL2FkMi50cmFmZmljZ2F0ZS5uZXQvIl0='),
            fromB64('Ll9wb3BJbl9pbmZpbml0ZV9hZA=='),
            fromB64('LmFkZ29vZ2xl'),
            fromB64('Ll9faXNib29zdFJldHVybkFk'),
        ],
        adGuardMobile: [
            fromB64('YW1wLWF1dG8tYWRz'),
            fromB64('LmFtcF9hZA=='),
            'amp-embed[type="24smi"]',
            '#mgid_iframe1',
            fromB64('I2FkX2ludmlld19hcmVh'),
        ],
        adGuardRussian: [
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hZC5sZXRtZWFkcy5jb20vIl0='),
            fromB64('LnJlY2xhbWE='),
            'div[id^="smi2adblock"]',
            fromB64('ZGl2W2lkXj0iQWRGb3hfYmFubmVyXyJd'),
            '#psyduckpockeball',
        ],
        adGuardSocial: [
            fromB64('YVtocmVmXj0iLy93d3cuc3R1bWJsZXVwb24uY29tL3N1Ym1pdD91cmw9Il0='),
            fromB64('YVtocmVmXj0iLy90ZWxlZ3JhbS5tZS9zaGFyZS91cmw/Il0='),
            '.etsy-tweet',
            '#inlineShare',
            '.popup-social',
        ],
        adGuardSpanishPortuguese: ['#barraPublicidade', '#Publicidade', '#publiEspecial', '#queTooltip', '.cnt-publi'],
        adGuardTrackingProtection: [
            '#qoo-counter',
            fromB64('YVtocmVmXj0iaHR0cDovL2NsaWNrLmhvdGxvZy5ydS8iXQ=='),
            fromB64('YVtocmVmXj0iaHR0cDovL2hpdGNvdW50ZXIucnUvdG9wL3N0YXQucGhwIl0='),
            fromB64('YVtocmVmXj0iaHR0cDovL3RvcC5tYWlsLnJ1L2p1bXAiXQ=='),
            '#top100counter',
        ],
        adGuardTurkish: [
            '#backkapat',
            fromB64('I3Jla2xhbWk='),
            fromB64('YVtocmVmXj0iaHR0cDovL2Fkc2Vydi5vbnRlay5jb20udHIvIl0='),
            fromB64('YVtocmVmXj0iaHR0cDovL2l6bGVuemkuY29tL2NhbXBhaWduLyJd'),
            fromB64('YVtocmVmXj0iaHR0cDovL3d3dy5pbnN0YWxsYWRzLm5ldC8iXQ=='),
        ],
        bulgarian: [fromB64('dGQjZnJlZW5ldF90YWJsZV9hZHM='), '#ea_intext_div', '.lapni-pop-over', '#xenium_hot_offers'],
        easyList: [
            '.yb-floorad',
            fromB64('LndpZGdldF9wb19hZHNfd2lkZ2V0'),
            fromB64('LnRyYWZmaWNqdW5reS1hZA=='),
            '.textad_headline',
            fromB64('LnNwb25zb3JlZC10ZXh0LWxpbmtz'),
        ],
        easyListChina: [
            fromB64('LmFwcGd1aWRlLXdyYXBbb25jbGljayo9ImJjZWJvcy5jb20iXQ=='),
            fromB64('LmZyb250cGFnZUFkdk0='),
            '#taotaole',
            '#aafoot.top_box',
            '.cfa_popup',
        ],
        easyListCookie: [
            '.ezmob-footer',
            '.cc-CookieWarning',
            '[data-cookie-number]',
            fromB64('LmF3LWNvb2tpZS1iYW5uZXI='),
            '.sygnal24-gdpr-modal-wrap',
        ],
        easyListCzechSlovak: [
            '#onlajny-stickers',
            fromB64('I3Jla2xhbW5pLWJveA=='),
            fromB64('LnJla2xhbWEtbWVnYWJvYXJk'),
            '.sklik',
            fromB64('W2lkXj0ic2tsaWtSZWtsYW1hIl0='),
        ],
        easyListDutch: [
            fromB64('I2FkdmVydGVudGll'),
            fromB64('I3ZpcEFkbWFya3RCYW5uZXJCbG9jaw=='),
            '.adstekst',
            fromB64('YVtocmVmXj0iaHR0cHM6Ly94bHR1YmUubmwvY2xpY2svIl0='),
            '#semilo-lrectangle',
        ],
        easyListGermany: [
            '#SSpotIMPopSlider',
            fromB64('LnNwb25zb3JsaW5rZ3J1ZW4='),
            fromB64('I3dlcmJ1bmdza3k='),
            fromB64('I3Jla2xhbWUtcmVjaHRzLW1pdHRl'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9iZDc0Mi5jb20vIl0='),
        ],
        easyListItaly: [
            fromB64('LmJveF9hZHZfYW5udW5jaQ=='),
            '.sb-box-pubbliredazionale',
            fromB64('YVtocmVmXj0iaHR0cDovL2FmZmlsaWF6aW9uaWFkcy5zbmFpLml0LyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hZHNlcnZlci5odG1sLml0LyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hZmZpbGlhemlvbmlhZHMuc25haS5pdC8iXQ=='),
        ],
        easyListLithuania: [
            fromB64('LnJla2xhbW9zX3RhcnBhcw=='),
            fromB64('LnJla2xhbW9zX251b3JvZG9z'),
            fromB64('aW1nW2FsdD0iUmVrbGFtaW5pcyBza3lkZWxpcyJd'),
            fromB64('aW1nW2FsdD0iRGVkaWt1b3RpLmx0IHNlcnZlcmlhaSJd'),
            fromB64('aW1nW2FsdD0iSG9zdGluZ2FzIFNlcnZlcmlhaS5sdCJd'),
        ],
        estonian: [fromB64('QVtocmVmKj0iaHR0cDovL3BheTRyZXN1bHRzMjQuZXUiXQ==')],
        fanboyAnnoyances: ['#ac-lre-player', '.navigate-to-top', '#subscribe_popup', '.newsletter_holder', '#back-top'],
        fanboyAntiFacebook: ['.util-bar-module-firefly-visible'],
        fanboyEnhancedTrackers: [
            '.open.pushModal',
            '#issuem-leaky-paywall-articles-zero-remaining-nag',
            '#sovrn_container',
            'div[class$="-hide"][zoompage-fontsize][style="display: block;"]',
            '.BlockNag__Card',
        ],
        fanboySocial: ['#FollowUs', '#meteored_share', '#social_follow', '.article-sharer', '.community__social-desc'],
        frellwitSwedish: [
            fromB64('YVtocmVmKj0iY2FzaW5vcHJvLnNlIl1bdGFyZ2V0PSJfYmxhbmsiXQ=='),
            fromB64('YVtocmVmKj0iZG9rdG9yLXNlLm9uZWxpbmsubWUiXQ=='),
            'article.category-samarbete',
            fromB64('ZGl2LmhvbGlkQWRz'),
            'ul.adsmodern',
        ],
        greekAdBlock: [
            fromB64('QVtocmVmKj0iYWRtYW4ub3RlbmV0LmdyL2NsaWNrPyJd'),
            fromB64('QVtocmVmKj0iaHR0cDovL2F4aWFiYW5uZXJzLmV4b2R1cy5nci8iXQ=='),
            fromB64('QVtocmVmKj0iaHR0cDovL2ludGVyYWN0aXZlLmZvcnRobmV0LmdyL2NsaWNrPyJd'),
            'DIV.agores300',
            'TABLE.advright',
        ],
        hungarian: [
            '#cemp_doboz',
            '.optimonk-iframe-container',
            fromB64('LmFkX19tYWlu'),
            fromB64('W2NsYXNzKj0iR29vZ2xlQWRzIl0='),
            '#hirdetesek_box',
        ],
        iDontCareAboutCookies: [
            '.alert-info[data-block-track*="CookieNotice"]',
            '.ModuleTemplateCookieIndicator',
            '.o--cookies--container',
            '#cookies-policy-sticky',
            '#stickyCookieBar',
        ],
        icelandicAbp: [fromB64('QVtocmVmXj0iL2ZyYW1ld29yay9yZXNvdXJjZXMvZm9ybXMvYWRzLmFzcHgiXQ==')],
        latvian: [
            fromB64('YVtocmVmPSJodHRwOi8vd3d3LnNhbGlkemluaS5sdi8iXVtzdHlsZT0iZGlzcGxheTogYmxvY2s7IHdpZHRoOiAxMjBweDsgaGVpZ2h0O' +
                'iA0MHB4OyBvdmVyZmxvdzogaGlkZGVuOyBwb3NpdGlvbjogcmVsYXRpdmU7Il0='),
            fromB64('YVtocmVmPSJodHRwOi8vd3d3LnNhbGlkemluaS5sdi8iXVtzdHlsZT0iZGlzcGxheTogYmxvY2s7IHdpZHRoOiA4OHB4OyBoZWlnaHQ6I' +
                'DMxcHg7IG92ZXJmbG93OiBoaWRkZW47IHBvc2l0aW9uOiByZWxhdGl2ZTsiXQ=='),
        ],
        listKr: [
            fromB64('YVtocmVmKj0iLy9hZC5wbGFuYnBsdXMuY28ua3IvIl0='),
            fromB64('I2xpdmVyZUFkV3JhcHBlcg=='),
            fromB64('YVtocmVmKj0iLy9hZHYuaW1hZHJlcC5jby5rci8iXQ=='),
            fromB64('aW5zLmZhc3R2aWV3LWFk'),
            '.revenue_unit_item.dable',
        ],
        listeAr: [
            fromB64('LmdlbWluaUxCMUFk'),
            '.right-and-left-sponsers',
            fromB64('YVtocmVmKj0iLmFmbGFtLmluZm8iXQ=='),
            fromB64('YVtocmVmKj0iYm9vcmFxLm9yZyJd'),
            fromB64('YVtocmVmKj0iZHViaXp6bGUuY29tL2FyLz91dG1fc291cmNlPSJd'),
        ],
        listeFr: [
            fromB64('YVtocmVmXj0iaHR0cDovL3Byb21vLnZhZG9yLmNvbS8iXQ=='),
            fromB64('I2FkY29udGFpbmVyX3JlY2hlcmNoZQ=='),
            fromB64('YVtocmVmKj0id2Vib3JhbWEuZnIvZmNnaS1iaW4vIl0='),
            '.site-pub-interstitiel',
            'div[id^="crt-"][data-criteo-id]',
        ],
        officialPolish: [
            '#ceneo-placeholder-ceneo-12',
            fromB64('W2hyZWZePSJodHRwczovL2FmZi5zZW5kaHViLnBsLyJd'),
            fromB64('YVtocmVmXj0iaHR0cDovL2Fkdm1hbmFnZXIudGVjaGZ1bi5wbC9yZWRpcmVjdC8iXQ=='),
            fromB64('YVtocmVmXj0iaHR0cDovL3d3dy50cml6ZXIucGwvP3V0bV9zb3VyY2UiXQ=='),
            fromB64('ZGl2I3NrYXBpZWNfYWQ='),
        ],
        ro: [
            fromB64('YVtocmVmXj0iLy9hZmZ0cmsuYWx0ZXgucm8vQ291bnRlci9DbGljayJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9ibGFja2ZyaWRheXNhbGVzLnJvL3Ryay9zaG9wLyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9ldmVudC4ycGVyZm9ybWFudC5jb20vZXZlbnRzL2NsaWNrIl0='),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9sLnByb2ZpdHNoYXJlLnJvLyJd'),
            'a[href^="/url/"]',
        ],
        ruAd: [
            fromB64('YVtocmVmKj0iLy9mZWJyYXJlLnJ1LyJd'),
            fromB64('YVtocmVmKj0iLy91dGltZy5ydS8iXQ=='),
            fromB64('YVtocmVmKj0iOi8vY2hpa2lkaWtpLnJ1Il0='),
            '#pgeldiz',
            '.yandex-rtb-block',
        ],
        thaiAds: [
            'a[href*=macau-uta-popup]',
            fromB64('I2Fkcy1nb29nbGUtbWlkZGxlX3JlY3RhbmdsZS1ncm91cA=='),
            fromB64('LmFkczMwMHM='),
            '.bumq',
            '.img-kosana',
        ],
        webAnnoyancesUltralist: [
            '#mod-social-share-2',
            '#social-tools',
            fromB64('LmN0cGwtZnVsbGJhbm5lcg=='),
            '.zergnet-recommend',
            '.yt.btn-link.btn-md.btn',
        ],
    };
}
/**
 * The order of the returned array means nothing (it's always sorted alphabetically).
 *
 * Notice that the source is slightly unstable.
 * Safari provides a 2-taps way to disable all content blockers on a page temporarily.
 * Also content blockers can be disabled permanently for a domain, but it requires 4 taps.
 * So empty array shouldn't be treated as "no blockers", it should be treated as "no signal".
 * If you are a website owner, don't make your visitors want to disable content blockers.
 */
function getDomBlockers(_a) {
    var _b = _a === void 0 ? {} : _a, debug = _b.debug;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var filters, filterNames, allSelectors, blockedSelectors, activeBlockers;
        var _c;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_d) {
            switch (_d.label) {
                case 0:
                    if (!isApplicable()) {
                        return [2 /*return*/, undefined];
                    }
                    filters = getFilters();
                    filterNames = Object.keys(filters);
                    allSelectors = (_c = []).concat.apply(_c, filterNames.map(function (filterName) { return filters[filterName]; }));
                    return [4 /*yield*/, getBlockedSelectors(allSelectors)];
                case 1:
                    blockedSelectors = _d.sent();
                    if (debug) {
                        printDebug(filters, blockedSelectors);
                    }
                    activeBlockers = filterNames.filter(function (filterName) {
                        var selectors = filters[filterName];
                        var blockedCount = countTruthy(selectors.map(function (selector) { return blockedSelectors[selector]; }));
                        return blockedCount > selectors.length * 0.6;
                    });
                    activeBlockers.sort();
                    return [2 /*return*/, activeBlockers];
            }
        });
    });
}
function isApplicable() {
    // Safari (desktop and mobile) and all Android browsers keep content blockers in both regular and private mode
    return isWebKit() || isAndroid();
}
function getBlockedSelectors(selectors) {
    var _a;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var d, root, elements, blockedSelectors, i, element, holder, i;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_b) {
            switch (_b.label) {
                case 0:
                    d = document;
                    root = d.createElement('div');
                    elements = new Array(selectors.length);
                    blockedSelectors = {} // Set() isn't used just in case somebody need older browser support
                    ;
                    forceShow(root);
                    // First create all elements that can be blocked. If the DOM steps below are done in a single cycle,
                    // browser will alternate tree modification and layout reading, that is very slow.
                    for (i = 0; i < selectors.length; ++i) {
                        element = selectorToElement(selectors[i]);
                        if (element.tagName === 'DIALOG') {
                            element.show();
                        }
                        holder = d.createElement('div') // Protects from unwanted effects of `+` and `~` selectors of filters
                        ;
                        forceShow(holder);
                        holder.appendChild(element);
                        root.appendChild(holder);
                        elements[i] = element;
                    }
                    _b.label = 1;
                case 1:
                    if (!!d.body) return [3 /*break*/, 3];
                    return [4 /*yield*/, wait(50)];
                case 2:
                    _b.sent();
                    return [3 /*break*/, 1];
                case 3:
                    d.body.appendChild(root);
                    try {
                        // Then check which of the elements are blocked
                        for (i = 0; i < selectors.length; ++i) {
                            if (!elements[i].offsetParent) {
                                blockedSelectors[selectors[i]] = true;
                            }
                        }
                    }
                    finally {
                        // Then remove the elements
                        (_a = root.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(root);
                    }
                    return [2 /*return*/, blockedSelectors];
            }
        });
    });
}
function forceShow(element) {
    element.style.setProperty('visibility', 'hidden', 'important');
    element.style.setProperty('display', 'block', 'important');
}
function printDebug(filters, blockedSelectors) {
    var message = 'DOM blockers debug:\n```';
    for (var _i = 0, _a = Object.keys(filters); _i < _a.length; _i++) {
        var filterName = _a[_i];
        message += "\n".concat(filterName, ":");
        for (var _b = 0, _c = filters[filterName]; _b < _c.length; _b++) {
            var selector = _c[_b];
            message += "\n  ".concat(blockedSelectors[selector] ? '🚫' : '➡️', " ").concat(selector);
        }
    }
    // console.log is ok here because it's under a debug clause
    // eslint-disable-next-line no-console
    console.log("".concat(message, "\n```"));
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/color-gamut
 */
function getColorGamut() {
    // rec2020 includes p3 and p3 includes srgb
    for (var _i = 0, _a = ['rec2020', 'p3', 'srgb']; _i < _a.length; _i++) {
        var gamut = _a[_i];
        if (matchMedia("(color-gamut: ".concat(gamut, ")")).matches) {
            return gamut;
        }
    }
    return undefined;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/inverted-colors
 */
function areColorsInverted() {
    if (doesMatch$5('inverted')) {
        return true;
    }
    if (doesMatch$5('none')) {
        return false;
    }
    return undefined;
}
function doesMatch$5(value) {
    return matchMedia("(inverted-colors: ".concat(value, ")")).matches;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/forced-colors
 */
function areColorsForced() {
    if (doesMatch$4('active')) {
        return true;
    }
    if (doesMatch$4('none')) {
        return false;
    }
    return undefined;
}
function doesMatch$4(value) {
    return matchMedia("(forced-colors: ".concat(value, ")")).matches;
}

var maxValueToCheck = 100;
/**
 * If the display is monochrome (e.g. black&white), the value will be ≥0 and will mean the number of bits per pixel.
 * If the display is not monochrome, the returned value will be 0.
 * If the browser doesn't support this feature, the returned value will be undefined.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/monochrome
 */
function getMonochromeDepth() {
    if (!matchMedia('(min-monochrome: 0)').matches) {
        // The media feature isn't supported by the browser
        return undefined;
    }
    // A variation of binary search algorithm can be used here.
    // But since expected values are very small (≤10), there is no sense in adding the complexity.
    for (var i = 0; i <= maxValueToCheck; ++i) {
        if (matchMedia("(max-monochrome: ".concat(i, ")")).matches) {
            return i;
        }
    }
    throw new Error('Too high value');
}

/**
 * @see https://www.w3.org/TR/mediaqueries-5/#prefers-contrast
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-contrast
 */
function getContrastPreference() {
    if (doesMatch$3('no-preference')) {
        return 0 /* ContrastPreference.None */;
    }
    // The sources contradict on the keywords. Probably 'high' and 'low' will never be implemented.
    // Need to check it when all browsers implement the feature.
    if (doesMatch$3('high') || doesMatch$3('more')) {
        return 1 /* ContrastPreference.More */;
    }
    if (doesMatch$3('low') || doesMatch$3('less')) {
        return -1 /* ContrastPreference.Less */;
    }
    if (doesMatch$3('forced')) {
        return 10 /* ContrastPreference.ForcedColors */;
    }
    return undefined;
}
function doesMatch$3(value) {
    return matchMedia("(prefers-contrast: ".concat(value, ")")).matches;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-reduced-motion
 */
function isMotionReduced() {
    if (doesMatch$2('reduce')) {
        return true;
    }
    if (doesMatch$2('no-preference')) {
        return false;
    }
    return undefined;
}
function doesMatch$2(value) {
    return matchMedia("(prefers-reduced-motion: ".concat(value, ")")).matches;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-reduced-transparency
 */
function isTransparencyReduced() {
    if (doesMatch$1('reduce')) {
        return true;
    }
    if (doesMatch$1('no-preference')) {
        return false;
    }
    return undefined;
}
function doesMatch$1(value) {
    return matchMedia("(prefers-reduced-transparency: ".concat(value, ")")).matches;
}

/**
 * @see https://www.w3.org/TR/mediaqueries-5/#dynamic-range
 */
function isHDR() {
    if (doesMatch('high')) {
        return true;
    }
    if (doesMatch('standard')) {
        return false;
    }
    return undefined;
}
function doesMatch(value) {
    return matchMedia("(dynamic-range: ".concat(value, ")")).matches;
}

var M = Math; // To reduce the minified code size
var fallbackFn = function () { return 0; };
/**
 * @see https://gitlab.torproject.org/legacy/trac/-/issues/13018
 * @see https://bugzilla.mozilla.org/show_bug.cgi?id=531915
 */
function getMathFingerprint() {
    // Native operations
    var acos = M.acos || fallbackFn;
    var acosh = M.acosh || fallbackFn;
    var asin = M.asin || fallbackFn;
    var asinh = M.asinh || fallbackFn;
    var atanh = M.atanh || fallbackFn;
    var atan = M.atan || fallbackFn;
    var sin = M.sin || fallbackFn;
    var sinh = M.sinh || fallbackFn;
    var cos = M.cos || fallbackFn;
    var cosh = M.cosh || fallbackFn;
    var tan = M.tan || fallbackFn;
    var tanh = M.tanh || fallbackFn;
    var exp = M.exp || fallbackFn;
    var expm1 = M.expm1 || fallbackFn;
    var log1p = M.log1p || fallbackFn;
    // Operation polyfills
    var powPI = function (value) { return M.pow(M.PI, value); };
    var acoshPf = function (value) { return M.log(value + M.sqrt(value * value - 1)); };
    var asinhPf = function (value) { return M.log(value + M.sqrt(value * value + 1)); };
    var atanhPf = function (value) { return M.log((1 + value) / (1 - value)) / 2; };
    var sinhPf = function (value) { return M.exp(value) - 1 / M.exp(value) / 2; };
    var coshPf = function (value) { return (M.exp(value) + 1 / M.exp(value)) / 2; };
    var expm1Pf = function (value) { return M.exp(value) - 1; };
    var tanhPf = function (value) { return (M.exp(2 * value) - 1) / (M.exp(2 * value) + 1); };
    var log1pPf = function (value) { return M.log(1 + value); };
    // Note: constant values are empirical
    return {
        acos: acos(0.123124234234234242),
        acosh: acosh(1e308),
        acoshPf: acoshPf(1e154),
        asin: asin(0.123124234234234242),
        asinh: asinh(1),
        asinhPf: asinhPf(1),
        atanh: atanh(0.5),
        atanhPf: atanhPf(0.5),
        atan: atan(0.5),
        sin: sin(-1e300),
        sinh: sinh(1),
        sinhPf: sinhPf(1),
        cos: cos(10.000000000123),
        cosh: cosh(1),
        coshPf: coshPf(1),
        tan: tan(-1e300),
        tanh: tanh(1),
        tanhPf: tanhPf(1),
        exp: exp(1),
        expm1: expm1(1),
        expm1Pf: expm1Pf(1),
        log1p: log1p(10),
        log1pPf: log1pPf(10),
        powPI: powPI(-100),
    };
}

/**
 * We use m or w because these two characters take up the maximum width.
 * Also there are a couple of ligatures.
 */
var defaultText = 'mmMwWLliI0fiflO&1';
/**
 * Settings of text blocks to measure. The keys are random but persistent words.
 */
var presets = {
    /**
     * The default font. User can change it in desktop Chrome, desktop Firefox, IE 11,
     * Android Chrome (but only when the size is ≥ than the default) and Android Firefox.
     */
    default: [],
    /** OS font on macOS. User can change its size and weight. Applies after Safari restart. */
    apple: [{ font: '-apple-system-body' }],
    /** User can change it in desktop Chrome and desktop Firefox. */
    serif: [{ fontFamily: 'serif' }],
    /** User can change it in desktop Chrome and desktop Firefox. */
    sans: [{ fontFamily: 'sans-serif' }],
    /** User can change it in desktop Chrome and desktop Firefox. */
    mono: [{ fontFamily: 'monospace' }],
    /**
     * Check the smallest allowed font size. User can change it in desktop Chrome, desktop Firefox and desktop Safari.
     * The height can be 0 in Chrome on a retina display.
     */
    min: [{ fontSize: '1px' }],
    /** Tells one OS from another in desktop Chrome. */
    system: [{ fontFamily: 'system-ui' }],
};
/**
 * The result is a dictionary of the width of the text samples.
 * Heights aren't included because they give no extra entropy and are unstable.
 *
 * The result is very stable in IE 11, Edge 18 and Safari 14.
 * The result changes when the OS pixel density changes in Chromium 87. The real pixel density is required to solve,
 * but seems like it's impossible: https://stackoverflow.com/q/1713771/1118709.
 * The "min" and the "mono" (only on Windows) value may change when the page is zoomed in Firefox 87.
 */
function getFontPreferences() {
    return withNaturalFonts(function (document, container) {
        var elements = {};
        var sizes = {};
        // First create all elements to measure. If the DOM steps below are done in a single cycle,
        // browser will alternate tree modification and layout reading, that is very slow.
        for (var _i = 0, _a = Object.keys(presets); _i < _a.length; _i++) {
            var key = _a[_i];
            var _b = presets[key], _c = _b[0], style = _c === void 0 ? {} : _c, _d = _b[1], text = _d === void 0 ? defaultText : _d;
            var element = document.createElement('span');
            element.textContent = text;
            element.style.whiteSpace = 'nowrap';
            for (var _e = 0, _f = Object.keys(style); _e < _f.length; _e++) {
                var name_1 = _f[_e];
                var value = style[name_1];
                if (value !== undefined) {
                    element.style[name_1] = value;
                }
            }
            elements[key] = element;
            container.append(document.createElement('br'), element);
        }
        // Then measure the created elements
        for (var _g = 0, _h = Object.keys(presets); _g < _h.length; _g++) {
            var key = _h[_g];
            sizes[key] = elements[key].getBoundingClientRect().width;
        }
        return sizes;
    });
}
/**
 * Creates a DOM environment that provides the most natural font available, including Android OS font.
 * Measurements of the elements are zoom-independent.
 * Don't put a content to measure inside an absolutely positioned element.
 */
function withNaturalFonts(action, containerWidthPx) {
    if (containerWidthPx === void 0) { containerWidthPx = 4000; }
    /*
     * Requirements for Android Chrome to apply the system font size to a text inside an iframe:
     * - The iframe mustn't have a `display: none;` style;
     * - The text mustn't be positioned absolutely;
     * - The text block must be wide enough.
     *   2560px on some devices in portrait orientation for the biggest font size option (32px);
     * - There must be much enough text to form a few lines (I don't know the exact numbers);
     * - The text must have the `text-size-adjust: none` style. Otherwise the text will scale in "Desktop site" mode;
     *
     * Requirements for Android Firefox to apply the system font size to a text inside an iframe:
     * - The iframe document must have a header: `<meta name="viewport" content="width=device-width, initial-scale=1" />`.
     *   The only way to set it is to use the `srcdoc` attribute of the iframe;
     * - The iframe content must get loaded before adding extra content with JavaScript;
     *
     * https://example.com as the iframe target always inherits Android font settings so it can be used as a reference.
     *
     * Observations on how page zoom affects the measurements:
     * - macOS Safari 11.1, 12.1, 13.1, 14.0: zoom reset + offsetWidth = 100% reliable;
     * - macOS Safari 11.1, 12.1, 13.1, 14.0: zoom reset + getBoundingClientRect = 100% reliable;
     * - macOS Safari 14.0: offsetWidth = 5% fluctuation;
     * - macOS Safari 14.0: getBoundingClientRect = 5% fluctuation;
     * - iOS Safari 9, 10, 11.0, 12.0: haven't found a way to zoom a page (pinch doesn't change layout);
     * - iOS Safari 13.1, 14.0: zoom reset + offsetWidth = 100% reliable;
     * - iOS Safari 13.1, 14.0: zoom reset + getBoundingClientRect = 100% reliable;
     * - iOS Safari 14.0: offsetWidth = 100% reliable;
     * - iOS Safari 14.0: getBoundingClientRect = 100% reliable;
     * - Chrome 42, 65, 80, 87: zoom 1/devicePixelRatio + offsetWidth = 1px fluctuation;
     * - Chrome 42, 65, 80, 87: zoom 1/devicePixelRatio + getBoundingClientRect = 100% reliable;
     * - Chrome 87: offsetWidth = 1px fluctuation;
     * - Chrome 87: getBoundingClientRect = 0.7px fluctuation;
     * - Firefox 48, 51: offsetWidth = 10% fluctuation;
     * - Firefox 48, 51: getBoundingClientRect = 10% fluctuation;
     * - Firefox 52, 53, 57, 62, 66, 67, 68, 71, 75, 80, 84: offsetWidth = width 100% reliable, height 10% fluctuation;
     * - Firefox 52, 53, 57, 62, 66, 67, 68, 71, 75, 80, 84: getBoundingClientRect = width 100% reliable, height 10%
     *   fluctuation;
     * - Android Chrome 86: haven't found a way to zoom a page (pinch doesn't change layout);
     * - Android Firefox 84: font size in accessibility settings changes all the CSS sizes, but offsetWidth and
     *   getBoundingClientRect keep measuring with regular units, so the size reflects the font size setting and doesn't
     *   fluctuate;
     * - IE 11, Edge 18: zoom 1/devicePixelRatio + offsetWidth = 100% reliable;
     * - IE 11, Edge 18: zoom 1/devicePixelRatio + getBoundingClientRect = reflects the zoom level;
     * - IE 11, Edge 18: offsetWidth = 100% reliable;
     * - IE 11, Edge 18: getBoundingClientRect = 100% reliable;
     */
    return withIframe(function (_, iframeWindow) {
        var iframeDocument = iframeWindow.document;
        var iframeBody = iframeDocument.body;
        var bodyStyle = iframeBody.style;
        bodyStyle.width = "".concat(containerWidthPx, "px");
        bodyStyle.webkitTextSizeAdjust = bodyStyle.textSizeAdjust = 'none';
        // See the big comment above
        if (isChromium()) {
            iframeBody.style.zoom = "".concat(1 / iframeWindow.devicePixelRatio);
        }
        else if (isWebKit()) {
            iframeBody.style.zoom = 'reset';
        }
        // See the big comment above
        var linesOfText = iframeDocument.createElement('div');
        linesOfText.textContent = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__spreadArray)([], Array((containerWidthPx / 20) << 0), true).map(function () { return 'word'; }).join(' ');
        iframeBody.appendChild(linesOfText);
        return action(iframeDocument, iframeBody);
    }, '<!doctype html><html><head><meta name="viewport" content="width=device-width, initial-scale=1">');
}

function isPdfViewerEnabled() {
    return navigator.pdfViewerEnabled;
}

/**
 * Unlike most other architectures, on x86/x86-64 when floating-point instructions
 * have no NaN arguments, but produce NaN output, the output NaN has sign bit set.
 * We use it to distinguish x86/x86-64 from other architectures, by doing subtraction
 * of two infinities (must produce NaN per IEEE 754 standard).
 *
 * See https://codebrowser.bddppq.com/pytorch/pytorch/third_party/XNNPACK/src/init.c.html#79
 */
function getArchitecture() {
    var f = new Float32Array(1);
    var u8 = new Uint8Array(f.buffer);
    f[0] = Infinity;
    f[0] = f[0] - f[0];
    return u8[3];
}

/**
 * The return type is a union instead of the enum, because it's too challenging to embed the const enum into another
 * project. Turning it into a union is a simple and an elegant solution.
 */
function getApplePayState() {
    var ApplePaySession = window.ApplePaySession;
    if (typeof (ApplePaySession === null || ApplePaySession === void 0 ? void 0 : ApplePaySession.canMakePayments) !== 'function') {
        return -1 /* ApplePayState.NoAPI */;
    }
    if (willPrintConsoleError()) {
        return -3 /* ApplePayState.NotAvailableInFrame */;
    }
    try {
        return ApplePaySession.canMakePayments() ? 1 /* ApplePayState.Enabled */ : 0 /* ApplePayState.Disabled */;
    }
    catch (error) {
        return getStateFromError(error);
    }
}
/**
 * Starting from Safari 15 calling `ApplePaySession.canMakePayments()` produces this error message when FingerprintJS
 * runs in an iframe with a cross-origin parent page, and the iframe on that page has no allow="payment *" attribute:
 *   Feature policy 'Payment' check failed for element with origin 'https://example.com' and allow attribute ''.
 * This function checks whether the error message is expected.
 *
 * We check for cross-origin parents, which is prone to false-positive results. Instead, we should check for allowed
 * feature/permission, but we can't because none of these API works in Safari yet:
 *   navigator.permissions.query({ name: ‘payment' })
 *   navigator.permissions.query({ name: ‘payment-handler' })
 *   document.featurePolicy
 */
var willPrintConsoleError = isAnyParentCrossOrigin;
function getStateFromError(error) {
    // See full expected error messages in the test
    if (error instanceof Error && error.name === 'InvalidAccessError' && /\bfrom\b.*\binsecure\b/i.test(error.message)) {
        return -2 /* ApplePayState.NotAvailableInInsecureContext */;
    }
    throw error;
}

/**
 * Checks whether the Safari's Privacy Preserving Ad Measurement setting is on.
 * The setting is on when the value is not undefined.
 * A.k.a. private click measurement, privacy-preserving ad attribution.
 *
 * Unfortunately, it doesn't work in mobile Safari.
 * Probably, it will start working in mobile Safari or stop working in desktop Safari later.
 * We've found no way to detect the setting state in mobile Safari. Help wanted.
 *
 * @see https://webkit.org/blog/11529/introducing-private-click-measurement-pcm/
 * @see https://developer.apple.com/videos/play/wwdc2021/10033
 */
function getPrivateClickMeasurement() {
    var _a;
    var link = document.createElement('a');
    var sourceId = (_a = link.attributionSourceId) !== null && _a !== void 0 ? _a : link.attributionsourceid;
    return sourceId === undefined ? undefined : String(sourceId);
}

/** WebGl context is not available */
var STATUS_NO_GL_CONTEXT = -1;
/** WebGL context `getParameter` method is not a function */
var STATUS_GET_PARAMETER_NOT_A_FUNCTION = -2;
var validContextParameters = new Set([
    10752, 2849, 2884, 2885, 2886, 2928, 2929, 2930, 2931, 2932, 2960, 2961, 2962, 2963, 2964, 2965, 2966, 2967, 2968,
    2978, 3024, 3042, 3088, 3089, 3106, 3107, 32773, 32777, 32777, 32823, 32824, 32936, 32937, 32938, 32939, 32968, 32969,
    32970, 32971, 3317, 33170, 3333, 3379, 3386, 33901, 33902, 34016, 34024, 34076, 3408, 3410, 3411, 3412, 3413, 3414,
    3415, 34467, 34816, 34817, 34818, 34819, 34877, 34921, 34930, 35660, 35661, 35724, 35738, 35739, 36003, 36004, 36005,
    36347, 36348, 36349, 37440, 37441, 37443, 7936, 7937, 7938,
    // SAMPLE_ALPHA_TO_COVERAGE (32926) and SAMPLE_COVERAGE (32928) are excluded because they trigger a console warning
    // in IE, Chrome ≤ 59 and Safari ≤ 13 and give no entropy.
]);
var validExtensionParams = new Set([
    34047,
    35723,
    36063,
    34852,
    34853,
    34854,
    34229,
    36392,
    36795,
    38449, // MAX_VIEWS_OVR
]);
var shaderTypes = ['FRAGMENT_SHADER', 'VERTEX_SHADER'];
var precisionTypes = ['LOW_FLOAT', 'MEDIUM_FLOAT', 'HIGH_FLOAT', 'LOW_INT', 'MEDIUM_INT', 'HIGH_INT'];
var rendererInfoExtensionName = 'WEBGL_debug_renderer_info';
var polygonModeExtensionName = 'WEBGL_polygon_mode';
/**
 * Gets the basic and simple WebGL parameters
 */
function getWebGlBasics(_a) {
    var _b, _c, _d, _e, _f, _g;
    var cache = _a.cache;
    var gl = getWebGLContext(cache);
    if (!gl) {
        return STATUS_NO_GL_CONTEXT;
    }
    if (!isValidParameterGetter(gl)) {
        return STATUS_GET_PARAMETER_NOT_A_FUNCTION;
    }
    var debugExtension = shouldAvoidDebugRendererInfo() ? null : gl.getExtension(rendererInfoExtensionName);
    return {
        version: ((_b = gl.getParameter(gl.VERSION)) === null || _b === void 0 ? void 0 : _b.toString()) || '',
        vendor: ((_c = gl.getParameter(gl.VENDOR)) === null || _c === void 0 ? void 0 : _c.toString()) || '',
        vendorUnmasked: debugExtension ? (_d = gl.getParameter(debugExtension.UNMASKED_VENDOR_WEBGL)) === null || _d === void 0 ? void 0 : _d.toString() : '',
        renderer: ((_e = gl.getParameter(gl.RENDERER)) === null || _e === void 0 ? void 0 : _e.toString()) || '',
        rendererUnmasked: debugExtension ? (_f = gl.getParameter(debugExtension.UNMASKED_RENDERER_WEBGL)) === null || _f === void 0 ? void 0 : _f.toString() : '',
        shadingLanguageVersion: ((_g = gl.getParameter(gl.SHADING_LANGUAGE_VERSION)) === null || _g === void 0 ? void 0 : _g.toString()) || '',
    };
}
/**
 * Gets the advanced and massive WebGL parameters and extensions
 */
function getWebGlExtensions(_a) {
    var cache = _a.cache;
    var gl = getWebGLContext(cache);
    if (!gl) {
        return STATUS_NO_GL_CONTEXT;
    }
    if (!isValidParameterGetter(gl)) {
        return STATUS_GET_PARAMETER_NOT_A_FUNCTION;
    }
    var extensions = gl.getSupportedExtensions();
    var contextAttributes = gl.getContextAttributes();
    var unsupportedExtensions = [];
    // Features
    var attributes = [];
    var parameters = [];
    var extensionParameters = [];
    var shaderPrecisions = [];
    // Context attributes
    if (contextAttributes) {
        for (var _i = 0, _b = Object.keys(contextAttributes); _i < _b.length; _i++) {
            var attributeName = _b[_i];
            attributes.push("".concat(attributeName, "=").concat(contextAttributes[attributeName]));
        }
    }
    // Context parameters
    var constants = getConstantsFromPrototype(gl);
    for (var _c = 0, constants_1 = constants; _c < constants_1.length; _c++) {
        var constant = constants_1[_c];
        var code = gl[constant];
        parameters.push("".concat(constant, "=").concat(code).concat(validContextParameters.has(code) ? "=".concat(gl.getParameter(code)) : ''));
    }
    // Extension parameters
    if (extensions) {
        for (var _d = 0, extensions_1 = extensions; _d < extensions_1.length; _d++) {
            var name_1 = extensions_1[_d];
            if ((name_1 === rendererInfoExtensionName && shouldAvoidDebugRendererInfo()) ||
                (name_1 === polygonModeExtensionName && shouldAvoidPolygonModeExtensions())) {
                continue;
            }
            var extension = gl.getExtension(name_1);
            if (!extension) {
                unsupportedExtensions.push(name_1);
                continue;
            }
            for (var _e = 0, _f = getConstantsFromPrototype(extension); _e < _f.length; _e++) {
                var constant = _f[_e];
                var code = extension[constant];
                extensionParameters.push("".concat(constant, "=").concat(code).concat(validExtensionParams.has(code) ? "=".concat(gl.getParameter(code)) : ''));
            }
        }
    }
    // Shader precision
    for (var _g = 0, shaderTypes_1 = shaderTypes; _g < shaderTypes_1.length; _g++) {
        var shaderType = shaderTypes_1[_g];
        for (var _h = 0, precisionTypes_1 = precisionTypes; _h < precisionTypes_1.length; _h++) {
            var precisionType = precisionTypes_1[_h];
            var shaderPrecision = getShaderPrecision(gl, shaderType, precisionType);
            shaderPrecisions.push("".concat(shaderType, ".").concat(precisionType, "=").concat(shaderPrecision.join(',')));
        }
    }
    // Postprocess
    extensionParameters.sort();
    parameters.sort();
    return {
        contextAttributes: attributes,
        parameters: parameters,
        shaderPrecisions: shaderPrecisions,
        extensions: extensions,
        extensionParameters: extensionParameters,
        unsupportedExtensions: unsupportedExtensions,
    };
}
/**
 * This function usually takes the most time to execute in all the sources, therefore we cache its result.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getWebGLContext(cache) {
    if (cache.webgl) {
        return cache.webgl.context;
    }
    var canvas = document.createElement('canvas');
    var context;
    canvas.addEventListener('webglCreateContextError', function () { return (context = undefined); });
    for (var _i = 0, _a = ['webgl', 'experimental-webgl']; _i < _a.length; _i++) {
        var type = _a[_i];
        try {
            context = canvas.getContext(type);
        }
        catch (_b) {
            // Ok, continue
        }
        if (context) {
            break;
        }
    }
    cache.webgl = { context: context };
    return context;
}
/**
 * https://developer.mozilla.org/en-US/docs/Web/API/WebGLShaderPrecisionFormat
 * https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/getShaderPrecisionFormat
 * https://www.khronos.org/registry/webgl/specs/latest/1.0/#5.12
 */
function getShaderPrecision(gl, shaderType, precisionType) {
    var shaderPrecision = gl.getShaderPrecisionFormat(gl[shaderType], gl[precisionType]);
    return shaderPrecision ? [shaderPrecision.rangeMin, shaderPrecision.rangeMax, shaderPrecision.precision] : [];
}
function getConstantsFromPrototype(obj) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    var keys = Object.keys(obj.__proto__);
    return keys.filter(isConstantLike);
}
function isConstantLike(key) {
    return typeof key === 'string' && !key.match(/[^A-Z0-9_x]/);
}
/**
 * Some browsers print a console warning when the WEBGL_debug_renderer_info extension is requested.
 * JS Agent aims to avoid printing messages to console, so we avoid this extension in that browsers.
 */
function shouldAvoidDebugRendererInfo() {
    return isGecko();
}
/**
 * Some browsers print a console warning when the WEBGL_polygon_mode extension is requested.
 * JS Agent aims to avoid printing messages to console, so we avoid this extension in that browsers.
 */
function shouldAvoidPolygonModeExtensions() {
    return isChromium() || isWebKit();
}
/**
 * Some unknown browsers have no `getParameter` method
 */
function isValidParameterGetter(gl) {
    return typeof gl.getParameter === 'function';
}

function getAudioContextBaseLatency() {
    var _a;
    // The signal emits warning in Chrome and Firefox, therefore it is enabled on Safari where it doesn't produce warning
    // and on Android where it's less visible
    var isAllowedPlatform = isAndroid() || isWebKit();
    if (!isAllowedPlatform) {
        return -2 /* SpecialFingerprint.Disabled */;
    }
    if (!window.AudioContext) {
        return -1 /* SpecialFingerprint.NotSupported */;
    }
    return (_a = new AudioContext().baseLatency) !== null && _a !== void 0 ? _a : -1 /* SpecialFingerprint.NotSupported */;
}

/**
 * The list of entropy sources used to make visitor identifiers.
 *
 * This value isn't restricted by Semantic Versioning, i.e. it may be changed without bumping minor or major version of
 * this package.
 *
 * Note: Rollup and Webpack are smart enough to remove unused properties of this object during tree-shaking, so there is
 * no need to export the sources individually.
 */
var sources = {
    // READ FIRST:
    // See https://github.com/fingerprintjs/fingerprintjs/blob/master/contributing.md#how-to-make-an-entropy-source
    // to learn how entropy source works and how to make your own.
    // The sources run in this exact order.
    // The asynchronous sources are at the start to run in parallel with other sources.
    fonts: getFonts,
    domBlockers: getDomBlockers,
    fontPreferences: getFontPreferences,
    audio: getAudioFingerprint,
    screenFrame: getScreenFrame,
    canvas: getCanvasFingerprint,
    osCpu: getOsCpu,
    languages: getLanguages,
    colorDepth: getColorDepth,
    deviceMemory: getDeviceMemory,
    screenResolution: getScreenResolution,
    hardwareConcurrency: getHardwareConcurrency,
    timezone: getTimezone,
    sessionStorage: getSessionStorage,
    localStorage: getLocalStorage,
    indexedDB: getIndexedDB,
    openDatabase: getOpenDatabase,
    cpuClass: getCpuClass,
    platform: getPlatform,
    plugins: getPlugins,
    touchSupport: getTouchSupport,
    vendor: getVendor,
    vendorFlavors: getVendorFlavors,
    cookiesEnabled: areCookiesEnabled,
    colorGamut: getColorGamut,
    invertedColors: areColorsInverted,
    forcedColors: areColorsForced,
    monochrome: getMonochromeDepth,
    contrast: getContrastPreference,
    reducedMotion: isMotionReduced,
    reducedTransparency: isTransparencyReduced,
    hdr: isHDR,
    math: getMathFingerprint,
    pdfViewerEnabled: isPdfViewerEnabled,
    architecture: getArchitecture,
    applePay: getApplePayState,
    privateClickMeasurement: getPrivateClickMeasurement,
    audioBaseLatency: getAudioContextBaseLatency,
    // Some sources can affect other sources (e.g. WebGL can affect canvas), so it's important to run these sources
    // after other sources.
    webGlBasics: getWebGlBasics,
    webGlExtensions: getWebGlExtensions,
};
/**
 * Loads the built-in entropy sources.
 * Returns a function that collects the entropy components to make the visitor identifier.
 */
function loadBuiltinSources(options) {
    return loadSources(sources, options, []);
}

var commentTemplate = '$ if upgrade to Pro: https://fpjs.dev/pro';
function getConfidence(components) {
    var openConfidenceScore = getOpenConfidenceScore(components);
    var proConfidenceScore = deriveProConfidenceScore(openConfidenceScore);
    return { score: openConfidenceScore, comment: commentTemplate.replace(/\$/g, "".concat(proConfidenceScore)) };
}
function getOpenConfidenceScore(components) {
    // In order to calculate the true probability of the visitor identifier being correct, we need to know the number of
    // website visitors (the higher the number, the less the probability because the fingerprint entropy is limited).
    // JS agent doesn't know the number of visitors, so we can only do an approximate assessment.
    if (isAndroid()) {
        return 0.4;
    }
    // Safari (mobile and desktop)
    if (isWebKit()) {
        return isDesktopWebKit() && !(isWebKit616OrNewer() && isSafariWebKit()) ? 0.5 : 0.3;
    }
    var platform = 'value' in components.platform ? components.platform.value : '';
    // Windows
    if (/^Win/.test(platform)) {
        // The score is greater than on macOS because of the higher variety of devices running Windows.
        // Chrome provides more entropy than Firefox according too
        // https://netmarketshare.com/browser-market-share.aspx?options=%7B%22filter%22%3A%7B%22%24and%22%3A%5B%7B%22platform%22%3A%7B%22%24in%22%3A%5B%22Windows%22%5D%7D%7D%5D%7D%2C%22dateLabel%22%3A%22Trend%22%2C%22attributes%22%3A%22share%22%2C%22group%22%3A%22browser%22%2C%22sort%22%3A%7B%22share%22%3A-1%7D%2C%22id%22%3A%22browsersDesktop%22%2C%22dateInterval%22%3A%22Monthly%22%2C%22dateStart%22%3A%222019-11%22%2C%22dateEnd%22%3A%222020-10%22%2C%22segments%22%3A%22-1000%22%7D
        // So we assign the same score to them.
        return 0.6;
    }
    // macOS
    if (/^Mac/.test(platform)) {
        // Chrome provides more entropy than Safari and Safari provides more entropy than Firefox.
        // Chrome is more popular than Safari and Safari is more popular than Firefox according to
        // https://netmarketshare.com/browser-market-share.aspx?options=%7B%22filter%22%3A%7B%22%24and%22%3A%5B%7B%22platform%22%3A%7B%22%24in%22%3A%5B%22Mac%20OS%22%5D%7D%7D%5D%7D%2C%22dateLabel%22%3A%22Trend%22%2C%22attributes%22%3A%22share%22%2C%22group%22%3A%22browser%22%2C%22sort%22%3A%7B%22share%22%3A-1%7D%2C%22id%22%3A%22browsersDesktop%22%2C%22dateInterval%22%3A%22Monthly%22%2C%22dateStart%22%3A%222019-11%22%2C%22dateEnd%22%3A%222020-10%22%2C%22segments%22%3A%22-1000%22%7D
        // So we assign the same score to them.
        return 0.5;
    }
    // Another platform, e.g. a desktop Linux. It's rare, so it should be pretty unique.
    return 0.7;
}
function deriveProConfidenceScore(openConfidenceScore) {
    return round(0.99 + 0.01 * openConfidenceScore, 0.0001);
}

function componentsToCanonicalString(components) {
    var result = '';
    for (var _i = 0, _a = Object.keys(components).sort(); _i < _a.length; _i++) {
        var componentKey = _a[_i];
        var component = components[componentKey];
        var value = 'error' in component ? 'error' : JSON.stringify(component.value);
        result += "".concat(result ? '|' : '').concat(componentKey.replace(/([:|\\])/g, '\\$1'), ":").concat(value);
    }
    return result;
}
function componentsToDebugString(components) {
    return JSON.stringify(components, function (_key, value) {
        if (value instanceof Error) {
            return errorToObject(value);
        }
        return value;
    }, 2);
}
function hashComponents(components) {
    return x64hash128(componentsToCanonicalString(components));
}
/**
 * Makes a GetResult implementation that calculates the visitor id hash on demand.
 * Designed for optimisation.
 */
function makeLazyGetResult(components) {
    var visitorIdCache;
    // This function runs very fast, so there is no need to make it lazy
    var confidence = getConfidence(components);
    // A plain class isn't used because its getters and setters aren't enumerable.
    return {
        get visitorId() {
            if (visitorIdCache === undefined) {
                visitorIdCache = hashComponents(this.components);
            }
            return visitorIdCache;
        },
        set visitorId(visitorId) {
            visitorIdCache = visitorId;
        },
        confidence: confidence,
        components: components,
        version: version,
    };
}
/**
 * A delay is required to ensure consistent entropy components.
 * See https://github.com/fingerprintjs/fingerprintjs/issues/254
 * and https://github.com/fingerprintjs/fingerprintjs/issues/307
 * and https://github.com/fingerprintjs/fingerprintjs/commit/945633e7c5f67ae38eb0fea37349712f0e669b18
 */
function prepareForSources(delayFallback) {
    if (delayFallback === void 0) { delayFallback = 50; }
    // A proper deadline is unknown. Let it be twice the fallback timeout so that both cases have the same average time.
    return requestIdleCallbackIfAvailable(delayFallback, delayFallback * 2);
}
/**
 * The function isn't exported from the index file to not allow to call it without `load()`.
 * The hiding gives more freedom for future non-breaking updates.
 *
 * A factory function is used instead of a class to shorten the attribute names in the minified code.
 * Native private class fields could've been used, but TypeScript doesn't allow them with `"target": "es5"`.
 */
function makeAgent(getComponents, debug) {
    var creationTime = Date.now();
    return {
        get: function (options) {
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
                var startTime, components, result;
                return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            startTime = Date.now();
                            return [4 /*yield*/, getComponents()];
                        case 1:
                            components = _a.sent();
                            result = makeLazyGetResult(components);
                            if (debug || (options === null || options === void 0 ? void 0 : options.debug)) {
                                // console.log is ok here because it's under a debug clause
                                // eslint-disable-next-line no-console
                                console.log("Copy the text below to get the debug data:\n\n```\nversion: ".concat(result.version, "\nuserAgent: ").concat(navigator.userAgent, "\ntimeBetweenLoadAndGet: ").concat(startTime - creationTime, "\nvisitorId: ").concat(result.visitorId, "\ncomponents: ").concat(componentsToDebugString(components), "\n```"));
                            }
                            return [2 /*return*/, result];
                    }
                });
            });
        },
    };
}
/**
 * Sends an unpersonalized AJAX request to collect installation statistics
 */
function monitor() {
    // The FingerprintJS CDN (https://github.com/fingerprintjs/cdn) replaces `window.__fpjs_d_m` with `true`
    if (window.__fpjs_d_m || Math.random() >= 0.001) {
        return;
    }
    try {
        var request = new XMLHttpRequest();
        request.open('get', "https://m1.openfpcdn.io/fingerprintjs/v".concat(version, "/npm-monitoring"), true);
        request.send();
    }
    catch (error) {
        // console.error is ok here because it's an unexpected error handler
        // eslint-disable-next-line no-console
        console.error(error);
    }
}
/**
 * Builds an instance of Agent and waits a delay required for a proper operation.
 */
function load(options) {
    var _a;
    if (options === void 0) { options = {}; }
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var delayFallback, debug, getComponents;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if ((_a = options.monitoring) !== null && _a !== void 0 ? _a : true) {
                        monitor();
                    }
                    delayFallback = options.delayFallback, debug = options.debug;
                    return [4 /*yield*/, prepareForSources(delayFallback)];
                case 1:
                    _b.sent();
                    getComponents = loadBuiltinSources({ cache: {}, debug: debug });
                    return [2 /*return*/, makeAgent(getComponents, debug)];
            }
        });
    });
}

// The default export is a syntax sugar (`import * as FP from '...' → import FP from '...'`).
// It should contain all the public exported values.
var index = { load: load, hashComponents: hashComponents, componentsToDebugString: componentsToDebugString };
// The exports below are for private usage. They may change unexpectedly. Use them at your own risk.
/** Not documented, out of Semantic Versioning, usage is at your own risk */
var murmurX64Hash128 = x64hash128;




/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=script&setup=true&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Admin_Shared_Components_Customer_Section_InvoiceSection_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Admin/Shared/Components/Customer/Section/InvoiceSection.vue */ "./resources/js/Pages/Admin/Shared/Components/Customer/Section/InvoiceSection.vue");
/* harmony import */ var _Admin_Shared_Components_Customer_Section_QuotesSection_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Shared/Components/Customer/Section/QuotesSection.vue */ "./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue");
/* harmony import */ var _Admin_Shared_Components_Customer_Section_RecentActivity_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Components/Customer/Section/RecentActivity.vue */ "./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue");
/* harmony import */ var _Admin_Shared_Components_Customer_Section_EventsAndLogs_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Components/Customer/Section/EventsAndLogs.vue */ "./resources/js/Pages/Admin/Shared/Components/Customer/Section/EventsAndLogs.vue");
/* harmony import */ var _Shared_Components_Customer_Section_PaymentMethod_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Shared/Components/Customer/Section/PaymentMethod.vue */ "./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue");
/* harmony import */ var _Shared_Components_Title_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Shared/Components/Title.vue */ "./resources/js/Pages/Admin/Shared/Components/Title.vue");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Admin/Shared/Components/Tooltip.vue */ "./resources/js/Pages/Admin/Shared/Components/Tooltip.vue");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Admin_Shared_Composables_payments__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @Admin/Shared/Composables/payments */ "./resources/js/Pages/Admin/Shared/Composables/payments.js");
/* harmony import */ var _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @Admin/Shared/Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
/* harmony import */ var _Admin_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @Admin/Shared/Components/Popup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popup.vue");
/* harmony import */ var _Admin_Shared_Components_Popups_CustomerPopup_vue__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @Admin/Shared/Components/Popups/CustomerPopup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue");
/* harmony import */ var _Admin_Shared_Components_Popups_DeletePopup_vue__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @Admin/Shared/Components/Popups/DeletePopup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _Admin_Shared_Components_Notify_vue__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @Admin/Shared/Components/Notify.vue */ "./resources/js/Pages/Admin/Shared/Components/Notify.vue");
/* harmony import */ var _Payment_RefundPopup_vue__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../Payment/RefundPopup.vue */ "./resources/js/Pages/Admin/Payment/RefundPopup.vue");
/* harmony import */ var _Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @Admin/Shared/Composables/useNotification */ "./resources/js/Pages/Admin/Shared/Composables/useNotification.js");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");
/* harmony import */ var _Admin_Shared_Components_Customer_Section_RelatedBriefSection_vue__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue */ "./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue");
/* harmony import */ var _Admin_Shared_Components_Payments_AmountColumn_vue__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @Admin/Shared/Components/Payments/AmountColumn.vue */ "./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }























/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Detail',
  props: {
    customer: Object,
    total_spent: Number,
    countries: Array,
    relatedBrief: {
      type: Object,
      required: true
    }
  },
  setup: function setup(__props, _ref) {
    var _isJsonString, _props$customer15, _props$customer16;
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var checkedOptions = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      allSelected: false,
      options: []
    });
    var selectAllCheckbox = function selectAllCheckbox() {
      var succeededPayments = props.customer.payments.filter(function (payment) {
        return payment.status === 1;
      });
      if (succeededPayments.length !== checkedOptions.value.options.length) {
        var selectedOptions = [];
        for (var i = 0; i < succeededPayments.length; i++) {
          selectedOptions.push(succeededPayments[i].id);
        }
        checkedOptions.value.options = selectedOptions;
        checkedOptions.value.allSelected = true;
      } else {
        checkedOptions.value.options = [];
        checkedOptions.value.allSelected = false;
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(checkedOptions.value, function () {
      if (checkedOptions.value.options.length === props.customer.payments.length) {
        checkedOptions.value.allSelected = true;
      } else {
        checkedOptions.value.allSelected = false;
      }
    });
    var sendEmailVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var notify = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var customerEmail = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var paymentId = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var allowBlockList = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      isBlocked: Boolean,
      message: String,
      popup: {
        visible: false,
        title: String,
        bodyText: String,
        btnText: String
      }
    });
    var testInvoice = (0,vue__WEBPACK_IMPORTED_MODULE_0__.reactive)({
      emails: customerEmail ? customerEmail : '',
      ccEmails: '',
      payment_id: paymentId ? paymentId : 0
    });
    var notificationData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      msg: "",
      autoClose: 3000,
      theme: "dark",
      type: "success",
      position: "bottom-center"
    });
    var refundPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var updateVisibility = function updateVisibility(newValue) {
      refundPopupVisibility.value = newValue;
    };
    var deletePopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var deleteCustomerResponse = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    var deleteCustomer = function deleteCustomer() {
      axios__WEBPACK_IMPORTED_MODULE_14___default().post(route("admin.customer.delete"), {
        id: props.customer.id
      }).then(function (response) {
        if (response.data.success) {
          notificationData.value.msg = response.data.message;
          notificationData.value.type = "promise";
          notificationData.value.response = deleteCustomerResponse.value;
          notify.value = true;
          _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__.router.visit(route('admin.customer.list'));
        } else {
          notificationData.value.response = deleteCustomerResponse.value;
          notificationData.value.msg = response.data.message;
          notificationData.value.type = "error";
          notify.value = true;
        }
      })["catch"](function (response) {
        notificationData.value.msg = "Customer Not Deleted!";
        notificationData.value.type = "error";
        notify.value = true;
      });
      deletePopupVisibility.value = false;
    };
    var customerDetail = (0,vue__WEBPACK_IMPORTED_MODULE_0__.reactive)({
      first_name: "",
      last_name: "",
      email: "",
      phone: "",
      address: "",
      city: "",
      company: "",
      state: "",
      zipcode: "",
      country: 0
    });
    var metaInputs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([{
      key: "",
      value: ""
    }]);
    var payments = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeMount)(function () {
      var _props$customer, _props$customer2, _props$customer3, _props$customer4, _props$customer5, _props$customer6, _props$customer7, _props$customer8, _props$customer9, _props$customer10, _props$customer11, _props$customer12;
      (_props$customer = props.customer) === null || _props$customer === void 0 || (_props$customer = _props$customer.payments) === null || _props$customer === void 0 || _props$customer.map(function (payment) {
        payment["paymentStatus"] = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__.findByID)(_Admin_Shared_Composables_payments__WEBPACK_IMPORTED_MODULE_9__.statuses, payment.status);
      });
      payments.value = (_props$customer2 = props.customer) === null || _props$customer2 === void 0 ? void 0 : _props$customer2.payments;
      customerDetail.first_name = (_props$customer3 = props.customer) === null || _props$customer3 === void 0 ? void 0 : _props$customer3.first_name;
      customerDetail.last_name = (_props$customer4 = props.customer) === null || _props$customer4 === void 0 ? void 0 : _props$customer4.last_name;
      customerDetail.email = (_props$customer5 = props.customer) === null || _props$customer5 === void 0 ? void 0 : _props$customer5.email;
      customerDetail.phone = (_props$customer6 = props.customer) === null || _props$customer6 === void 0 ? void 0 : _props$customer6.phone;
      customerDetail.address = (_props$customer7 = props.customer) === null || _props$customer7 === void 0 ? void 0 : _props$customer7.address;
      customerDetail.city = (_props$customer8 = props.customer) === null || _props$customer8 === void 0 ? void 0 : _props$customer8.city;
      customerDetail.company = (_props$customer9 = props.customer) === null || _props$customer9 === void 0 ? void 0 : _props$customer9.company;
      customerDetail.state = (_props$customer10 = props.customer) === null || _props$customer10 === void 0 ? void 0 : _props$customer10.state;
      customerDetail.zipcode = (_props$customer11 = props.customer) === null || _props$customer11 === void 0 ? void 0 : _props$customer11.zipcode;
      customerDetail.country = (_props$customer12 = props.customer) === null || _props$customer12 === void 0 ? void 0 : _props$customer12.country;
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      var _props$customer13;
      initializeAllowBlockList((_props$customer13 = props.customer) === null || _props$customer13 === void 0 ? void 0 : _props$customer13.isBlocked);
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onUpdated)(function () {
      var _props$customer14;
      initializeAllowBlockList((_props$customer14 = props.customer) === null || _props$customer14 === void 0 ? void 0 : _props$customer14.isBlocked);
    });
    var addInput = function addInput() {
      metaInputs.value.push({
        key: "",
        value: ""
      });
    };
    var removeInput = function removeInput(index) {
      if (metaInputs.value.length > 1) {
        metaInputs.value.splice(index, 1);
      }
    };
    var detailContentDiv = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var showMoreDetail = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var detailPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var metadataPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var stripe = (_isJsonString = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__.isJsonString)((_props$customer15 = props.customer) === null || _props$customer15 === void 0 ? void 0 : _props$customer15.stripe)) !== null && _isJsonString !== void 0 ? _isJsonString : {};
    var customerID = stripe === null || stripe === void 0 ? void 0 : stripe.id;
    var paymentMethod = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__.isJsonString)((_props$customer16 = props.customer) === null || _props$customer16 === void 0 ? void 0 : _props$customer16.stripe_payment_method);
    var showDetail = function showDetail(e) {
      var _parentNode, _parentNode2, _parentNode3;
      var parentNode;
      if (e.target.tagName === "A") {
        parentNode = e.target.parentNode.parentNode;
      } else if (e.target.tagName === "I") {
        parentNode = e.target.parentNode.parentNode.parentNode;
      }
      (_parentNode = parentNode) === null || _parentNode === void 0 || (_parentNode = _parentNode.querySelector(".purpleLink")) === null || _parentNode === void 0 || _parentNode.classList.toggle("showThis");
      (_parentNode2 = parentNode) === null || _parentNode2 === void 0 || (_parentNode2 = _parentNode2.querySelector(".showinnerdiv")) === null || _parentNode2 === void 0 || _parentNode2.classList.toggle("flexVisible");
      (_parentNode3 = parentNode) === null || _parentNode3 === void 0 || (_parentNode3 = _parentNode3.querySelector("i.bx-caret-right")) === null || _parentNode3 === void 0 || _parentNode3.classList.toggle("rotateIcon");
    };

    // const toggleBillingInfo = e => {
    //    e.currentTarget.classList.toggle("hide");
    //   const inputs = e.currentTarget.parentNode.querySelectorAll('.popup-details-input');
    //   inputs.forEach(input => input.classList.toggle('d-none'))
    // }

    var showDetailPopup = function showDetailPopup() {
      detailPopupVisibility.value = true;
    };
    var hideDetailPopup = function hideDetailPopup() {
      detailPopupVisibility.value = false;
    };
    var showMetaPopup = function showMetaPopup() {
      var metaObject = [];
      if (stripe && stripe.metadata) {
        Object.keys(stripe === null || stripe === void 0 ? void 0 : stripe.metadata).forEach(function (key) {
          metaObject.push({
            key: key,
            value: stripe === null || stripe === void 0 ? void 0 : stripe.metadata[key]
          });
        });
      }
      metaInputs.value = metaObject;
      metadataPopupVisibility.value = true;
    };
    var updateMetadata = function updateMetadata() {
      hideMetaPopup();
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__.router.visit(route("admin.customer.update.metadata", {
        clientID: props.customer.id
      }), {
        method: "post",
        data: {
          metadata: metaInputs.value
        },
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var hideMetaPopup = function hideMetaPopup() {
      metadataPopupVisibility.value = false;
    };
    var togglePopupArea = function togglePopupArea(e) {
      var element = e.target;
      if (element.tagName.toLowerCase() === "input") {
        element.parentNode.parentNode.querySelector(".popupToggleArea").classList.toggle("show");
      }
    };
    var showMoreDetailFunc = function showMoreDetailFunc() {
      detailContentDiv.value.classList.toggle("expanded");
      var btnText = showMoreDetail.value.text;
      showMoreDetail.value.text = btnText == "Show More" ? "Show Less" : "Show More";
    };
    var updateCustomer = function updateCustomer(formData) {
      axios__WEBPACK_IMPORTED_MODULE_14___default().post(route("admin.customer.update", {
        clientID: props.customer.id
      }), formData).then(function (response) {
        if (!response.data.errors && response.status == 200) {
          notificationData.value.msg = 'Customer Updated Successfully';
          notificationData.value.type = 'success';
          hideDetailPopup();
          notify.value = true;
          _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__.router.visit(route("admin.customer.detail", {
            id: props.customer.id
          }));
        } else if (response.data.errors) {
          errors = response.data.errors;
        }
      })["catch"](function (error) {
        console.error('Error:', error);
        notificationData.value.msg = 'Customer Not Updated!';
        notificationData.value.type = 'error';
        notify.value = true;
      });
    };
    var visitPaymentDetail = function visitPaymentDetail(token) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__.router.visit(route("admin.payment.detail.id", {
        id: token
      }), {
        method: "get",
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var selectedPayment = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var paymentCurrency = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var showRefundPopup = function showRefundPopup(payment) {
      var _payment$link;
      refundPopupVisibility.value = true;
      selectedPayment.value = {
        id: payment === null || payment === void 0 ? void 0 : payment.id,
        price: payment === null || payment === void 0 ? void 0 : payment.price
      };
      console.log(selectedPayment.value);
      paymentCurrency.value = payment === null || payment === void 0 || (_payment$link = payment.link) === null || _payment$link === void 0 ? void 0 : _payment$link.currency_country;
    };
    var sentTestingInvoice = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var _response$data, response;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (!(testInvoice.payment_id != 0 && testInvoice.emails != '')) {
                _context.next = 8;
                break;
              }
              _context.next = 3;
              return axios__WEBPACK_IMPORTED_MODULE_14___default().post(route('admin.invoice.sendTestInvoice'), testInvoice);
            case 3:
              response = _context.sent;
              sendEmailVisibility.value = false;
              if (response !== null && response !== void 0 && (_response$data = response.data) !== null && _response$data !== void 0 && _response$data.success) {
                (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__.useNotification)().success(response.data.message);
              } else {
                (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__.useNotification)().error(response.data.message);
              }
              _context.next = 11;
              break;
            case 8:
              testInvoice.emails = '';
              testInvoice.ccEmails = '';
              (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__.useNotification)().error('Email cannot be empty');
            case 11:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function sentTestingInvoice() {
        return _ref2.apply(this, arguments);
      };
    }();
    var initializeAllowBlockList = function initializeAllowBlockList(isBlocked) {
      allowBlockList.value.isBlocked = isBlocked ? true : false;
      if (!allowBlockList.value.isBlocked) {
        allowBlockList.value.message = 'Add to block list';
        allowBlockList.value.popup.title = 'Add to block list?';
        allowBlockList.value.popup.bodyText = "If you add a customer to block list, they can be blocked by a Radar rule.";
        allowBlockList.value.popup.btnText = 'Add';
      } else {
        allowBlockList.value.message = 'Remove from block list';
        allowBlockList.value.popup.title = 'Remove from allow list?';
        allowBlockList.value.popup.bodyText = "If you remove a customer from block list, they can't be blocked by a Radar rule.";
        allowBlockList.value.popup.btnText = 'Remove';
      }
    };
    var AddToAllowBlockList = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(customerID, isBlocked) {
        var _allowBlockRequest;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.prev = 0;
              _context2.next = 3;
              return axios__WEBPACK_IMPORTED_MODULE_14___default().post(route('admin.customer.allow.block.list', {
                id: customerID
              }), {
                isBlocked: isBlocked
              });
            case 3:
              _allowBlockRequest = _context2.sent;
              (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__.useNotification)().success(_allowBlockRequest.data.message);
              console.log(_allowBlockRequest.data.message);
              allowBlockList.value.popup.visible = false;
              setTimeout(function () {
                _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__.router.reload({
                  only: ['customer']
                });
              }, 2000);
              _context2.next = 14;
              break;
            case 10:
              _context2.prev = 10;
              _context2.t0 = _context2["catch"](0);
              if (_context2.t0.response) {
                // The request was made and the server responded with a status code
                console.log(_context2.t0.response.data); // Log the response data from the server
                console.log(_context2.t0.response.status); // Log the HTTP status code
              } else if (_context2.t0.request) {
                // The request was made but no response was received
                console.error(_context2.t0.request);
              } else {
                // Something happened in setting up the request that triggered an error
                console.error('Error:', _context2.t0.message);
                (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__.useNotification)().error(allowBlockRequest.data.message);
              }
              allowBlockList.value.popup.visible = false;
            case 14:
            case "end":
              return _context2.stop();
          }
        }, _callee2, null, [[0, 10]]);
      }));
      return function AddToAllowBlockList(_x, _x2) {
        return _ref3.apply(this, arguments);
      };
    }();
    var __returned__ = {
      props: props,
      checkedOptions: checkedOptions,
      selectAllCheckbox: selectAllCheckbox,
      sendEmailVisibility: sendEmailVisibility,
      notify: notify,
      customerEmail: customerEmail,
      paymentId: paymentId,
      allowBlockList: allowBlockList,
      testInvoice: testInvoice,
      notificationData: notificationData,
      refundPopupVisibility: refundPopupVisibility,
      updateVisibility: updateVisibility,
      deletePopupVisibility: deletePopupVisibility,
      deleteCustomerResponse: deleteCustomerResponse,
      deleteCustomer: deleteCustomer,
      customerDetail: customerDetail,
      metaInputs: metaInputs,
      payments: payments,
      addInput: addInput,
      removeInput: removeInput,
      detailContentDiv: detailContentDiv,
      showMoreDetail: showMoreDetail,
      detailPopupVisibility: detailPopupVisibility,
      metadataPopupVisibility: metadataPopupVisibility,
      stripe: stripe,
      customerID: customerID,
      paymentMethod: paymentMethod,
      showDetail: showDetail,
      showDetailPopup: showDetailPopup,
      hideDetailPopup: hideDetailPopup,
      showMetaPopup: showMetaPopup,
      updateMetadata: updateMetadata,
      hideMetaPopup: hideMetaPopup,
      togglePopupArea: togglePopupArea,
      showMoreDetailFunc: showMoreDetailFunc,
      updateCustomer: updateCustomer,
      visitPaymentDetail: visitPaymentDetail,
      selectedPayment: selectedPayment,
      paymentCurrency: paymentCurrency,
      showRefundPopup: showRefundPopup,
      sentTestingInvoice: sentTestingInvoice,
      initializeAllowBlockList: initializeAllowBlockList,
      AddToAllowBlockList: AddToAllowBlockList,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      reactive: vue__WEBPACK_IMPORTED_MODULE_0__.reactive,
      onBeforeMount: vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeMount,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      onUpdated: vue__WEBPACK_IMPORTED_MODULE_0__.onUpdated,
      InvoiceSection: _Admin_Shared_Components_Customer_Section_InvoiceSection_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      QuotesSection: _Admin_Shared_Components_Customer_Section_QuotesSection_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      RecentActivity: _Admin_Shared_Components_Customer_Section_RecentActivity_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
      EventsAndLogs: _Admin_Shared_Components_Customer_Section_EventsAndLogs_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
      PaymentMethodSection: _Shared_Components_Customer_Section_PaymentMethod_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
      Title: _Shared_Components_Title_vue__WEBPACK_IMPORTED_MODULE_6__["default"],
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_21__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_22__["default"];
      },
      Tooltip: _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_7__["default"],
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_8__.router;
      },
      get statuses() {
        return _Admin_Shared_Composables_payments__WEBPACK_IMPORTED_MODULE_9__.statuses;
      },
      get findByID() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__.findByID;
      },
      get isJsonString() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__.isJsonString;
      },
      Popup: _Admin_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_11__["default"],
      CustomerPopup: _Admin_Shared_Components_Popups_CustomerPopup_vue__WEBPACK_IMPORTED_MODULE_12__["default"],
      DeletePopup: _Admin_Shared_Components_Popups_DeletePopup_vue__WEBPACK_IMPORTED_MODULE_13__["default"],
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_14___default());
      },
      Notify: _Admin_Shared_Components_Notify_vue__WEBPACK_IMPORTED_MODULE_15__["default"],
      RefundPopup: _Payment_RefundPopup_vue__WEBPACK_IMPORTED_MODULE_16__["default"],
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      get useNotification() {
        return _Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_17__.useNotification;
      },
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_18__["default"],
      RelatedBriefSection: _Admin_Shared_Components_Customer_Section_RelatedBriefSection_vue__WEBPACK_IMPORTED_MODULE_19__["default"],
      AmountColumn: _Admin_Shared_Components_Payments_AmountColumn_vue__WEBPACK_IMPORTED_MODULE_20__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=script&setup=true&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=script&setup=true&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Admin_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Admin/Shared/Components/Popup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popup.vue");
/* harmony import */ var _Admin_Shared_Components_Popups_PasswordPopup_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Shared/Components/Popups/PasswordPopup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Composables/useNotification */ "./resources/js/Pages/Admin/Shared/Composables/useNotification.js");
/* harmony import */ var _Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Admin/Shared/Composables/useRefundNotification */ "./resources/js/Pages/Admin/Shared/Composables/useRefundNotification.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Admin/Shared/Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }









var __default__ = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'RefundPopup',
  inheritAttrs: false,
  customOptions: {}
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/Object.assign(__default__, {
  props: {
    type: {
      type: String,
      required: false,
      "default": "single"
    },
    data: Object,
    currency: {
      type: Object,
      "default": {
        aplha_code3: "USA",
        code: "USD",
        id: 170,
        symbol: "$"
      }
    },
    visibility: Boolean,
    onClose: Function,
    maxWidth: {
      type: String,
      "default": "450px"
    }
  },
  emits: ["update:visibility"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    ;
    var props = __props;
    var emit = __emit;
    var refundBtn = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var errors = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({});
    var passwordPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var paymentsToRefund = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var refundCount = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      success: 0,
      failed: 0,
      cancelled: 0
    });
    var title = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)("");
    var showCustomToast = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      visibility: false,
      status: false
    });
    var refundPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var refundData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.reactive)({
      amount: 0,
      count: 0,
      ids: []
    });
    var notificationData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      autoClose: 3000,
      theme: "dark",
      type: "success",
      position: "bottom-center"
    });
    var popupFormData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      amount: 0,
      reason: "duplicate",
      detailed_reason: "",
      payments: []
    });
    var isUndoTriggered = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      title.value = "Refund payment";
      if (props.type != "single") {
        title.value = "Refund " + refundData.count + " payment";
      }
    });
    var checkAmount = function checkAmount(amount) {
      var price = refundData.amount;
      if (amount < 0 || amount == 0) {
        popupFormData.value.amount = 0;
        refundBtn.value.setAttribute('disabled', true);
      } else if (amount > price) {
        popupFormData.value.amount = price;
        refundBtn.value.setAttribute('disabled', false);
      } else {
        popupFormData.value.amount = amount;
        popupFormData.value.amount = popupFormData.value.amount.toString().replace(/^0+/, '');
        refundBtn.value.removeAttribute('disabled');
      }
    };
    var checkBlank = function checkBlank(amount) {
      if (amount == '') {
        popupFormData.value.amount = 0;
      }
    };
    var resetCount = function resetCount() {
      refundCount.value.success = 0;
      refundCount.value.failed = 0;
      refundCount.value.cancelled = 0;
    };
    var refundPayments = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var toastId, total, mainToast, _loop, index;
        return _regeneratorRuntime().wrap(function _callee$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              isUndoTriggered.value = false;
              showCustomToast.value.status = false;
              resetCount();
              toastId = (0,_Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification)().custom("Refunding your payments", "Undo", function () {
                return undoNotify(toastId);
              });
              refundPopupVisibility.value = false;
              popupFormData.value.payments = props.data.refundIDs;
              paymentsToRefund.value = popupFormData.value.payments.map(function (payment) {
                return {
                  id: payment,
                  status: true,
                  processing: false
                };
              });
              _context2.next = 9;
              return new Promise(function (resolve) {
                return setTimeout(resolve, 5000);
              });
            case 9:
              (0,_Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification)().remove(toastId);
              total = paymentsToRefund.value.length;
              if (isUndoTriggered.value) {
                _context2.next = 15;
                break;
              }
              _context2.next = 14;
              return new Promise(function (resolve) {
                return setTimeout(resolve, 1000);
              });
            case 14:
              mainToast = (0,_Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification)().loading("Refunding payment 0 of ".concat(total), "Cancel", function () {
                return cancelRefund(0);
              }, refundCount.value.success, refundCount.value.failed, refundCount.value.cancelled);
            case 15:
              _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop(index) {
                var payment, refund;
                return _regeneratorRuntime().wrap(function _loop$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      payment = paymentsToRefund.value[index];
                      if (!isUndoTriggered.value) {
                        _context.next = 3;
                        break;
                      }
                      return _context.abrupt("return", 1);
                    case 3:
                      // Stop processing if undo is triggered

                      (0,_Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification)().update(mainToast, 'loading', "Refunding payment ".concat(index + 1, " of ").concat(total), "Cancel", function () {
                        return cancelRefund(index);
                      }, refundCount.value.success, refundCount.value.failed, refundCount.value.cancelled);
                      _context.next = 6;
                      return new Promise(function (resolve) {
                        return setTimeout(resolve, 3000);
                      });
                    case 6:
                      if (!(payment.status && !isUndoTriggered.value)) {
                        _context.next = 13;
                        break;
                      }
                      _context.next = 9;
                      return refundSinglePayment({
                        amount: popupFormData.value.amount,
                        reason: popupFormData.value.reason,
                        detailed_reason: popupFormData.value.detailed_reason,
                        gateway: props.data.payment_gateway.gateway,
                        currency: props.data.currency_country
                      }, payment.id, index);
                    case 9:
                      refund = _context.sent;
                      if (refund.success) {
                        refundCount.value.success++;
                      } else {
                        refundCount.value.failed++;
                      }
                      _context.next = 14;
                      break;
                    case 13:
                      refundCount.value.cancelled++;
                    case 14:
                    case "end":
                      return _context.stop();
                  }
                }, _loop);
              });
              index = 0;
            case 17:
              if (!(index < paymentsToRefund.value.length)) {
                _context2.next = 24;
                break;
              }
              return _context2.delegateYield(_loop(index), "t0", 19);
            case 19:
              if (!_context2.t0) {
                _context2.next = 21;
                break;
              }
              return _context2.abrupt("break", 24);
            case 21:
              index++;
              _context2.next = 17;
              break;
            case 24:
              (0,_Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification)().remove(mainToast);
              if (!isUndoTriggered.value) {
                setTimeout(function () {
                  (0,_Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification)().success("Payments Refunded", "Review", function () {
                    return reviewRefundedPayments();
                  }, refundCount.value.success, refundCount.value.failed, refundCount.value.cancelled);
                }, 1000);
              }
              _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_6__.router.reload();
            case 27:
            case "end":
              return _context2.stop();
          }
        }, _callee);
      }));
      return function refundPayments() {
        return _ref2.apply(this, arguments);
      };
    }();
    var calculateRefundAmount = function calculateRefundAmount(payments, refundIDs) {
      var amount = 0;
      payments.map(function (payment) {
        if (refundIDs.includes(payment.id)) {
          amount += payment.price;
        }
      });
      return amount;
    };
    var cancelRefundPopup = function cancelRefundPopup() {
      props.data.refundIDs = [];
      //checkedOptions.value.allSelected = false;

      refundPopupVisibility.value = false;
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return props.visibility;
    }, function (visibility) {
      if (visibility) {
        if (props.type == "single") {
          var _findByID;
          title.value = "Refund payment";
          refundData.count = 1;
          refundData.amount = (_findByID = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_7__.findByID)(props.data.payments, props.data.refundIDs[0])) === null || _findByID === void 0 ? void 0 : _findByID.price;
          popupFormData.value.amount = refundData.amount;
        } else {
          refundData.count = props.data.refundIDs.length;
          refundData.amount = calculateRefundAmount(props.data.payments, props.data.refundIDs);
          popupFormData.value.amount = refundData.amount;
          refundData.ids = props.data.refundIDs;
          title.value = "Refund " + refundData.count + " payment";
        }
        refundPopupVisibility.value = true;
      } else {
        refundPopupVisibility.value = false;
      }
      emit("update:visibility", refundPopupVisibility.value);
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return refundPopupVisibility.value;
    }, function (visibility) {
      emit("update:visibility", refundPopupVisibility.value);
    });
    var refundPayment = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(payload) {
        var refundProcess;
        return _regeneratorRuntime().wrap(function _callee2$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              _context3.prev = 0;
              _context3.next = 3;
              return axios__WEBPACK_IMPORTED_MODULE_3___default().post(route("admin.payment.refund.single"), payload);
            case 3:
              refundProcess = _context3.sent;
              return _context3.abrupt("return", refundProcess.data);
            case 7:
              _context3.prev = 7;
              _context3.t0 = _context3["catch"](0);
              throw _context3.t0;
            case 10:
            case "end":
              return _context3.stop();
          }
        }, _callee2, null, [[0, 7]]);
      }));
      return function refundPayment(_x) {
        return _ref3.apply(this, arguments);
      };
    }();
    var refundSinglePayment = function refundSinglePayment(refundData, paymentID, index) {
      return new Promise( /*#__PURE__*/function () {
        var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(resolve, reject) {
          var refundProcess, message, success, error;
          return _regeneratorRuntime().wrap(function _callee3$(_context4) {
            while (1) switch (_context4.prev = _context4.next) {
              case 0:
                _context4.prev = 0;
                _context4.next = 3;
                return refundPayment({
                  payment: paymentID,
                  reason: refundData.reason,
                  detailed_reason: refundData.detailed_reason,
                  amount: refundData.amount,
                  gateway: refundData.gateway,
                  currency: refundData.currency
                });
              case 3:
                refundProcess = _context4.sent;
                if (refundProcess !== null && refundProcess !== void 0 && refundProcess.success) {
                  //useNotification().success(refundProcess?.message);
                  success = true;
                  error = refundProcess === null || refundProcess === void 0 ? void 0 : refundProcess.error;
                  message = refundProcess === null || refundProcess === void 0 ? void 0 : refundProcess.message;
                } else {
                  // useNotification().error('Something went wrong');
                  success = false;
                  message = refundProcess === null || refundProcess === void 0 ? void 0 : refundProcess.message;
                }
                resolve({
                  success: success,
                  message: message
                });
                _context4.next = 11;
                break;
              case 8:
                _context4.prev = 8;
                _context4.t0 = _context4["catch"](0);
                reject({
                  success: false,
                  message: _context4.t0.message
                });
              case 11:
              case "end":
                return _context4.stop();
            }
          }, _callee3, null, [[0, 8]]);
        }));
        return function (_x2, _x3) {
          return _ref4.apply(this, arguments);
        };
      }());
    };
    var undoNotify = function undoNotify(toastID) {
      isUndoTriggered.value = true; // Set the undo flag
      (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_4__.useNotification)().remove(toastID);
      console.log("Undo triggered, refunding payments canceled.");
      (0,_Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_4__.useNotification)().error("Undo Refunding payments", notificationData.value);
      showCustomToast.value.status = true;
    };
    var cancelRefund = function cancelRefund(index) {
      var payment = paymentsToRefund.value[index];
      if (payment) {
        payment.status = false;
        console.log("Refund for payment ".concat(payment.id, " cancelled."));
      }
    };
    var reviewRefundedPayments = function reviewRefundedPayments() {
      console.log('REVIEW REFUNDED');
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_6__.router.visit(route('admin.payment.refund.list'), {
        method: "get",
        data: {
          'payments': popupFormData.value.payments,
          'successCount': refundCount.value.success,
          'failedCount': refundCount.value.failed,
          'cancelCount': refundCount.value.cancelled
        },
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(passwordPopupVisibility, function (newValue) {
      if (newValue === true) {
        refundPopupVisibility.value = false;
      }
    });

    // watch(popupFormData.value, (newAmount) => {
    //   refundData.amount = newAmount.amount;
    // });

    var __returned__ = {
      props: props,
      emit: emit,
      refundBtn: refundBtn,
      errors: errors,
      passwordPopupVisibility: passwordPopupVisibility,
      paymentsToRefund: paymentsToRefund,
      refundCount: refundCount,
      title: title,
      showCustomToast: showCustomToast,
      refundPopupVisibility: refundPopupVisibility,
      refundData: refundData,
      notificationData: notificationData,
      popupFormData: popupFormData,
      isUndoTriggered: isUndoTriggered,
      checkAmount: checkAmount,
      checkBlank: checkBlank,
      resetCount: resetCount,
      refundPayments: refundPayments,
      calculateRefundAmount: calculateRefundAmount,
      cancelRefundPopup: cancelRefundPopup,
      refundPayment: refundPayment,
      refundSinglePayment: refundSinglePayment,
      undoNotify: undoNotify,
      cancelRefund: cancelRefund,
      reviewRefundedPayments: reviewRefundedPayments,
      __MACROS_defineComponent: vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      reactive: vue__WEBPACK_IMPORTED_MODULE_0__.reactive,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      Popup: _Admin_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      PasswordPopup: _Admin_Shared_Components_Popups_PasswordPopup_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_3___default());
      },
      get useNotification() {
        return _Admin_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_4__.useNotification;
      },
      get useRefundNotification() {
        return _Admin_Shared_Composables_useRefundNotification__WEBPACK_IMPORTED_MODULE_5__.useRefundNotification;
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_6__.router;
      },
      get findByID() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_7__.findByID;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
}));

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Badge',
  props: {
    badgeClass: {
      type: String,
      "default": ''
    },
    badgeText: {
      type: String,
      "default": ''
    },
    iconClass: {
      type: String,
      "default": ''
    },
    iconPosition: {
      type: String,
      "default": null
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var __returned__ = {
      props: props
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/EventsAndLogs.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/EventsAndLogs.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Composables_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'EventsAndLogs',
  props: {
    customerLogs: Array,
    payments: Array
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var detailLogs = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)([]);
    var logs = function logs() {
      var paymentLogs = [];
      props.payments.forEach(function (payment) {
        paymentLogs.push.apply(paymentLogs, _toConsumableArray(payment.payment_logs));
      });
      paymentLogs.push.apply(paymentLogs, _toConsumableArray(props.customerLogs));

      // Filter logs where type is not 'note'
      var filteredLogs = paymentLogs.filter(function (log) {
        return log.type !== 'note';
      });

      // Sort the filtered logs by created_at in descending order
      filteredLogs.sort(function (a, b) {
        return new Date(b.created_at) - new Date(a.created_at);
      });
      return filteredLogs;
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      detailLogs.value = logs();
    });
    var visitCustomerLogsDetail = function visitCustomerLogsDetail(id) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.logs.detail', {
        id: id
      }), {
        method: 'get',
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var visitCustomerEventDetail = function visitCustomerEventDetail(id, type) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.events.detail', {
        id: id
      }), {
        method: 'get',
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var logURL = function logURL(log) {
      var logDetail = (0,_Composables_functions__WEBPACK_IMPORTED_MODULE_2__.isJsonString)(log);
      var url = logDetail !== null && logDetail !== void 0 && logDetail.id ? logDetail.object + '/' + logDetail.id : logDetail === null || logDetail === void 0 ? void 0 : logDetail.object;
      return url;
    };
    var __returned__ = {
      props: props,
      detailLogs: detailLogs,
      logs: logs,
      visitCustomerLogsDetail: visitCustomerLogsDetail,
      visitCustomerEventDetail: visitCustomerEventDetail,
      logURL: logURL,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      get isJsonString() {
        return _Composables_functions__WEBPACK_IMPORTED_MODULE_2__.isJsonString;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/InvoiceSection.vue?vue&type=script&setup=true&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/InvoiceSection.vue?vue&type=script&setup=true&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Admin_Shared_Composables_enums__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Admin/Shared/Composables/enums */ "./resources/js/Pages/Admin/Shared/Composables/enums.js");
/* harmony import */ var _Admin_Shared_Composables_Invoice_useDownload__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Shared/Composables/Invoice/useDownload */ "./resources/js/Pages/Admin/Shared/Composables/Invoice/useDownload.js");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'InvoiceSection',
  props: {
    invoices: Array,
    customerID: Number
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var invoiceDetail = function invoiceDetail(id) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.invoice.detail.id', {
        id: id
      }), {
        method: 'get',
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var _useDownload = (0,_Admin_Shared_Composables_Invoice_useDownload__WEBPACK_IMPORTED_MODULE_2__.useDownload)(),
      downloadInvoice = _useDownload.download;

    // const DuplicateInvoice = async (invoiceID, invoiceNo) => {
    //     console.log(invoiceID, invoiceNo);
    //     const duplicateToast = toast("Duplicating " + invoiceNo + "..", {
    //         theme: "dark",
    //         type: "info",
    //         position: "bottom-right",
    //         dangerouslyHTMLString: true,
    //     });

    //     const duplicate = await axios.post(route("admin.invoice.duplicate"), {
    //         invoice_id: invoiceID,
    //     });

    //     if (duplicate.data?.status) {
    //         toast.update(duplicateToast, {
    //             message:
    //                 "Duplication " +
    //                 duplicate.data?.data?.invoiceNo +
    //                 " completed.",
    //             type: "success",
    //             position: 'bottom-center'
    //         });

    //         setTimeout(() => {
    //             router.visit(route('admin.invoice.list'));
    //         }, 2000);
    //     } else {
    //         toast.update(duplicateToast, {
    //             message: duplicate.data?.message,
    //             type: "error",
    //             position: 'bottom-center'
    //         });
    //     }
    // };

    // const deletePopupVisibility = ref(false);
    // const deleteInvoiceId = ref(null);

    // const handleInvoiceDeletePopup = (itemId) => {
    //     deletePopupVisibility.value = true;
    //     deleteInvoiceId.value = itemId;
    // };

    // const onDeleteSubmit = () => {
    //     router.visit(
    //         route("admin.invoice.delete", { invoiceID: deleteInvoiceId.value }),
    //         {
    //             method: "get",
    //             replace: false,
    //             preserveState: false,
    //             preserveScroll: false,
    //         }
    //     );

    //     deletePopupVisibility.value = false;
    //     deleteInvoiceId.value = null;
    // };

    var __returned__ = {
      props: props,
      invoiceDetail: invoiceDetail,
      downloadInvoice: downloadInvoice,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_5__["default"];
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      get invoiceStatus() {
        return _Admin_Shared_Composables_enums__WEBPACK_IMPORTED_MODULE_1__.invoiceStatus;
      },
      get useDownload() {
        return _Admin_Shared_Composables_Invoice_useDownload__WEBPACK_IMPORTED_MODULE_2__.useDownload;
      },
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Composables_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
/* harmony import */ var vue_country_flag_next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-country-flag-next */ "./node_modules/vue-country-flag-next/dist/country-flag.esm.js");
/* harmony import */ var i18n_iso_countries__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! i18n-iso-countries */ "./node_modules/i18n-iso-countries/index.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'PaymentMethod',
  props: {
    detail: Object,
    customerName: String
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var AccordianParent = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var customAccordianBtn = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var getCountryFullName = function getCountryFullName(countryCode) {
      // Load the data for the specified language (e.g., 'en' for English)
      i18n_iso_countries__WEBPACK_IMPORTED_MODULE_2__.registerLocale(__webpack_require__(/*! i18n-iso-countries/langs/en.json */ "./node_modules/i18n-iso-countries/langs/en.json"));

      // Get the full country name
      return i18n_iso_countries__WEBPACK_IMPORTED_MODULE_2__.getName(countryCode, 'en');
    };
    var checkText = function checkText(_ref2) {
      var check = _ref2.check;
      return check == 'pass' ? 'Passed ' : 'Failed ';
    };
    var checkIcon = function checkIcon(_ref3) {
      var check = _ref3.check;
      return check == 'pass' ? passedIcon() : failedIcon();
    };
    var passedIcon = function passedIcon() {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('i', {
        "class": 'bx bxs-check-circle'
      });
    };
    var failedIcon = function failedIcon() {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('i', {
        "class": 'bx bxs-x-circle'
      });
    };
    var showAccordian = function showAccordian(e) {
      e.preventDefault();
      var parent = AccordianParent.current;
      AccordianParent.value.querySelector('.custom-accordion-body').classList.toggle('active');
    };
    var __returned__ = {
      props: props,
      AccordianParent: AccordianParent,
      customAccordianBtn: customAccordianBtn,
      getCountryFullName: getCountryFullName,
      checkText: checkText,
      checkIcon: checkIcon,
      passedIcon: passedIcon,
      failedIcon: failedIcon,
      showAccordian: showAccordian,
      h: vue__WEBPACK_IMPORTED_MODULE_0__.h,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get capitalizeWords() {
        return _Composables_functions__WEBPACK_IMPORTED_MODULE_1__.capitalizeWords;
      },
      get siteURL() {
        return _Composables_functions__WEBPACK_IMPORTED_MODULE_1__.siteURL;
      },
      get CountryFlag() {
        return vue_country_flag_next__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get isoCountries() {
        return i18n_iso_countries__WEBPACK_IMPORTED_MODULE_2__;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Composables_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'QuotesSection',
  props: {
    quotes: Array,
    customerID: Number
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var showQuoteBox = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    var quote = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)('');
    var editQuoteID = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(0);
    var addQuote = function addQuote() {
      if (quote.value) {
        _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.quote.create', {
          id: props.customerID
        }), {
          method: 'post',
          data: {
            comment: quote.value,
            type: 'customer'
          },
          replace: true,
          preserveState: true,
          preserveScroll: true
        });
        showQuoteBox.value = false;
        quote.value = '';
      } else {
        alert('Kindly add quote.');
      }
    };
    var editQuote = function editQuote(id) {
      editQuoteID.value = id;
      var fetchQuote = (0,_Composables_functions__WEBPACK_IMPORTED_MODULE_2__.findByID)(props.quotes, id);
      quote.value = fetchQuote.comment;
      showQuoteBox.value = true;
    };
    var updateQuote = function updateQuote() {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.quote.update', {
        id: props.customerID,
        quoteID: editQuoteID.value
      }), {
        method: 'post',
        data: {
          comment: quote.value,
          type: 'customer'
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      editQuoteID.value = 0;
      quote.value = '';
      showQuoteBox.value = false;
    };
    var cancelQuote = function cancelQuote() {
      showQuoteBox.value = false;
      quote.value = '';
    };
    var deleteQuote = function deleteQuote(id) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.quote.delete', {
        id: props.customerID,
        quoteID: id
      }), {
        method: 'post',
        data: {
          type: 'customer'
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
    };
    var __returned__ = {
      props: props,
      showQuoteBox: showQuoteBox,
      quote: quote,
      editQuoteID: editQuoteID,
      addQuote: addQuote,
      editQuote: editQuote,
      updateQuote: updateQuote,
      cancelQuote: cancelQuote,
      deleteQuote: deleteQuote,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      get findByID() {
        return _Composables_functions__WEBPACK_IMPORTED_MODULE_2__.findByID;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=script&setup=true&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=script&setup=true&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Admin_Shared_Composables_authorization__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Shared/Composables/authorization */ "./resources/js/Pages/Admin/Shared/Composables/authorization.js");
/* harmony import */ var _Admin_Shared_Components_Lists_TimeLineList_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Components/Lists/TimeLineList.vue */ "./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'RecentActivity',
  props: {
    paymentLogs: Array,
    customerID: Number
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var addNoteBox = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    var note = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)('');
    var itemRefs = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)([]);
    var editNoteID = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(0);
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      window.addEventListener('keydown', cancelNote);
    });
    var type = {
      'initiated.intent': 'ri-currency-fill',
      'customer.created': 'ri-user-3-line',
      'customer.payment_method': 'ri-bank-card-fill',
      'succeeded.3D Secure': 'bx bxs-check-circle',
      'note': 'bx bx-note'
    };
    var paymentLogs = function paymentLogs() {
      var pinID = -1;
      var pinLog = {};
      var logs = props.paymentLogs;
      for (var index in logs) {
        if (logs[index].pin == 1) {
          pinID = index;
          pinLog = logs[index];
          break;
        }
      }
      if (pinID > 0) {
        logs.splice(pinID, 1);
        logs.unshift(pinLog);
      }
      return logs;
    };
    var cancelNote = function cancelNote(event) {
      if (event.code == 'Escape') {
        addNoteBox.value = false;
        note.value = '';
      }
      if (event.ctrlKey && (event === null || event === void 0 ? void 0 : event.code) == 'Enter') {
        if (addNoteBox.value == true) {
          addNote();
          addNoteBox.value == false;
        }
      }
    };
    var addNote = function addNote() {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.payment.log.create', {
        id: props.customerID
      }), {
        method: 'post',
        data: {
          activity: note.value,
          type: 'note',
          request: '',
          response: '',
          log_type: 'customer'
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = '';
    };
    var editNote = function editNote(index) {
      editNoteID.value = props.paymentLogs[index].id;
      addNoteBox.value = true;
      note.value = props.paymentLogs[index].activity;
    };
    var updateNote = function updateNote() {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.payment.log.update', {
        id: props.customerID,
        logID: editNoteID.value
      }), {
        method: 'post',
        data: {
          activity: note.value,
          log_type: 'customer'
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      editNoteID.value = 0;
    };
    var deleteNote = function deleteNote(index) {
      editNoteID.value = props.paymentLogs[index].id;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.payment.log.delete', {
        id: props.customerID,
        logID: editNoteID.value
      }), {
        method: 'post',
        data: {
          log_type: 'customer'
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      editNoteID.value = 0;
      itemRefs.value.map(function (item, i) {
        item.style.display = 'none';
      });
    };
    var __returned__ = {
      props: props,
      addNoteBox: addNoteBox,
      note: note,
      itemRefs: itemRefs,
      editNoteID: editNoteID,
      type: type,
      paymentLogs: paymentLogs,
      cancelNote: cancelNote,
      addNote: addNote,
      editNote: editNote,
      updateNote: updateNote,
      deleteNote: deleteNote,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      get modulePermission() {
        return _Admin_Shared_Composables_authorization__WEBPACK_IMPORTED_MODULE_2__.modulePermission;
      },
      TimeLineList: _Admin_Shared_Components_Lists_TimeLineList_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=script&setup=true&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=script&setup=true&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Composables/functions */ "./resources/js/Pages/Admin/Brief/Shared/Composables/functions.js");
/* harmony import */ var _Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Brief/Shared/Composables/Brief/useDownload */ "./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");
/* harmony import */ var _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Admin/Shared/Components/Tooltip.vue */ "./resources/js/Pages/Admin/Shared/Components/Tooltip.vue");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }









/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'RelatedBriefSection',
  props: {
    relatedBrief: Array,
    customerID: Number
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      logFingerprint();
    });
    var routes = {
      logo: 'brief-detail.detail',
      web: 'web.brief-detail.detail',
      video: 'video.brief-detail.detail',
      smm: 'smm.brief-detail.detail',
      sem: 'sem.brief-detail.detail',
      mobile_app: 'app.brief-detail.detail'
    };
    var visitBriefDetail = function visitBriefDetail(briefID, briefType) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router.visit(route(routes[briefType], {
        id: briefID
      }), {
        method: 'get',
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var badgesData = function badgesData(briefType) {
      var dataArray = {
        logo: {
          "class": 'badge badge-soft-success'
        },
        web: {
          "class": 'badge badge-soft-primary'
        },
        video: {
          "class": 'badge badge-soft-info'
        },
        smm: {
          "class": 'badge badge-soft-warning'
        },
        sem: {
          "class": 'badge badge-soft-dark'
        },
        mobile_app: {
          "class": 'badge badge-soft-danger'
        }
      };
      var dataKey = briefType.toLowerCase().replace(/ /g, '_');
      if (dataKey in dataArray) {
        return dataArray[dataKey]["class"];
      }
      return "";
    };
    var downloadBriefByType = function downloadBriefByType(encoded_id, name, brief_type) {
      var _useDownload = (0,_Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_3__.useDownload)(),
        download = _useDownload.download,
        downloadWebBrief = _useDownload.downloadWebBrief,
        downloadVideoBrief = _useDownload.downloadVideoBrief,
        downloadSmmBrief = _useDownload.downloadSmmBrief,
        downloadSemBrief = _useDownload.downloadSemBrief,
        downloadAppBrief = _useDownload.downloadAppBrief;
      var fingerprintValue = fingerprint.value;
      if (brief_type == "logo") {
        download(encoded_id, name, fingerprintValue);
      } else if (brief_type == "web") {
        downloadWebBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "video") {
        downloadVideoBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "smm") {
        downloadSmmBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "sem") {
        downloadSemBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "mobile_app") {
        downloadAppBrief(encoded_id, name, fingerprintValue);
      }
    };
    var getCopyTextRoute = function getCopyTextRoute(brief) {
      switch (brief.brief_type) {
        case 'logo':
          return route('frontend.brief.view', {
            id: brief === null || brief === void 0 ? void 0 : brief.encoded_id
          });
        case 'web':
          return route('frontend.web.brief.view', {
            id: brief === null || brief === void 0 ? void 0 : brief.encoded_id
          });
        case 'video':
          return route('frontend.video.brief.view', {
            id: brief === null || brief === void 0 ? void 0 : brief.encoded_id
          });
        case 'smm':
          return route('frontend.smm.brief.view', {
            id: brief === null || brief === void 0 ? void 0 : brief.encoded_id
          });
        case 'sem':
          return route('frontend.sem.brief.view', {
            id: brief === null || brief === void 0 ? void 0 : brief.encoded_id
          });
        case 'mobile_app':
          return route('frontend.app.brief.view', {
            id: brief === null || brief === void 0 ? void 0 : brief.encoded_id
          });
        default:
          return '';
      }
    };
    var handleClick = function handleClick(event, briefId, briefType) {
      var fingerprintValue = fingerprint.value;
      if (event.target.innerText === 'Copy Brief Link') {
        axios__WEBPACK_IMPORTED_MODULE_6___default().post(route('brief.copy.activity'), {
          id: briefId,
          brief_type: briefType,
          fingerprint: fingerprintValue
        });
      }
    };
    var __returned__ = {
      props: props,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      routes: routes,
      visitBriefDetail: visitBriefDetail,
      badgesData: badgesData,
      downloadBriefByType: downloadBriefByType,
      getCopyTextRoute: getCopyTextRoute,
      handleClick: handleClick,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_8__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_9__["default"];
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router;
      },
      get formatText() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_2__.formatText;
      },
      get useDownload() {
        return _Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_3__.useDownload;
      },
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
      Tooltip: _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_6___default());
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__.useFingerprint;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Composables_authorization__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Composables/authorization */ "./resources/js/Pages/Admin/Shared/Composables/authorization.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'TimeLineList',
  props: {
    logs: Array,
    paymentID: Number,
    logType: String,
    iconTypes: Object,
    routeTo: String
  },
  emits: ['editPin', 'deletePin'],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emits = __emit;
    var itemRefs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var visibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var editNoteID = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    var pinToTopText = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('Pin to the top');
    var capitalize = function capitalize(s) {
      return s && s[0].toUpperCase() + s.slice(1);
    };
    var typeIcon = function typeIcon(logType, logActivity) {
      return props.iconTypes[logType];
    };
    var openOptionPanel = function openOptionPanel(index) {
      visibility.value = true;
      itemRefs.value.forEach(function (item, i) {
        if (i !== index && item && item.style) {
          item.style.display = "none";
        }
      });
      var item = itemRefs.value[index];
      if (item && item.style) {
        item.style.display = item.style.display === "block" ? "none" : "block";
      } else {
        console.error("Item or item style is undefined.");
      }
    };
    var closeOptionPanel = function closeOptionPanel(e) {
      var clickContain = false;
      itemRefs.value.forEach(function (item) {
        var contains = item.contains(e.target);
        if (contains) {
          clickContain = true;
        }
      });
      if (visibility && itemRefs.value && !clickContain) {
        itemRefs.value.forEach(function (item) {
          return item.style.display = "none";
        });
        visibility.value = false;
      } else {
        setTimeout(function () {
          itemRefs.value.forEach(function (item) {
            return item.style.display = "none";
          });
        }, 500);
        visibility.value = false;
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      var _props$logs;
      document.addEventListener("mousedown", closeOptionPanel);
      (_props$logs = props.logs) === null || _props$logs === void 0 || _props$logs.forEach(function (log) {
        if (log.type == "note" && log.pin == 1) {
          pinToTopText.value = "Replace Pin";
        }
      });
    });
    var togglePinNote = function togglePinNote(index, pinValue) {
      editNoteID.value = props.logs[index].id;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router.visit(route("admin.payment.log.update", {
        id: props.paymentID,
        logID: editNoteID.value
      }), {
        method: "post",
        data: {
          pin: pinValue,
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      editNoteID.value = 0;
    };
    var editNote = function editNote(index) {
      itemRefs.value.at(index).style.display = "none";
      emits('editPin', index);
    };
    var deleteNote = function deleteNote(index) {
      emits('deletePin', index);
    };
    var __returned__ = {
      props: props,
      emits: emits,
      itemRefs: itemRefs,
      visibility: visibility,
      editNoteID: editNoteID,
      pinToTopText: pinToTopText,
      capitalize: capitalize,
      typeIcon: typeIcon,
      openOptionPanel: openOptionPanel,
      closeOptionPanel: closeOptionPanel,
      togglePinNote: togglePinNote,
      editNote: editNote,
      deleteNote: deleteNote,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router;
      },
      get modulePermission() {
        return _Composables_authorization__WEBPACK_IMPORTED_MODULE_2__.modulePermission;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Notify.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Notify.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var vue3_toastify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue3-toastify */ "./node_modules/vue3-toastify/dist/index.mjs");
/* harmony import */ var _css_toast_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../css/toast.css */ "./resources/css/toast.css");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Notify',
  props: {
    notify: Boolean,
    notificationData: Object
  },
  emits: ["performUndo"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emit = __emit;
    var NotificationProp = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.notificationData);
    var displayPromise = function displayPromise() {
      if (props.notificationData.type == "error") {
        vue3_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.error(NotificationProp.value.msg, {
          position: NotificationProp.value.position,
          theme: NotificationProp.value.theme,
          autoClose: NotificationProp.value.autoClose
        });
      } else if (props.notificationData.type == "successWithUndo") {
        vue3_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success({
          render: function render() {
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
              style: {
                display: "flex",
                width: "100%",
                justifyContent: "space-between",
                alignItems: "center"
              }
            }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("p", {
              style: {
                marginBottom: "0px"
              }
            }, "Testing"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
              onClick: function onClick(event) {
                event.stopPropagation();
                emit("performUndo");
              }
            }, "Undo")]);
          }
        }, {
          position: NotificationProp.value.position,
          theme: NotificationProp.value.theme,
          autoClose: NotificationProp.value.autoClose,
          closeButton: false
        });
      } else if (props.notificationData.type == "successWithCount") {
        var paymentCount = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        var totalPaymentCount = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(3);
        setInterval(function () {
          if (paymentCount.value < totalPaymentCount.value) {
            paymentCount.value++;
          }
        }, 500);
        vue3_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success({
          render: function render() {
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
              style: {
                display: "flex",
                width: "100%",
                justifyContent: "space-between",
                alignItems: "center"
              }
            }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("p", {
              style: {
                marginBottom: "0px"
              }
            }, "Refunding ".concat(paymentCount.value, " of ").concat(totalPaymentCount.value, " Payment")), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
              onClick: function onClick(event) {
                event.stopPropagation();
                emit("performUndo");
              }
            }, "Undo")]);
          }
        }, {
          position: NotificationProp.value.position,
          theme: NotificationProp.value.theme,
          autoClose: NotificationProp.value.autoClose,
          closeButton: false
        });
      } else {
        vue3_toastify__WEBPACK_IMPORTED_MODULE_1__.toast.success(NotificationProp.value.msg, {
          position: NotificationProp.value.position,
          theme: NotificationProp.value.theme,
          autoClose: NotificationProp.value.autoClose
        });
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return [props.notify, props.notificationData];
    }, function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        updatedShow = _ref3[0],
        updatedNotificationData = _ref3[1];
      if (updatedShow) {
        NotificationProp.value = updatedNotificationData;
        displayPromise();
      }
    }, {
      deep: true
    });
    var __returned__ = {
      props: props,
      emit: emit,
      NotificationProp: NotificationProp,
      displayPromise: displayPromise,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      h: vue__WEBPACK_IMPORTED_MODULE_0__.h,
      get toast() {
        return vue3_toastify__WEBPACK_IMPORTED_MODULE_1__.toast;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=script&setup=true&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Composables_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }





var __default__ = (0,vue__WEBPACK_IMPORTED_MODULE_1__.defineComponent)({
  name: 'AmountColumn',
  inheritAttrs: false,
  customOptions: {}
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/Object.assign(__default__, {
  props: {
    item: Object,
    keyVal: {
      type: String,
      required: false
    },
    isFirst: {
      type: Boolean,
      required: false,
      "default": false
    },
    showCurrency: {
      type: Boolean,
      required: false,
      "default": true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var showBadgeMessage = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    var visitPaymentDetail = function visitPaymentDetail(token) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route('admin.payment.detail.id', {
        id: token
      }), {
        method: 'get',
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var badgeMessage = (0,vue__WEBPACK_IMPORTED_MODULE_1__.computed)(function () {
      var item = props.item;
      if (item) {
        var _item$paymentStatus, _item$paymentStatus2, _item$paymentStatus3, _item$paymentStatus4, _item$paymentStatus5, _item$paymentStatus6, _item$paymentStatus7;
        if (((_item$paymentStatus = item.paymentStatus) === null || _item$paymentStatus === void 0 ? void 0 : _item$paymentStatus.id) === 1) {
          return "This payment is complete.";
        } else if (((_item$paymentStatus2 = item.paymentStatus) === null || _item$paymentStatus2 === void 0 ? void 0 : _item$paymentStatus2.id) === 3) {
          var _item$payment_logs;
          if ((item === null || item === void 0 || (_item$payment_logs = item.payment_logs) === null || _item$payment_logs === void 0 ? void 0 : _item$payment_logs.length) > 0) {
            var _item$payment_logs$;
            var intent = (0,_Composables_functions__WEBPACK_IMPORTED_MODULE_2__.isJsonString)((_item$payment_logs$ = item.payment_logs[0]) === null || _item$payment_logs$ === void 0 ? void 0 : _item$payment_logs$.response);
            if (intent && intent !== null && intent !== void 0 && intent.status) {
              if (intent.status == "requires_payment_method") {
                return "The customer has not entered their payment method.";
              } else if (intent.status == "requires_action") {
                return "The Payment is incomplete.";
              } else {
                return "The Payment is incomplete.";
              }
            } else {
              return "The Payment is incomplete.";
            }
          } else {
            return "The Payment is incomplete.";
          }
        } else if (((_item$paymentStatus3 = item.paymentStatus) === null || _item$paymentStatus3 === void 0 ? void 0 : _item$paymentStatus3.id) === 9) {
          var paymentLogs = item.payment_logs;
          if (paymentLogs && paymentLogs.length > 0) {
            var _iterator = _createForOfIteratorHelper(paymentLogs),
              _step;
            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var log = _step.value;
                if (log.type === 'refund.refunded') {
                  var request = JSON.parse(log.request);
                  if (request && request.amount) {
                    var _item$link$currency_c;
                    return "".concat((_item$link$currency_c = item.link.currency_country) === null || _item$link$currency_c === void 0 ? void 0 : _item$link$currency_c.symbol, " ").concat(request.amount, " amount has been refunded");
                  }
                }
              }
              // If no refund.refunded logs are found, check for refund.failed logs
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }
            var _iterator2 = _createForOfIteratorHelper(paymentLogs),
              _step2;
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var _log = _step2.value;
                if (_log.type === 'refund.failed') {
                  var _request = JSON.parse(_log.request);
                  if (_request && _request.amount) {
                    var _item$link$currency_c2;
                    return "".concat((_item$link$currency_c2 = item.link.currency_country) === null || _item$link$currency_c2 === void 0 ? void 0 : _item$link$currency_c2.symbol, " ").concat(_request.amount, " amount has not been refunded");
                  }
                }
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        } else if (((_item$paymentStatus4 = item.paymentStatus) === null || _item$paymentStatus4 === void 0 ? void 0 : _item$paymentStatus4.id) === 10) {
          return "Request of refund has been initiated.";
        } else if (((_item$paymentStatus5 = item.paymentStatus) === null || _item$paymentStatus5 === void 0 ? void 0 : _item$paymentStatus5.id) === 11) {
          return "Refund has been initiated.";
        } else if (((_item$paymentStatus6 = item.paymentStatus) === null || _item$paymentStatus6 === void 0 ? void 0 : _item$paymentStatus6.id) === 14) {
          return "Request of refund has already been initiated from stripe account.";
        } else if (((_item$paymentStatus7 = item.paymentStatus) === null || _item$paymentStatus7 === void 0 ? void 0 : _item$paymentStatus7.id) === 15) {
          return "This payment is initiated manually from the system.";
        } else {
          var gateway_message = item.gateway_message;
          if (gateway_message && gateway_message.length > 0) {
            var messageObj = JSON.parse(gateway_message);
            if (messageObj && messageObj.chat_code) {
              return messageObj.chat_code;
            } else if (messageObj && messageObj.message) {
              return messageObj.message;
            }
          }
        }
      }
      return "";
    });
    var toggleBadgeMessage = function toggleBadgeMessage(event, value) {
      showBadgeMessage.value = value;
      event.target.style.zIndex = value ? 9999 : 1;
    };
    var __returned__ = {
      props: props,
      showBadgeMessage: showBadgeMessage,
      visitPaymentDetail: visitPaymentDetail,
      badgeMessage: badgeMessage,
      toggleBadgeMessage: toggleBadgeMessage,
      __MACROS_defineComponent: vue__WEBPACK_IMPORTED_MODULE_1__.defineComponent,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_1__.computed,
      get isJsonString() {
        return _Composables_functions__WEBPACK_IMPORTED_MODULE_2__.isJsonString;
      },
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_3__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
}));

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Popup',
  props: {
    title: String,
    visibility: Boolean,
    "class": String,
    onClose: Function,
    maxWidth: String || "450px"
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var slots = (0,vue__WEBPACK_IMPORTED_MODULE_0__.useSlots)();
    var visibilityClass = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.visibility ? "showThis" : "");
    var onCloseFunction = props.onClose ? props.onClose : function () {
      return null;
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return props.visibility;
    }, function (newVal) {
      visibilityClass.value = props.visibility ? "showThis" : "";
    });
    var __returned__ = {
      props: props,
      slots: slots,
      visibilityClass: visibilityClass,
      onCloseFunction: onCloseFunction,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      useSlots: vue__WEBPACK_IMPORTED_MODULE_0__.useSlots
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=script&setup=true&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=script&setup=true&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Popup_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Popup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popup.vue");
/* harmony import */ var vue_tel_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-tel-input */ "./node_modules/vue-tel-input/dist/vue-tel-input.js");
/* harmony import */ var vue_tel_input_vue_tel_input_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-tel-input/vue-tel-input.css */ "./node_modules/vue-tel-input/dist/vue-tel-input.css");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'CustomerPopup',
  props: {
    title: String,
    customerDetail: Object,
    popupVisibility: Boolean,
    hidePopup: Function,
    onSubmit: Function,
    isUpdate: Boolean,
    countries: Object,
    errors: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var formData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      first_name: "",
      last_name: "",
      email: "",
      company: "",
      phone: "",
      country: "",
      address: "",
      city: "",
      state: "",
      zipcode: "",
      returnJson: true
    });
    var activeCountry = function activeCountry(value) {
      var _props$countries;
      var selectedCountry = (_props$countries = props.countries) === null || _props$countries === void 0 ? void 0 : _props$countries.find(function (country) {
        return country.aplha_code2 === value.iso2;
      });
      if (selectedCountry) {
        formData.value.country = selectedCountry.country;
      } else {
        console.error('Selected country not found:', value.iso2);
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      if (props.customerDetail) {
        var _props$customerDetail, _props$customerDetail2, _props$customerDetail3, _props$customerDetail4, _props$customerDetail5, _props$customerDetail6, _props$customerDetail7, _props$customerDetail8, _props$customerDetail9, _props$customerDetail10;
        formData.value.first_name = (_props$customerDetail = props.customerDetail.first_name) !== null && _props$customerDetail !== void 0 ? _props$customerDetail : "";
        formData.value.last_name = (_props$customerDetail2 = props.customerDetail.last_name) !== null && _props$customerDetail2 !== void 0 ? _props$customerDetail2 : "";
        formData.value.email = (_props$customerDetail3 = props.customerDetail.email) !== null && _props$customerDetail3 !== void 0 ? _props$customerDetail3 : "";
        formData.value.company = (_props$customerDetail4 = props.customerDetail.company) !== null && _props$customerDetail4 !== void 0 ? _props$customerDetail4 : "";
        formData.value.phone = (_props$customerDetail5 = props.customerDetail.phone) !== null && _props$customerDetail5 !== void 0 ? _props$customerDetail5 : "";
        formData.value.country = (_props$customerDetail6 = props.customerDetail.country) !== null && _props$customerDetail6 !== void 0 ? _props$customerDetail6 : "";
        formData.value.address = (_props$customerDetail7 = props.customerDetail.address) !== null && _props$customerDetail7 !== void 0 ? _props$customerDetail7 : "";
        formData.value.city = (_props$customerDetail8 = props.customerDetail.city) !== null && _props$customerDetail8 !== void 0 ? _props$customerDetail8 : "";
        formData.value.state = (_props$customerDetail9 = props.customerDetail.state) !== null && _props$customerDetail9 !== void 0 ? _props$customerDetail9 : "";
        formData.value.zipcode = (_props$customerDetail10 = props.customerDetail.zipcode) !== null && _props$customerDetail10 !== void 0 ? _props$customerDetail10 : "";
      }
    });
    var submit = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              try {
                props.onSubmit(formData.value);
              } catch (errors) {
                console.error(errors);
              }
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function submit() {
        return _ref2.apply(this, arguments);
      };
    }();
    var __returned__ = {
      props: props,
      formData: formData,
      activeCountry: activeCountry,
      submit: submit,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      Popup: _Popup_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      get VueTelInput() {
        return vue_tel_input__WEBPACK_IMPORTED_MODULE_2__.VueTelInput;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Popup_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Popup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popup.vue");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'DeletePopup',
  props: {
    title: String,
    message: String,
    deleteVisibility: Boolean,
    hideDeletePopup: Function,
    onDeleteSubmit: Function
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var __returned__ = {
      props: props,
      Popup: _Popup_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=script&setup=true&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=script&setup=true&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Popup_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Popup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popup.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'PasswordPopup',
  props: {
    title: String,
    popupVisibility: Boolean,
    hidePopup: Function,
    onSubmit: Function,
    errors: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var formData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      password: ""
    });
    var submitting = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var isDisabled = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return submitting.value;
    });
    var submit = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              submitting.value = true;
              _context.prev = 1;
              _context.next = 4;
              return props.onSubmit(formData.value);
            case 4:
              submitting.value = false;
              _context.next = 10;
              break;
            case 7:
              _context.prev = 7;
              _context.t0 = _context["catch"](1);
              submitting.value = false;
            case 10:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[1, 7]]);
      }));
      return function submit() {
        return _ref2.apply(this, arguments);
      };
    }();
    var disableAutocomplete = function disableAutocomplete(event) {
      event.target.setAttribute('autocomplete', 'new-password');
      event.preventDefault();
    };
    var __returned__ = {
      props: props,
      formData: formData,
      submitting: submitting,
      isDisabled: isDisabled,
      submit: submit,
      disableAutocomplete: disableAutocomplete,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed,
      Popup: _Popup_vue__WEBPACK_IMPORTED_MODULE_1__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Tooltip_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tooltip.vue */ "./resources/js/Pages/Admin/Shared/Components/Tooltip.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Title',
  props: {
    heading: String,
    breadcrumb: Array | String | null
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var textToCopy = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return navigator.clipboard.writeText(props.breadcrumb);
            case 3:
              alert('Text copied to clipboard: ' + props.breadcrumb);
              _context.next = 9;
              break;
            case 6:
              _context.prev = 6;
              _context.t0 = _context["catch"](0);
              alert(_context.t0.message);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[0, 6]]);
      }));
      return function textToCopy() {
        return _ref2.apply(this, arguments);
      };
    }();
    var __returned__ = {
      props: props,
      textToCopy: textToCopy,
      Tooltip: _Tooltip_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=script&setup=true&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=script&setup=true&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Tooltip',
  props: {
    copyText: String,
    tooltipText: String,
    direction: String,
    showText: String,
    showTextStyle: String,
    showTextClass: String,
    showButtonStyle: String,
    showButtonClass: String,
    showIcon: Boolean,
    showCopied: {
      type: Boolean,
      "default": true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var copiedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var direction = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return props !== null && props !== void 0 && props.direction ? props.direction.toLowerCase() : "top";
    });
    var getDirectionClass = function getDirectionClass(value) {
      switch (value) {
        case 'bottom':
          return 'bottomDirectionClass';
          break;
        case 'right':
          return 'rightDirectionClass';
          break;
        case 'left':
          return 'leftDirectionClass';
          break;
        default:
          return 'topDirectionClass';
          break;
      }
      props !== null && props !== void 0 && props.direction ? props.direction.toLowerCase() : "top";
    };
    var defaultText = props.tooltipText ? props.tooltipText : "";
    var textToCopy = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return navigator.clipboard.writeText(props.copyText);
            case 3:
              if (props.showCopied) {
                copiedRef.value = true;
              }
              _context.next = 9;
              break;
            case 6:
              _context.prev = 6;
              _context.t0 = _context["catch"](0);
              alert(_context.t0.message);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[0, 6]]);
      }));
      return function textToCopy() {
        return _ref2.apply(this, arguments);
      };
    }();
    var textToCopyRevert = function textToCopyRevert() {
      setTimeout(function () {
        copiedRef.value = false;
      }, 300);
    };
    var __returned__ = {
      props: props,
      copiedRef: copiedRef,
      direction: direction,
      getDirectionClass: getDirectionClass,
      defaultText: defaultText,
      textToCopy: textToCopy,
      textToCopyRevert: textToCopyRevert,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=template&id=08f4abee&scoped=true":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=template&id=08f4abee&scoped=true ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-08f4abee"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row",
  style: {
    "background": "#fff"
  }
};
var _hoisted_2 = {
  "class": "col-lg-4 col-sm-12 pt-4 customerleftcol"
};
var _hoisted_3 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-user-3-line",
    style: {
      "vertical-align": "bottom",
      "margin-right": "5px"
    }
  }), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Customers")], -1 /* HOISTED */);
});
var _hoisted_4 = {
  "class": "clickshowcontent"
};
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "bx bx-caret-right"
  }, null, -1 /* HOISTED */);
});
var _hoisted_6 = {
  "class": "showinnerdiv"
};
var _hoisted_7 = {
  "class": "clickshowcontent"
};
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "bx bx-caret-right"
  }, null, -1 /* HOISTED */);
});
var _hoisted_9 = {
  "class": "showinnerdiv"
};
var _hoisted_10 = {
  "class": "detailscontentdiv",
  ref: "detailContentDiv"
};
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_12 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_13 = {
  "class": "showMore"
};
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_15 = {
  "class": "showMore"
};
var _hoisted_16 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_17 = {
  "class": "showMore"
};
var _hoisted_18 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_19 = {
  "class": "showMore"
};
var _hoisted_20 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_21 = {
  "class": "showMore"
};
var _hoisted_22 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_23 = {
  "class": "clickshowcontent"
};
var _hoisted_24 = {
  "class": "d-flex justify-content-between"
};
var _hoisted_25 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "bx bx-caret-right rotateIcon"
  }, null, -1 /* HOISTED */);
});
var _hoisted_26 = {
  "class": "showinnerdiv flexVisible"
};
var _hoisted_27 = {
  key: 0,
  "class": "payment-detail-table"
};
var _hoisted_28 = {
  style: {
    "width": "50%",
    "color": "#687385"
  }
};
var _hoisted_29 = {
  style: {
    "width": "50%",
    "padding-left": "15px"
  }
};
var _hoisted_30 = {
  "class": "col-lg-8 col-sm-12"
};
var _hoisted_31 = {
  "class": "card small-headings"
};
var _hoisted_32 = {
  "class": "card-header pt-0 pb-0"
};
var _hoisted_33 = {
  "class": "row align-items-center"
};
var _hoisted_34 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", {
    "class": "nav nav-tabs nav-tabs-custom nav-success border-0",
    role: "tablist"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
    "class": "nav-item"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "nav-link active",
    "data-bs-toggle": "tab",
    href: "#overview",
    role: "tab"
  }, "Overview")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
    "class": "nav-item"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "nav-link",
    "data-bs-toggle": "tab",
    href: "#events-logs",
    role: "tab"
  }, "Events and logs")])])], -1 /* HOISTED */);
});
var _hoisted_35 = {
  "class": "col-md-6"
};
var _hoisted_36 = {
  "class": "payment-columns-filter p-0"
};
var _hoisted_37 = {
  key: 0
};
var _hoisted_38 = {
  "class": "btn-group"
};
var _hoisted_39 = {
  key: 1
};
var _hoisted_40 = {
  "class": "btn-group"
};
var _hoisted_41 = {
  "class": "btn-group"
};
var _hoisted_42 = {
  "class": "btn-group dropdown-normal float-end create-payment-btn"
};
var _hoisted_43 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    type: "button",
    "class": "btn btn-light dropdown-toggle",
    "data-bs-toggle": "dropdown",
    "aria-haspopup": "true",
    "aria-expanded": "false"
  }, " ... ", -1 /* HOISTED */);
});
var _hoisted_44 = {
  "class": "dropdown-menu dropdown-menu-end"
};
var _hoisted_45 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
    "class": "dropHead"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item"
  }, "PAYMENTS")], -1 /* HOISTED */);
});
var _hoisted_46 = {
  key: 0
};
var _hoisted_47 = {
  key: 1
};
var _hoisted_48 = {
  key: 2
};
var _hoisted_49 = {
  key: 3,
  "class": "dropHead"
};
var _hoisted_50 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item"
  }, "ACCOUNT", -1 /* HOISTED */);
});
var _hoisted_51 = [_hoisted_50];
var _hoisted_52 = {
  key: 4
};
var _hoisted_53 = {
  key: 5
};
var _hoisted_54 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "dropdown-top-caret"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "21",
    height: "9",
    role: "presentation"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("g", {
    fill: "#fff",
    "fill-rule": "evenodd"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    fill: "#fff",
    "fill-opacity": "0.1",
    d: "M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"
  }), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    fill: "currentcolor",
    d: "M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"
  })])])], -1 /* HOISTED */);
});
var _hoisted_55 = {
  "class": "card-body"
};
var _hoisted_56 = {
  "class": "tab-content text-muted"
};
var _hoisted_57 = {
  "class": "tab-pane active",
  id: "overview",
  role: "tabpanel"
};
var _hoisted_58 = {
  key: 0,
  "class": "single-payment-details"
};
var _hoisted_59 = {
  "class": "single-payment-head mb-0"
};
var _hoisted_60 = {
  "class": "row align-items-end"
};
var _hoisted_61 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Payments")], -1 /* HOISTED */);
});
var _hoisted_62 = {
  "class": "col-md-6 text-right"
};
var _hoisted_63 = {
  "class": "payment-columns-filter align-items-center pb-0"
};
var _hoisted_64 = {
  "class": "m-0 text-muted"
};
var _hoisted_65 = {
  "class": "border-left"
};
var _hoisted_66 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-arrow-go-back-line align-middle"
  }, null, -1 /* HOISTED */);
});
var _hoisted_67 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Refund", -1 /* HOISTED */);
});
var _hoisted_68 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "ctrl", -1 /* HOISTED */);
});
var _hoisted_69 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "+", -1 /* HOISTED */);
});
var _hoisted_70 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "enter", -1 /* HOISTED */);
});
var _hoisted_71 = [_hoisted_66, _hoisted_67, _hoisted_68, _hoisted_69, _hoisted_70];
var _hoisted_72 = {
  "class": "row"
};
var _hoisted_73 = {
  "class": "col-12"
};
var _hoisted_74 = {
  id: "scroll-horizontal",
  "class": "table nowrap align-middle m-0",
  style: {
    "width": "100%"
  }
};
var _hoisted_75 = {
  scope: "col",
  style: {
    "width": "10px"
  }
};
var _hoisted_76 = {
  "class": "form-check"
};
var _hoisted_77 = ["checked"];
var _hoisted_78 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px"
    }
  }, "Amount", -1 /* HOISTED */);
});
var _hoisted_79 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px"
    }
  }, null, -1 /* HOISTED */);
});
var _hoisted_80 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px"
    }
  }, null, -1 /* HOISTED */);
});
var _hoisted_81 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, "Description", -1 /* HOISTED */);
});
var _hoisted_82 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "175px"
    }
  }, "Date", -1 /* HOISTED */);
});
var _hoisted_83 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px"
    }
  }, null, -1 /* HOISTED */);
});
var _hoisted_84 = {
  scope: "row"
};
var _hoisted_85 = {
  "class": "form-check"
};
var _hoisted_86 = ["value", "disabled"];
var _hoisted_87 = ["onClick"];
var _hoisted_88 = ["onClick"];
var _hoisted_89 = {
  "class": "payment-actionListUl"
};
var _hoisted_90 = {
  key: 0
};
var _hoisted_91 = ["onClick"];
var _hoisted_92 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-arrow-go-back-line align-middle"
  }, null, -1 /* HOISTED */);
});
var _hoisted_93 = [_hoisted_92];
var _hoisted_94 = ["onClick"];
var _hoisted_95 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "mdi mdi-email"
  }, null, -1 /* HOISTED */);
});
var _hoisted_96 = [_hoisted_95];
var _hoisted_97 = {
  "class": "dropdown d-inline-block"
};
var _hoisted_98 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    "class": "btn btn-soft-secondary btn-sm dropdown",
    type: "button",
    "data-bs-toggle": "dropdown",
    "aria-expanded": "false"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-more-fill align-middle"
  })], -1 /* HOISTED */);
});
var _hoisted_99 = {
  "class": "dropdown-menu dropdown-menu-end"
};
var _hoisted_100 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
    "class": "dropHead"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item"
  }, "Actions")], -1 /* HOISTED */);
});
var _hoisted_101 = {
  key: 0
};
var _hoisted_102 = ["onClick"];
var _hoisted_103 = ["onClick"];
var _hoisted_104 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
    "class": "dropHead"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item"
  }, "Connections")], -1 /* HOISTED */);
});
var _hoisted_105 = {
  "class": "tab-pane",
  id: "events-logs",
  role: "tabpanel"
};
var _hoisted_106 = {
  "class": "popup-details-input flex180"
};
var _hoisted_107 = ["onUpdate:modelValue"];
var _hoisted_108 = {
  "class": "popup-details-input"
};
var _hoisted_109 = ["onUpdate:modelValue"];
var _hoisted_110 = ["onClick"];
var _hoisted_111 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-delete-bin-fill"
  }, null, -1 /* HOISTED */);
});
var _hoisted_112 = [_hoisted_111];
var _hoisted_113 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "mdi mdi-plus"
  }, null, -1 /* HOISTED */);
});
var _hoisted_114 = {
  "class": "popup-details-area text-muted"
};
var _hoisted_115 = {
  "class": "popup-details-input"
};
var _hoisted_116 = {
  "class": "row"
};
var _hoisted_117 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-3"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, "Deliver to")])], -1 /* HOISTED */);
});
var _hoisted_118 = {
  "class": "col-md-9"
};
var _hoisted_119 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
    "class": "mt-2 mb-0"
  }, " Activate your account to send this email to other addresses ", -1 /* HOISTED */);
});
var _hoisted_120 = {
  "class": "popup-details-area text-muted"
};
var _hoisted_121 = {
  "class": "mt-2 mb-0"
};
var _hoisted_122 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("title", null, "Customer Detail", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$custome, _$setup$stripe, _$setup$props$custome2, _$setup$props$custome3, _$setup$props$custome4, _$setup$props$custome5, _$setup$props$custome6, _$setup$props$custome7, _$setup$props$custome8, _$setup$props$custome9, _$setup$props$custome10, _$setup$props$custome11, _$setup$props$custome12, _$setup$stripe2, _$setup$stripe3, _$setup$props$custome13, _$setup$props$custome14, _$setup$props$custome15, _$setup$props$custome16, _$setup$props$custome17, _$setup$props$custome18, _$setup$props$custome19, _$props$customer, _$props$customer2, _$setup$props$custome22, _$setup$props$custome23, _$setup$props$custome24, _$setup$props$custome25, _$setup$props$custome26, _$setup$props$custome27, _$setup$props$custome28, _$setup$props$custome29, _$setup$props$custome30, _$setup$selectedPayme;
  var _component_Link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Link");
  var _component_Head = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Head");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Title"], {
    heading: "Customer",
    breadcrumb: $setup.customerID
  }, null, 8 /* PROPS */, ["breadcrumb"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [_hoisted_3, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.customer.first_name) + " " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.customer.last_name), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.customer.email), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "d-flex justify-content-between"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    onClick: $setup.showDetail
  }, [_hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Insights")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "purpleLink",
    onClick: $setup.showDetailPopup
  })]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Spent"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($props.total_spent), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Since"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO((_$setup$props$custome = $setup.props.customer) === null || _$setup$props$custome === void 0 ? void 0 : _$setup$props$custome.created_at), "MMM yy")), 1 /* TEXT */)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "d-flex justify-content-between"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    onClick: $setup.showDetail
  }, [_hoisted_8, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Details")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "purpleLink",
    onClick: $setup.showDetailPopup
  }, " Edit")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Customer ID "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Tooltip"], {
    "copy-text": (_$setup$stripe = $setup.stripe) === null || _$setup$stripe === void 0 ? void 0 : _$setup$stripe.id
  }, null, 8 /* PROPS */, ["copy-text"])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Full Name "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome2 = $setup.props.customer) === null || _$setup$props$custome2 === void 0 ? void 0 : _$setup$props$custome2.first_name) + " " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome3 = $setup.props.customer) === null || _$setup$props$custome3 === void 0 ? void 0 : _$setup$props$custome3.last_name), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Email"), _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome4 = $setup.props.customer) === null || _$setup$props$custome4 === void 0 ? void 0 : _$setup$props$custome4.email), 1 /* TEXT */), (_$setup$props$custome5 = $setup.props.customer) !== null && _$setup$props$custome5 !== void 0 && _$setup$props$custome5.extra_emails && (_$setup$props$custome6 = $setup.props.customer) !== null && _$setup$props$custome6 !== void 0 && _$setup$props$custome6.extra_emails.length ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(", " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(JSON.parse($setup.props.customer.extra_emails).join(', ')), 1 /* TEXT */)], 64 /* STABLE_FRAGMENT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Phone"), _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome7 = $setup.props.customer) === null || _$setup$props$custome7 === void 0 ? void 0 : _$setup$props$custome7.phone), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_13, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Company"), _hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome8 = $setup.props.customer) === null || _$setup$props$custome8 === void 0 ? void 0 : _$setup$props$custome8.company), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" City"), _hoisted_16, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome9 = $setup.props.customer) === null || _$setup$props$custome9 === void 0 ? void 0 : _$setup$props$custome9.city), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_17, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Zipcode"), _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome10 = $setup.props.customer) === null || _$setup$props$custome10 === void 0 ? void 0 : _$setup$props$custome10.zipcode), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_19, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" State"), _hoisted_20, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome11 = $setup.props.customer) === null || _$setup$props$custome11 === void 0 ? void 0 : _$setup$props$custome11.state), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_21, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Country"), _hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$custome12 = $setup.props.customer) === null || _$setup$props$custome12 === void 0 ? void 0 : _$setup$props$custome12.country), 1 /* TEXT */)])], 512 /* NEED_PATCH */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "detailsshowmorebtn",
    ref: "showMoreDetail",
    onClick: $setup.showMoreDetailFunc
  }, "Show More", 512 /* NEED_PATCH */)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_23, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_24, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    onClick: $setup.showDetail
  }, [_hoisted_25, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Metadata")]), _ctx.$modulePermission('Customer', 'Edit') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
    key: 0,
    "class": "purpleLink showThis",
    onClick: $setup.showMetaPopup
  }, "Edit")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_26, [(_$setup$stripe2 = $setup.stripe) !== null && _$setup$stripe2 !== void 0 && _$setup$stripe2.metadata ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_27, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(Object.entries((_$setup$stripe3 = $setup.stripe) === null || _$setup$stripe3 === void 0 ? void 0 : _$setup$stripe3.metadata), function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      key = _ref2[0],
      value = _ref2[1];
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: key
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_28, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(key), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_29, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(value), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_30, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_31, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_32, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_33, [_hoisted_34, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_35, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_36, [_ctx.$modulePermission('PaymentLinkGenerator', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_37, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_38, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    "class": "btn btn-light exportPopup-toggle",
    href: _ctx.route('admin.payment.generate', {
      customerID: (_$setup$props$custome13 = $setup.props.customer) === null || _$setup$props$custome13 === void 0 ? void 0 : _$setup$props$custome13.id
    })
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Create Payment ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), _ctx.$modulePermission('Invoice', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_39, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_40, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    "class": "btn btn-light exportPopup-toggle",
    href: _ctx.route('admin.invoice.create', {
      customer_id: parseInt((_$setup$props$custome14 = $setup.props.customer) === null || _$setup$props$custome14 === void 0 ? void 0 : _$setup$props$custome14.id)
    })
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Create Invoice ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_41, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    "class": "btn btn-light exportPopup-toggle",
    href: _ctx.route('brief.link.add', {
      customer_id: parseInt((_$setup$props$custome15 = $setup.props.customer) === null || _$setup$props$custome15 === void 0 ? void 0 : _$setup$props$custome15.id)
    })
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Create Brief ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_42, [_hoisted_43, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_44, [_hoisted_45, _ctx.$modulePermission('PaymentLinkGenerator', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_46, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    href: _ctx.route('admin.payment.generate', {
      customerID: (_$setup$props$custome16 = $setup.props.customer) === null || _$setup$props$custome16 === void 0 ? void 0 : _$setup$props$custome16.id
    }),
    "class": "dropdown-item"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Create payment")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), _ctx.$modulePermission('Invoice', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_47, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    href: _ctx.route('admin.invoice.create', {
      customer_id: parseInt((_$setup$props$custome17 = $setup.props.customer) === null || _$setup$props$custome17 === void 0 ? void 0 : _$setup$props$custome17.id)
    }),
    "class": "dropdown-item"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Create invoice")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    href: _ctx.route('brief.link.add', {
      customer_id: parseInt((_$setup$props$custome18 = $setup.props.customer) === null || _$setup$props$custome18 === void 0 ? void 0 : _$setup$props$custome18.id)
    }),
    "class": "dropdown-item"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Create brief")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])]), _ctx.$modulePermission('BlockList', 'Create') || _ctx.$modulePermission('BlockList', 'Edit') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_48, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      $setup.allowBlockList.popup.visible = true;
    })
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.allowBlockList.message), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), _ctx.$modulePermission('Customer', 'Edit') || _ctx.$modulePermission('Customer', 'Delete') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_49, [].concat(_hoisted_51))) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), _ctx.$modulePermission('Customer', 'Edit') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_52, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item",
    onClick: $setup.showDetailPopup
  }, "Edit information")])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <li><a href=\"#!\" class=\"dropdown-item\">Apply coupon</a></li> "), _ctx.$modulePermission('Customer', 'Delete') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_53, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item text-red",
    onClick: _cache[1] || (_cache[1] = function ($event) {
      return $setup.deletePopupVisibility = true;
    })
  }, "Delete customer")])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), _hoisted_54])])])])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_55, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_56, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_57, [_ctx.$modulePermission('Payment', 'View') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_58, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_59, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_60, [_hoisted_61, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_62, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_63, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [_ctx.$modulePermission('PaymentLinkGenerator', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_Link, {
    key: 0,
    href: _ctx.route('admin.payment.generate', {
      customerID: (_$setup$props$custome19 = $setup.props.customer) === null || _$setup$props$custome19 === void 0 ? void 0 : _$setup$props$custome19.id
    }),
    "class": "payment-head-link"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Create ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), $setup.checkedOptions.options.length > 0 && _ctx.$modulePermission('Refund', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_64, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.checkedOptions.options.length), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", _hoisted_65, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "dashed",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      return $setup.checkedOptions.options = [];
    })
  }, "Deselect")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "btn-group"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    type: "button",
    "class": "btn",
    onClick: $setup.showRefundPopup
  }, [].concat(_hoisted_71))])])], 64 /* STABLE_FRAGMENT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_72, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_73, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_74, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", _hoisted_75, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_76, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    "class": "form-check-input fs-15",
    type: "checkbox",
    id: "checkAll",
    value: "option",
    checked: $setup.checkedOptions.allSelected,
    onClick: $setup.selectAllCheckbox
  }, null, 8 /* PROPS */, _hoisted_77), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <input class=\"form-check-input fs-15\" type=\"checkbox\" id=\"checkAll\" value=\"option\" /> ")])]), _hoisted_78, _hoisted_79, _hoisted_80, _hoisted_81, _hoisted_82, _hoisted_83])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [$setup.payments ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.payments, function (payment, i) {
    var _payment$link;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", _hoisted_84, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_85, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <input class=\"form-check-input fs-15\" type=\"checkbox\" name=\"checkAll\" value=\"option1\" /> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
      "class": "form-check-input fs-15",
      type: "checkbox",
      name: "check[]",
      value: payment.id,
      "onUpdate:modelValue": _cache[3] || (_cache[3] = function ($event) {
        return $setup.checkedOptions.options = $event;
      }),
      disabled: payment.status !== 1
    }, null, 8 /* PROPS */, _hoisted_86), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.checkedOptions.options]])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <td v-on:click=\"visitPaymentDetail(payment.id)\">\r\n                                                        <b>\r\n                                                            {{ payment?.link?.currency_country?.symbol }}{{ payment?.price }}\r\n                                                        </b>\r\n                                                    </td>\r\n                                                    <td v-on:click=\"visitPaymentDetail(payment.id)\">\r\n                                                        {{ payment?.link?.currency_country?.code }}\r\n                                                    </td>\r\n                                                    <td>\r\n                                                        <Badge :badgeClass=\"`badge badge-soft-${payment?.paymentStatus?.style?.class}`\" :badgeText=\"payment?.paymentStatus?.text\" :iconClass=\"payment?.paymentStatus?.style?.icon\" />\r\n                                                    </td> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["AmountColumn"], {
      item: payment
    }, null, 8 /* PROPS */, ["item"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitPaymentDetail(payment.id);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(payment === null || payment === void 0 || (_payment$link = payment.link) === null || _payment$link === void 0 ? void 0 : _payment$link.item_name), 9 /* TEXT, PROPS */, _hoisted_87), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitPaymentDetail(payment.id);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(payment === null || payment === void 0 ? void 0 : payment.created_at), "PPpp")), 9 /* TEXT, PROPS */, _hoisted_88), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_89, [_ctx.$modulePermission('Refund', 'Create') && payment.status == 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_90, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      "class": "btn btn-soft-secondary btn-sm dropdown",
      type: "button",
      onClick: function onClick($event) {
        return $setup.showRefundPopup(payment);
      }
    }, [].concat(_hoisted_93), 8 /* PROPS */, _hoisted_91)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      "class": "btn btn-soft-secondary btn-sm dropdown",
      type: "button",
      onClick: function onClick($event) {
        var _$setup$props$custome20;
        $setup.sendEmailVisibility = true;
        $setup.customerEmail = (_$setup$props$custome20 = $setup.props.customer) === null || _$setup$props$custome20 === void 0 ? void 0 : _$setup$props$custome20.email;
        $setup.paymentId = payment.id;
      }
    }, [].concat(_hoisted_96), 8 /* PROPS */, _hoisted_94)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_97, [_hoisted_98, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_99, [_hoisted_100, _ctx.$modulePermission('Refund', 'Create') && payment.status == 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_101, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      href: "#!",
      "class": "dropdown-item",
      onClick: function onClick($event) {
        return $setup.showRefundPopup(payment);
      }
    }, " Refund payment ", 8 /* PROPS */, _hoisted_102)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      href: "#!",
      "class": "dropdown-item",
      onClick: function onClick($event) {
        var _$setup$props$custome21;
        $setup.sendEmailVisibility = true;
        $setup.customerEmail = (_$setup$props$custome21 = $setup.props.customer) === null || _$setup$props$custome21 === void 0 ? void 0 : _$setup$props$custome21.email;
        $setup.paymentId = payment.id;
      }
    }, " Send receipt ", 8 /* PROPS */, _hoisted_103)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      onClick: _cache[4] || (_cache[4] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {}, ["stop"])),
      href: "javascript:void(0)",
      "class": "dropdown-item"
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Tooltip"], {
      tooltipText: "Payment ID",
      showText: "Copy Payment ID",
      showTextClass: "copy-payment-id-text",
      copyText: payment === null || payment === void 0 ? void 0 : payment.intent_id,
      showIcon: false
    }, null, 8 /* PROPS */, ["copyText"])])]), _hoisted_104, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
      href: _ctx.route('admin.payment.detail.id', {
        id: payment.id
      }),
      "class": "dropdown-item"
    }, {
      "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
        return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" View payment details ")];
      }),
      _: 2 /* DYNAMIC */
    }, 1032 /* PROPS, DYNAMIC_SLOTS */, ["href"])])])])])])])]);
  }), 128 /* KEYED_FRAGMENT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])])])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["PaymentMethodSection"], {
    detail: $setup.paymentMethod,
    "customer-name": ((_$props$customer = $props.customer) === null || _$props$customer === void 0 ? void 0 : _$props$customer.first_name) + ' ' + ((_$props$customer2 = $props.customer) === null || _$props$customer2 === void 0 ? void 0 : _$props$customer2.last_name)
  }, null, 8 /* PROPS */, ["detail", "customer-name"]), _ctx.$modulePermission('Invoice', 'View') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["InvoiceSection"], {
    key: 1,
    invoices: (_$setup$props$custome22 = $setup.props.customer) === null || _$setup$props$custome22 === void 0 ? void 0 : _$setup$props$custome22.invoices,
    customerID: (_$setup$props$custome23 = $setup.props.customer) === null || _$setup$props$custome23 === void 0 ? void 0 : _$setup$props$custome23.id
  }, null, 8 /* PROPS */, ["invoices", "customerID"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["RelatedBriefSection"], {
    relatedBrief: $setup.props.relatedBrief,
    customerID: (_$setup$props$custome24 = $setup.props.customer) === null || _$setup$props$custome24 === void 0 ? void 0 : _$setup$props$custome24.id
  }, null, 8 /* PROPS */, ["relatedBrief", "customerID"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["QuotesSection"], {
    quotes: (_$setup$props$custome25 = $setup.props.customer) === null || _$setup$props$custome25 === void 0 ? void 0 : _$setup$props$custome25.quotes,
    customerID: (_$setup$props$custome26 = $setup.props.customer) === null || _$setup$props$custome26 === void 0 ? void 0 : _$setup$props$custome26.id
  }, null, 8 /* PROPS */, ["quotes", "customerID"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["RecentActivity"], {
    paymentLogs: (_$setup$props$custome27 = $setup.props.customer) === null || _$setup$props$custome27 === void 0 ? void 0 : _$setup$props$custome27.payment_logs,
    customerID: (_$setup$props$custome28 = $setup.props.customer) === null || _$setup$props$custome28 === void 0 ? void 0 : _$setup$props$custome28.id
  }, null, 8 /* PROPS */, ["paymentLogs", "customerID"])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_105, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["EventsAndLogs"], {
    "customer-logs": (_$setup$props$custome29 = $setup.props.customer) === null || _$setup$props$custome29 === void 0 ? void 0 : _$setup$props$custome29.payment_logs,
    payments: (_$setup$props$custome30 = $setup.props.customer) === null || _$setup$props$custome30 === void 0 ? void 0 : _$setup$props$custome30.payments
  }, null, 8 /* PROPS */, ["customer-logs", "payments"])])])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("end col")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["CustomerPopup"], {
    title: "Update Customer",
    customerDetail: $setup.customerDetail,
    popupVisibility: $setup.detailPopupVisibility,
    hidePopup: $setup.hideDetailPopup,
    onSubmit: function onSubmit(formData) {
      return $setup.updateCustomer(formData);
    },
    isUpdate: true,
    countries: $props.countries
  }, null, 8 /* PROPS */, ["customerDetail", "popupVisibility", "onSubmit", "countries"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Popup"], {
    title: "Edit metadata",
    "class": "metaPopupArea",
    visibility: $setup.metadataPopupVisibility,
    onClose: $setup.hideMetaPopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.metaInputs, function (input, index) {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
          key: index,
          "class": "flex-inputArea"
        }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_106, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
          "onUpdate:modelValue": function onUpdateModelValue($event) {
            return input.key = $event;
          },
          type: "text",
          placeholder: "Key"
        }, null, 8 /* PROPS */, _hoisted_107), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, input.key]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_108, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
          "onUpdate:modelValue": function onUpdateModelValue($event) {
            return input.value = $event;
          },
          type: "text",
          placeholder: "Value"
        }, null, 8 /* PROPS */, _hoisted_109), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, input.value]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
          "class": "deleteArea",
          onClick: function onClick($event) {
            return $setup.removeInput(index);
          }
        }, [].concat(_hoisted_112), 8 /* PROPS */, _hoisted_110)]);
      }), 128 /* KEYED_FRAGMENT */))];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
        "class": "btn-to-start"
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.addInput
      }, [_hoisted_113, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add another item ")])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.hideMetaPopup
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: $setup.updateMetadata
      }, " Save ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["visibility"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["DeletePopup"], {
    title: "customer",
    message: "This will permanently remove the customer's billing information and immediately cancel any current subscriptions. Past payments or invoices associated with the customer will still remain. This action cannot be undone.",
    deleteVisibility: $setup.deletePopupVisibility,
    hideDeletePopup: function hideDeletePopup() {
      return $setup.deletePopupVisibility = false;
    },
    onDeleteSubmit: function onDeleteSubmit() {
      return $setup.deleteCustomer();
    }
  }, null, 8 /* PROPS */, ["deleteVisibility", "hideDeletePopup", "onDeleteSubmit"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Notify"], {
    notify: $setup.notify,
    notificationData: $setup.notificationData
  }, null, 8 /* PROPS */, ["notify", "notificationData"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["RefundPopup"], {
    type: "single",
    data: {
      payments: [$setup.selectedPayment],
      refundIDs: [(_$setup$selectedPayme = $setup.selectedPayment) === null || _$setup$selectedPayme === void 0 ? void 0 : _$setup$selectedPayme.id]
    },
    currency: $setup.paymentCurrency,
    visibility: $setup.refundPopupVisibility,
    onClose: function onClose() {
      return $setup.refundPopupVisibility = false;
    },
    maxWidth: "45vw",
    "onUpdate:visibility": $setup.updateVisibility
  }, null, 8 /* PROPS */, ["data", "currency", "visibility", "onClose"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Popup"], {
    title: "Send receipt",
    visibility: $setup.sendEmailVisibility,
    onClose: function onClose() {
      return $setup.sendEmailVisibility = false;
    }
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_114, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_115, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_116, [_hoisted_117, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_118, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Customer Email",
        disabled: "",
        "onUpdate:modelValue": _cache[5] || (_cache[5] = function ($event) {
          return $setup.customerEmail = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.customerEmail]]), _hoisted_119])])])])];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[6] || (_cache[6] = function ($event) {
          return $setup.sendEmailVisibility = false;
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: $setup.sentTestingInvoice
      }, " Send ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["visibility", "onClose"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Popup"], {
    title: $setup.allowBlockList.popup.title,
    visibility: $setup.allowBlockList.popup.visible,
    onClose: function onClose() {
      return $setup.allowBlockList.popup.visible = false;
    }
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_120, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_121, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.allowBlockList.popup.bodyText), 1 /* TEXT */)])];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[7] || (_cache[7] = function ($event) {
          return $setup.allowBlockList.popup.visible = false;
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: _cache[8] || (_cache[8] = function ($event) {
          return $setup.AddToAllowBlockList($setup.props.customer.id, !$setup.allowBlockList.isBlocked);
        })
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.allowBlockList.popup.btnText), 1 /* TEXT */)];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("end row"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Head, null, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [_hoisted_122];
    }),
    _: 1 /* STABLE */
  })], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=template&id=75fd909c&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=template&id=75fd909c&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-75fd909c"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
    style: {
      "margin": "5px 0"
    }
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Refunds take 5-10 days to appear on a customer's statement. Stripe's fees for the original payment won't be returned, but there are no additional fees for the refund. "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "https://support.stripe.com/questions/understanding-fees-for-refunded-payments",
    style: {
      "color": "#625afa",
      "font-weight": "600"
    }
  }, "Learn more"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(". "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("pre", null, "                ")], -1 /* HOISTED */);
});
var _hoisted_2 = {
  key: 0,
  "class": "row"
};
var _hoisted_3 = {
  "class": "col-md-5"
};
var _hoisted_4 = {
  "class": "popup-details-input label-field"
};
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Refund", -1 /* HOISTED */);
});
var _hoisted_6 = {
  "class": "row"
};
var _hoisted_7 = {
  "class": "col-md-5"
};
var _hoisted_8 = {
  "class": "popup-details-input label-field"
};
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Reason", -1 /* HOISTED */);
});
var _hoisted_10 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("option", {
    disabled: ""
  }, "Select a reason", -1 /* HOISTED */);
});
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("option", {
    value: "duplicate"
  }, "Duplicate", -1 /* HOISTED */);
});
var _hoisted_12 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("option", {
    value: "fraudulent"
  }, "Fraudulent", -1 /* HOISTED */);
});
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("option", {
    value: "requested_by_customer"
  }, "Requested by customer", -1 /* HOISTED */);
});
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("option", {
    value: "other"
  }, "Other", -1 /* HOISTED */);
});
var _hoisted_15 = [_hoisted_10, _hoisted_11, _hoisted_12, _hoisted_13, _hoisted_14];
var _hoisted_16 = {
  "class": "row",
  style: {
    "margin-top": "1rem"
  }
};
var _hoisted_17 = {
  "class": "popup-details-input"
};
var _hoisted_18 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
    style: {
      "margin-bottom": "2px"
    }
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", {
    style: {
      "font-weight": "600"
    }
  }, " Add more details... ")], -1 /* HOISTED */);
});
var _hoisted_19 = ["required"];
var _hoisted_20 = {
  key: 1
};
var _hoisted_21 = {
  key: 0,
  "class": "btn-to-start"
};
var _hoisted_22 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "Esc", -1 /* HOISTED */);
});
var _hoisted_23 = {
  key: 0
};
var _hoisted_24 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "ctrl", -1 /* HOISTED */);
});
var _hoisted_25 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "+", -1 /* HOISTED */);
});
var _hoisted_26 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "enter", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Popup"], {
    title: $setup.title,
    "class": "refund-popup",
    visibility: $setup.refundPopupVisibility,
    onClose: function onClose() {
      return $setup.refundPopupVisibility = false;
    },
    maxWidth: "40vw"
  }, {
    head: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [_hoisted_1];
    }),
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [$setup.props.type == 'single' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [_hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "number",
        "onUpdate:modelValue": _cache[0] || (_cache[0] = function ($event) {
          return $setup.popupFormData.amount = $event;
        }),
        min: "0",
        onInput: _cache[1] || (_cache[1] = function ($event) {
          return $setup.checkAmount($setup.popupFormData.amount);
        }),
        onBlur: _cache[2] || (_cache[2] = function ($event) {
          return $setup.checkAmount($setup.popupFormData.amount);
        }),
        onFocusout: _cache[3] || (_cache[3] = function ($event) {
          return $setup.checkBlank($setup.popupFormData.amount);
        })
      }, null, 544 /* NEED_HYDRATION, NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.popupFormData.amount]])])])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [_hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("select", {
        "onUpdate:modelValue": _cache[4] || (_cache[4] = function ($event) {
          return $setup.popupFormData.reason = $event;
        }),
        style: {
          "font-weight": "600"
        }
      }, [].concat(_hoisted_15), 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelSelect, $setup.popupFormData.reason]])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_17, [_hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("textarea", {
        required: $setup.popupFormData.reason == 'other',
        name: "detailed_reason",
        style: {
          "height": "50px",
          "resize": "none"
        },
        "onUpdate:modelValue": _cache[5] || (_cache[5] = function ($event) {
          return $setup.popupFormData.detailed_reason = $event;
        })
      }, "\r\n          ", 8 /* PROPS */, _hoisted_19), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.popupFormData.detailed_reason]])])]), $setup.popupFormData.reason == 'other' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_20, "A note is requried when you not selected the reason.")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      var _$props$currency, _$props$currency2;
      return [$setup.props.type == 'multiple' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_21, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Total refunds: "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$currency = $props.currency) === null || _$props$currency === void 0 ? void 0 : _$props$currency.symbol) + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.popupFormData.amount), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.cancelRefundPopup
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Cancel"), _hoisted_22]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        ref: "refundBtn",
        "class": "purpleLinkStyle",
        onClick: _cache[6] || (_cache[6] = function ($event) {
          return $setup.passwordPopupVisibility = true;
        })
      }, [$setup.props.type == 'single' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_23, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$currency2 = $props.currency) === null || _$props$currency2 === void 0 ? void 0 : _$props$currency2.symbol) + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.popupFormData.amount), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Refund "), _hoisted_24, _hoisted_25, _hoisted_26], 512 /* NEED_PATCH */)];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["PasswordPopup"], {
    title: "Confirm your password",
    popupVisibility: $setup.passwordPopupVisibility,
    hidePopup: function hidePopup() {
      return $setup.passwordPopupVisibility = false;
    },
    onSubmit: function onSubmit(formData) {
      $setup.axios.post(_ctx.route('admin.staff.verify.password'), formData).then(function (response) {
        if (!response.data.errors && response.status == 200) {
          $setup.passwordPopupVisibility = false;
          $setup.refundPayments();
        } else if (response.data.errors) {
          $setup.errors = response.data.errors;
        }
      })["catch"](function (error) {
        console.error('Error:', error);
      });
    },
    errors: $setup.errors
  }, null, 8 /* PROPS */, ["popupVisibility", "hidePopup", "onSubmit", "errors"])], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=template&id=cc3ec3ca":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=template&id=cc3ec3ca ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["", [$setup.props.badgeClass, $setup.props.iconPosition ? 'd-flex' : '', $setup.props.iconPosition === 'right' ? 'flex-row' : 'flex-row-reverse']])
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.badgeText) + " ", 1 /* TEXT */), $setup.props.iconClass ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", {
    key: 0,
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["", $setup.props.iconClass])
  }, null, 2 /* CLASS */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 2 /* CLASS */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/EventsAndLogs.vue?vue&type=template&id=7e2208ac":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/EventsAndLogs.vue?vue&type=template&id=7e2208ac ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "eventslogdiv mb-5"
};
var _hoisted_2 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", null, "Logs", -1 /* HOISTED */);
var _hoisted_3 = {
  id: "scroll-horizontal",
  "class": "table nowrap align-middle productsTables borders-toTop",
  style: {
    "width": "100%"
  }
};
var _hoisted_4 = ["onClick"];
var _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
  style: {
    "width": "75px"
  }
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "badge badge-soft-default"
}, " 200 OK ")], -1 /* HOISTED */);
var _hoisted_6 = {
  style: {
    "width": "135px"
  }
};
var _hoisted_7 = {
  "class": "eventslogdiv"
};
var _hoisted_8 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", null, "Events", -1 /* HOISTED */);
var _hoisted_9 = {
  id: "scroll-horizontal",
  "class": "table nowrap align-middle productsTables borders-toTop",
  style: {
    "width": "100%"
  }
};
var _hoisted_10 = ["onClick"];
var _hoisted_11 = {
  style: {
    "width": "15%"
  }
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.detailLogs, function (event, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i,
      onClick: function onClick($event) {
        return $setup.visitCustomerLogsDetail(event.id);
      }
    }, [_hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "POST /v1/" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.logURL(event.response)), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(event === null || event === void 0 ? void 0 : event.created_at), 'PPpp')), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_4);
  }), 128 /* KEYED_FRAGMENT */))])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [_hoisted_8, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.detailLogs, function (event, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i,
      onClick: function onClick($event) {
        return $setup.visitCustomerEventDetail(event.id);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(event.activity), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(event === null || event === void 0 ? void 0 : event.created_at), 'PPpp')), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_10);
  }), 128 /* KEYED_FRAGMENT */))])])])], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/InvoiceSection.vue?vue&type=template&id=9267d12a":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/InvoiceSection.vue?vue&type=template&id=9267d12a ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = {
  "class": "single-payment-head mb-0"
};
var _hoisted_3 = {
  "class": "row align-items-end"
};
var _hoisted_4 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
  "class": "col-md-6"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Invoices")], -1 /* HOISTED */);
var _hoisted_5 = {
  "class": "col-md-6 text-right"
};
var _hoisted_6 = {
  "class": "row"
};
var _hoisted_7 = {
  "class": "col-12"
};
var _hoisted_8 = {
  key: 0,
  id: "scroll-horizontal",
  "class": "table nowrap align-middle productsTables",
  style: {
    "width": "100%"
  }
};
var _hoisted_9 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
  style: {
    "width": "10px"
  }
}, "Amount"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
  style: {
    "width": "10px"
  }
}), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
  style: {
    "width": "10px"
  }
}), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
  style: {
    "min-width": "150px"
  }
}, "Invoice Number"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
  style: {
    "min-width": "10px"
  }
}, "Created"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
  style: {
    "width": "10px"
  }
})])], -1 /* HOISTED */);
var _hoisted_10 = ["onClick"];
var _hoisted_11 = ["onClick"];
var _hoisted_12 = ["onClick"];
var _hoisted_13 = ["onClick"];
var _hoisted_14 = ["onClick"];
var _hoisted_15 = {
  "class": "payment-actionListUl"
};
var _hoisted_16 = ["onClick"];
var _hoisted_17 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "mdi mdi-download"
}, null, -1 /* HOISTED */);
var _hoisted_18 = [_hoisted_17];
var _hoisted_19 = {
  "class": "dropdown d-inline-block"
};
var _hoisted_20 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  "class": "btn btn-soft-secondary btn-sm dropdown",
  type: "button",
  "data-bs-toggle": "dropdown",
  "aria-expanded": "false"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "ri-more-fill align-middle"
})], -1 /* HOISTED */);
var _hoisted_21 = {
  "class": "dropdown-menu dropdown-menu-end drop-down-colors"
};
var _hoisted_22 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
  "class": "dropHead"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
  href: "#!",
  "class": "dropdown-item"
}, "Actions")], -1 /* HOISTED */);
var _hoisted_23 = ["onClick"];
var _hoisted_24 = {
  key: 0
};
var _hoisted_25 = {
  key: 1,
  "class": "na mt-3"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_Link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [_ctx.$modulePermission('Invoice', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_Link, {
    key: 0,
    href: _ctx.route('admin.invoice.create', {
      customer_id: parseInt($setup.props.customerID)
    }),
    "class": "payment-head-link"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Create")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [$setup.props.invoices.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_8, [_hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.invoices, function (invoiceItem, index) {
    var _invoiceItem$payment, _invoiceItem$payment2, _invoiceItem$payment3, _$setup$invoiceStatus, _$setup$invoiceStatus2;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: index
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.invoiceDetail(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.id);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(invoiceItem === null || invoiceItem === void 0 || (_invoiceItem$payment = invoiceItem.payment) === null || _invoiceItem$payment === void 0 || (_invoiceItem$payment = _invoiceItem$payment.link) === null || _invoiceItem$payment === void 0 || (_invoiceItem$payment = _invoiceItem$payment.currency_country) === null || _invoiceItem$payment === void 0 ? void 0 : _invoiceItem$payment.symbol) + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(invoiceItem === null || invoiceItem === void 0 || (_invoiceItem$payment2 = invoiceItem.payment) === null || _invoiceItem$payment2 === void 0 || (_invoiceItem$payment2 = _invoiceItem$payment2.link) === null || _invoiceItem$payment2 === void 0 ? void 0 : _invoiceItem$payment2.price), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_10), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.invoiceDetail(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.id);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(invoiceItem === null || invoiceItem === void 0 || (_invoiceItem$payment3 = invoiceItem.payment) === null || _invoiceItem$payment3 === void 0 || (_invoiceItem$payment3 = _invoiceItem$payment3.link) === null || _invoiceItem$payment3 === void 0 || (_invoiceItem$payment3 = _invoiceItem$payment3.currency_country) === null || _invoiceItem$payment3 === void 0 ? void 0 : _invoiceItem$payment3.aplha_code3), 9 /* TEXT, PROPS */, _hoisted_11), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.invoiceDetail(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.id);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Badge"], {
      badgeClass: (_$setup$invoiceStatus = $setup.invoiceStatus.get(invoiceItem.status)) === null || _$setup$invoiceStatus === void 0 || (_$setup$invoiceStatus = _$setup$invoiceStatus.style) === null || _$setup$invoiceStatus === void 0 ? void 0 : _$setup$invoiceStatus.className,
      badgeText: (_$setup$invoiceStatus2 = $setup.invoiceStatus.get(invoiceItem.status)) === null || _$setup$invoiceStatus2 === void 0 ? void 0 : _$setup$invoiceStatus2.name
    }, null, 8 /* PROPS */, ["badgeClass", "badgeText"])], 8 /* PROPS */, _hoisted_12), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.invoiceDetail(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.id);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(invoiceItem.invoice_no), 9 /* TEXT, PROPS */, _hoisted_13), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.invoiceDetail(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.id);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(invoiceItem.created_at), 'dd MMM yy')), 9 /* TEXT, PROPS */, _hoisted_14), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: function onClick($event) {
        return $setup.downloadInvoice(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.payment_id, invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.invoice_no);
      },
      "class": "btn btn-soft-secondary btn-sm dropdown buttonWithSmallText",
      type: "button"
    }, [].concat(_hoisted_18), 8 /* PROPS */, _hoisted_16)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_19, [_hoisted_20, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_21, [_hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      onClick: function onClick($event) {
        return $setup.downloadInvoice(invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.payment_id, invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.invoice_no);
      },
      "class": "dropdown-item"
    }, " Download PDF ", 8 /* PROPS */, _hoisted_23)]), _ctx.$modulePermission('Invoice', 'Edit') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_24, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
      href: _ctx.route('admin.invoice.edit', {
        id: invoiceItem === null || invoiceItem === void 0 ? void 0 : invoiceItem.id
      }),
      "class": "dropdown-item"
    }, {
      "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
        return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Edit invoice ")];
      }),
      _: 2 /* DYNAMIC */
    }, 1032 /* PROPS, DYNAMIC_SLOTS */, ["href"])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <li>\r\n                            <a\r\n                                @click=\"\r\n                                    DuplicateInvoice(\r\n                                      invoiceItem?.id,\r\n                                      invoiceItem?.invoice_no\r\n                                    )\r\n                                \"\r\n                                class=\"dropdown-item\"\r\n                            >\r\n                                Duplicate\r\n                                invoice\r\n                            </a>\r\n                          </li>\r\n                          <li v-if=\"invoiceItem?.status != 2\">\r\n                            <a class=\"dropdown-item text-red\" @click=\"handleInvoiceDeletePopup(invoiceItem?.id,)\">\r\n                              Delete draft\r\n                            </a>\r\n                          </li> ")])])])])])]);
  }), 128 /* KEYED_FRAGMENT */))])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_25, "No invoices"))])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <DeletePopup\r\n        title=\"invoice\"\r\n        message=\"Are you sure you want to permanently delete this draft invoice? This cannot be undone.\"\r\n        :deleteVisibility=\"deletePopupVisibility\"\r\n        :hideDeletePopup=\"() => (deletePopupVisibility = false)\"\r\n        :onDeleteSubmit=\"onDeleteSubmit\"\r\n    /> ")], 2112 /* STABLE_FRAGMENT, DEV_ROOT_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=template&id=50787864&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=template&id=50787864&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-50787864"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "single-payment-head m-0"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "row align-items-end"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Payment methods")])])], -1 /* HOISTED */);
});
var _hoisted_3 = {
  "class": "row"
};
var _hoisted_4 = {
  "class": "col-12"
};
var _hoisted_5 = {
  key: 0,
  "class": "custom-accordions",
  ref: "AccordianParent"
};
var _hoisted_6 = {
  "class": "custom-accordion-head"
};
var _hoisted_7 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-arrow-right-s-line"
  }, null, -1 /* HOISTED */);
});
var _hoisted_8 = ["src", "onerror"];
var _hoisted_9 = {
  "class": "custom-accordion-detail"
};
var _hoisted_10 = {
  "class": "custom-accordion-body"
};
var _hoisted_11 = {
  "class": "row"
};
var _hoisted_12 = {
  "class": "col-lg-8"
};
var _hoisted_13 = {
  "class": "payment-detail-table"
};
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Name", -1 /* HOISTED */);
});
var _hoisted_15 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Number", -1 /* HOISTED */);
});
var _hoisted_16 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Fingerprint", -1 /* HOISTED */);
});
var _hoisted_17 = {
  href: "#"
};
var _hoisted_18 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Expires", -1 /* HOISTED */);
});
var _hoisted_19 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Type", -1 /* HOISTED */);
});
var _hoisted_20 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "ID", -1 /* HOISTED */);
});
var _hoisted_21 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Postal code", -1 /* HOISTED */);
});
var _hoisted_22 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Phone", -1 /* HOISTED */);
});
var _hoisted_23 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Email", -1 /* HOISTED */);
});
var _hoisted_24 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Origin", -1 /* HOISTED */);
});
var _hoisted_25 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "CVC check", -1 /* HOISTED */);
});
var _hoisted_26 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, " Zip check ", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$props$detail, _$props$detail2, _$props$detail3, _$props$detail4, _$props$detail5, _$props$detail6, _$props$detail7, _$props$detail8, _$props$detail9, _$props$detail10, _$props$detail11, _$props$detail12, _$props$detail13, _$props$detail14, _$props$detail15, _$props$detail16, _$props$detail17, _$props$detail18, _$props$detail19, _$props$detail20;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [$props.detail ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    "class": "custom-accordion-detailArea",
    onClick: $setup.showAccordian,
    ref: "customAccordianBtn"
  }, [_hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
    "class": "card-logo",
    src: $setup.siteURL + 'backend/images/cards/' + ((_$props$detail = $props.detail) === null || _$props$detail === void 0 || (_$props$detail = _$props$detail.card) === null || _$props$detail === void 0 ? void 0 : _$props$detail.brand) + '.svg',
    onerror: "this.onerror=null; this.src='" + $setup.siteURL + "backend/images/cards/generic.svg'"
  }, null, 8 /* PROPS */, _hoisted_8), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalizeWords((_$props$detail2 = $props.detail) === null || _$props$detail2 === void 0 || (_$props$detail2 = _$props$detail2.card) === null || _$props$detail2 === void 0 ? void 0 : _$props$detail2.brand)) + " •••• " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail3 = $props.detail) === null || _$props$detail3 === void 0 || (_$props$detail3 = _$props$detail3.card) === null || _$props$detail3 === void 0 ? void 0 : _$props$detail3.last4), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, "Expires " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail4 = $props.detail) === null || _$props$detail4 === void 0 || (_$props$detail4 = _$props$detail4.card) === null || _$props$detail4 === void 0 ? void 0 : _$props$detail4.exp_month) + " / " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail5 = $props.detail) === null || _$props$detail5 === void 0 || (_$props$detail5 = _$props$detail5.card) === null || _$props$detail5 === void 0 ? void 0 : _$props$detail5.exp_year), 1 /* TEXT */)])], 512 /* NEED_PATCH */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_13, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.customerName), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_15, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "•••• " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail6 = $props.detail) === null || _$props$detail6 === void 0 || (_$props$detail6 = _$props$detail6.card) === null || _$props$detail6 === void 0 ? void 0 : _$props$detail6.last4), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_16, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", _hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail7 = $props.detail) === null || _$props$detail7 === void 0 || (_$props$detail7 = _$props$detail7.card) === null || _$props$detail7 === void 0 ? void 0 : _$props$detail7.fingerprint), 1 /* TEXT */)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail8 = $props.detail) === null || _$props$detail8 === void 0 || (_$props$detail8 = _$props$detail8.card) === null || _$props$detail8 === void 0 ? void 0 : _$props$detail8.exp_month) + " / " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail9 = $props.detail) === null || _$props$detail9 === void 0 || (_$props$detail9 = _$props$detail9.card) === null || _$props$detail9 === void 0 ? void 0 : _$props$detail9.exp_year), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_19, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalizeWords((_$props$detail10 = $props.detail) === null || _$props$detail10 === void 0 || (_$props$detail10 = _$props$detail10.card) === null || _$props$detail10 === void 0 ? void 0 : _$props$detail10.brand)), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_20, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail11 = $props.detail) === null || _$props$detail11 === void 0 ? void 0 : _$props$detail11.id), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_21, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail12 = $props.detail) === null || _$props$detail12 === void 0 || (_$props$detail12 = _$props$detail12.billing_details) === null || _$props$detail12 === void 0 || (_$props$detail12 = _$props$detail12.address) === null || _$props$detail12 === void 0 ? void 0 : _$props$detail12.postal_code), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail13 = $props.detail) === null || _$props$detail13 === void 0 || (_$props$detail13 = _$props$detail13.billing_details) === null || _$props$detail13 === void 0 ? void 0 : _$props$detail13.phone), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_23, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$props$detail14 = $props.detail) === null || _$props$detail14 === void 0 || (_$props$detail14 = _$props$detail14.billing_details) === null || _$props$detail14 === void 0 ? void 0 : _$props$detail14.email), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_24, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.getCountryFullName((_$props$detail15 = $props.detail) === null || _$props$detail15 === void 0 || (_$props$detail15 = _$props$detail15.card) === null || _$props$detail15 === void 0 ? void 0 : _$props$detail15.country)) + " ", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["CountryFlag"], {
    country: (_$props$detail16 = $props.detail) === null || _$props$detail16 === void 0 || (_$props$detail16 = _$props$detail16.card) === null || _$props$detail16 === void 0 ? void 0 : _$props$detail16.country,
    size: "small"
  }, null, 8 /* PROPS */, ["country"])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_25, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.checkText({
    check: (_$props$detail17 = $props.detail) === null || _$props$detail17 === void 0 || (_$props$detail17 = _$props$detail17.card) === null || _$props$detail17 === void 0 ? void 0 : _$props$detail17.checks.cvc_check
  })) + " ", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["checkIcon"], {
    check: (_$props$detail18 = $props.detail) === null || _$props$detail18 === void 0 || (_$props$detail18 = _$props$detail18.card) === null || _$props$detail18 === void 0 ? void 0 : _$props$detail18.checks.cvc_check
  }, null, 8 /* PROPS */, ["check"])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [_hoisted_26, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.checkText({
    check: (_$props$detail19 = $props.detail) === null || _$props$detail19 === void 0 || (_$props$detail19 = _$props$detail19.card) === null || _$props$detail19 === void 0 ? void 0 : _$props$detail19.checks.address_postal_code_check
  })) + " ", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["checkIcon"], {
    check: (_$props$detail20 = $props.detail) === null || _$props$detail20 === void 0 || (_$props$detail20 = _$props$detail20.card) === null || _$props$detail20 === void 0 ? void 0 : _$props$detail20.checks.address_postal_code_check
  }, null, 8 /* PROPS */, ["check"])])])])])])])])], 512 /* NEED_PATCH */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=template&id=585fc86a&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=template&id=585fc86a&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-585fc86a"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = {
  "class": "single-payment-head mb-0"
};
var _hoisted_3 = {
  "class": "row align-items-end"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Quotes")], -1 /* HOISTED */);
});
var _hoisted_5 = {
  "class": "col-md-6 text-right"
};
var _hoisted_6 = {
  "class": "row"
};
var _hoisted_7 = {
  "class": "col-12"
};
var _hoisted_8 = {
  "class": "row mb-3 mt-3"
};
var _hoisted_9 = {
  "class": "col-lg-12"
};
var _hoisted_10 = {
  "class": "mt-3 text-end"
};
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Esc", -1 /* HOISTED */);
});
var _hoisted_12 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_15 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
var _hoisted_16 = {
  key: 0,
  id: "scroll-horizontal",
  "class": "table nowrap align-middle productsTables",
  style: {
    "width": "100%"
  }
};
var _hoisted_17 = {
  "class": "payment-actionListUl"
};
var _hoisted_18 = {
  "class": "dropdown d-inline-block"
};
var _hoisted_19 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    "class": "btn btn-soft-secondary btn-sm dropdown",
    type: "button",
    "data-bs-toggle": "dropdown",
    "aria-expanded": "false"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-more-fill align-middle"
  })], -1 /* HOISTED */);
});
var _hoisted_20 = {
  "class": "dropdown-menu dropdown-menu-end drop-down-colors"
};
var _hoisted_21 = ["onClick"];
var _hoisted_22 = ["onClick"];
var _hoisted_23 = {
  key: 1,
  "class": "na mt-3"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "payment-head-link",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      $setup.showQuoteBox = true;
      $setup.editQuoteID = 0;
    })
  }, "Create")])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("textarea", {
    "class": "form-control",
    rows: "4",
    "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
      return $setup.quote = $event;
    })
  }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.quote]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "cancelbtn",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      return $setup.cancelQuote();
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Cancel "), _hoisted_11]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addQuotepurple",
    onClick: $setup.addQuote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add quote "), _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_13], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.editQuoteID == 0]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addQuotepurple",
    onClick: $setup.updateQuote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Edit quote "), _hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_15], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.editQuoteID > 0]])])])], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.showQuoteBox]]), $setup.props.quotes ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_16, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.quotes, function (quote, index) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: index
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(quote.comment), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_17, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [_hoisted_19, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_20, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      onClick: function onClick($event) {
        return $setup.editQuote(quote.id);
      },
      "class": "dropdown-item"
    }, " Edit Quote ", 8 /* PROPS */, _hoisted_21)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      onClick: function onClick($event) {
        return $setup.deleteQuote(quote.id);
      },
      "class": "dropdown-item text-red"
    }, " Delete Quote ", 8 /* PROPS */, _hoisted_22)])])])])])])]);
  }), 128 /* KEYED_FRAGMENT */))])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_23, "No quotes"))])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=template&id=b4968c06&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=template&id=b4968c06&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-b4968c06"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = {
  "class": "single-payment-head"
};
var _hoisted_3 = {
  "class": "row align-items-end"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Recent activity")], -1 /* HOISTED */);
});
var _hoisted_5 = {
  "class": "col-md-6 text-right"
};
var _hoisted_6 = {
  "class": "row mb-4"
};
var _hoisted_7 = {
  "class": "col-lg-12"
};
var _hoisted_8 = {
  "class": "mt-3 text-end"
};
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Esc", -1 /* HOISTED */);
});
var _hoisted_10 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
var _hoisted_12 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [$setup.modulePermission('Notes', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
    key: 0,
    "class": "payment-head-link",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.addNoteBox = true;
    })
  }, "Add note")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("textarea", {
    "class": "form-control",
    rows: "4",
    "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
      return $setup.note = $event;
    })
  }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.note]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "cancelbtn",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      $setup.addNoteBox = false;
      $setup.note = '';
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Cancel "), _hoisted_9]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addnotepurple",
    onClick: $setup.updateNote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Save Changes "), _hoisted_10, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_11], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.editNoteID]]), $setup.modulePermission('Notes', 'Create') ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("button", {
    key: 0,
    id: "addnotepurple",
    onClick: $setup.addNote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Add note "), _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_13], 512 /* NEED_PATCH */)), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, !$setup.editNoteID]]) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.addNoteBox]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["TimeLineList"], {
    onEditPin: $setup.editNote,
    onDeletePin: $setup.deleteNote,
    iconTypes: $setup.type,
    paymentID: $setup.props.customerID,
    logs: $setup.paymentLogs(),
    logType: "customer"
  }, null, 8 /* PROPS */, ["paymentID", "logs"])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=template&id=5637d11a&scoped=true":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=template&id=5637d11a&scoped=true ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-5637d11a"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = {
  "class": "single-payment-head mb-0"
};
var _hoisted_3 = {
  "class": "row align-items-end"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Briefs")], -1 /* HOISTED */);
});
var _hoisted_5 = {
  "class": "col-md-6 text-right"
};
var _hoisted_6 = {
  "class": "row"
};
var _hoisted_7 = {
  "class": "col-12"
};
var _hoisted_8 = {
  key: 0,
  id: "scroll-horizontal",
  "class": "table nowrap align-middle productsTables",
  style: {
    "width": "100%"
  }
};
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px",
      "white-space": "pre"
    }
  }, "Business Name"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px"
    }
  }), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px",
      "white-space": "pre"
    }
  }, "Customer Name"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "min-width": "150px"
    }
  }, "Email"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "min-width": "10px"
    }
  }, "Created"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", {
    style: {
      "width": "10px"
    }
  })])], -1 /* HOISTED */);
});
var _hoisted_10 = ["onClick"];
var _hoisted_11 = ["onClick"];
var _hoisted_12 = ["onClick"];
var _hoisted_13 = ["onClick"];
var _hoisted_14 = ["onClick"];
var _hoisted_15 = {
  "class": "payment-actionListUl"
};
var _hoisted_16 = ["onClick"];
var _hoisted_17 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "mdi mdi-download"
  }, null, -1 /* HOISTED */);
});
var _hoisted_18 = [_hoisted_17];
var _hoisted_19 = {
  "class": "dropdown d-inline-block"
};
var _hoisted_20 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    "class": "btn btn-soft-secondary btn-sm dropdown",
    type: "button",
    "data-bs-toggle": "dropdown",
    "aria-expanded": "false"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-more-fill align-middle"
  })], -1 /* HOISTED */);
});
var _hoisted_21 = {
  "class": "dropdown-menu dropdown-menu-end drop-down-colors"
};
var _hoisted_22 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
    "class": "dropHead"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item"
  }, "Actions")], -1 /* HOISTED */);
});
var _hoisted_23 = ["onClick"];
var _hoisted_24 = {
  "class": "dropdown-item"
};
var _hoisted_25 = {
  key: 1,
  "class": "na mt-3"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_Link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
    href: _ctx.route('brief.link.add', {
      customer_id: parseInt($setup.props.customerID)
    }),
    "class": "payment-head-link"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Create")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href"])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [$setup.props.relatedBrief.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_8, [_hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.relatedBrief, function (brief, index) {
    var _brief$business_name;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: index
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitBriefDetail(brief === null || brief === void 0 ? void 0 : brief.id, brief === null || brief === void 0 ? void 0 : brief.brief_type);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_brief$business_name = brief.business_name) !== null && _brief$business_name !== void 0 ? _brief$business_name : 'Not Available'), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_10), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitBriefDetail(brief === null || brief === void 0 ? void 0 : brief.id, brief === null || brief === void 0 ? void 0 : brief.brief_type);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Badge"], {
      badgeClass: $setup.badgesData(brief.brief_type),
      badgeText: $setup.formatText(brief.brief_type)
    }, null, 8 /* PROPS */, ["badgeClass", "badgeText"])], 8 /* PROPS */, _hoisted_11), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitBriefDetail(brief === null || brief === void 0 ? void 0 : brief.id, brief === null || brief === void 0 ? void 0 : brief.brief_type);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.name), 9 /* TEXT, PROPS */, _hoisted_12), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitBriefDetail(brief === null || brief === void 0 ? void 0 : brief.id, brief === null || brief === void 0 ? void 0 : brief.brief_type);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.email), 9 /* TEXT, PROPS */, _hoisted_13), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
      onClick: function onClick($event) {
        return $setup.visitBriefDetail(brief === null || brief === void 0 ? void 0 : brief.id, brief === null || brief === void 0 ? void 0 : brief.brief_type);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(brief.created_at), 'dd MMM yy')), 9 /* TEXT, PROPS */, _hoisted_14), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function ($event) {
        return $setup.downloadBriefByType(brief === null || brief === void 0 ? void 0 : brief.encoded_id, brief === null || brief === void 0 ? void 0 : brief.name, brief.brief_type);
      }, ["stop"]),
      "class": "btn btn-soft-secondary btn-sm dropdown buttonWithSmallText",
      type: "button"
    }, [].concat(_hoisted_18), 8 /* PROPS */, _hoisted_16)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_19, [_hoisted_20, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_21, [_hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function ($event) {
        return $setup.downloadBriefByType(brief === null || brief === void 0 ? void 0 : brief.encoded_id, brief === null || brief === void 0 ? void 0 : brief.name, brief.brief_type);
      }, ["stop"]),
      "class": "dropdown-item"
    }, " Download ", 8 /* PROPS */, _hoisted_23)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", _hoisted_24, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Tooltip"], {
      onClickCapture: function onClickCapture($event) {
        return $setup.handleClick($event, brief === null || brief === void 0 ? void 0 : brief.id, brief.brief_type + '_brief');
      },
      tooltipText: "Brief Link",
      showText: "Copy Brief Link",
      showTextClass: "copy-payment-link-text",
      copyText: $setup.getCopyTextRoute(brief),
      showIcon: false
    }, null, 8 /* PROPS */, ["onClickCapture", "copyText"])])])])])])])])]);
  }), 128 /* KEYED_FRAGMENT */))])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_25, "No briefs"))])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=template&id=03caa1b1&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=template&id=03caa1b1&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-03caa1b1"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "timeline-ul"
};
var _hoisted_2 = {
  "class": "timeline-details"
};
var _hoisted_3 = ["onClick"];
var _hoisted_4 = {
  key: 0,
  "class": "bx bx-dots-horizontal-rounded"
};
var _hoisted_5 = ["onFocusout"];
var _hoisted_6 = ["onClick"];
var _hoisted_7 = ["onClick"];
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, "Unpin", -1 /* HOISTED */);
});
var _hoisted_9 = [_hoisted_8];
var _hoisted_10 = ["onClick"];
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, "Edit", -1 /* HOISTED */);
});
var _hoisted_12 = [_hoisted_11];
var _hoisted_13 = ["onClick"];
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "color-red"
  }, "Delete", -1 /* HOISTED */);
});
var _hoisted_15 = [_hoisted_14];
var _hoisted_16 = {
  key: 0,
  "class": "pinToTop"
};
var _hoisted_17 = {
  key: 1
};
var _hoisted_18 = {
  key: 2
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("ul", _hoisted_1, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.logs, function (log, i) {
    var _$setup$typeIcon;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      key: i
    }, [!(log.type == 'api.call' || log.type == 'payment.file.posted') && log.event != 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: 0
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["bg-white text-muted", log.pin ? 'bx bxs-pin' : (_$setup$typeIcon = $setup.typeIcon(log.type, log.activity)) !== null && _$setup$typeIcon !== void 0 ? _$setup$typeIcon : 'ri-bank-card-fill'])
    }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      "class": "threedots",
      onClick: function onClick($event) {
        return $setup.openOptionPanel(i);
      }
    }, [log.type == 'note' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_4)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 8 /* PROPS */, _hoisted_3), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
      "class": "threedotsclickopen",
      ref_for: true,
      ref: "itemRefs",
      onFocusout: function onFocusout($event) {
        return $setup.closeOptionPanel(i);
      }
    }, [log.pin == 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 0,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.togglePinNote(i, 1);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.pinToTopText), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_6)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), log.pin == 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 1,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.togglePinNote(i, 0);
      }
    }, [].concat(_hoisted_9), 8 /* PROPS */, _hoisted_7)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.modulePermission('Notes', 'Edit') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 2,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.editNote(i);
      }
    }, [].concat(_hoisted_12), 8 /* PROPS */, _hoisted_10)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.modulePermission('Notes', 'Delete') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 3,
      "class": "mb-0",
      onClick: function onClick($event) {
        return $setup.deleteNote(i);
      }
    }, [].concat(_hoisted_15), 8 /* PROPS */, _hoisted_13)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 40 /* PROPS, NEED_HYDRATION */, _hoisted_5), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, log.type == 'note']]), log.pin ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_16, "Pinned note")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), log.type != 'note' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalize(log === null || log === void 0 ? void 0 : log.activity)), 1 /* TEXT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalize(log === null || log === void 0 ? void 0 : log.activity)), 1 /* TEXT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(log.created_at), "PPpp")), 1 /* TEXT */)])], 64 /* STABLE_FRAGMENT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]);
  }), 128 /* KEYED_FRAGMENT */))]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=template&id=b8ed8cf0&scoped=true":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=template&id=b8ed8cf0&scoped=true ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$item$li, _$setup$props$item$li2, _$setup$props$item, _$setup$props$item2, _$setup$props$item3;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.visitPaymentDetail($setup.props.item.id);
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$item$li = $setup.props.item.link.currency_country) === null || _$setup$props$item$li === void 0 ? void 0 : _$setup$props$item$li.symbol) + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.item.price), 1 /* TEXT */)]), $setup.props.showCurrency ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", {
    key: 0,
    onClick: _cache[1] || (_cache[1] = function ($event) {
      return $setup.visitPaymentDetail($setup.props.item.id);
    })
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$item$li2 = $setup.props.item.link.currency_country) === null || _$setup$props$item$li2 === void 0 ? void 0 : _$setup$props$item$li2.code), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
    "class": "badgeColumn",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      return $setup.visitPaymentDetail($setup.props.item.id);
    }),
    onMouseenter: _cache[3] || (_cache[3] = function ($event) {
      return $setup.toggleBadgeMessage($event, true);
    }),
    onMouseleave: _cache[4] || (_cache[4] = function ($event) {
      return $setup.toggleBadgeMessage($event, false);
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(vue__WEBPACK_IMPORTED_MODULE_0__.Transition, {
    name: "fade",
    persisted: ""
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["message", {
          'first-message': $props.isFirst,
          'not-first-message': !$props.isFirst
        }])
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.badgeMessage), 3 /* TEXT, CLASS */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.showBadgeMessage]])];
    }),
    _: 1 /* STABLE */
  }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Badge"], {
    badgeClass: "badge badge-soft-".concat((_$setup$props$item = $setup.props.item) === null || _$setup$props$item === void 0 || (_$setup$props$item = _$setup$props$item.paymentStatus) === null || _$setup$props$item === void 0 || (_$setup$props$item = _$setup$props$item.style) === null || _$setup$props$item === void 0 ? void 0 : _$setup$props$item["class"]),
    badgeText: (_$setup$props$item2 = $setup.props.item) === null || _$setup$props$item2 === void 0 || (_$setup$props$item2 = _$setup$props$item2.paymentStatus) === null || _$setup$props$item2 === void 0 ? void 0 : _$setup$props$item2.text,
    iconClass: (_$setup$props$item3 = $setup.props.item) === null || _$setup$props$item3 === void 0 || (_$setup$props$item3 = _$setup$props$item3.paymentStatus) === null || _$setup$props$item3 === void 0 || (_$setup$props$item3 = _$setup$props$item3.style) === null || _$setup$props$item3 === void 0 ? void 0 : _$setup$props$item3.icon
  }, null, 8 /* PROPS */, ["badgeClass", "badgeText", "iconClass"])], 32 /* NEED_HYDRATION */)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=template&id=118e72b8":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=template&id=118e72b8 ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "popup-head"
};
var _hoisted_2 = {
  "class": "popup-body"
};
var _hoisted_3 = {
  "class": "popup-footer"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$maxWidt;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["popup-bg", "".concat($setup.props["class"], "bg ").concat($setup.visibilityClass)]),
    onClick: _cache[0] || (_cache[0] = function () {
      return $setup.onCloseFunction && $setup.onCloseFunction.apply($setup, arguments);
    })
  }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["popup-area", "".concat($setup.props["class"], " ").concat($setup.visibilityClass)]),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
      width: (_$setup$props$maxWidt = $setup.props.maxWidth) !== null && _$setup$props$maxWidt !== void 0 ? _$setup$props$maxWidt : '450px'
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.title), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "head")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "body")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "footer")])], 6 /* CLASS, STYLE */)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=template&id=ef55f284":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=template&id=ef55f284 ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "popup-details-area"
};
var _hoisted_2 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Account information", -1 /* HOISTED */);
var _hoisted_3 = {
  "class": "popup-details-input"
};
var _hoisted_4 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "First Name", -1 /* HOISTED */);
var _hoisted_5 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_6 = {
  "class": "popup-details-input"
};
var _hoisted_7 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Last Name", -1 /* HOISTED */);
var _hoisted_8 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_9 = {
  "class": "popup-details-input"
};
var _hoisted_10 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Account email", -1 /* HOISTED */);
var _hoisted_11 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_12 = {
  "class": "popup-details-input"
};
var _hoisted_13 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Company", -1 /* HOISTED */);
var _hoisted_14 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_15 = {
  "class": "popup-details-area"
};
var _hoisted_16 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "bx bx-chevron-down"
}, null, -1 /* HOISTED */);
var _hoisted_17 = {
  "class": "popup-details-input"
};
var _hoisted_18 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Phone Number ", -1 /* HOISTED */);
var _hoisted_19 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_20 = {
  "class": "popup-details-input"
};
var _hoisted_21 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Country", -1 /* HOISTED */);
var _hoisted_22 = ["disabled"];
var _hoisted_23 = ["value"];
var _hoisted_24 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_25 = {
  "class": "popup-details-input"
};
var _hoisted_26 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Address", -1 /* HOISTED */);
var _hoisted_27 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_28 = {
  "class": "popup-details-input"
};
var _hoisted_29 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "City", -1 /* HOISTED */);
var _hoisted_30 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_31 = {
  "class": "popup-details-input"
};
var _hoisted_32 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "State", -1 /* HOISTED */);
var _hoisted_33 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_34 = {
  "class": "popup-details-input"
};
var _hoisted_35 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Zipcode", -1 /* HOISTED */);
var _hoisted_36 = {
  key: 0,
  "class": "text-danger"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Popup"], {
    title: $setup.props.title,
    "class": "detailsPopupArea",
    visibility: $setup.props.popupVisibility,
    onClose: $setup.props.hidePopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      var _$setup$props$errors, _$setup$props$errors2, _$setup$props$errors3, _$setup$props$errors4, _$setup$props$errors5, _$setup$props$errors6, _$setup$props$errors7, _$setup$props$errors8, _$setup$props$errors9, _$setup$props$errors10, _$setup$props$errors11, _$setup$props$errors12, _$setup$props$errors13, _$setup$props$errors14, _$setup$props$errors15, _$setup$props$errors16, _$setup$props$errors17, _$setup$props$errors18, _$setup$props$errors19, _$setup$props$errors20, _$setup$props$errors21, _$setup$props$errors22, _$setup$props$errors23, _$setup$props$errors24, _$setup$props$errors25, _$setup$props$errors26, _$setup$props$errors27, _$setup$props$errors28, _$setup$props$errors29, _$setup$props$errors30;
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "First Name",
        name: "first_name",
        "onUpdate:modelValue": _cache[0] || (_cache[0] = function ($event) {
          return $setup.formData.first_name = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.first_name]]), (_$setup$props$errors = $setup.props.errors) !== null && _$setup$props$errors !== void 0 && _$setup$props$errors.first_name && ((_$setup$props$errors2 = $setup.props.errors) === null || _$setup$props$errors2 === void 0 ? void 0 : _$setup$props$errors2.first_name.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors3 = $setup.props.errors) === null || _$setup$props$errors3 === void 0 ? void 0 : _$setup$props$errors3.first_name[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [_hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "Last Name",
        name: "last_name",
        "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
          return $setup.formData.last_name = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.last_name]]), (_$setup$props$errors4 = $setup.props.errors) !== null && _$setup$props$errors4 !== void 0 && _$setup$props$errors4.last_name && ((_$setup$props$errors5 = $setup.props.errors) === null || _$setup$props$errors5 === void 0 ? void 0 : _$setup$props$errors5.last_name.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_8, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors6 = $setup.props.errors) === null || _$setup$props$errors6 === void 0 ? void 0 : _$setup$props$errors6.last_name[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [_hoisted_10, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "Account email",
        "onUpdate:modelValue": _cache[2] || (_cache[2] = function ($event) {
          return $setup.formData.email = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.email]]), (_$setup$props$errors7 = $setup.props.errors) !== null && _$setup$props$errors7 !== void 0 && _$setup$props$errors7.email && ((_$setup$props$errors8 = $setup.props.errors) === null || _$setup$props$errors8 === void 0 ? void 0 : _$setup$props$errors8.email.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors9 = $setup.props.errors) === null || _$setup$props$errors9 === void 0 ? void 0 : _$setup$props$errors9.email[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [_hoisted_13, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "Company",
        "onUpdate:modelValue": _cache[3] || (_cache[3] = function ($event) {
          return $setup.formData.company = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.company]]), (_$setup$props$errors10 = $setup.props.errors) !== null && _$setup$props$errors10 !== void 0 && _$setup$props$errors10.company && ((_$setup$props$errors11 = $setup.props.errors) === null || _$setup$props$errors11 === void 0 ? void 0 : _$setup$props$errors11.company.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors12 = $setup.props.errors) === null || _$setup$props$errors12 === void 0 ? void 0 : _$setup$props$errors12.company[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", {
        onClick: _cache[4] || (_cache[4] = function () {
          return _ctx.toggleBillingInfo && _ctx.toggleBillingInfo.apply(_ctx, arguments);
        })
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Billing information "), _hoisted_16]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"popup-details-input\">\r\n              <label>Billing email</label>\r\n              <label class=\"checkbox-label\" @click=\"togglePopupArea\">\r\n                <input type=\"checkbox\" checked/>\r\n                <span>Same as account email</span>\r\n              </label>\r\n              <div class=\"popupToggleArea\">\r\n                <input type=\"email\" placeholder=\"billing@example.com\"/>\r\n              </div>\r\n          </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_17, [_hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["VueTelInput"], {
        modelValue: $setup.formData.phone,
        "onUpdate:modelValue": _cache[5] || (_cache[5] = function ($event) {
          return $setup.formData.phone = $event;
        }),
        defaultCountry: "US",
        onCountryChanged: $setup.activeCountry,
        mode: "international",
        placeholder: "12 123 45 67"
      }, null, 8 /* PROPS */, ["modelValue"]), (_$setup$props$errors13 = $setup.props.errors) !== null && _$setup$props$errors13 !== void 0 && _$setup$props$errors13.phone && ((_$setup$props$errors14 = $setup.props.errors) === null || _$setup$props$errors14 === void 0 ? void 0 : _$setup$props$errors14.phone.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_19, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors15 = $setup.props.errors) === null || _$setup$props$errors15 === void 0 ? void 0 : _$setup$props$errors15.phone[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_20, [_hoisted_21, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("select", {
        "onUpdate:modelValue": _cache[6] || (_cache[6] = function ($event) {
          return $setup.formData.country = $event;
        })
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("option", {
        value: "0",
        disabled: $setup.props.isUpdate
      }, " Choose a country... ", 8 /* PROPS */, _hoisted_22), ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.countries, function (country) {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("option", {
          value: country.country
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(country.country), 9 /* TEXT, PROPS */, _hoisted_23);
      }), 256 /* UNKEYED_FRAGMENT */))], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelSelect, $setup.formData.country]]), (_$setup$props$errors16 = $setup.props.errors) !== null && _$setup$props$errors16 !== void 0 && _$setup$props$errors16.country && ((_$setup$props$errors17 = $setup.props.errors) === null || _$setup$props$errors17 === void 0 ? void 0 : _$setup$props$errors17.country.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_24, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors18 = $setup.props.errors) === null || _$setup$props$errors18 === void 0 ? void 0 : _$setup$props$errors18.country[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_25, [_hoisted_26, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "Address",
        "onUpdate:modelValue": _cache[7] || (_cache[7] = function ($event) {
          return $setup.formData.address = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.address]]), (_$setup$props$errors19 = $setup.props.errors) !== null && _$setup$props$errors19 !== void 0 && _$setup$props$errors19.address && ((_$setup$props$errors20 = $setup.props.errors) === null || _$setup$props$errors20 === void 0 ? void 0 : _$setup$props$errors20.address.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_27, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors21 = $setup.props.errors) === null || _$setup$props$errors21 === void 0 ? void 0 : _$setup$props$errors21.address[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_28, [_hoisted_29, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "City",
        "onUpdate:modelValue": _cache[8] || (_cache[8] = function ($event) {
          return $setup.formData.city = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.city]]), (_$setup$props$errors22 = $setup.props.errors) !== null && _$setup$props$errors22 !== void 0 && _$setup$props$errors22.city && ((_$setup$props$errors23 = $setup.props.errors) === null || _$setup$props$errors23 === void 0 ? void 0 : _$setup$props$errors23.city.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_30, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors24 = $setup.props.errors) === null || _$setup$props$errors24 === void 0 ? void 0 : _$setup$props$errors24.city[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_31, [_hoisted_32, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "State",
        "onUpdate:modelValue": _cache[9] || (_cache[9] = function ($event) {
          return $setup.formData.state = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.state]]), (_$setup$props$errors25 = $setup.props.errors) !== null && _$setup$props$errors25 !== void 0 && _$setup$props$errors25.state && ((_$setup$props$errors26 = $setup.props.errors) === null || _$setup$props$errors26 === void 0 ? void 0 : _$setup$props$errors26.state.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_33, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors27 = $setup.props.errors) === null || _$setup$props$errors27 === void 0 ? void 0 : _$setup$props$errors27.state[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_34, [_hoisted_35, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        placeholder: "Zipcode",
        "onUpdate:modelValue": _cache[10] || (_cache[10] = function ($event) {
          return $setup.formData.zipcode = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.zipcode]]), (_$setup$props$errors28 = $setup.props.errors) !== null && _$setup$props$errors28 !== void 0 && _$setup$props$errors28.zipcode && ((_$setup$props$errors29 = $setup.props.errors) === null || _$setup$props$errors29 === void 0 ? void 0 : _$setup$props$errors29.zipcode.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_36, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors30 = $setup.props.errors) === null || _$setup$props$errors30 === void 0 ? void 0 : _$setup$props$errors30.zipcode[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"popup-details-input\">\r\n              <label>Time zone</label>\r\n              <select>\r\n                <option>Choose a time zone...</option>\r\n              </select>\r\n          </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"popup-details-input\">\r\n              <label>Language</label>\r\n              <select>\r\n                <option>Language</option>\r\n              </select>\r\n          </div>\r\n          <div class=\"popup-details-input\">\r\n              <label>Currency</label>\r\n              <select disabled>\r\n                <option>USD - US Dollar</option>\r\n              </select>\r\n          </div>\r\n          <div class=\"popup-details-input\">\r\n              <label>Invoice prefix</label>\r\n              <input value=\"7266F9DB\" type=\"text\"/>\r\n          </div>\r\n          <div class=\"popup-details-input\">\r\n              <label>Next invoice sequence</label>\r\n              <input value=\"1\" type=\"text\"/>\r\n          </div>")])];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[11] || (_cache[11] = function () {
          var _$setup$props;
          return $setup.props.hidePopup && (_$setup$props = $setup.props).hidePopup.apply(_$setup$props, arguments);
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: _cache[12] || (_cache[12] = function ($event) {
          return $setup.submit();
        })
      }, [$setup.props.isUpdate ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 0
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Update")], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 1
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Add")], 64 /* STABLE_FRAGMENT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(" ") + " customer ")])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=template&id=e27c74de&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=template&id=e27c74de&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-e27c74de"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "popup-details-area text-muted"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Popup"], {
    title: "Delete ".concat($setup.props.title),
    "class": "",
    visibility: $setup.props.deleteVisibility,
    onClose: $setup.props.hideDeletePopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.message), 1 /* TEXT */)];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[0] || (_cache[0] = function () {
          var _$setup$props;
          return $setup.props.hideDeletePopup && (_$setup$props = $setup.props).hideDeletePopup.apply(_$setup$props, arguments);
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "redLinkStyle",
        onClick: _cache[1] || (_cache[1] = function () {
          var _$setup$props2;
          return $setup.props.onDeleteSubmit && (_$setup$props2 = $setup.props).onDeleteSubmit.apply(_$setup$props2, arguments);
        })
      }, " Delete " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.title), 1 /* TEXT */)];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=template&id=5272debe&scoped=true":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=template&id=5272debe&scoped=true ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-5272debe"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "popup-details-area"
};
var _hoisted_2 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "popup-details-area text-muted"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, "For your security, please confirm your password.")], -1 /* HOISTED */);
});
var _hoisted_3 = {
  "class": "popup-details-input"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Password ", -1 /* HOISTED */);
});
var _hoisted_5 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_6 = ["disabled"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Popup"], {
    title: $setup.props.title,
    "class": "detailsPopupArea",
    visibility: $setup.props.popupVisibility,
    onClose: $setup.props.hidePopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      var _$setup$props$errors, _$setup$props$errors2, _$setup$props$errors3;
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "password",
        placeholder: "Password",
        name: "password",
        "onUpdate:modelValue": _cache[0] || (_cache[0] = function ($event) {
          return $setup.formData.password = $event;
        }),
        autocomplete: "new-password",
        onFocus: $setup.disableAutocomplete
      }, null, 544 /* NEED_HYDRATION, NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.password]]), (_$setup$props$errors = $setup.props.errors) !== null && _$setup$props$errors !== void 0 && _$setup$props$errors.password && ((_$setup$props$errors2 = $setup.props.errors) === null || _$setup$props$errors2 === void 0 ? void 0 : _$setup$props$errors2.password.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors3 = $setup.props.errors) === null || _$setup$props$errors3 === void 0 ? void 0 : _$setup$props$errors3.password[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[1] || (_cache[1] = function () {
          var _$setup$props;
          return $setup.props.hidePopup && (_$setup$props = $setup.props).hidePopup.apply(_$setup$props, arguments);
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: _cache[2] || (_cache[2] = function ($event) {
          return $setup.submit();
        }),
        disabled: $setup.isDisabled
      }, " Continue ", 8 /* PROPS */, _hoisted_6)];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=template&id=c6b47b60&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=template&id=c6b47b60&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-c6b47b60"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "col-12"
};
var _hoisted_3 = {
  "class": "page-title-box d-sm-flex align-items-center justify-content-between"
};
var _hoisted_4 = {
  "class": "mb-sm-0"
};
var _hoisted_5 = {
  "class": "page-title-right"
};
var _hoisted_6 = {
  "class": "breadcrumb m-0"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props, _$setup$props2;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", _hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.heading), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ol", _hoisted_6, [typeof $setup.props.breadcrumb === 'string' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Tooltip"], {
    key: 0,
    "copy-text": (_$setup$props2 = $setup.props) === null || _$setup$props2 === void 0 ? void 0 : _$setup$props2.breadcrumb
  }, null, 8 /* PROPS */, ["copy-text"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.breadcrumb, function (item, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      "class": "breadcrumb-item active",
      key: i
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(item), 1 /* TEXT */);
  }), 128 /* KEYED_FRAGMENT */))])])])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=template&id=5c57ca7b&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=template&id=5c57ca7b&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-5c57ca7b"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "copycardArea"
};
var _hoisted_2 = ["onClick"];
var _hoisted_3 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copy ID", -1 /* HOISTED */);
});
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "ctrl", -1 /* HOISTED */);
});
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "+", -1 /* HOISTED */);
});
var _hoisted_6 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "i", -1 /* HOISTED */);
});
var _hoisted_7 = {
  key: 1
};
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-check-line"
  })], -1 /* HOISTED */);
});
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copied", -1 /* HOISTED */);
});
var _hoisted_10 = ["innerHTML"];
var _hoisted_11 = {
  key: 0,
  "class": "ri-clipboard-line"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)($setup.textToCopy, ["stop"]),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.showButtonStyle),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.props.showButtonClass),
    onMouseleave: $setup.textToCopyRevert
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["customTooltip", $setup.getDirectionClass($setup.direction)])
  }, [!$setup.copiedRef ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [!$setup.defaultText ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [_hoisted_3, _hoisted_4, _hoisted_5, _hoisted_6], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.defaultText), 1 /* TEXT */))], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, [_hoisted_8, _hoisted_9], 64 /* STABLE_FRAGMENT */))], 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.showTextStyle),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.props.showTextClass),
    innerHTML: $setup.props.showText || $setup.props.copyText
  }, null, 14 /* CLASS, STYLE, PROPS */, _hoisted_10), $setup.props.showIcon ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", _hoisted_11)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 46 /* CLASS, STYLE, PROPS, NEED_HYDRATION */, _hoisted_2)]);
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js":
/*!********************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDownload: () => (/* binding */ useDownload)
/* harmony export */ });
/* harmony import */ var _downloadFile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../downloadFile */ "./resources/js/Pages/Admin/Brief/Shared/Composables/downloadFile.js");
/* harmony import */ var _useNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../useNotification */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js");


function useDownload() {
  var _useNotification = (0,_useNotification__WEBPACK_IMPORTED_MODULE_1__.useNotification)(),
    notifySuccess = _useNotification.success,
    notifyError = _useNotification.error;
  var download = function download(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadWebBrief = function downloadWebBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("web.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadVideoBrief = function downloadVideoBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("video.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadSmmBrief = function downloadSmmBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("smm.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadAppBrief = function downloadAppBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("app.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadSemBrief = function downloadSemBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("sem.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  return {
    download: download,
    downloadWebBrief: downloadWebBrief,
    downloadVideoBrief: downloadVideoBrief,
    downloadSmmBrief: downloadSmmBrief,
    downloadAppBrief: downloadAppBrief,
    downloadSemBrief: downloadSemBrief
  };
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/downloadFile.js":
/*!***************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/downloadFile.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   downloadFile: () => (/* binding */ downloadFile)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var downloadFile = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(route, fileName) {
    var response, url, link;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return axios__WEBPACK_IMPORTED_MODULE_0___default().get(route, {
            responseType: "blob"
          });
        case 3:
          response = _context.sent;
          url = window.URL.createObjectURL(new Blob([response.data]));
          link = document.createElement("a");
          link.href = url;
          link.setAttribute("download", fileName + ".pdf");
          document.body.appendChild(link);
          link.click();
          return _context.abrupt("return", {
            fileName: fileName + ".pdf",
            success: true
          });
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.error("Error downloading PDF:", _context.t0);
          _context.t0.fileName = fileName + ".pdf";
          throw _context.t0;
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function downloadFile(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js":
/*!*****************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFingerprint: () => (/* binding */ useFingerprint)
/* harmony export */ });
/* harmony import */ var _fingerprintjs_fingerprintjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @fingerprintjs/fingerprintjs */ "./node_modules/@fingerprintjs/fingerprintjs/dist/fp.esm.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function useFingerprint() {
  return _useFingerprint.apply(this, arguments);
}
function _useFingerprint() {
  _useFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    var fpPromise, fp, result, visitorId;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          // Initialize FingerprintJS
          fpPromise = _fingerprintjs_fingerprintjs__WEBPACK_IMPORTED_MODULE_0__["default"].load(); // Generate the fingerprint
          _context.next = 3;
          return fpPromise;
        case 3:
          fp = _context.sent;
          _context.next = 6;
          return fp.get();
        case 6:
          result = _context.sent;
          // The visitor identifier
          visitorId = result.visitorId; // Return the visitor ID
          return _context.abrupt("return", visitorId);
        case 9:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _useFingerprint.apply(this, arguments);
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js":
/*!******************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useNotification: () => (/* binding */ useNotification)
/* harmony export */ });
/* harmony import */ var _css_toast_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../css/toast.css */ "./resources/css/toast.css");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var vue3_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue3-toastify */ "./node_modules/vue3-toastify/dist/index.mjs");



function useNotification() {
  var setting = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var isEmptyConfig = Object.keys(setting).length === 0;
  if (isEmptyConfig) {
    setting = {
      autoClose: 3000,
      theme: "dark",
      type: "success",
      position: "bottom-center"
    };
  }
  function success(message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(message, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function error(message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(message, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function warning(message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.warning(message, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function custom(message, btnText, callback) {
    var toastId = vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.loading({
      render: function render() {
        return (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('div', {
          style: {
            display: 'flex',
            width: '100%',
            justifyContent: 'space-between',
            alignItems: 'center'
          }
        }, [(0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('p', {
          style: {
            marginBottom: '0px'
          }
        }, message), (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('span', {
          style: {
            borderLeft: '1px solid gray',
            height: '4rem',
            margin: '-1rem 0rem',
            paddingLeft: '0.5rem',
            placeContent: 'center'
          }
        }, {
          onClick: function onClick(event) {
            event.stopPropagation();
            //emit('performUndo', true);
            vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.remove(toastId);
            callback();
          }
        }, btnText)]);
      }
    }, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose,
      closeButton: false
    });
    return {
      toastId: toastId
    };
  }
  function update(toastID, message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.update(toastID, {
      message: message,
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function remove(toastID) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.remove(toastID);
  }
  return {
    success: success,
    error: error,
    warning: warning,
    custom: custom,
    update: update,
    remove: remove
  };
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Shared/Composables/Invoice/useDownload.js":
/*!****************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Shared/Composables/Invoice/useDownload.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDownload: () => (/* binding */ useDownload)
/* harmony export */ });
/* harmony import */ var _downloadFile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../downloadFile */ "./resources/js/Pages/Admin/Shared/Composables/downloadFile.js");
/* harmony import */ var _useNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../useNotification */ "./resources/js/Pages/Admin/Shared/Composables/useNotification.js");


function useDownload() {
  var _useNotification = (0,_useNotification__WEBPACK_IMPORTED_MODULE_1__.useNotification)(),
    notifySuccess = _useNotification.success,
    notifyError = _useNotification.error;
  var download = function download(paymentID, invoice_no) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("admin.invoice.download", {
      id: paymentID
    }), invoice_no).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadPublicInvoice = function downloadPublicInvoice(paymentID, invoice_no) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("public.invoice.download", {
      id: paymentID
    }), invoice_no).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  return {
    download: download,
    downloadPublicInvoice: downloadPublicInvoice
  };
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Shared/Composables/downloadFile.js":
/*!*********************************************************************!*\
  !*** ./resources/js/Pages/Admin/Shared/Composables/downloadFile.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   downloadFile: () => (/* binding */ downloadFile)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var downloadFile = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(route, fileName) {
    var response, url, link;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return axios__WEBPACK_IMPORTED_MODULE_0___default().get(route, {
            responseType: "blob"
          });
        case 3:
          response = _context.sent;
          url = window.URL.createObjectURL(new Blob([response.data]));
          link = document.createElement("a");
          link.href = url;
          link.setAttribute("download", fileName + ".pdf");
          document.body.appendChild(link);
          link.click();
          return _context.abrupt("return", {
            fileName: fileName + ".pdf",
            success: true
          });
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.error("Error downloading PDF:", _context.t0);
          _context.t0.fileName = fileName + ".pdf";
          throw _context.t0;
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function downloadFile(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

/***/ }),

/***/ "./resources/js/Pages/Admin/Shared/Composables/enums.js":
/*!**************************************************************!*\
  !*** ./resources/js/Pages/Admin/Shared/Composables/enums.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   invoiceStatus: () => (/* binding */ invoiceStatus)
/* harmony export */ });
var invoiceStatus = function () {
  var statuses = [{
    id: 1,
    name: 'Paid',
    style: {
      className: 'badge badge-soft-success'
    }
  }, {
    id: 2,
    name: 'Draft',
    style: {
      className: 'badge badge-soft-default'
    }
  }];
  return {
    get: function get(status) {
      return statuses.find(function (item) {
        return item.id === status;
      });
    }
  };
}();

/***/ }),

/***/ "./resources/js/Pages/Admin/Shared/Composables/payments.js":
/*!*****************************************************************!*\
  !*** ./resources/js/Pages/Admin/Shared/Composables/payments.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cardBrands: () => (/* binding */ cardBrands),
/* harmony export */   linkStatus: () => (/* binding */ linkStatus),
/* harmony export */   statuses: () => (/* binding */ statuses)
/* harmony export */ });
var statuses = [{
  id: 6,
  name: 'blocked',
  text: 'Blocked',
  style: {
    icon: 'mdi mdi-block-helper',
    "class": 'danger'
  }
}, {
  id: 5,
  name: 'canceled',
  text: 'Canceled',
  style: {
    icon: 'bx bx-x-circle',
    "class": 'danger'
  }
},
/*   {
    id: 7,
    name: 'disputed',
    text: 'Disputed',
    style: {
      icon: 'mdi mdi-block-helper',
      class: 'danger'
    },
  },  */
{
  id: 8,
  name: 'early_fraud_warning',
  text: 'Early Fraud Warning',
  style: {
    icon: 'ri ri-error-warning-line',
    "class": 'danger'
  }
}, {
  id: 2,
  name: 'failed',
  text: 'Failed',
  style: {
    icon: 'bx bx-x-circle',
    "class": 'danger'
  }
}, {
  id: 4,
  name: 'processing',
  text: 'Processing',
  style: {
    icon: 'mdi mdi-clock-outline',
    "class": 'default'
  }
}, {
  id: 3,
  name: 'incomplete',
  text: 'Incomplete',
  style: {
    icon: 'mdi mdi-clock-outline',
    "class": 'default'
  }
}, {
  id: 9,
  name: 'partially_refunded',
  text: 'Partially Refunded',
  style: {
    icon: 'mdi mdi-arrow-u-left-top',
    "class": 'default'
  }
},
/* {
  id: 9,
  name: 'pending',
  text: 'Pending',
  style: {
    icon: 'mdi mdi-block-helper',
    class: 'danger'
  },
}, */
{
  id: 10,
  name: 'refund_pending',
  text: 'Refund Pending',
  style: {
    icon: 'mdi mdi-arrow-u-left-top',
    "class": 'default'
  }
}, {
  id: 11,
  name: 'refunded',
  text: 'Refunded',
  style: {
    icon: 'mdi mdi-arrow-u-left-top',
    "class": 'default'
  }
}, {
  id: 1,
  name: 'succeeded',
  text: 'Succeeded',
  style: {
    icon: 'ri ri-check-line',
    "class": 'success'
  }
}, {
  id: 12,
  name: 'uncaptured',
  text: 'Uncaptured',
  style: {
    icon: 'mdi mdi-arrow-u-left-top',
    "class": 'default'
  }
},
/* {
  id: 13,
  name: 'waiting_on_funding',
  text: 'Waiting On Funding',
  style: {
    icon: 'mdi mdi-arrow-u-left-top',
    class: 'default'
  },
}, */
{
  id: 14,
  name: 'already_refunded',
  text: 'Already Refunded',
  style: {
    icon: 'mdi mdi-arrow-u-left-top',
    "class": 'default'
  }
}, {
  id: 15,
  name: 'manual',
  text: 'Manual',
  style: {
    icon: 'ri ri-check-line',
    "class": 'success'
  }
}];
var cardBrands = [{
  id: 1,
  label: "American Express",
  value: "american_express"
}, {
  id: 2,
  label: "Diners Club",
  value: "diners_club"
}, {
  id: 3,
  label: "Discover",
  value: "discover"
}, {
  id: 4,
  label: "Eftpos Australia",
  value: "eftpos_australia"
}, {
  id: 5,
  label: "JCB",
  value: "jcb"
}, {
  id: 6,
  label: "MasterCard",
  value: "mastercard"
}, {
  id: 7,
  label: "UnionPay",
  value: "unionpay"
}, {
  id: 8,
  label: "Visa",
  value: "visa"
}, {
  id: 9,
  label: "BCcard",
  value: "bccard"
}, {
  id: 10,
  label: "DinaCard",
  value: "dinacard"
}, {
  id: 11,
  label: "Cartes Bancaires",
  value: "cartes_bancaires"
}];
var linkStatus = [{
  id: 1,
  name: 'active',
  text: 'Active',
  style: {
    icon: 'ri-loader-2-fill',
    "class": 'primary'
  }
}, {
  id: 2,
  name: 'succeeded',
  text: 'Succeeded',
  style: {
    icon: 'ri-check-line',
    "class": 'success'
  }
}, {
  id: 3,
  name: 'failed',
  text: 'Failed',
  style: {
    icon: 'bx bx-x-circle',
    "class": 'danger'
  }
}, {
  id: 4,
  name: 'processing',
  text: 'Processing',
  style: {
    icon: 'ri-loader-2-fill',
    "class": 'info'
  }
}, {
  id: 5,
  name: 'deactivated',
  text: 'Deactivated',
  style: {
    icon: 'bx bx-block',
    "class": 'danger'
  }
}, {
  id: 6,
  name: 'expired',
  text: 'Expired',
  style: {
    icon: 'bx bx-block',
    "class": 'danger'
  }
}];

/***/ }),

/***/ "./resources/js/Pages/Admin/Shared/Composables/useRefundNotification.js":
/*!******************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Shared/Composables/useRefundNotification.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useRefundNotification: () => (/* binding */ useRefundNotification)
/* harmony export */ });
/* harmony import */ var _css_toast_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css/toast.css */ "./resources/css/toast.css");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var vue3_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue3-toastify */ "./node_modules/vue3-toastify/dist/index.mjs");



function useRefundNotification() {
  var setting = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var isEmptyConfig = Object.keys(setting).length === 0;
  if (isEmptyConfig) {
    setting = {
      autoClose: 3000,
      theme: "dark",
      type: "success",
      position: "bottom-center"
    };
  }
  function renderToast(message, btnText, callback, successCount, failCount, cancelCount) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('div', {
      style: {
        display: 'flex',
        width: '100%',
        justifyContent: 'space-between',
        alignItems: 'center'
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('div', [(0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('p', {
      style: {
        marginBottom: '0px'
      }
    }, message), (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('small', {
      style: {
        marginBottom: '0px',
        fontWeight: '500',
        color: '#bababa'
      }
    }, "".concat(successCount, " successful, ").concat(failCount, " failed, ").concat(cancelCount, " Cancelled"))]), (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('span', {
      style: {
        borderLeft: '1px solid gray',
        height: '4rem',
        margin: '-1rem 0rem',
        paddingLeft: '0.5rem',
        placeContent: 'center'
      },
      onClick: function onClick(event) {
        event.stopPropagation();
        callback();
      }
    }, btnText)]);
  }
  function showToast(type, message, btnText, callback, successCount, failCount, cancelCount) {
    var options = {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose,
      closeButton: false,
      type: type
    };
    console.log(options);
    var toastId = (0,vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast)({
      render: function render() {
        return renderToast(message, btnText, callback, successCount, failCount, cancelCount);
      }
    }, options);
    return toastId;
  }
  function loading(message, btnText, callback, successCount, failCount, cancelCount) {
    var options = {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose,
      closeButton: false
    };
    var toastId = vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.loading({
      render: function render() {
        return renderToast(message, btnText, callback, successCount, failCount, cancelCount);
      }
    }, options);
    return toastId;
  }
  function update(toastId, type, message, btnText, callback, successCount, failCount, cancelCount) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.update(toastId, {
      render: function render() {
        return renderToast(message, btnText, callback, successCount, failCount, cancelCount);
      },
      type: 'loading',
      autoClose: setting.autoClose,
      closeButton: false,
      position: setting.position,
      theme: setting.theme
    });
  }
  function success(message, btnText, callback, successCount, failCount, cancelCount) {
    var options = {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose,
      closeButton: false
    };
    var toastId = vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success({
      render: function render() {
        return renderToast(message, btnText, callback, successCount, failCount, cancelCount);
      }
    }, options);
    return toastId;
  }
  function remove(toastID) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.remove(toastID);
  }
  function initialMessage(message, btnText, callback) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('div', {
      style: {
        display: 'flex',
        width: '100%',
        justifyContent: 'space-between',
        alignItems: 'center'
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('p', {
      style: {
        marginBottom: '0px'
      }
    }, message), (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('span', {
      style: {
        borderLeft: '1px solid gray',
        height: '4rem',
        margin: '-1rem 0rem',
        paddingLeft: '0.5rem',
        display: 'flex',
        // Added display property
        alignItems: 'center' // Added alignItems property
      },
      onClick: function onClick(event) {
        event.stopPropagation();
        callback();
      }
    }, btnText) // Moved btnText as a child of the span element
    ]);
  }
  function custom(message, btnText, callback) {
    var toastId = vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.loading({
      render: function render() {
        return initialMessage(message, btnText, callback);
      }
    }, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose,
      closeButton: false,
      type: vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.TYPE.DEFAULT
    });
    return toastId;
  }
  return {
    loading: loading,
    success: success,
    remove: remove,
    update: update,
    showToast: showToast,
    custom: custom
  };
}

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-tel-input/dist/vue-tel-input.css":
/*!*******************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-tel-input/dist/vue-tel-input.css ***!
  \*******************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".vti__flag{width:20px}.vti__flag.be{width:18px}.vti__flag.ch{width:15px}.vti__flag.mc{width:19px}.vti__flag.ne{width:18px}.vti__flag.np{width:13px}.vti__flag.va{width:15px}@media only screen and (-webkit-min-device-pixel-ratio: 2),only screen and (min-device-pixel-ratio: 2),only screen and (min-resolution: 192dpi),only screen and (min-resolution: 2dppx){.vti__flag{background-size:5630px 15px}}.vti__flag.ac{height:10px;background-position:0px 0px}.vti__flag.ad{height:14px;background-position:-22px 0px}.vti__flag.ae{height:10px;background-position:-44px 0px}.vti__flag.af{height:14px;background-position:-66px 0px}.vti__flag.ag{height:14px;background-position:-88px 0px}.vti__flag.ai{height:10px;background-position:-110px 0px}.vti__flag.al{height:15px;background-position:-132px 0px}.vti__flag.am{height:10px;background-position:-154px 0px}.vti__flag.ao{height:14px;background-position:-176px 0px}.vti__flag.aq{height:14px;background-position:-198px 0px}.vti__flag.ar{height:13px;background-position:-220px 0px}.vti__flag.as{height:10px;background-position:-242px 0px}.vti__flag.at{height:14px;background-position:-264px 0px}.vti__flag.au{height:10px;background-position:-286px 0px}.vti__flag.aw{height:14px;background-position:-308px 0px}.vti__flag.ax{height:13px;background-position:-330px 0px}.vti__flag.az{height:10px;background-position:-352px 0px}.vti__flag.ba{height:10px;background-position:-374px 0px}.vti__flag.bb{height:14px;background-position:-396px 0px}.vti__flag.bd{height:12px;background-position:-418px 0px}.vti__flag.be{height:15px;background-position:-440px 0px}.vti__flag.bf{height:14px;background-position:-460px 0px}.vti__flag.bg{height:12px;background-position:-482px 0px}.vti__flag.bh{height:12px;background-position:-504px 0px}.vti__flag.bi{height:12px;background-position:-526px 0px}.vti__flag.bj{height:14px;background-position:-548px 0px}.vti__flag.bl{height:14px;background-position:-570px 0px}.vti__flag.bm{height:10px;background-position:-592px 0px}.vti__flag.bn{height:10px;background-position:-614px 0px}.vti__flag.bo{height:14px;background-position:-636px 0px}.vti__flag.bq{height:14px;background-position:-658px 0px}.vti__flag.br{height:14px;background-position:-680px 0px}.vti__flag.bs{height:10px;background-position:-702px 0px}.vti__flag.bt{height:14px;background-position:-724px 0px}.vti__flag.bv{height:15px;background-position:-746px 0px}.vti__flag.bw{height:14px;background-position:-768px 0px}.vti__flag.by{height:10px;background-position:-790px 0px}.vti__flag.bz{height:14px;background-position:-812px 0px}.vti__flag.ca{height:10px;background-position:-834px 0px}.vti__flag.cc{height:10px;background-position:-856px 0px}.vti__flag.cd{height:15px;background-position:-878px 0px}.vti__flag.cf{height:14px;background-position:-900px 0px}.vti__flag.cg{height:14px;background-position:-922px 0px}.vti__flag.ch{height:15px;background-position:-944px 0px}.vti__flag.ci{height:14px;background-position:-961px 0px}.vti__flag.ck{height:10px;background-position:-983px 0px}.vti__flag.cl{height:14px;background-position:-1005px 0px}.vti__flag.cm{height:14px;background-position:-1027px 0px}.vti__flag.cn{height:14px;background-position:-1049px 0px}.vti__flag.co{height:14px;background-position:-1071px 0px}.vti__flag.cp{height:14px;background-position:-1093px 0px}.vti__flag.cr{height:12px;background-position:-1115px 0px}.vti__flag.cu{height:10px;background-position:-1137px 0px}.vti__flag.cv{height:12px;background-position:-1159px 0px}.vti__flag.cw{height:14px;background-position:-1181px 0px}.vti__flag.cx{height:10px;background-position:-1203px 0px}.vti__flag.cy{height:14px;background-position:-1225px 0px}.vti__flag.cz{height:14px;background-position:-1247px 0px}.vti__flag.de{height:12px;background-position:-1269px 0px}.vti__flag.dg{height:10px;background-position:-1291px 0px}.vti__flag.dj{height:14px;background-position:-1313px 0px}.vti__flag.dk{height:15px;background-position:-1335px 0px}.vti__flag.dm{height:10px;background-position:-1357px 0px}.vti__flag.do{height:13px;background-position:-1379px 0px}.vti__flag.dz{height:14px;background-position:-1401px 0px}.vti__flag.ea{height:14px;background-position:-1423px 0px}.vti__flag.ec{height:14px;background-position:-1445px 0px}.vti__flag.ee{height:13px;background-position:-1467px 0px}.vti__flag.eg{height:14px;background-position:-1489px 0px}.vti__flag.eh{height:10px;background-position:-1511px 0px}.vti__flag.er{height:10px;background-position:-1533px 0px}.vti__flag.es{height:14px;background-position:-1555px 0px}.vti__flag.et{height:10px;background-position:-1577px 0px}.vti__flag.eu{height:14px;background-position:-1599px 0px}.vti__flag.fi{height:12px;background-position:-1621px 0px}.vti__flag.fj{height:10px;background-position:-1643px 0px}.vti__flag.fk{height:10px;background-position:-1665px 0px}.vti__flag.fm{height:11px;background-position:-1687px 0px}.vti__flag.fo{height:15px;background-position:-1709px 0px}.vti__flag.fr{height:14px;background-position:-1731px 0px}.vti__flag.ga{height:15px;background-position:-1753px 0px}.vti__flag.gb{height:10px;background-position:-1775px 0px}.vti__flag.gd{height:12px;background-position:-1797px 0px}.vti__flag.ge{height:14px;background-position:-1819px 0px}.vti__flag.gf{height:14px;background-position:-1841px 0px}.vti__flag.gg{height:14px;background-position:-1863px 0px}.vti__flag.gh{height:14px;background-position:-1885px 0px}.vti__flag.gi{height:10px;background-position:-1907px 0px}.vti__flag.gl{height:14px;background-position:-1929px 0px}.vti__flag.gm{height:14px;background-position:-1951px 0px}.vti__flag.gn{height:14px;background-position:-1973px 0px}.vti__flag.gp{height:14px;background-position:-1995px 0px}.vti__flag.gq{height:14px;background-position:-2017px 0px}.vti__flag.gr{height:14px;background-position:-2039px 0px}.vti__flag.gs{height:10px;background-position:-2061px 0px}.vti__flag.gt{height:13px;background-position:-2083px 0px}.vti__flag.gu{height:11px;background-position:-2105px 0px}.vti__flag.gw{height:10px;background-position:-2127px 0px}.vti__flag.gy{height:12px;background-position:-2149px 0px}.vti__flag.hk{height:14px;background-position:-2171px 0px}.vti__flag.hm{height:10px;background-position:-2193px 0px}.vti__flag.hn{height:10px;background-position:-2215px 0px}.vti__flag.hr{height:10px;background-position:-2237px 0px}.vti__flag.ht{height:12px;background-position:-2259px 0px}.vti__flag.hu{height:10px;background-position:-2281px 0px}.vti__flag.ic{height:14px;background-position:-2303px 0px}.vti__flag.id{height:14px;background-position:-2325px 0px}.vti__flag.ie{height:10px;background-position:-2347px 0px}.vti__flag.il{height:15px;background-position:-2369px 0px}.vti__flag.im{height:10px;background-position:-2391px 0px}.vti__flag.in{height:14px;background-position:-2413px 0px}.vti__flag.io{height:10px;background-position:-2435px 0px}.vti__flag.iq{height:14px;background-position:-2457px 0px}.vti__flag.ir{height:12px;background-position:-2479px 0px}.vti__flag.is{height:15px;background-position:-2501px 0px}.vti__flag.it{height:14px;background-position:-2523px 0px}.vti__flag.je{height:12px;background-position:-2545px 0px}.vti__flag.jm{height:10px;background-position:-2567px 0px}.vti__flag.jo{height:10px;background-position:-2589px 0px}.vti__flag.jp{height:14px;background-position:-2611px 0px}.vti__flag.ke{height:14px;background-position:-2633px 0px}.vti__flag.kg{height:12px;background-position:-2655px 0px}.vti__flag.kh{height:13px;background-position:-2677px 0px}.vti__flag.ki{height:10px;background-position:-2699px 0px}.vti__flag.km{height:12px;background-position:-2721px 0px}.vti__flag.kn{height:14px;background-position:-2743px 0px}.vti__flag.kp{height:10px;background-position:-2765px 0px}.vti__flag.kr{height:14px;background-position:-2787px 0px}.vti__flag.kw{height:10px;background-position:-2809px 0px}.vti__flag.ky{height:10px;background-position:-2831px 0px}.vti__flag.kz{height:10px;background-position:-2853px 0px}.vti__flag.la{height:14px;background-position:-2875px 0px}.vti__flag.lb{height:14px;background-position:-2897px 0px}.vti__flag.lc{height:10px;background-position:-2919px 0px}.vti__flag.li{height:12px;background-position:-2941px 0px}.vti__flag.lk{height:10px;background-position:-2963px 0px}.vti__flag.lr{height:11px;background-position:-2985px 0px}.vti__flag.ls{height:14px;background-position:-3007px 0px}.vti__flag.lt{height:12px;background-position:-3029px 0px}.vti__flag.lu{height:12px;background-position:-3051px 0px}.vti__flag.lv{height:10px;background-position:-3073px 0px}.vti__flag.ly{height:10px;background-position:-3095px 0px}.vti__flag.ma{height:14px;background-position:-3117px 0px}.vti__flag.mc{height:15px;background-position:-3139px 0px}.vti__flag.md{height:10px;background-position:-3160px 0px}.vti__flag.me{height:10px;background-position:-3182px 0px}.vti__flag.mf{height:14px;background-position:-3204px 0px}.vti__flag.mg{height:14px;background-position:-3226px 0px}.vti__flag.mh{height:11px;background-position:-3248px 0px}.vti__flag.mk{height:10px;background-position:-3270px 0px}.vti__flag.ml{height:14px;background-position:-3292px 0px}.vti__flag.mm{height:14px;background-position:-3314px 0px}.vti__flag.mn{height:10px;background-position:-3336px 0px}.vti__flag.mo{height:14px;background-position:-3358px 0px}.vti__flag.mp{height:10px;background-position:-3380px 0px}.vti__flag.mq{height:14px;background-position:-3402px 0px}.vti__flag.mr{height:14px;background-position:-3424px 0px}.vti__flag.ms{height:10px;background-position:-3446px 0px}.vti__flag.mt{height:14px;background-position:-3468px 0px}.vti__flag.mu{height:14px;background-position:-3490px 0px}.vti__flag.mv{height:14px;background-position:-3512px 0px}.vti__flag.mw{height:14px;background-position:-3534px 0px}.vti__flag.mx{height:12px;background-position:-3556px 0px}.vti__flag.my{height:10px;background-position:-3578px 0px}.vti__flag.mz{height:14px;background-position:-3600px 0px}.vti__flag.na{height:14px;background-position:-3622px 0px}.vti__flag.nc{height:10px;background-position:-3644px 0px}.vti__flag.ne{height:15px;background-position:-3666px 0px}.vti__flag.nf{height:10px;background-position:-3686px 0px}.vti__flag.ng{height:10px;background-position:-3708px 0px}.vti__flag.ni{height:12px;background-position:-3730px 0px}.vti__flag.nl{height:14px;background-position:-3752px 0px}.vti__flag.no{height:15px;background-position:-3774px 0px}.vti__flag.np{height:15px;background-position:-3796px 0px}.vti__flag.nr{height:10px;background-position:-3811px 0px}.vti__flag.nu{height:10px;background-position:-3833px 0px}.vti__flag.nz{height:10px;background-position:-3855px 0px}.vti__flag.om{height:10px;background-position:-3877px 0px}.vti__flag.pa{height:14px;background-position:-3899px 0px}.vti__flag.pe{height:14px;background-position:-3921px 0px}.vti__flag.pf{height:14px;background-position:-3943px 0px}.vti__flag.pg{height:15px;background-position:-3965px 0px}.vti__flag.ph{height:10px;background-position:-3987px 0px}.vti__flag.pk{height:14px;background-position:-4009px 0px}.vti__flag.pl{height:13px;background-position:-4031px 0px}.vti__flag.pm{height:14px;background-position:-4053px 0px}.vti__flag.pn{height:10px;background-position:-4075px 0px}.vti__flag.pr{height:14px;background-position:-4097px 0px}.vti__flag.ps{height:10px;background-position:-4119px 0px}.vti__flag.pt{height:14px;background-position:-4141px 0px}.vti__flag.pw{height:13px;background-position:-4163px 0px}.vti__flag.py{height:11px;background-position:-4185px 0px}.vti__flag.qa{height:8px;background-position:-4207px 0px}.vti__flag.re{height:14px;background-position:-4229px 0px}.vti__flag.ro{height:14px;background-position:-4251px 0px}.vti__flag.rs{height:14px;background-position:-4273px 0px}.vti__flag.ru{height:14px;background-position:-4295px 0px}.vti__flag.rw{height:14px;background-position:-4317px 0px}.vti__flag.sa{height:14px;background-position:-4339px 0px}.vti__flag.sb{height:10px;background-position:-4361px 0px}.vti__flag.sc{height:10px;background-position:-4383px 0px}.vti__flag.sd{height:10px;background-position:-4405px 0px}.vti__flag.se{height:13px;background-position:-4427px 0px}.vti__flag.sg{height:14px;background-position:-4449px 0px}.vti__flag.sh{height:10px;background-position:-4471px 0px}.vti__flag.si{height:10px;background-position:-4493px 0px}.vti__flag.sj{height:15px;background-position:-4515px 0px}.vti__flag.sk{height:14px;background-position:-4537px 0px}.vti__flag.sl{height:14px;background-position:-4559px 0px}.vti__flag.sm{height:15px;background-position:-4581px 0px}.vti__flag.sn{height:14px;background-position:-4603px 0px}.vti__flag.so{height:14px;background-position:-4625px 0px}.vti__flag.sr{height:14px;background-position:-4647px 0px}.vti__flag.ss{height:10px;background-position:-4669px 0px}.vti__flag.st{height:10px;background-position:-4691px 0px}.vti__flag.sv{height:12px;background-position:-4713px 0px}.vti__flag.sx{height:14px;background-position:-4735px 0px}.vti__flag.sy{height:14px;background-position:-4757px 0px}.vti__flag.sz{height:14px;background-position:-4779px 0px}.vti__flag.ta{height:10px;background-position:-4801px 0px}.vti__flag.tc{height:10px;background-position:-4823px 0px}.vti__flag.td{height:14px;background-position:-4845px 0px}.vti__flag.tf{height:14px;background-position:-4867px 0px}.vti__flag.tg{height:13px;background-position:-4889px 0px}.vti__flag.th{height:14px;background-position:-4911px 0px}.vti__flag.tj{height:10px;background-position:-4933px 0px}.vti__flag.tk{height:10px;background-position:-4955px 0px}.vti__flag.tl{height:10px;background-position:-4977px 0px}.vti__flag.tm{height:14px;background-position:-4999px 0px}.vti__flag.tn{height:14px;background-position:-5021px 0px}.vti__flag.to{height:10px;background-position:-5043px 0px}.vti__flag.tr{height:14px;background-position:-5065px 0px}.vti__flag.tt{height:12px;background-position:-5087px 0px}.vti__flag.tv{height:10px;background-position:-5109px 0px}.vti__flag.tw{height:14px;background-position:-5131px 0px}.vti__flag.tz{height:14px;background-position:-5153px 0px}.vti__flag.ua{height:14px;background-position:-5175px 0px}.vti__flag.ug{height:14px;background-position:-5197px 0px}.vti__flag.um{height:11px;background-position:-5219px 0px}.vti__flag.us{height:11px;background-position:-5241px 0px}.vti__flag.uy{height:14px;background-position:-5263px 0px}.vti__flag.uz{height:10px;background-position:-5285px 0px}.vti__flag.va{height:15px;background-position:-5307px 0px}.vti__flag.vc{height:14px;background-position:-5324px 0px}.vti__flag.ve{height:14px;background-position:-5346px 0px}.vti__flag.vg{height:10px;background-position:-5368px 0px}.vti__flag.vi{height:14px;background-position:-5390px 0px}.vti__flag.vn{height:14px;background-position:-5412px 0px}.vti__flag.vu{height:12px;background-position:-5434px 0px}.vti__flag.wf{height:14px;background-position:-5456px 0px}.vti__flag.ws{height:10px;background-position:-5478px 0px}.vti__flag.xk{height:15px;background-position:-5500px 0px}.vti__flag.ye{height:14px;background-position:-5522px 0px}.vti__flag.yt{height:14px;background-position:-5544px 0px}.vti__flag.za{height:14px;background-position:-5566px 0px}.vti__flag.zm{height:14px;background-position:-5588px 0px}.vti__flag.zw{height:10px;background-position:-5610px 0px}.vti__flag{width:20px;height:15px;box-shadow:0 0 1px #888;background-image:url(data:image/png;base64,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);background-repeat:no-repeat;background-color:#dbdbdb;background-position:20px 0}@media only screen and (-webkit-min-device-pixel-ratio: 2),only screen and (min-device-pixel-ratio: 2),only screen and (min-resolution: 192dpi),only screen and (min-resolution: 2dppx){.vti__flag{background-image:url(data:image/png;base64,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)}}.vti__flag.np{background-color:transparent}.vue-tel-input{border-radius:3px;display:flex;border:1px solid #bbb;text-align:left}.vue-tel-input.disabled .selection,.vue-tel-input.disabled .dropdown,.vue-tel-input.disabled input{cursor:no-drop}.vue-tel-input:focus-within{box-shadow:inset 0 1px 1px #00000013,0 0 8px #66afe999;border-color:#66afe9}.vti__dropdown{display:flex;flex-direction:column;align-content:center;justify-content:center;position:relative;padding:7px;cursor:pointer}.vti__dropdown.show{max-height:300px;overflow:scroll}.vti__dropdown.open{background-color:#f3f3f3}.vti__dropdown.disabled{cursor:no-drop;outline:none;background-color:#f3f3f3}.vti__dropdown:hover{background-color:#f3f3f3}.vti__selection{font-size:.8em;display:flex;align-items:center}.vti__selection .vti__country-code{color:#666}.vti__flag{margin-right:5px;margin-left:5px}.vti__dropdown-list{z-index:1;padding:0;margin:0;text-align:left;list-style:none;max-height:200px;overflow-y:scroll;position:absolute;left:-1px;background-color:#fff;border:1px solid #ccc;width:390px}.vti__dropdown-list.below{top:33px}.vti__dropdown-list.above{top:auto;bottom:100%}.vti__dropdown-arrow{transform:scaleY(.5);display:inline-block;color:#666}.vti__dropdown-item{cursor:pointer;padding:4px 15px}.vti__dropdown-item.highlighted{background-color:#f3f3f3}.vti__dropdown-item.last-preferred{border-bottom:1px solid #cacaca}.vti__dropdown-item .vti__flag{display:inline-block;margin-right:5px}.vti__input{border:none;border-radius:0 2px 2px 0;width:100%;outline:none;padding-left:7px}.vti__search_box{border:1px solid #ccc;width:94%;padding:7px;margin:2px}\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=0&id=08f4abee&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=0&id=08f4abee&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.metaPopupArea {\r\n    max-width: 640px;\r\n}\r\n\r\n.copy-payment-id-text{\r\nmargin-left: -5px; text-align:left;font-weight:600;color:#625afa;\r\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=1&id=08f4abee&scoped=true&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=1&id=08f4abee&scoped=true&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.payment-columns-filter > li > .btn-group > .dropdown-menu[data-v-08f4abee] {\r\n    padding: var(--vz-dropdown-padding-y) var(--vz-dropdown-padding-x);\n}\n#cancelbtn[data-v-08f4abee] {\r\n    border: 1px solid #b9bec4;\r\n    border-radius: 6px;\r\n    color: #414552;\r\n    font-weight: 600;\r\n    font-size: 13px;\r\n    background: transparent;\r\n    padding: 6px 10px;\r\n    margin-right: 6px;\n}\n#cancelbtn > span[data-v-08f4abee] {\r\n    background: rgb(235 238 241);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\n.customerleftcol > a[data-v-08f4abee] {\r\n    color: #30313d;\r\n    /* color: #625afa; */\r\n    font-size: 14px;\r\n    font-weight: 500;\n}\n.customerleftcol > h3[data-v-08f4abee] {\r\n    font-size: 28px;\r\n    line-height: 1;\r\n    font-weight: 700;\r\n    color: #000;\r\n    margin: 8px 0;\r\n    letter-spacing: -1px;\n}\n.customerleftcol > p[data-v-08f4abee] {\r\n    font-size: 14px;\r\n    font-weight: 400;\r\n    color: #6d7785;\r\n    margin-bottom: 30px;\n}\n.clickshowcontent[data-v-08f4abee] {\r\n    margin-bottom: 20px;\n}\n.clickshowcontent .showinnerdiv[data-v-08f4abee] {\r\n    display: none;\r\n    flex-direction: row;\r\n    width: 100%;\r\n    border-top: 1px solid #e9ebec;\r\n    margin-top: 10px;\r\n    padding-top: 16px;\r\n    position: relative;\n}\n.flexVisible[data-v-08f4abee] {\r\n    display: flex !important;\n}\n.clickshowcontent .showinnerdiv p[data-v-08f4abee] {\r\n    flex: 1 1 0px;\r\n    display: grid;\r\n    color: #687385;\n}\n.clickshowcontent .showinnerdiv p strong[data-v-08f4abee] {\r\n    font-weight: 500;\r\n    color: #414552;\n}\n.clickshowcontent a[data-v-08f4abee] {\r\n    cursor: pointer;\r\n    font-weight: 600;\r\n    font-size: 14px;\n}\n.clickshowcontent a i[data-v-08f4abee] {\r\n    color: #687385;\n}\n.rotateIcon[data-v-08f4abee] {\r\n    transform: rotate(90deg);\r\n    transition: transform 0.3s ease; /* Add a smooth transition */\n}\n.eventslogdiv > h4[data-v-08f4abee] {\r\n    font-weight: 600;\r\n    color: #000;\r\n    font-size: 16px;\n}\n.eventslogdiv > p[data-v-08f4abee] {\r\n    border-top: 1px solid #eaebec;\r\n    padding: 16px 0;\n}\n.eventslogdiv > p > a[data-v-08f4abee] {\r\n    color: #6f6f6f;\r\n    font-size: 13px;\r\n    font-weight: 400;\n}\n.eventslogdiv > p > a > .eventslogstatus[data-v-08f4abee] {\r\n    background: #ebeef1;\r\n    padding: 4px 10px;\r\n    line-height: 0;\r\n    border-radius: 4px;\r\n    border: 1px solid #d8dee4;\r\n    color: #6f6f6f;\r\n    margin-right: 35px;\n}\n.eventslogdiv > p > a > span[data-v-08f4abee]:nth-last-child(1) {\r\n    float: right;\n}\nbutton.custom-accordion-detailArea[data-v-08f4abee] {\r\n    background: transparent;\r\n    border: 0;\r\n    padding-top: 15px;\n}\n.custom-accordion-body[data-v-08f4abee] {\r\n    display: block;\r\n    max-height: 0;\r\n    transition: all 0.4s ease-in-out;\n}\n.custom-accordion-body.active[data-v-08f4abee] {\r\n    max-height: 1000px;\n}\n.detailscontentdiv[data-v-08f4abee] {\r\n    width: 100%;\r\n    margin-bottom: 20px;\r\n    transition: max-height 0.3s ease-in-out;\n}\n.detailscontentdiv:not(.expanded) > .showMore[data-v-08f4abee] {\r\n    display: none;\n}\n.detailscontentdiv.expanded[data-v-08f4abee] {\r\n    max-height: none;\n}\n.detailscontentdiv > p[data-v-08f4abee] {\r\n    color: #687385;\r\n    font-size: 13px;\r\n    margin-bottom: 8px;\n}\n.detailsSpan[data-v-08f4abee] {\r\n    display: inline-block;\r\n    margin-top: 1px;\n}\n.cardLike[data-v-08f4abee] {\r\n    padding: 0 4px;\r\n    border-radius: 4px;\r\n    background: #f0f2f5;\r\n    border: 1px solid #eee;\n}\n.detailscontentdiv > p > span[data-v-08f4abee] {\r\n    color: #414552;\n}\n.showinnerdiv a[data-v-08f4abee] {\r\n    font-size: 13px;\r\n    font-weight: 500;\r\n    color: #625afa;\r\n    position: absolute;\r\n    bottom: -8px;\r\n    left: 0;\n}\n.purpleLink[data-v-08f4abee] {\r\n    color: #625afa;\r\n    opacity: 0;\r\n    visibility: hidden;\r\n    transition: all 0.3s;\n}\n.showThis[data-v-08f4abee] {\r\n    opacity: 1;\r\n    visibility: visible;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=style&index=0&id=75fd909c&scoped=true&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=style&index=0&id=75fd909c&scoped=true&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.label-field[data-v-75fd909c] {\r\n    font-size: 13px;\r\n    display: flex;\r\n    flex-direction: row;\r\n    gap: 1rem;\r\n    place-items: center;\r\n    margin: 0.4rem 0rem;\n}\n.purpleLinkStyle[data-v-75fd909c]:disabled {\r\n    background: #706e79;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=style&index=0&id=50787864&scoped=true&lang=css":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=style&index=0&id=50787864&scoped=true&lang=css ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\nbutton.custom-accordion-detailArea[data-v-50787864] {\r\n    background: transparent;\r\n    border: 0;\r\n    padding-top: 15px;\n}\n.custom-accordion-body[data-v-50787864] {\r\n    display: block;\r\n    max-height: 0;\r\n    transition: all 0.4s ease-in-out;\n}\n.custom-accordion-body.active[data-v-50787864] {\r\n    max-height: 1000px;\n}\n.card-logo[data-v-50787864] {\r\n  width: 3rem;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=style&index=0&id=585fc86a&scoped=true&lang=css":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=style&index=0&id=585fc86a&scoped=true&lang=css ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n#addQuotepurple[data-v-585fc86a] {\r\n    border: 1px solid var(--custom-primary);\r\n    border-radius: 6px;\r\n    color: #fff;\r\n    font-size: 13px;\r\n    font-weight: 600;\r\n    background: var(--custom-primary);\r\n    padding: 6px 10px;\n}\n#addQuotepurple > span[data-v-585fc86a] {\r\n    background: rgb(141 127 250);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\n#cancelbtn[data-v-585fc86a] {\r\n    border: 1px solid #b9bec4;\r\n    border-radius: 6px;\r\n    color: #414552;\r\n    font-weight: 600;\r\n    font-size: 13px;\r\n    background: transparent;\r\n    padding: 6px 10px;\r\n    margin-right: 6px;\n}\n#cancelbtn > span[data-v-585fc86a] {\r\n    background: rgb(235 238 241);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\r\n\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=style&index=0&id=b4968c06&scoped=true&lang=css":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=style&index=0&id=b4968c06&scoped=true&lang=css ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.bxs-pin[data-v-b4968c06], .pinToTop[data-v-b4968c06] { color: #c83901;\n}\n.bxs-pin[data-v-b4968c06] {\r\n  transform: rotate(45deg);\n}\r\n /* Timeline text field CSS Start*/\n#cancelbtn[data-v-b4968c06]{\r\n    border: 1px solid #b9bec4;\r\n    border-radius: 6px;\r\n    color: #414552;\r\n    font-weight: 600;\r\n    font-size: 13px;\r\n    background: transparent;\r\n    padding: 6px 10px;\r\n    margin-right: 6px;\n}\n#cancelbtn > span[data-v-b4968c06]{\r\n    background: rgb(235 238 241);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\n#addnotepurple[data-v-b4968c06]{\r\n    border: 1px solid var(--custom-primary);\r\n    border-radius: 6px;\r\n    color: #fff;\r\n    font-size: 13px;\r\n    font-weight: 600;\r\n    background: var(--custom-primary);\r\n    padding: 6px 10px;\n}\n#addnotepurple > span[data-v-b4968c06]{\r\n    background: rgb(141 127 250);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\ntextarea[data-v-b4968c06]{\r\n    resize: none;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=style&index=0&id=5637d11a&scoped=true&lang=css":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=style&index=0&id=5637d11a&scoped=true&lang=css ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n[data-v-5637d11a] .dropdown-item > .copycardArea > button{\r\n    color: var(--custom-primary) !important;\r\n    font-weight: 600;\r\n    right: 40px;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=style&index=0&id=03caa1b1&scoped=true&lang=css":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=style&index=0&id=03caa1b1&scoped=true&lang=css ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.bxs-pin[data-v-03caa1b1],\r\n.pinToTop[data-v-03caa1b1] {\r\n    color: #c83901;\n}\n.bxs-pin[data-v-03caa1b1] {\r\n    transform: rotate(45deg);\n}\n.threedots[data-v-03caa1b1] {\r\n    float: right;\r\n    border-radius: 6px;\r\n    padding: 0 10px;\r\n    border: 1px solid transparent;\r\n    color: #414552;\n}\n.highlight-border[data-v-03caa1b1] {\r\n    border: 1px solid #d5dbe1; /* You can change the color and style as needed */\n}\n.timeline-details[data-v-03caa1b1] {\r\n    position: relative;\n}\n.threedotsclickopen[data-v-03caa1b1] {\r\n    position: absolute;\r\n    top: 28px;\r\n    right: -1%;\r\n    width: 14%;\r\n    background: #fff;\r\n    padding: 10px 0px;\r\n    box-shadow: 0 0 0 1px #8898aa1a, 0 15px 35px #31315d1a, 0 5px 15px #00000014;\r\n    border-radius: 6px;\r\n    border: 1px solid #d5dbe1;\r\n    display: none;\r\n    z-index: 1;\n}\n.color-red[data-v-03caa1b1] {\r\n    color: #ff0000 !important;\n}\n.threedotsclickopen p > a[data-v-03caa1b1] {\r\n    color: #7b5afa;\r\n    font-weight: 600;\n}\n.threedotsclickopen p[data-v-03caa1b1] {\r\n    padding: 6px 15px;\n}\n.threedotsclickopen p[data-v-03caa1b1]:hover {\r\n    background-color: #f5f5f5;\n}\n.threedotsclickopen p:hover a[data-v-03caa1b1] {\r\n    color: #000;\n}\n.bx-check-circle[data-v-03caa1b1]:before {\r\n    color: green;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=style&index=0&id=b8ed8cf0&scoped=true&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=style&index=0&id=b8ed8cf0&scoped=true&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.first-message[data-v-b8ed8cf0] {\r\n    top: 80%;\n}\n.not-first-message[data-v-b8ed8cf0]{\r\n    bottom: 80%;\n}\n.fade-enter-to[data-v-b8ed8cf0], .fade-leave-from[data-v-b8ed8cf0] {\r\n    opacity: 1;\n}\n.fade-enter-active[data-v-b8ed8cf0], .fade-leave-active[data-v-b8ed8cf0] {\r\n    transition: opacity 0.25s;\n}\n.fade-enter-from[data-v-b8ed8cf0], .fade-leave-to[data-v-b8ed8cf0] {\r\n    opacity: 0;\n}\n.badgeColumn[data-v-b8ed8cf0]{\r\n    z-index: 999;\r\n    position: relative;\n}\n.message[data-v-b8ed8cf0] {\r\n    position: absolute;\r\n    left: 50%;\r\n    padding: 0.625rem 0.75rem;\r\n    min-width: 150%;\r\n    width: -moz-max-content;\r\n    width: max-content;\r\n    max-width: 250%;\r\n    background: rgb(255, 255, 255);\r\n    border-radius: 0.4rem;\r\n    box-shadow: 0 4px 4px 0 rgb(0 0 0 / 10%);\r\n    transform: translate(-50%, 0);\r\n    word-wrap: break-word;\r\n    border: 1px solid #d8dee4;\r\n    color: rgb(64 67 78);\r\n    font-family: 'Poppins', sans-serif;\r\n    font-weight: 500;\r\n    font-size: 0.625rem;\r\n    z-index: 1;\r\n    text-wrap: wrap;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=style&index=0&id=118e72b8&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=style&index=0&id=118e72b8&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.popup-bg {\r\n    z-index: 10000;\r\n    position: fixed;\r\n    top: 0;\r\n    bottom: 0;\r\n    left: 0;\r\n    right: 0;\r\n    background-color: #c1c9d2b3;\r\n}\r\n\r\n.popup-bg:not(.showThis),\r\n.popup-area:not(.showThis) {\r\n    opacity: 0;\r\n    visibility: hidden;\r\n}\r\n\r\n.popup-bg,\r\n.popup-area {\r\n    transition: all 0.3s;\r\n}\r\n.popup-area {\r\n    position: fixed;\r\n    left: 50%;\r\n    top: 50%;\r\n    width: 100%;\r\n    /* max-width: 450px; */\r\n    border-radius: 8px;\r\n    background: #fff;\r\n    transform: translate(-50%, -50%);\r\n    z-index: 10001;\r\n    display: flex;\r\n    flex-direction: column;\r\n    max-height: calc(100vh - 60px);\r\n}\r\n\r\n.popup-head {\r\n    padding: 1rem;\r\n    box-shadow: inset 0 -1px #ebeef1;\r\n    flex: 1 0 auto;\r\n}\r\n\r\n.popup-body {\r\n    background-color: #f6f8fa;\r\n    padding: 20px 20px;\r\n    flex: 1 1 auto;\r\n    overflow: auto;\r\n}\r\n\r\n.popup-details-area > h3 {\r\n    font-size: 15px;\r\n    font-weight: 500;\r\n    color: #1a1b25;\r\n    margin-bottom: 30px;\r\n}\r\n\r\n.popup-details-area a {\r\n    font-weight: 600;\r\n    color: var(--custom-primary) !important;\r\n}\r\n\r\n.popup-details-area > h3 > i {\r\n    font-size: 18px;\r\n    line-height: 0;\r\n    transform: translate(0, 3px);\r\n}\r\n\r\n.popup-details-area > h3.hide > i {\r\n    transform: rotate(180deg) translate(0, -3px);\r\n}\r\n\r\n.popup-details-area + .popup-details-area {\r\n    margin-top: 40px;\r\n}\r\n\r\n.popupToggleArea:not(.show) {\r\n    display: none;\r\n}\r\n\r\n.popupToggleArea {\r\n    padding: 7px 0;\r\n}\r\n\r\n.popup-details-input {\r\n    font-size: 13px;\r\n}\r\n\r\n.popup-details-input + .popup-details-input {\r\n    margin-top: 30px;\r\n}\r\n\r\n.popup-details-input label:not(.checkbox-label) {\r\n    display: block;\r\n    font-weight: 500;\r\n    color: #414552;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.popup-details-input label.checkbox-label {\r\n    display: flex;\r\n    align-items: center;\r\n    margin: 0;\r\n    padding: 5px 0;\r\n    gap: 10px;\r\n}\r\n.popup-details-input input:not(:is([type=\"checkbox\"], [type=\"radio\"])) {\r\n    border: 1px solid #ccc;\r\n}\r\n\r\n.popup-details-input\r\n    input:not(:is([type=\"checkbox\"], [type=\"radio\"])):focus-visible,\r\n.popup-details-input select:focus-visible,\r\n.popup-details-input textarea:focus-visible {\r\n    outline-color: var(--custom-primary);\r\n}\r\n\r\n.popup-details-input input:not(:is([type=\"checkbox\"], [type=\"radio\"])),\r\n.popup-details-input select,\r\n.popup-details-input textarea {\r\n    width: 100%;\r\n    padding: 3px 10px;\r\n    min-height: 28px;\r\n    border-radius: 6px;\r\n}\r\n\r\n.popup-details-input\r\n    :is(input, select, textarea)\r\n    + :is(input, select, textarea) {\r\n    margin-top: 15px;\r\n}\r\n\r\n.popup-details-input :is(select, textarea) {\r\n    color: #404452;\r\n    background: #fff;\r\n    border: 0;\r\n    outline: 0;\r\n    box-shadow: rgba(0, 0, 0, 0) 0px 0px 0px 0px,\r\n        rgba(0, 0, 0, 0) 0px 0px 0px 0px, rgba(0, 0, 0, 0.12) 0px 1px 1px 0px,\r\n        rgba(64, 68, 82, 0.16) 0px 0px 0px 1px, rgba(0, 0, 0, 0) 0px 0px 0px 0px,\r\n        rgba(0, 0, 0, 0) 0px 0px 0px 0px, rgba(64, 68, 82, 0.08) 0px 2px 5px 0px;\r\n}\r\n\r\n.popup-head > h2 {\r\n    font-size: 1rem;\r\n    margin: 0;\r\n    font-weight: 700;\r\n    color: #1a1b25;\r\n}\r\n\r\n.flex-inputArea {\r\n    display: flex;\r\n    gap: 12px;\r\n    align-items: center;\r\n}\r\n\r\n.flex-inputArea + .flex-inputArea {\r\n    margin-top: 15px;\r\n}\r\n\r\n.flex-inputArea > .popup-details-input {\r\n    margin: 0;\r\n    flex: 1;\r\n}\r\n\r\n.flex-inputArea > .popup-details-input.flex180 {\r\n    flex: 0 0 180px;\r\n}\r\n\r\n.flex-inputArea > .deleteArea {\r\n    color: var(--custom-primary);\r\n    cursor: pointer;\r\n}\r\n\r\n.popup-footer {\r\n    box-shadow: inset 0 1px #ebeef1;\r\n    padding: 15px 20px;\r\n    font-size: 14px;\r\n    display: flex;\r\n    gap: 7px;\r\n    justify-content: flex-end;\r\n    flex: 1 0 auto;\r\n}\r\n\r\n.popup-footer > button,\r\nlabel.popup-file-upload-label > button {\r\n    background: #fff;\r\n    font-size: 13px;\r\n    line-height: 20px;\r\n    min-height: 28px;\r\n    border-radius: 6px;\r\n    box-shadow: 0px 1px 1px 0px rgba(16, 17, 26, 0.16), #d5dbe1 0 0 0 1px,\r\n        0 0 0 0 transparent, 0 0 0 0 transparent;\r\n    padding: 3px 10px;\r\n    font-weight: 500;\r\n    border: 0;\r\n    outline: 0;\r\n}\r\n\r\nlabel.popup-file-upload-label {\r\n    display: flex;\r\n    gap: 10px;\r\n    align-items: center;\r\n    font-weight: 600;\r\n    cursor: pointer;\r\n}\r\n\r\nlabel.popup-file-upload-label > button {\r\n    display: inline-flex;\r\n    align-items: center;\r\n    margin: 0;\r\n    gap: 7px;\r\n    font-weight: 600;\r\n}\r\n\r\nlabel.popup-file-upload-label > button > i {\r\n    font-size: 18px;\r\n    line-height: 0;\r\n}\r\n\r\n.popup-file-upload {\r\n    cursor: pointer;\r\n}\r\n\r\n.popup-file-upload > input {\r\n    display: none;\r\n}\r\n\r\n.popup-footer > button.purpleLinkStyle {\r\n    background: #625afa;\r\n    color: #fff;\r\n}\r\n\r\n.btn-to-start {\r\n    flex: 1;\r\n}\r\n\r\n.btn-to-start > button {\r\n    border: 0;\r\n    background: transparent;\r\n    outline: 0;\r\n    color: var(--custom-primary);\r\n    font-weight: 500;\r\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=style&index=0&id=ef55f284&lang=css":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=style&index=0&id=ef55f284&lang=css ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.vue-tel-input {\r\n    border-radius: 6px !important;\r\n}\r\n\r\n.vue-tel-input input {\r\n    outline: none !important;\r\n    border: none !important;\r\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=style&index=0&id=e27c74de&scoped=true&lang=css":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=style&index=0&id=e27c74de&scoped=true&lang=css ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.redLinkStyle[data-v-e27c74de] {\r\n    background: #df1b41 !important;\r\n    color: #fff !important;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=style&index=0&id=5272debe&scoped=true&lang=css":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=style&index=0&id=5272debe&scoped=true&lang=css ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.popup-footer > button.purpleLinkStyle[disabled][data-v-5272debe] {\r\n    opacity: 0.5;\r\n    cursor: not-allowed;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=style&index=0&id=c6b47b60&scoped=true&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=style&index=0&id=c6b47b60&scoped=true&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.textToCopy span[data-v-c6b47b60]{\r\n  cursor: pointer;\r\n  padding: 4px 10px;\r\n  border-radius: 6px;\n}\n.textToCopy span[data-v-c6b47b60]:hover{\r\n  background-color: #f5f5f5;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=style&index=0&id=5c57ca7b&scoped=true&lang=css":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=style&index=0&id=5c57ca7b&scoped=true&lang=css ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.copycardArea[data-v-5c57ca7b] {\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: flex-end;\r\n    font-size: 12px;\n}\np > .copycardArea[data-v-5c57ca7b] {\r\n    justify-content: initial;\n}\n.copycardArea > button[data-v-5c57ca7b] {\r\n    position: relative;\r\n    padding: 2px 5px;\r\n    border-radius: 4px;\r\n    /* margin-bottom: 5px; */\r\n    background: transparent;\r\n    transition: color 0.3s;\r\n    cursor: pointer;\r\n    border: 0;\r\n    outline: 0;\n}\n.copycardArea > button[data-v-5c57ca7b]:hover,\r\np .copycardArea > button[data-v-5c57ca7b] {\r\n    background: #f5f5f5;\n}\np > .copycardArea > button[data-v-5c57ca7b] {\r\n    border: 1px solid #e6e6e6;\n}\n.customTooltip[data-v-5c57ca7b] {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 3px;\r\n    position: absolute;\r\n    left: 50%;\r\n    transform: translate(-50%);\r\n    background: #434352;\r\n    padding: 6px 10px;\r\n    color: #fff;\r\n    border-radius: 6px;\r\n    white-space: nowrap;\r\n    transition: opacity 0.3s, visibility 0.3s;\r\n    z-index: 10010;\n}\n.topDirectionClass[data-v-5c57ca7b]{\r\n    bottom: 120%;\n}\n.bottomDirectionClass[data-v-5c57ca7b]{\r\n    top: 120%;\n}\n.customTooltip > span[data-v-5c57ca7b] {\r\n    display: inline-block;\n}\n.copycardArea > button:not(:hover) > .customTooltip[data-v-5c57ca7b] {\r\n    opacity: 0;\r\n    visibility: hidden;\n}\n.customTooltip > span.code[data-v-5c57ca7b] {\r\n    background: rgba(255, 255, 255, 0.15);\r\n    padding: 1px 5px;\r\n    border-radius: 4px;\r\n    min-width: 25px;\r\n    text-align: center;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/diacritics/index.js":
/*!******************************************!*\
  !*** ./node_modules/diacritics/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.remove = removeDiacritics;

var replacementList = [
  {
    base: ' ',
    chars: "\u00A0",
  }, {
    base: '0',
    chars: "\u07C0",
  }, {
    base: 'A',
    chars: "\u24B6\uFF21\u00C0\u00C1\u00C2\u1EA6\u1EA4\u1EAA\u1EA8\u00C3\u0100\u0102\u1EB0\u1EAE\u1EB4\u1EB2\u0226\u01E0\u00C4\u01DE\u1EA2\u00C5\u01FA\u01CD\u0200\u0202\u1EA0\u1EAC\u1EB6\u1E00\u0104\u023A\u2C6F",
  }, {
    base: 'AA',
    chars: "\uA732",
  }, {
    base: 'AE',
    chars: "\u00C6\u01FC\u01E2",
  }, {
    base: 'AO',
    chars: "\uA734",
  }, {
    base: 'AU',
    chars: "\uA736",
  }, {
    base: 'AV',
    chars: "\uA738\uA73A",
  }, {
    base: 'AY',
    chars: "\uA73C",
  }, {
    base: 'B',
    chars: "\u24B7\uFF22\u1E02\u1E04\u1E06\u0243\u0181",
  }, {
    base: 'C',
    chars: "\u24b8\uff23\uA73E\u1E08\u0106\u0043\u0108\u010A\u010C\u00C7\u0187\u023B",
  }, {
    base: 'D',
    chars: "\u24B9\uFF24\u1E0A\u010E\u1E0C\u1E10\u1E12\u1E0E\u0110\u018A\u0189\u1D05\uA779",
  }, {
    base: 'Dh',
    chars: "\u00D0",
  }, {
    base: 'DZ',
    chars: "\u01F1\u01C4",
  }, {
    base: 'Dz',
    chars: "\u01F2\u01C5",
  }, {
    base: 'E',
    chars: "\u025B\u24BA\uFF25\u00C8\u00C9\u00CA\u1EC0\u1EBE\u1EC4\u1EC2\u1EBC\u0112\u1E14\u1E16\u0114\u0116\u00CB\u1EBA\u011A\u0204\u0206\u1EB8\u1EC6\u0228\u1E1C\u0118\u1E18\u1E1A\u0190\u018E\u1D07",
  }, {
    base: 'F',
    chars: "\uA77C\u24BB\uFF26\u1E1E\u0191\uA77B",
  }, {
    base: 'G',
    chars: "\u24BC\uFF27\u01F4\u011C\u1E20\u011E\u0120\u01E6\u0122\u01E4\u0193\uA7A0\uA77D\uA77E\u0262",
  }, {
    base: 'H',
    chars: "\u24BD\uFF28\u0124\u1E22\u1E26\u021E\u1E24\u1E28\u1E2A\u0126\u2C67\u2C75\uA78D",
  }, {
    base: 'I',
    chars: "\u24BE\uFF29\xCC\xCD\xCE\u0128\u012A\u012C\u0130\xCF\u1E2E\u1EC8\u01CF\u0208\u020A\u1ECA\u012E\u1E2C\u0197",
  }, {
    base: 'J',
    chars: "\u24BF\uFF2A\u0134\u0248\u0237",
  }, {
    base: 'K',
    chars: "\u24C0\uFF2B\u1E30\u01E8\u1E32\u0136\u1E34\u0198\u2C69\uA740\uA742\uA744\uA7A2",
  }, {
    base: 'L',
    chars: "\u24C1\uFF2C\u013F\u0139\u013D\u1E36\u1E38\u013B\u1E3C\u1E3A\u0141\u023D\u2C62\u2C60\uA748\uA746\uA780",
  }, {
    base: 'LJ',
    chars: "\u01C7",
  }, {
    base: 'Lj',
    chars: "\u01C8",
  }, {
    base: 'M',
    chars: "\u24C2\uFF2D\u1E3E\u1E40\u1E42\u2C6E\u019C\u03FB",
  }, {
    base: 'N',
    chars: "\uA7A4\u0220\u24C3\uFF2E\u01F8\u0143\xD1\u1E44\u0147\u1E46\u0145\u1E4A\u1E48\u019D\uA790\u1D0E",
  }, {
    base: 'NJ',
    chars: "\u01CA",
  }, {
    base: 'Nj',
    chars: "\u01CB",
  }, {
    base: 'O',
    chars: "\u24C4\uFF2F\xD2\xD3\xD4\u1ED2\u1ED0\u1ED6\u1ED4\xD5\u1E4C\u022C\u1E4E\u014C\u1E50\u1E52\u014E\u022E\u0230\xD6\u022A\u1ECE\u0150\u01D1\u020C\u020E\u01A0\u1EDC\u1EDA\u1EE0\u1EDE\u1EE2\u1ECC\u1ED8\u01EA\u01EC\xD8\u01FE\u0186\u019F\uA74A\uA74C",
  }, {
    base: 'OE',
    chars: "\u0152",
  }, {
    base: 'OI',
    chars: "\u01A2",
  }, {
    base: 'OO',
    chars: "\uA74E",
  }, {
    base: 'OU',
    chars: "\u0222",
  }, {
    base: 'P',
    chars: "\u24C5\uFF30\u1E54\u1E56\u01A4\u2C63\uA750\uA752\uA754",
  }, {
    base: 'Q',
    chars: "\u24C6\uFF31\uA756\uA758\u024A",
  }, {
    base: 'R',
    chars: "\u24C7\uFF32\u0154\u1E58\u0158\u0210\u0212\u1E5A\u1E5C\u0156\u1E5E\u024C\u2C64\uA75A\uA7A6\uA782",
  }, {
    base: 'S',
    chars: "\u24C8\uFF33\u1E9E\u015A\u1E64\u015C\u1E60\u0160\u1E66\u1E62\u1E68\u0218\u015E\u2C7E\uA7A8\uA784",
  }, {
    base: 'T',
    chars: "\u24C9\uFF34\u1E6A\u0164\u1E6C\u021A\u0162\u1E70\u1E6E\u0166\u01AC\u01AE\u023E\uA786",
  }, {
    base: 'Th',
    chars: "\u00DE",
  }, {
    base: 'TZ',
    chars: "\uA728",
  }, {
    base: 'U',
    chars: "\u24CA\uFF35\xD9\xDA\xDB\u0168\u1E78\u016A\u1E7A\u016C\xDC\u01DB\u01D7\u01D5\u01D9\u1EE6\u016E\u0170\u01D3\u0214\u0216\u01AF\u1EEA\u1EE8\u1EEE\u1EEC\u1EF0\u1EE4\u1E72\u0172\u1E76\u1E74\u0244",
  }, {
    base: 'V',
    chars: "\u24CB\uFF36\u1E7C\u1E7E\u01B2\uA75E\u0245",
  }, {
    base: 'VY',
    chars: "\uA760",
  }, {
    base: 'W',
    chars: "\u24CC\uFF37\u1E80\u1E82\u0174\u1E86\u1E84\u1E88\u2C72",
  }, {
    base: 'X',
    chars: "\u24CD\uFF38\u1E8A\u1E8C",
  }, {
    base: 'Y',
    chars: "\u24CE\uFF39\u1EF2\xDD\u0176\u1EF8\u0232\u1E8E\u0178\u1EF6\u1EF4\u01B3\u024E\u1EFE",
  }, {
    base: 'Z',
    chars: "\u24CF\uFF3A\u0179\u1E90\u017B\u017D\u1E92\u1E94\u01B5\u0224\u2C7F\u2C6B\uA762",
  }, {
    base: 'a',
    chars: "\u24D0\uFF41\u1E9A\u00E0\u00E1\u00E2\u1EA7\u1EA5\u1EAB\u1EA9\u00E3\u0101\u0103\u1EB1\u1EAF\u1EB5\u1EB3\u0227\u01E1\u00E4\u01DF\u1EA3\u00E5\u01FB\u01CE\u0201\u0203\u1EA1\u1EAD\u1EB7\u1E01\u0105\u2C65\u0250\u0251",
  }, {
    base: 'aa',
    chars: "\uA733",
  }, {
    base: 'ae',
    chars: "\u00E6\u01FD\u01E3",
  }, {
    base: 'ao',
    chars: "\uA735",
  }, {
    base: 'au',
    chars: "\uA737",
  }, {
    base: 'av',
    chars: "\uA739\uA73B",
  }, {
    base: 'ay',
    chars: "\uA73D",
  }, {
    base: 'b',
    chars: "\u24D1\uFF42\u1E03\u1E05\u1E07\u0180\u0183\u0253\u0182",
  }, {
    base: 'c',
    chars: "\uFF43\u24D2\u0107\u0109\u010B\u010D\u00E7\u1E09\u0188\u023C\uA73F\u2184",
  }, {
    base: 'd',
    chars: "\u24D3\uFF44\u1E0B\u010F\u1E0D\u1E11\u1E13\u1E0F\u0111\u018C\u0256\u0257\u018B\u13E7\u0501\uA7AA",
  }, {
    base: 'dh',
    chars: "\u00F0",
  }, {
    base: 'dz',
    chars: "\u01F3\u01C6",
  }, {
    base: 'e',
    chars: "\u24D4\uFF45\u00E8\u00E9\u00EA\u1EC1\u1EBF\u1EC5\u1EC3\u1EBD\u0113\u1E15\u1E17\u0115\u0117\u00EB\u1EBB\u011B\u0205\u0207\u1EB9\u1EC7\u0229\u1E1D\u0119\u1E19\u1E1B\u0247\u01DD",
  }, {
    base: 'f',
    chars: "\u24D5\uFF46\u1E1F\u0192",
  }, {
    base: 'ff',
    chars: "\uFB00",
  }, {
    base: 'fi',
    chars: "\uFB01",
  }, {
    base: 'fl',
    chars: "\uFB02",
  }, {
    base: 'ffi',
    chars: "\uFB03",
  }, {
    base: 'ffl',
    chars: "\uFB04",
  }, {
    base: 'g',
    chars: "\u24D6\uFF47\u01F5\u011D\u1E21\u011F\u0121\u01E7\u0123\u01E5\u0260\uA7A1\uA77F\u1D79",
  }, {
    base: 'h',
    chars: "\u24D7\uFF48\u0125\u1E23\u1E27\u021F\u1E25\u1E29\u1E2B\u1E96\u0127\u2C68\u2C76\u0265",
  }, {
    base: 'hv',
    chars: "\u0195",
  }, {
    base: 'i',
    chars: "\u24D8\uFF49\xEC\xED\xEE\u0129\u012B\u012D\xEF\u1E2F\u1EC9\u01D0\u0209\u020B\u1ECB\u012F\u1E2D\u0268\u0131",
  }, {
    base: 'j',
    chars: "\u24D9\uFF4A\u0135\u01F0\u0249",
  }, {
    base: 'k',
    chars: "\u24DA\uFF4B\u1E31\u01E9\u1E33\u0137\u1E35\u0199\u2C6A\uA741\uA743\uA745\uA7A3",
  }, {
    base: 'l',
    chars: "\u24DB\uFF4C\u0140\u013A\u013E\u1E37\u1E39\u013C\u1E3D\u1E3B\u017F\u0142\u019A\u026B\u2C61\uA749\uA781\uA747\u026D",
  }, {
    base: 'lj',
    chars: "\u01C9",
  }, {
    base: 'm',
    chars: "\u24DC\uFF4D\u1E3F\u1E41\u1E43\u0271\u026F",
  }, {
    base: 'n',
    chars: "\u24DD\uFF4E\u01F9\u0144\xF1\u1E45\u0148\u1E47\u0146\u1E4B\u1E49\u019E\u0272\u0149\uA791\uA7A5\u043B\u0509",
  }, {
    base: 'nj',
    chars: "\u01CC",
  }, {
    base: 'o',
    chars: "\u24DE\uFF4F\xF2\xF3\xF4\u1ED3\u1ED1\u1ED7\u1ED5\xF5\u1E4D\u022D\u1E4F\u014D\u1E51\u1E53\u014F\u022F\u0231\xF6\u022B\u1ECF\u0151\u01D2\u020D\u020F\u01A1\u1EDD\u1EDB\u1EE1\u1EDF\u1EE3\u1ECD\u1ED9\u01EB\u01ED\xF8\u01FF\uA74B\uA74D\u0275\u0254\u1D11",
  }, {
    base: 'oe',
    chars: "\u0153",
  }, {
    base: 'oi',
    chars: "\u01A3",
  }, {
    base: 'oo',
    chars: "\uA74F",
  }, {
    base: 'ou',
    chars: "\u0223",
  }, {
    base: 'p',
    chars: "\u24DF\uFF50\u1E55\u1E57\u01A5\u1D7D\uA751\uA753\uA755\u03C1",
  }, {
    base: 'q',
    chars: "\u24E0\uFF51\u024B\uA757\uA759",
  }, {
    base: 'r',
    chars: "\u24E1\uFF52\u0155\u1E59\u0159\u0211\u0213\u1E5B\u1E5D\u0157\u1E5F\u024D\u027D\uA75B\uA7A7\uA783",
  }, {
    base: 's',
    chars: "\u24E2\uFF53\u015B\u1E65\u015D\u1E61\u0161\u1E67\u1E63\u1E69\u0219\u015F\u023F\uA7A9\uA785\u1E9B\u0282",
  }, {
    base: 'ss',
    chars: "\xDF",
  }, {
    base: 't',
    chars: "\u24E3\uFF54\u1E6B\u1E97\u0165\u1E6D\u021B\u0163\u1E71\u1E6F\u0167\u01AD\u0288\u2C66\uA787",
  }, {
    base: 'th',
    chars: "\u00FE",
  }, {
    base: 'tz',
    chars: "\uA729",
  }, {
    base: 'u',
    chars: "\u24E4\uFF55\xF9\xFA\xFB\u0169\u1E79\u016B\u1E7B\u016D\xFC\u01DC\u01D8\u01D6\u01DA\u1EE7\u016F\u0171\u01D4\u0215\u0217\u01B0\u1EEB\u1EE9\u1EEF\u1EED\u1EF1\u1EE5\u1E73\u0173\u1E77\u1E75\u0289",
  }, {
    base: 'v',
    chars: "\u24E5\uFF56\u1E7D\u1E7F\u028B\uA75F\u028C",
  }, {
    base: 'vy',
    chars: "\uA761",
  }, {
    base: 'w',
    chars: "\u24E6\uFF57\u1E81\u1E83\u0175\u1E87\u1E85\u1E98\u1E89\u2C73",
  }, {
    base: 'x',
    chars: "\u24E7\uFF58\u1E8B\u1E8D",
  }, {
    base: 'y',
    chars: "\u24E8\uFF59\u1EF3\xFD\u0177\u1EF9\u0233\u1E8F\xFF\u1EF7\u1E99\u1EF5\u01B4\u024F\u1EFF",
  }, {
    base: 'z',
    chars: "\u24E9\uFF5A\u017A\u1E91\u017C\u017E\u1E93\u1E95\u01B6\u0225\u0240\u2C6C\uA763",
  }
];

var diacriticsMap = {};
for (var i = 0; i < replacementList.length; i += 1) {
  var chars = replacementList[i].chars;
  for (var j = 0; j < chars.length; j += 1) {
    diacriticsMap[chars[j]] = replacementList[i].base;
  }
}

function removeDiacritics(str) {
  return str.replace(/[^\u0000-\u007e]/g, function(c) {
    return diacriticsMap[c] || c;
  });
}

exports.replacementList = replacementList;
exports.diacriticsMap = diacriticsMap;


/***/ }),

/***/ "./node_modules/i18n-iso-countries/index.js":
/*!**************************************************!*\
  !*** ./node_modules/i18n-iso-countries/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const codes = __webpack_require__(/*! ./codes.json */ "./node_modules/i18n-iso-countries/codes.json");
const supportedLocales = __webpack_require__(/*! ./supportedLocales.json */ "./node_modules/i18n-iso-countries/supportedLocales.json");
const removeDiacritics = (__webpack_require__(/*! diacritics */ "./node_modules/diacritics/index.js").remove);
const registeredLocales = {};

/*
 * All codes map to ISO 3166-1 alpha-2
 */
const alpha2 = {},
  alpha3 = {},
  numeric = {},
  invertedNumeric = {};

codes.forEach(function (codeInformation) {
  const s = codeInformation;
  alpha2[s[0]] = s[1];
  alpha3[s[1]] = s[0];
  numeric[s[2]] = s[0];
  invertedNumeric[s[0]] = s[2];
});

/**
 * @private
 * @param {number} code
 */
function formatNumericCode(code) {
  return String("000" + (code ? code : "")).slice(-3);
}

/**
 * @private
 * Avoid using obj.hasOwnProperty directly as `hasOwnProperty` could be a
 * property in itself ({ hasOwnProperty: 1 }) and cause weird bugs
 * https://eslint.org/docs/rules/no-prototype-builtins
 */
function hasOwnProperty(object, property) {
  return Object.prototype.hasOwnProperty.call(object, property);
}

/**
 * @private
 * Pass localeList through a filter and return a newLocaleList obj
 * with the same structure of the old localeList.
 *
 * @param {LocalizedCountryNames} localeList  Local List in raw
 * @param {Function} filter    callback to set filter rule
 * @return {String | String[]} new filtered Local List
 */
function localeFilter(localeList, filter) {
  return Object.keys(localeList).reduce(function (newLocaleList, alpha2) {
    const nameList = localeList[alpha2];
    newLocaleList[alpha2] = filter(nameList, alpha2);
    return newLocaleList;
  }, {});
}

/**
 * @private
 * Preserve for getName & getNames
 *
 * @param {GetNameOptions.select} type all | official | alias
 * @param countryNameList  string array of country's
 *                         official name and alias
 * @return {String | String[]} of a country name
 */
function filterNameBy(type, countryNameList) {
  switch (type) {
    case "official":
      return Array.isArray(countryNameList)
        ? countryNameList[0]
        : countryNameList;

    case "all":
      return typeof countryNameList === "string"
        ? [countryNameList]
        : countryNameList;

    case "alias":
      return Array.isArray(countryNameList)
        ? countryNameList[1] || countryNameList[0]
        : countryNameList;

    default:
      throw new TypeError(
        "LocaleNameType must be one of these: all, official, alias!"
      );
  }
}

/**
 * Register countries in browsers' environment:
 * @param {object} localeData
 * @example countries.registerLocale(require("i18n-iso-countries/langs/en.json"));
 * @return void
 */
exports.registerLocale = function (localeData) {
  if (!localeData.locale) {
    throw new TypeError("Missing localeData.locale");
  }

  if (!localeData.countries) {
    throw new TypeError("Missing localeData.countries");
  }

  registeredLocales[localeData.locale] = localeData.countries;
};

/*
 * @param code Alpha-3 code
 * @return Alpha-2 code or undefined
 */
function alpha3ToAlpha2(code) {
  return alpha3[code];
}
exports.alpha3ToAlpha2 = alpha3ToAlpha2;

/*
 * @param code Alpha-2 code
 * @return Alpha-3 code or undefined
 */
function alpha2ToAlpha3(code) {
  return alpha2[code];
}
exports.alpha2ToAlpha3 = alpha2ToAlpha3;

/*
 * @param code Alpha-3 code
 * @return Numeric code or undefined
 */
function alpha3ToNumeric(code) {
  return invertedNumeric[alpha3ToAlpha2(code)];
}
exports.alpha3ToNumeric = alpha3ToNumeric;

/*
 * @param code Alpha-2 code
 * @return Numeric code or undefined
 */
function alpha2ToNumeric(code) {
  return invertedNumeric[code];
}
exports.alpha2ToNumeric = alpha2ToNumeric;

/*
 * @param code Numeric code
 * @return Alpha-3 code or undefined
 */
function numericToAlpha3(code) {
  const padded = formatNumericCode(code);
  return alpha2ToAlpha3(numeric[padded]);
}
exports.numericToAlpha3 = numericToAlpha3;

/*
 * @param code Numeric code
 * @return Alpha-2 code or undefined
 */
function numericToAlpha2(code) {
  const padded = formatNumericCode(code);
  return numeric[padded];
}
exports.numericToAlpha2 = numericToAlpha2;

/*
 * @param code ISO 3166-1 alpha-2, alpha-3 or numeric code
 * @return ISO 3166-1 alpha-3
 */
function toAlpha3(code) {
  if (typeof code === "string") {
    if (/^[0-9]*$/.test(code)) {
      return numericToAlpha3(code);
    }
    if (code.length === 2) {
      return alpha2ToAlpha3(code.toUpperCase());
    }
    if (code.length === 3) {
      return code.toUpperCase();
    }
  }
  if (typeof code === "number") {
    return numericToAlpha3(code);
  }
  return undefined;
}
exports.toAlpha3 = toAlpha3;

/*
 * @param code ISO 3166-1 alpha-2, alpha-3 or numeric code
 * @return ISO 3166-1 alpha-2
 */
function toAlpha2(code) {
  if (typeof code === "string") {
    if (/^[0-9]*$/.test(code)) {
      return numericToAlpha2(code);
    }
    if (code.length === 2) {
      return code.toUpperCase();
    }
    if (code.length === 3) {
      return alpha3ToAlpha2(code.toUpperCase());
    }
  }
  if (typeof code === "number") {
    return numericToAlpha2(code);
  }
  return undefined;
}
exports.toAlpha2 = toAlpha2;

/**
 * @param {string | number | Alpha2Code | Alpha3Code} code
 * @param {String} lang          language for country name
 * @param {GetNameOptions} options
 * @return {String | String[] | undefined}  name
 */
exports.getName = function (code, lang, options = {}) {
  if (!("select" in options)) {
    options.select = "official";
  }
  try {
    const codeMaps = registeredLocales[lang.toLowerCase()];
    const nameList = codeMaps[toAlpha2(code)];
    return filterNameBy(options.select, nameList);
  } catch (err) {
    return undefined;
  }
};

/**
 * @param {String} lang             language for country names
 * @param {GetNameOptions} options   getNames Options
 * @return {LocalizedCountryNames}  country code
 *                                  mapped to county name
 */
exports.getNames = function (lang, options = {}) {
  if (!("select" in options)) {
    options.select = "official";
  }
  const localeList = registeredLocales[lang.toLowerCase()];
  if (localeList === undefined) return {};
  return localeFilter(localeList, function (nameList) {
    return filterNameBy(options.select, nameList);
  });
};

/*
 * @param name name
 * @param lang language for country name
 * @return ISO 3166-1 alpha-2 or undefined
 */
exports.getAlpha2Code = function (name, lang) {
  const normalizeString = (string) => string.toLowerCase();
  const areSimilar = (a, b) => normalizeString(a) === normalizeString(b);

  try {
    const codenames = registeredLocales[lang.toLowerCase()];
    for (const p in codenames) {
      if (!hasOwnProperty(codenames, p)) {
        continue;
      }
      if (typeof codenames[p] === "string") {
        if (areSimilar(codenames[p], name)) {
          return p;
        }
      }
      if (Array.isArray(codenames[p])) {
        for (const mappedName of codenames[p]) {
          if (areSimilar(mappedName, name)) {
            return p;
          }
        }
      }
    }
    return undefined;
  } catch (err) {
    return undefined;
  }
};

/*
 * @param name name
 * @param lang language for country name
 * @return ISO 3166-1 alpha-2 or undefined
 */
exports.getSimpleAlpha2Code = function (name, lang) {
  const normalizeString = (string) => removeDiacritics(string.toLowerCase());
  const areSimilar = (a, b) => normalizeString(a) === normalizeString(b);

  try {
    const codenames = registeredLocales[lang.toLowerCase()];
    for (const p in codenames) {
      if (!hasOwnProperty(codenames, p)) {
        continue;
      }
      if (typeof codenames[p] === "string") {
        if (areSimilar(codenames[p], name)) {
          return p;
        }
      }
      if (Array.isArray(codenames[p])) {
        for (const mappedName of codenames[p]) {
          if (areSimilar(mappedName, name)) {
            return p;
          }
        }
      }
    }
    return undefined;
  } catch (err) {
    return undefined;
  }
};

/*
 * @return Object of alpha-2 codes mapped to alpha-3 codes
 */
exports.getAlpha2Codes = function () {
  return alpha2;
};

/*
 * @param name name
 * @param lang language for country name
 * @return ISO 3166-1 alpha-3 or undefined
 */
exports.getAlpha3Code = function (name, lang) {
  const alpha2 = exports.getAlpha2Code(name, lang);
  if (alpha2) {
    return exports.toAlpha3(alpha2);
  } else {
    return undefined;
  }
};

/*
 * @param name name
 * @param lang language for country name
 * @return ISO 3166-1 alpha-3 or undefined
 */
exports.getSimpleAlpha3Code = function (name, lang) {
  const alpha2 = exports.getSimpleAlpha2Code(name, lang);
  if (alpha2) {
    return exports.toAlpha3(alpha2);
  } else {
    return undefined;
  }
};

/*
 * @return Object of alpha-3 codes mapped to alpha-2 codes
 */
exports.getAlpha3Codes = function () {
  return alpha3;
};

/*
 * @return Object of numeric codes mapped to alpha-2 codes
 */
exports.getNumericCodes = function () {
  return numeric;
};

/*
 * @return Array of registered languages
 */
exports.langs = function () {
  return Object.keys(registeredLocales);
};

/*
 * @return Array of supported languages
 */
exports.getSupportedLanguages = function () {
  return supportedLocales;
};

/*
 * @param code ISO 3166-1 alpha-2, alpha-3 or numeric code
 * @return Boolean
 */
exports.isValid = function (code) {
  if (!code) {
    return false;
  }

  const coerced = code.toString().toUpperCase();
  return (
    hasOwnProperty(alpha3, coerced) ||
    hasOwnProperty(alpha2, coerced) ||
    hasOwnProperty(numeric, coerced)
  );
};


/***/ }),

/***/ "./node_modules/vue-tel-input/dist/vue-tel-input.css":
/*!***********************************************************!*\
  !*** ./node_modules/vue-tel-input/dist/vue-tel-input.css ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_clonedRuleSet_9_use_1_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_vue_tel_input_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./vue-tel-input.css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-tel-input/dist/vue-tel-input.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_vue_tel_input_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_vue_tel_input_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=0&id=08f4abee&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=0&id=08f4abee&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Detail_vue_vue_type_style_index_0_id_08f4abee_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Detail.vue?vue&type=style&index=0&id=08f4abee&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=0&id=08f4abee&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Detail_vue_vue_type_style_index_0_id_08f4abee_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Detail_vue_vue_type_style_index_0_id_08f4abee_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=1&id=08f4abee&scoped=true&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=1&id=08f4abee&scoped=true&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Detail_vue_vue_type_style_index_1_id_08f4abee_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Detail.vue?vue&type=style&index=1&id=08f4abee&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Customer/Detail.vue?vue&type=style&index=1&id=08f4abee&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Detail_vue_vue_type_style_index_1_id_08f4abee_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Detail_vue_vue_type_style_index_1_id_08f4abee_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=style&index=0&id=75fd909c&scoped=true&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=style&index=0&id=75fd909c&scoped=true&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RefundPopup_vue_vue_type_style_index_0_id_75fd909c_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./RefundPopup.vue?vue&type=style&index=0&id=75fd909c&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Payment/RefundPopup.vue?vue&type=style&index=0&id=75fd909c&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RefundPopup_vue_vue_type_style_index_0_id_75fd909c_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RefundPopup_vue_vue_type_style_index_0_id_75fd909c_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=style&index=0&id=50787864&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=style&index=0&id=50787864&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_PaymentMethod_vue_vue_type_style_index_0_id_50787864_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./PaymentMethod.vue?vue&type=style&index=0&id=50787864&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/PaymentMethod.vue?vue&type=style&index=0&id=50787864&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_PaymentMethod_vue_vue_type_style_index_0_id_50787864_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_PaymentMethod_vue_vue_type_style_index_0_id_50787864_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=style&index=0&id=585fc86a&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=style&index=0&id=585fc86a&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_QuotesSection_vue_vue_type_style_index_0_id_585fc86a_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./QuotesSection.vue?vue&type=style&index=0&id=585fc86a&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/QuotesSection.vue?vue&type=style&index=0&id=585fc86a&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_QuotesSection_vue_vue_type_style_index_0_id_585fc86a_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_QuotesSection_vue_vue_type_style_index_0_id_585fc86a_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=style&index=0&id=b4968c06&scoped=true&lang=css":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=style&index=0&id=b4968c06&scoped=true&lang=css ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RecentActivity_vue_vue_type_style_index_0_id_b4968c06_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./RecentActivity.vue?vue&type=style&index=0&id=b4968c06&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RecentActivity.vue?vue&type=style&index=0&id=b4968c06&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RecentActivity_vue_vue_type_style_index_0_id_b4968c06_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RecentActivity_vue_vue_type_style_index_0_id_b4968c06_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=style&index=0&id=5637d11a&scoped=true&lang=css":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=style&index=0&id=5637d11a&scoped=true&lang=css ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RelatedBriefSection_vue_vue_type_style_index_0_id_5637d11a_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./RelatedBriefSection.vue?vue&type=style&index=0&id=5637d11a&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Customer/Section/RelatedBriefSection.vue?vue&type=style&index=0&id=5637d11a&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RelatedBriefSection_vue_vue_type_style_index_0_id_5637d11a_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_RelatedBriefSection_vue_vue_type_style_index_0_id_5637d11a_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=style&index=0&id=03caa1b1&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=style&index=0&id=03caa1b1&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_TimeLineList_vue_vue_type_style_index_0_id_03caa1b1_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./TimeLineList.vue?vue&type=style&index=0&id=03caa1b1&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Lists/TimeLineList.vue?vue&type=style&index=0&id=03caa1b1&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_TimeLineList_vue_vue_type_style_index_0_id_03caa1b1_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_TimeLineList_vue_vue_type_style_index_0_id_03caa1b1_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=style&index=0&id=b8ed8cf0&scoped=true&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=style&index=0&id=b8ed8cf0&scoped=true&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_AmountColumn_vue_vue_type_style_index_0_id_b8ed8cf0_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./AmountColumn.vue?vue&type=style&index=0&id=b8ed8cf0&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Payments/AmountColumn.vue?vue&type=style&index=0&id=b8ed8cf0&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_AmountColumn_vue_vue_type_style_index_0_id_b8ed8cf0_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_AmountColumn_vue_vue_type_style_index_0_id_b8ed8cf0_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=style&index=0&id=118e72b8&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=style&index=0&id=118e72b8&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Popup_vue_vue_type_style_index_0_id_118e72b8_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Popup.vue?vue&type=style&index=0&id=118e72b8&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=style&index=0&id=118e72b8&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Popup_vue_vue_type_style_index_0_id_118e72b8_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Popup_vue_vue_type_style_index_0_id_118e72b8_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=style&index=0&id=ef55f284&lang=css":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=style&index=0&id=ef55f284&lang=css ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_CustomerPopup_vue_vue_type_style_index_0_id_ef55f284_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./CustomerPopup.vue?vue&type=style&index=0&id=ef55f284&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/CustomerPopup.vue?vue&type=style&index=0&id=ef55f284&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_CustomerPopup_vue_vue_type_style_index_0_id_ef55f284_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_CustomerPopup_vue_vue_type_style_index_0_id_ef55f284_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=style&index=0&id=e27c74de&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=style&index=0&id=e27c74de&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_DeletePopup_vue_vue_type_style_index_0_id_e27c74de_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./DeletePopup.vue?vue&type=style&index=0&id=e27c74de&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=style&index=0&id=e27c74de&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_DeletePopup_vue_vue_type_style_index_0_id_e27c74de_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_DeletePopup_vue_vue_type_style_index_0_id_e27c74de_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=style&index=0&id=5272debe&scoped=true&lang=css":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=style&index=0&id=5272debe&scoped=true&lang=css ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_PasswordPopup_vue_vue_type_style_index_0_id_5272debe_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./PasswordPopup.vue?vue&type=style&index=0&id=5272debe&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/PasswordPopup.vue?vue&type=style&index=0&id=5272debe&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_PasswordPopup_vue_vue_type_style_index_0_id_5272debe_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_PasswordPopup_vue_vue_type_style_index_0_id_5272debe_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=style&index=0&id=c6b47b60&scoped=true&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=style&index=0&id=c6b47b60&scoped=true&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Title_vue_vue_type_style_index_0_id_c6b47b60_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Title.vue?vue&type=style&index=0&id=c6b47b60&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Title.vue?vue&type=style&index=0&id=c6b47b60&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Title_vue_vue_type_style_index_0_id_c6b47b60_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Title_vue_vue_type_style_index_0_id_c6b47b60_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=style&index=0&id=5c57ca7b&scoped=true&lang=css":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=style&index=0&id=5c57ca7b&scoped=true&lang=css ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Tooltip_vue_vue_type_style_index_0_id_5c57ca7b_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../../node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!../../../../../../node_modules/vue-loader/dist/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Tooltip.vue?vue&type=style&index=0&id=5c57ca7b&scoped=true&lang=css */ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=style&index=0&id=5c57ca7b&scoped=true&lang=css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Tooltip_vue_vue_type_style_index_0_id_5c57ca7b_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_clonedRuleSet_9_use_1_node_modules_vue_loader_dist_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_9_use_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Tooltip_vue_vue_type_style_index_0_id_5c57ca7b_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./node_modules/vue-country-flag-next/dist/country-flag.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/vue-country-flag-next/dist/country-flag.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");


function styleInject(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}

var css_248z = ".flag{width:52px;height:39px;display:inline-block;background:url(data:image/png;base64,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