<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddModelToUserActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_activities', function (Blueprint $table) {
            $table->text('activity_desc')->change();
            $table->string('activity_type')->nullable()->change();
            $table->unsignedBigInteger('model_id')->after('user_id');
            $table->string('model_type')->after('model_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_activities', function (Blueprint $table) {
            $table->string('activity_desc')->change();
            $table->string('activity_type')->change();
            $table->dropColumn('model_id');
            $table->dropColumn('model_type');
        });
    }
}
