<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('phone');
            $table->string('email');
            $table->dateTime('date_time');
            $table->string('industry');
            $table->text('description');
            $table->string('lead_type');
            $table->string('lead_source');
            $table->string('lead_status');
            // $table->string('contact_medium');
            $table->unsignedTinyInteger('probability');
            $table->bigInteger('salesperson')->unsigned()->index();
            $table->foreign('salesperson')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->string('rating');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leads');
    }
}
