<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class UpdateCouponTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::dropIfExists('coupons');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('description');
            $table->string('coupon_id');
            $table->integer('discount')->nullable();
            $table->enum('discount_type', ['percent', 'flat'])->default('flat');
            $table->string('duration');
            $table->date('date_from')->nullable();
            $table->date('date_to')->nullable();
            $table->text('data')->nullable();
            $table->foreignId('currency')->constrained('country_currencies');

            $table->bigInteger('created_by')->unsigned()->index()->nullable();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');

            $table->bigInteger('updated_by')->unsigned()->index()->nullable();
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
}
