<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_logs', function (Blueprint $table) {
            //payment_link_id, Activity, type(Initiated, Process, Succeeded), request, response, created_at

            $table->id();
            $table->morphs('loggable');
            $table->string('activity');
            $table->string('type');
            $table->text('request')->nullable();
            $table->text('response')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->boolean('pin')->default(0);
            $table->unsignedSmallInteger('code')->default(200);
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_logs');
    }
}
