<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id')->index();
            $table->unsignedBigInteger('payment_link_id')->index();
            $table->unsignedFloat('price');
            $table->unsignedFloat('discount')->nullable();
            $table->unsignedBigInteger('currency')->index();
            $table->string('ip', 40)->nullable();
            $table->string('intent_id')->nullable();
            $table->string('charge_id')->nullable();
            $table->text('charge')->nullable();
            $table->text('refund')->nullable();
            $table->text('intent')->nullable();
            $table->text('paymentMethod')->nullable();
            $table->string('last_four', 4)->default('');
            $table->text('device')->nullable();
            $table->text('location')->nullable();
            $table->text('bin')->nullable();
            $table->unsignedBigInteger('coupon_id')->index()->nullable();
            $table->unsignedFloat('converted_amount');
            $table->text('comment')->nullable();
            $table->text('gateway_message')->nullable();
            $table->unsignedSmallInteger('status')->default(1);

            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('payment_link_id')->references('id')->on('payment_links')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('currency')->references('id')->on('country_currencies')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('cascade')->onUpdate('cascade');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
