<?php

namespace App\Traits;

use Illuminate\Support\Facades\Cache;
use App\Models\Setting;
use Illuminate\Support\Arr;

trait ApplicationTrait
{

  public function get_setting($key_name = null)
  {

    if ($key_name == null) {
      return Setting::all()->pluck('value', 'key');
    }

    if (cache::has('brandSettings')) {
      $brand_settings = cache::get('brandSettings');
    } else {
      $brand_settings = Cache::remember('brandSettings', 86400, function () {
        return Setting::all()->toArray();
      });
    }

    $find = Arr::where($brand_settings, function ($value, $key) use ($key_name) {
      if ($value["key"] == $key_name) {
        return $value["value"];
      }
    });

    if (!empty($find)) {
      return head($find)["value"];
    } else {
      return null;
    }
  }
}
