<?php

namespace App\Services;

use Exception;
use Illuminate\Support\Facades\Log;
use Stripe\Exception\AuthenticationException;
use Stripe\Exception\ApiErrorException;
use Stripe\Exception\CardException;
use Stripe\Exception\RateLimitException;
use Stripe\Exception\InvalidRequestException;
use Stripe\Exception\ApiConnectionException;

class StripeExceptionHandler
{
    public static function handle(Exception $e, $token="")
    {
        if (
            $e instanceof AuthenticationException ||
            $e instanceof ApiErrorException ||
            $e instanceof CardException ||
            $e instanceof RateLimitException ||
            $e instanceof InvalidRequestException ||
            $e instanceof ApiConnectionException
        ) {
            Log::error("Token: ".$token." has an exception on ".get_class($e).". Message: ".$e->getMessage());
            
            $detailedError = explode('|', $e->getMessage());
            
            return response()->json([
                'stripe' => true,
                'message' => (count($detailedError) > 1) ? $detailedError[2] : $e->getMessage(),
                'code' => (count($detailedError) > 1) ? $detailedError[0].':'.$detailedError[1] : $e->getError()->code,
            ]);
            
        } else {
            Log::error("Token: ".$token." has an exception on ".get_class($e).". Message: ".$e->getMessage());
            
            $detailedError = explode('|', $e->getMessage());
            
            return response()->json([
                'stripe' => true,
                'message' => (count($detailedError) > 1) ? $detailedError[2] : $e->getMessage(),
                'code' => (count($detailedError) > 1) ? $detailedError[0].':'.$detailedError[1] : $e->getCode(),
            ]);
        }
    }
}
