<?php

namespace App\Services;

use App\Repositories\SmmBrief\SmmBriefRepository;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SmmBriefService
{

    private $smmBriefRepository, $streakService;

    public function __construct(SmmBriefRepository $smmBriefRepository, StreakService $streakService)
    {
        $this->smmBriefRepository = $smmBriefRepository;
        $this->streakService = $streakService;

    }

    public function create($briefDetails)
    {
        try {
            $brief = $this->smmBriefRepository->createBrief($briefDetails);

            $this->streakService->createBox([
                "name" => $data['name'] ?? '',
                "company_name" => $brief['business_name'] ?? '',
                "phone_number" => $brief['phone_number'] ?? '',
                "industry" => $brief['industry'] ?? '',
                "brief_url" => !empty($brief['encoded_id']) ? route('frontend.smm.brief.view', $brief['encoded_id']) : '',
                "email" => $brief['email'] ?? '',
            ]);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function list(Request $request)
    {
        try {
            $briefs = $this->smmBriefRepository->getAllBriefs($request);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetchByEncodedID($briefID, $authenticated = false)
    {
        try {
            $brief = $this->smmBriefRepository->getByEncodedID($briefID, $authenticated);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getBrief($id)
    {
        try {
            $brief = $this->smmBriefRepository->getBrief($id);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

}