<?php

namespace App\Services\Payment\Stripe;

use App\Services\StripeErrorHandler;
use Exception;

class Charge extends Stripe
{
    public function get($chargeId)
    {
        try {
            $this->paymentSetting();
            $charge = $this->stripe->charges->retrieve($chargeId);

            return $charge;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }
}
