<?php

namespace App\Services;

use Illuminate\Support\Arr;

class MetadataService
{
    protected $model;
    protected $columnName;

    public function __construct($model, $columnName)
    {
        $this->model = $model;
        $this->columnName = $columnName;
    }

    /**
     * Update metadata for a given model.
     *
     * @param mixed $data
     * @return void
     */
    public function update($data)
    {
        $metadata = Arr::pluck($data, 'value', 'key');
        $modelObj = $this->model->{$this->columnName} ? json_decode($this->model->{$this->columnName}, true) : [];

        $modelObj['metadata'] = $metadata;
        $this->model->update([$this->columnName => json_encode($modelObj)]);
    }
}
