<?php

namespace App\Services;

use App\Repositories\Payment\Log\LogRepository;

class LogService
{
    private $logger;

    function __construct(LogRepository $logger)
    {
        $this->logger = $logger;
    }

    function log($class, $data, $routeTo = "", $event ="")
    {
        $logClass = $this->quoteClasses($class);
        $data['loggable_type'] = $logClass['class'];
        
        if($event != "") {
            $data['event'] = $event;
        }

        $log = $this->logger->log($data);
        $log = $log->refresh();

        if ($routeTo) {
            $log->route = $routeTo;
        } else {
            $log->route = $logClass['route'];
        }

        return $log;
    }

    function update($id, $data, $routeTo = "")
    {
        $logClass = $this->quoteClasses($data['log_type']);
        if (isset($data['log_type'])) {
            unset($data['log_type']);
        }
        $data['loggable_type'] = $logClass['class'];
        $log = $this->logger->updateLog($id, $data);
        $log = $log->refresh();

        if ($routeTo) {
            $log->route = $routeTo;
        } else {
            $log->route = $logClass['route'];
        }

        return $log;
    }

    function delete($id, $type, $routeTo = "")
    {
        $logClass = $this->quoteClasses($type);
        $this->logger->deleteLog($id);
        $log['route'] = $logClass['route'];

        if ($routeTo) {
            $log['route'] = $routeTo;
        } else {
            $log['route'] = $logClass['route'];
        }


        return $log;
    }

    function getLogsByPaymentId($id, $type)
    {
        $logClass = $this->quoteClasses($type);
        $log = $this->logger->getLog($id);
        $log = $log->refresh();
        $log->route = $logClass['route'];

        return $log;
    }

    function pinLog($pinLogID, $paymentLinkID, $type, $pin = '', $routeTo = "")
    {
        $logClass = $this->quoteClasses($type);
        $log = $this->logger->pinLog($pinLogID, $paymentLinkID, $pin);
        $log = $log->refresh();

        if ($routeTo) {
            $log->route = $routeTo;
        } else {
            $log->route = $logClass['route'];
        }
        return $log;
    }

    function quoteClasses($class)
    {
        $commentable = [
            'customer' => [
                'route' => 'admin.customer.detail',
                'class' => 'App\Models\User'
            ],
            'payment' => [
                'route' => 'admin.payment.detail.id',
                'class' => 'App\Models\Payment'
            ],
            'payment_link' => [
                'route' => 'admin.payment.linkgenerator.list',
                'class' => 'App\Models\PaymentLink'
            ],
            'invoice' => [
                'route' => 'admin.invoice.list',
                'class' => 'App\Models\Invoice'
            ],
            'lead' => [
                'route' => 'admin.lead.detail.id',
                'class' => 'App\Models\Lead'
            ],
            'mobile_app_brief' => [
                'route' => 'app.brief-detail.detail',
                'class' => 'App\Models\MobileAppBrief'
            ],
            'smm_brief' => [
                'route' => 'smm.brief-detail.detail',
                'class' => 'App\Models\SmmBrief'
            ],
            'sem_brief' => [
                'route' => 'sem.brief-detail.detail',
                'class' => 'App\Models\SemBrief'
            ],
            'web_brief' => [
                'route' => 'web.brief-detail.detail',
                'class' => 'App\Models\WebBrief'
            ],
            'brief' => [
                'route' => 'brief-detail.detail',
                'class' => 'App\Models\Brief'
            ],
            'video_brief' => [
                'route' => 'video.brief-detail.detail',
                'class' => 'App\Models\VideoBrief'
            ],
            
        ];

        return $commentable[$class];
    }

    function eventStatus($activity, $paymentID, $response, $createdBy)
    {
        $data = array(
            'activity' => $activity,
            'type' => 'payment.intent.status',
            'request' => response()->json([])->content(),
            'response' => $response,
            'code' => 200,
            'loggable_id' => $paymentID,
            'created_by' => $createdBy,
            'event' => 1,
        );

        $logClass = $this->quoteClasses('payment');
        $data['loggable_type'] = $logClass['class'];
        
        $log = $this->logger->log($data);
        $log = $log->refresh();

        return $log;
    }
}
