<?php
namespace App\Services;

use Illuminate\Support\Facades\Http;
use Exception;

class BinApiService {
  private $userID, $apiKey, $url;

  function __construct()
  {
    $this->userID = env('NEUTRINO_USER_ID');
    $this->apiKey = env('NEUTRINO_API_KEY');  
    $this->url = 'https://neutrinoapi.net/';
  }

  function binLookup($first8Digits, $ip) {
    try {
      $binDetail = Http::withHeaders([
        'User-ID' => $this->userID,
        'API-Key' => $this->apiKey
      ])->get("{$this->url}bin-lookup?bin-number={$first8Digits}&ip={$ip}");
      
      return $binDetail->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  function ipInfo($ip) {
    try {
      $ipInfo = Http::withHeaders([
        'User-ID' => $this->userID,
        'API-Key' => $this->apiKey
      ])->get("{$this->url}ip-info?ip={$ip}");
      
      return $ipInfo->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  function userAgent($userAgent) {
    try {
      $binDetail = Http::withHeaders([
        'User-ID' => $this->userID,
        'API-Key' => $this->apiKey
      ])->get("{$this->url}ua-lookup?ua={$userAgent}");
      
      return $binDetail->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  function ipBlocklist($ip, $vpnLookup = false) {
    try {
      $ipBlocklist = Http::withHeaders([
        'User-ID' => $this->userID,
        'API-Key' => $this->apiKey
      ])->get("{$this->url}ip-blocklist?ip={$ip}&vpn-lookup={$vpnLookup}");
      
      return $ipBlocklist->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  function emailVerify($email, $fixTypos = false) {
    try {
      $ipBlocklist = Http::withHeaders([
        'User-ID' => $this->userID,
        'API-Key' => $this->apiKey
      ])->get("{$this->url}email-validate?email={$email}&fix-typos={$fixTypos}");
      
      return $ipBlocklist->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  function geolocate($address, $houseNumber = "", $street = "", $city, $county="", $state, $postalCode, $countryCode, $languageCode ='en', $fuzzySearch= false) {
    try {
      $geolocate = Http::withHeaders([
        'User-ID' => $this->userID,
        'API-Key' => $this->apiKey
      ])->get("{$this->url}geocode-address?address={$address}&house-number={$houseNumber}&street={$street}&city={$city}&county={$county}&state={$state}&postalCode={$postalCode}&countryCode={$countryCode}&languageCode={$languageCode}&fuzzy-search={$fuzzySearch}");
      
      return $geolocate->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  public function reverseGeocode($latitude, $longitude)
  {
    try {
        $response = Http::withHeaders([
            'User-ID' => $this->userID,
            'API-Key' => $this->apiKey
        ])->get("{$this->url}geocode-reverse", [
            'latitude' => $latitude,
            'longitude' => $longitude,
            'language-code' => 'en', // Optional: specify language code if needed
        ]);

        return $response->json();
    } catch (Exception $ex) {
        return response()->json([
            "code" => $ex->getCode(),
            "message" => $ex->getMessage()
        ]);
    }
  }

}