<?php 

namespace App\Repositories\Quotes;

use App\Models\Quotes;
use Exception;

class QuotesRepository implements QuotesInterface {
  
  private $quotes;

  function __construct(Quotes $quotes)
  {
    $this->quotes = $quotes;  
  }

  // Log payment
  public function quote($class, $data) {
      $quoteClass = $this->quoteClasses($class);
      $data['commentable_type'] = $quoteClass['class'];
      $quote = $this->quotes->create($data);
      $quote = $quote->refresh();
      $quote->route = $quoteClass['route'];
      
      return $quote;
  }

  // Update payment log
  public function update($id, $data) {
    $quoteClass = $this->quoteClasses($data['type']);
    $data['commentable_type'] = $quoteClass['class'];
    unset($data['type']);
    
    $quote = $this->quotes->whereId($id);
    $quote->update($data);
    $quote = $quote->first()->refresh();

    $quote->route = $quoteClass['route'];
      
    return $quote;
  }

  // Delete payment log
  public function delete($id, $class) {
    $quoteClass = $this->quoteClasses($class);
    $this->quotes->whereId($id)->delete();
    
    return $quoteClass;
  }

  // View payment log
  public function get($id, $classWiseID = []) {
    return $this->quotes->whereId($id)->first();
  }

  // List payment log
  public function quotes($condition="") {
    $quote = $this->quotes;
    
    if($condition != "") {
      $quote->where($condition);
    }

    return $quote->get();
  }

  function quoteClasses($class) {
    $commentable = [
      'customer' => [
        'route' => 'admin.customer.detail',
        'class' => 'App\Models\User'
      ],
      'payment' => [
        'route' => 'admin.payment.detail.id',
        'class' => 'App\Models\Payment'
      ],
      'payment_link' => [
        'route' => 'admin.payment.linkgenerator.list',
        'class' => 'App\Models\PaymentLink'
      ],
      'lead' => [
        'route' => 'admin.lead.detail.id',
        'class' => 'App\Models\Lead'
      ],
    ];

    return $commentable[$class];
  }
}