<?php

namespace App\Repositories\Payment;

use App\Models\Payment;

class PaymentRepository implements PaymentInterface
{
  private $paymentModel;

  public function __construct(Payment $paymentModel)
  {
    $this->paymentModel = $paymentModel;
  }

  public function create($data)
  {
    $payment = $this->paymentModel->create($data);
    $payment = $payment->refresh();

    return $payment;
  }

  public function update($id, $data)
  {
    $payment = $this->paymentModel::find($id);
    $payment->update($data);
    $payment = $payment->refresh();

    return $payment;
  }

  public function retrieve($id)
  {
    $payment = $this->paymentModel::find($id);

    return $payment;
  }

  public function list($conditions = [])
  {
    $payments = $this->paymentModel::query();

    if (!empty($conditions)) {
      foreach ($conditions as $key => $value) {
        $payments->where($key, $value);
      }
    }

    return $payments->get();
  }

  public function delete($id)
  {
    $payment = $this->paymentModel::find($id);

    if ($payment->delete()) {
      return true;
    } else {
      return false;
    }
  }
}
