<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class UserActivityDetail extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_activity_id',
        'old_value',
        'new_value'
    ];

    public function user_activity()
    {
        return $this->belongsTo(UserActivity::class);
    }

    public function getOldValueAttribute($value)
    {
        return $value ? Crypt::decryptString($value) : null;
    }

    public function getNewValueAttribute($value)
    {
        return $value ? Crypt::decryptString($value) : null;
    }
}
