<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BriefLink extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'data',
        'status'
    ];

    private $briefTypes = [
        'logo_brief',
        'web_brief',
        'video_brief',
        'smm_brief',
        'sem_brief',
        'mobile_app_brief',
    ];

    public function briefLinkLog()
    {
        return $this->morphMany(BriefLog::class, 'brief');
    }

    public function getBriefTypes(){
        return $this->briefTypes;
    }


    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    public function salesPerson()
    {
        return $this->belongsTo(User::class, 'salesperson_id', 'id');
    }

}
