<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\Setting;

class InvoiceEmail extends Mailable
{
  use Queueable, SerializesModels;

  public $invoice;

  /**
   * Create a new message instance.
   *
   * @return void
   */
  public function __construct($invoice)
  {
    $this->invoice = $invoice;
  }

  /**
   * Build the message.
   *
   * @return $this
   */
  public function build()
  {
    $logo = Setting::where("key", '=', "logo")->get()->first();
    $company_name = Setting::where("key", '=', "company_name")->get()->first();
    $company_email = Setting::where("key", '=', "company_email")->get()->first();
    $company_number = Setting::where("key", '=', "company_number")->get()->first();

    $brand_settings = array(
      "logo" => $logo->value,
      "company_name" => $company_name->value,
      //"company_email" => $company_email->value,
      //"company_number" => $company_number->value,
    );


    $subject = "Payment Invoice | " . @$brand_settings["company_name"];

    return $this->from('', 'Testing')
      ->subject($subject)
      ->view('frontend.payments.invoice')->with([
        "brand_settings" => $brand_settings,
        'invoice' => $this->invoice
      ]);
  }
}
