<?php

namespace App\Jobs;

use App\Models\PaymentLink;
use Carbon\Carbon;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ExpirePaymentLinks implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            $currentTimeStamp = Carbon::now()->timestamp;
    
            $links = PaymentLink::where('status', 1)
                    ->where('valid_till', '<', $currentTimeStamp)
                    ->update([
                        'status' => 6
                    ]);
        } catch(Exception $ex) {
            throw $ex;
        }
    }
}
