<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CouponRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id' => 'nullable|integer',
            'description' => 'required_without:id|string',
            'type' => 'required_without:id|in:percent,flat|string',
            'discount' => 'required_without:id|integer',
            'currency' => 'required_without:id|exists:country_currencies,id',
            'date_from' => 'nullable|date',
            'date_to' => 'nullable|date',
            'duration' => 'required_without:id|in:once,forever,multiple_months',
            'duration_months' => 'required_without:id|required_if:duration,multiple_months|integer|min:1|max:12',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'description.required_without' => 'The description field is required.',
            'description.string' => 'The description must be a string.',
            'type.required_without' => 'The type field is required.',
            'type.in' => 'The type field must be either "percent" or "flat".',
            'discount.required_without' => 'The discount field is required.',
            'discount.integer' => 'The discount must be an integer.',
            'discount.min' => 'The discount must be at least 1.',
            'discount.max' => 'The discount may not be greater than 100.',
            'currency.required_without' => 'The currency field is required.',
            'currency.exists' => 'The selected currency is invalid.',
            'date_from.date' => 'The date from must be a valid date.',
            'date_to.date' => 'The date to must be a valid date.',
            'duration.required_without' => 'The duration field is required.',
            'duration.in' => 'The selected duration is invalid.',
            'duration_months.required_if' => 'The duration months field is required when duration is months.',
            'duration_months.integer' => 'The duration months must be an integer.',
            'duration_months.min' => 'The duration months must be at least 1.',
            'duration_months.max' => 'The duration months may not be greater than 12.',
        ];
    }
}
