<?php

namespace App\Http\Middleware;

use Carbon\Carbon;
use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class CheckTwoFactorAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        if ($user && $user->two_step == 1 && $user->google2fa_secret === null && $user->two_step_checked === null) {
            return redirect()->route('admin.2fa');
        } else if($user && $user->two_step == 1 && $user->google2fa_secret === null && Carbon::parse($user->two_step_checked)->lessThan(Carbon::now()->subWeek())){
            return redirect()->route('admin.2fa');
        } else {
            return $next($request);
        }
        
    }
}
