<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\UserActivity;
use Inertia\Inertia;
use Illuminate\Support\Facades\Auth;
use APP\Models\User;


class UserActivityController extends Controller
{
    public function showUserActivities(Request $request, $userId)
    {
        $user = $request->user();

        // Check if role is not super admin
        if (Auth::check() && !$user->hasRole('Super Admin')) {
            return response()->json(['error' => 'Unauthorized Role'], 403);
        }

        // Fetch paginated activities
        $activities = UserActivity::with('user_activity_details')
            ->where('user_id', $userId)
            ->orderBy('created_at', 'desc')
            ->paginate(5) // Adjust items per page
            ->withQueryString();

        // Initialize an empty array for transformed activities
        $transformedActivities = [];

        // Transform data while keeping pagination metadata
        foreach ($activities as $activity) {
            $transformedActivities[] = [
                'id' => $activity->id,
                'user_id' => $activity->user_id,
                'activity_type' => $activity->activity_type,
                'activity_desc' => $activity->activity_desc,
                'details' => $activity->user_activity_details->map(function ($detail) {
                    return [
                        'old_value' => $detail->old_value, // Assuming these are already decrypted
                        'new_value' => $detail->new_value, // Assuming these are already decrypted
                        'created_at' => $detail->created_at->toDateTimeString()
                    ];
                }),
                'created_at' => $activity->created_at->toDateTimeString()
            ];
        }

        // Return response with pagination metadata and transformed data
        return response()->json([
            'data' => $transformedActivities,
            'meta' => [
                'current_page' => $activities->currentPage(),
                'last_page' => $activities->lastPage(),
                'per_page' => $activities->perPage(),
                'total' => $activities->total(),
                'prev_page_url' => $activities->previousPageUrl(),
                'next_page_url' => $activities->nextPageUrl(),
            ]
        ]);
    }




}
