<?php
namespace App\Helper;

class PaymentHelper {
  public static function itemArray($paymentDetails)
  {
      if (is_array($paymentDetails)) {
          return [
              "first_name" => $paymentDetails['firstname'],
              "last_name" => $paymentDetails['lastname'],
              "email" => $paymentDetails['clientemail'],
              "phone" => $paymentDetails['phonenum'],
              "address" => $paymentDetails['address'],
              "company" => $paymentDetails['companyname'],
              "country" => $paymentDetails['country'],
              "state" => $paymentDetails['statename'],
              "city" => $paymentDetails['city'],
              "zipcode" => $paymentDetails['zipcode'],
              "cardNo" => $paymentDetails['cardNo'] ?? '',
              //"expDate" => $paymentDetails['exp-date'],
              "card_cvc" => $paymentDetails['cvc'] ?? '',
              "amount" => $paymentDetails['itemprice'],
              "item_name" => $paymentDetails['itemname'],
              "token" => $paymentDetails['token'],
              "discount" => $paymentDetails['discount'],
              "original_amount" => $paymentDetails['original_amount'],
              "gateway" => $paymentDetails['payment_gateway'],
              "currency" => $paymentDetails['currency'],
              "coupon_id" => $paymentDetails['coupon_id'],
              "payment_error" => $paymentDetails['payment_error'],
              "payment_message" => $paymentDetails['payment_message'],
              "payment_response" => $paymentDetails['payment_response'],
              "ThreeDSecure_Popup" => $paymentDetails['ThreeDSecure_Popup'],
              "cardValidity" => $paymentDetails['cardValidity'] ?? '',
              "cardExp_month" => $paymentDetails['month'] ?? '',
              "cardExp_year" => $paymentDetails['year'] ?? ''
          ];
      }

      return [];
  }

  public static function claimCoupon($itemAmount, $discount, $discountType) {
    $data['amount'] = $itemAmount;

    if ($discountType == 'percent') {
        $data['amount'] =  $itemAmount - ($itemAmount * ($discount / 100));
        $data['discountType'] = 'percentage';
    } else {
        $data['amount'] = $itemAmount - $discount;
        $data['discountType'] = $discountType;
    }

    $data['discount'] = $discount;

    return $data;
  }
}