<?php

namespace App\Helper\Helper;

use App\Models\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\QuickNotify;
use Spatie\Permission\Models\Role;

class NotificationHelper {
    public static function notify(string $type, string $message, array $notification, int $sendTo) {
      
      $recipient = User::find($sendTo);
      
      // if ($recipient->hasRole('Salesperson')) {
      //     $management = User::whereHas('roles', function ($query) {
      //       $query->where('name', 'Admin');
      //       $query->orWhere('name', 'Super Admin');
      //     })->orWhere(function ($query) use ($sendTo) {
      //       $query->whereHas('roles', function ($subQuery) {
      //           $subQuery->where('name', 'Brand Manager')
      //           ->orWhere('name', 'Salesperson');
      //       });
      //     })->whereDoesntHave('roles', function ($query) {
      //         $query->where('name', 'Admin');
      //     })->get();

      //     if ($type == "payment" || $type == "payment-failed") {
      //       $qaManagement = User::whereHas('roles', function ($query) {
      //           $query->where('name', 'Quality Assurance');
      //       })->get();
      //       $management = $management->merge($qaManagement);
      //     }

      // } 
      
    //   if($recipient->hasRole('Brand Manager')) {
    //     $rolesWithNotificationGlobalPermission = Role::whereHas('permissions', function ($query) {
    //       $query->where('name', 'Notification-Global');
    //   })->pluck('name')->toArray();

    //   $rolesWithoutNotificationGlobalPermission = Role::whereDoesntHave('permissions', function ($query) {
    //     $query->where('name', 'Notification-Global');
    // })->pluck('name')->toArray();

    //     $management = User::whereHas('roles', function ($query) use ($rolesWithNotificationGlobalPermission) {
    //       $query->whereIn('name', $rolesWithNotificationGlobalPermission);
    //       $query->orWhere('name', 'Super Admin');
    //       })->orWhere(function ($query) use ($sendTo, $rolesWithoutNotificationGlobalPermission) {
    //           $query->whereHas('roles', function ($subQuery) use ($rolesWithoutNotificationGlobalPermission) {
    //               $subQuery->where('name', 'Brand Manager')
    //               ->orWhereIn('name', $rolesWithoutNotificationGlobalPermission);
    //           })->where('id', $sendTo);
    //       })->whereDoesntHave('roles', function ($query) {
    //         $query->where('name', 'Admin');
    //     })->get();

    //     // if ($type == "payment" || $type == "payment-failed") {
    //     //   $qaManagement = User::whereHas('roles', function ($query) {
    //     //       $query->where('name', 'Quality Assurance');
    //     //   })->get();
    //     //   $management = $management->merge($qaManagement);
    //     // }

    //   }
    
    if ($type == "role") {
      $management = User::all();
    } else if ($type == "coupon-feature") {
      $management = User::all();
    } else if ($type == "activitieslog-feature") {
      $management = User::all();
    } else if ($type == "role-feature") {

      $management = User::whereHas('roles', function ($query) {
        $query->where('name', 'Super Admin');
      })->get();

    } else {
        if($recipient->hasRole('Super Admin')){

          $management = User::whereHas('roles', function ($query) {
            $query->where('name', 'Super Admin');
          })->get();

        } else {
          $userRole = $recipient?->roles?->first()?->name;
          if($recipient->can('Notification-Global')){
            $management = User::whereHas('roles', function ($query) use ($userRole) {
              $query->where('name', $userRole);
              $query->orWhere('name', 'Super Admin');
            })->get();
    
            // if ($type == "payment" || $type == "payment-failed") {
            //   $qaManagement = User::whereHas('roles', function ($query) {
            //       $query->where('name', 'Quality Assurance');
            //   })->get();
            //   $management = $management->merge($qaManagement);
            // }
          } else {

            $rolesWithNotificationGlobalPermission = Role::whereHas('permissions', function ($query) {
              $query->where('name', 'Notification-Global');
          })->pluck('name')->toArray();

            $management = User::whereHas('roles', function ($query) use ($rolesWithNotificationGlobalPermission) {
              $query->whereIn('name', $rolesWithNotificationGlobalPermission);
              $query->orWhere('name', 'Super Admin');
            })->orWhere(function ($query) use ($sendTo, $userRole) {
              $query->whereHas('roles', function ($subQuery) use ($userRole) {
                  $subQuery->where('name', $userRole);
              });
            })->whereDoesntHave('roles', function ($query) {
                $query->where('name', 'Admin');
            })->get();
    
            // if ($type == "payment" || $type == "payment-failed") {
            //   $qaManagement = User::whereHas('roles', function ($query) {
            //       $query->where('name', 'Quality Assurance');
            //   })->get();
            //   $management = $management->merge($qaManagement);
            // }
          }
        }
      }

        $notify = [
            'performed_by' => $sendTo,
            'title' => $type,
            'message' => $message,
            'type' => $type,
            'data' => $notification,
        ];

        Notification::send($management, new QuickNotify($notify));
    }
}
