<?php
namespace App\Helper;

use App\Models\UserActivity;
use App\Models\UserActivityDetail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;

class ActivityLogHelper
{

    public static function logActivityByTitle($userId, $activityType, $activityDesc, $updatedFields = null)
    {
        $activityDesc = $updatedFields ? "$activityDesc: " . implode(', ', $updatedFields) : $activityDesc;

        UserActivity::create([
            'user_id' => $userId,
            'activity_type' => $activityType,
            'activity_desc' => $activityDesc,
        ]);
    }

    public static function staticLogActivity($activityType, $activityDesc)
    {
        if (Auth::check()) {
            $user = Auth::user();

            UserActivity::create([
                'user_id' => $user->id,
                'activity_type' => $activityType,
                'activity_desc' => $activityDesc,
            ]);
        }
    }

    // THIS FUNCTION IS CREATED FOR FUTURE USE IF NEED STORE OLD AND NEW VALUES WITH ENCRPTED.
    public static function logActivityForUser($userId, $activityType, $activityDesc, $details = [])
    {
        $activity = UserActivity::create([
            'user_id' => $userId,
            'activity_type' => $activityType,
            'activity_desc' => $activityDesc,
        ]);

        // Iterate over the changes and log each one
        foreach ($details as $key => $detail) {
            UserActivityDetail::create([
                'user_activity_id' => $activity->id,
                'old_value' => isset($detail['old_value']) ? Crypt::encryptString($detail['old_value']) : '',
                'new_value' => isset($detail['new_value']) ? Crypt::encryptString($detail['new_value']) : '',
            ]);
        }
    }


}
