<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-sidebar-visibility="show" data-layout-style="default" data-layout-mode="light" data-layout-width="fluid" data-layout-position="fixed">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="{{ asset('backend/js/layout.js') }}"></script>
  <!-- Bootstrap Css -->
  <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
  <link href="{{ asset('backend/fonts/SegoeUI/style.css') }}" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="{{ asset('backend/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
  <style>
    body {
        font-family: apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    }
   .main-div{
    background-color: #ebebeb;
    height: 100%;
    width: 100%;
    padding: 2.5rem 1rem;
}

.sections-div{
    margin: auto;
    max-width: 50rem;
}

.border-top{
    border: none;
    padding: 0;
    height: 1.45rem;
    background-color: #625afa;
    margin-top: -31px;
    width: 800px;
    margin-left: -16px;
}
.section{
    background-color: white;
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 0.5rem;
    /* overflow: hidden; */
    }
.break-page {
    page-break-inside: avoid;
}
.header-section{
    padding-top: 2rem;
    overflow: hidden;
}

.heading{
    font-weight: 600;
    color: #525252;
    margin-bottom: 0;
}

 .header-heading{
    margin-bottom: 1rem;
}

.header-description{
    margin: 10px 0;
}

.description{
    font-size: 14px;
    color: #666;
    line-height: 0.75rem;
}

.input-fieldset{
    margin-bottom: 1rem;
    display: flex;
    flex-direction: column;
    width: 100%;
    flex-basis: 50%;
    border: 1px solid rgba(0, 0, 0, 0);
}

.input-label{
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 0;
}

.label-description{
    font-size: 12px;
    color: #666;
    margin-top: -0.25rem;
}

.mb-2{
    vertical-align: 0.5rem;
}

.input{
    min-height: 15px;
    height: auto;
    padding: 0.6rem;
    border-radius: 6px;
    border: 0;
    font-size: 12px;
    border: 2px solid #e5e5e5;
    width: 94%;
    margin-top: 0.3rem;
}

.input:focus{
    outline: none;
}

.checkbox_label{
    margin-left: 0.5rem;
    cursor: pointer;
}

.checkbox_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.checkbox_row label{
    margin-bottom: 0;
    vertical-align: 5px;
}
.checkbox-grid{
    display: flex;
    flex-wrap: wrap;
    width: 40rem;
}

.checkbox-image-container{
    text-align: left;
    width: 100%;
}

.checkbox_image_label{
    display: inline-block;
    width: 45%;
    box-sizing: border-box;
    padding: 0.6rem;
    vertical-align: top;
    text-align: center;
    margin-bottom: 1rem;
}

.checkbox-image-option{
    width: 100%;
    height: auto;
}

.checkbox_image_label:has( input:checked) > .checkbox-image-option {
    border-color: #625afa;
}

.checkbox-description{
    text-align: left;
}

.checkbox-image-input {
    margin-right: 0.2rem;
}

.checkbox-image-input{
    align-self: self-start;
    margin-top: 0.25rem;
    scale: 1.25;
}
.checkbox-description span{
    vertical-align: 5px;
}

.radio_text{
    margin-left: 0.5rem;
    cursor: pointer;
}

.radio_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.radio_row label{
    margin-bottom: 0;
    vertical-align: 3px;
}
.submit-btn{
    display: block;
    width: 100%;
    background-color: #625afa;
    border: none;
    color: white;
    border-radius: 0.25rem;
    padding: 0.5rem 0;
    font-weight: 600;
}

.text-red{
    color: red;;
}

.asterisk{
    color: red;
    font-size: 1.25rem;
}


@media (max-width: 576px) {
    .checkbox_image_label {
        flex-basis: 100%;
    }
}
  </style>
</head>

<body>
    
    <div class="main-div">
        <div class="sections-div">
            <section class="section header-section">
                <div class="border-top"></div>
                <h1 class="header-heading heading">Video Brief Questionnaire</h1>
                <p class="header-description description">All correspondence and documents provided will be treated as confidential between the client and the designer, unless consent has been granted by both parties involved.</p>
                <p class="header-description description">
                    <b>NOTE:
                        <ul>
                            <li>
                                Your contact information is safe with us and are never shared with any third party.
                            </li>
                            <li>
                                <span class="asterisk">*</span> Indicates required question.
                            </li>
                        </ul>
                    </b>
                </p>
            </section>

            <form class="form">
                @if($formData["email"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="email" class="input-label">Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Email" name="email" class="input email-input" value="{{ $formData["email"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["name"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="name" class="input-label">Client Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Name" name="name" class="input name-input" value="{{ $formData["name"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["phone"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="phone" class="input-label">Contact Number <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Mobile Number" name="phone" class="input phone-input" value="{{ $formData["phone"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="project_name" class="input-label mb-2">Name of the Project <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Project Name" name="project_name" class="input business-email-input" value="{{ $formData["project_name"] }}" >
                        </fieldset>
                    </section>
                    @php
                    // Remove underscores and capitalize first word
                    $industry = ucwords(str_replace('_', ' ', $formData['industry']));
                    @endphp
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="industry" class="input-label mb-2">Business Industry <span class="asterisk">*</span></label>
                            <select name="industry" class="input">
                                <option value="{{ $formData['industry'] }}" selected>{{ $industry }}</option>
                            </select>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website" class="input-label mb-2">Current Website Address (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Website" name="website" class="input website-input" value="{{ $formData["website"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="social_media" class="input-label mb-2">Current Social Media Profile (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Social Media Links" name="social_media" class="input social-media-input" value="{{ $formData["social_media"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_description" class="input-label mb-2">Business Description <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Describe Your Business" name="business_description" class="input business-description-input" value="{{ $formData["business_description"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_services" class="input-label mb-2">Business Products / Services <span class="asterisk">*</span></label>
                            <input type="text" placeholder="List Your Business Services" name="business_services" class="input business-services-input" value="{{ $formData["business_services"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="audience" class="input-label mb-2">Target Audience or Customers your want to Target? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Describe Your Target Audience" name="audience" class="input audience-input" value="{{ $formData["audience"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="competitor" class="input-label mb-2">Competitors or Similar Businesses (For Reference Purpose) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Answer" name="competitor" class="input competitor-input" value="{{ $formData["competitor"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="u_s_p" class="input-label mb-2">How is your company different from your competitors? (Your USP) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Unique Selling Proposition" name="u_s_p" class="input u-s-p-input" value="{{ $formData["u_s_p"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="comments" class="input-label mb-2">Additional Comments - eg. My Vision For the Script <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Any Comments" name="comments" class="input comments-input" value="{{ $formData["comments"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="video_purpose" class="input-label mb-2">Purpose of the Video <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Purpose of the Video" name="video_purpose" class="input video-purpose-input" value="{{ $formData["video_purpose"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="video_duration" class="input-label mb-2">What is the duration of the video? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Desired Duration of the Video" name="video_duration" class="input video-duration-input" value="{{ $formData["video_duration"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="reference" class="input-label mb-2">Would you like to follow any reference video e.g. character animation, motion graphic or whiteboard? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Any References" name="reference" class="input reference-input" value="{{ $formData["reference"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="style" class="input-label mb-2">Would you like to follow any specific style of characters? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Style You Prefer" name="style" class="input style-input" value="{{ $formData["style"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="color" class="input-label mb-2">Would you like to use any specific color pallets? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Preferred Colors" name="color" class="input color-input" value="{{ $formData["color"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Voice-over preference? (Male/female) <span class="asterisk">*</span></legend>
                            <div class="checkbox_row">
                                <input type="checkbox" id="male" name="voice[]" value="male" {{ in_array('male', $formData["voice"]) ? 'checked' : '' }}>
                                <label for="male" class="checkbox_label">Male</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="female" name="voice[]" value="female" {{ in_array('female', $formData["voice"]) ? 'checked' : '' }}>
                                <label for="female" class="checkbox_label">Female</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="artist_accent" class="input-label mb-2">Voice-over Artist Accent <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Preferred Artist Accent" name="artist_accent" class="input artist-accent-input" value="{{ $formData["artist_accent"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="animation_style" class="input-label mb-2">Animation Style <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Preferred Animation Style" name="animation_style" class="input animation-style-input" value="{{ $formData["animation_style"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="reference_video" class="input-label mb-2">Any Reference Video You Like us to use as Inspiration <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Reference Video URL" name="reference_video" class="input reference-video-input" value="{{ $formData["reference_video"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="deadline" class="input-label mb-2">Are you working with any deadline? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter the Project Deadline" name="deadline" class="input deadline-input" value="{{ $formData["deadline"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="additional_comments" class="input-label mb-2">Additional Comments over the Video <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Any Additional Comments" name="additional_comments" class="input additional-comments-input" value="{{ $formData["additional_comments"] }}" >
                        </fieldset>
                    </section>
            </form>
        </div>
    </div>

  <!-- JAVASCRIPT -->
  <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/libs/simplebar/simplebar.min.js') }}"></script>
  <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
  <script src="{{ asset('backend/libs/feather-icons/feather.min.js') }}"></script>
  
  <script src="{{ asset(mix('js/app.js')) }}"></script>