@extends('admin.layouts.main')
@section('page')
<!-- start page title -->
<div class="row">
  <div class="col-12">
    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
      <h4 class="mb-sm-0">Payments</h4>

      <div class="page-title-right">
        <ol class="breadcrumb m-0">
          <!-- <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li> -->
          <li class="breadcrumb-item active">Payments</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<!-- end page title -->

<div class="row">
  <div class="col-lg-12">
    <div class="card">
      <div class="card-header pt-0 pb-0">
        <div class="row align-items-center">
          <div class="col-md-6">
            <ul class="nav nav-tabs nav-tabs-custom nav-success border-0" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#all-payments" role="tab">
                  All payments
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#disputes" role="tab">
                  Disputes
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#all-transactions" role="tab">
                  All transactions
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-6">
            <div class="btn-group float-end create-payment-btn">
              <button type="button" class="btn btn-primary waves-effect waves-light btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="ri-add-line align-bottom me-1"></i>
                Create Payment
              </button>
              <div class="dropdown-menu dropdown-menu-md">
                <div class="dropdown-top-caret">
                  <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                    <g fill="#fff" fill-rule="evenodd">
                      <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                      <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                    </g>
                  </svg>
                </div>
                <ul>
                  <li>
                    <a href="#">
                      <i class="ri-bill-fill"></i>
                      <div class="create-payment-linksDetails">
                        <h3>Invoice</h3>
                        <p>Collect a one-time payment from a specific customer.</p>
                      </div>
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="ri-link"></i>
                      <div class="create-payment-linksDetails">
                        <h3>Payment link</h3>
                        <p>Create a link to accept one-time or recurring payments from anyone.</p>
                      </div>
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="ri-refresh-fill"></i>
                      <div class="create-payment-linksDetails">
                        <h3>Subscription</h3>
                        <p>Create a recurring payment for a specific customer.</p>
                      </div>
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="ri-currency-fill"></i>
                      <div class="create-payment-linksDetails">
                        <h3>Manual payment</h3>
                        <p>Enter card details for your customer.</p>
                      </div>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="card-body">
        <div class="tab-content text-muted">
          <div class="tab-pane active" id="all-payments" role="tabpanel">
            <ul class="payment-top-filters">
              <li>
                <button type="button" class="btn active">
                  <span>All</span>
                  <strong>1</strong>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Succeeded</span>
                  <strong>1</strong>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Refunded</span>
                  <strong>0</strong>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Uncaptured</span>
                  <strong>0</strong>
                </button>
              </li>
              <li>
                <button type="button" class="btn">
                  <span>Failed</span>
                  <strong>0</strong>
                </button>
              </li>
            </ul>
            <div class="row align-items-center">
              <div class="col-md-6">
                <ul class="payment-second-filter">
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Date
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Date</label>
                          </div>
                          <div class="mb-2">
                            <select>
                              <option value="inTheLast">
                                is in the last
                              </option>
                              <option value="equals">
                                is equal to
                              </option>
                              <option value="between">
                                is between
                              </option>
                              <option value="isAfter">
                                is after
                              </option>
                              <option value="isAfterOrOn">
                                is on or after
                              </option>
                              <option value="isBefore">
                                is before
                              </option>
                              <option value="isBeforeOrOn">
                                is before or on
                              </option>
                            </select>
                          </div>
                          <div class="dropdown-next-area mb-2">
                            <div class="next">
                              <i class="bx bx-subdirectory-right"></i>
                            </div>
                            <input type="number" />
                            <select>
                              <option value="days">days</option>
                              <option value="months">months</option>
                            </select>
                          </div>
                          <div class="dropdown-next-area mb-2">
                            <div class="text-nowrap">
                              Time zone:
                            </div>
                            <div class="form-check form-radio-primary">
                              <input class="form-check-input" type="radio" name="formradiocolor1" id="gtm-2" checked>
                              <label class="form-check-label" for="gtm-2">
                                GTM+2
                              </label>
                            </div>
                            <div class="form-check form-radio-primary">
                              <input class="form-check-input" type="radio" name="formradiocolor1" id="utc" checked>
                              <label class="form-check-label" for="utc">
                                UTC
                              </label>
                            </div>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Amount
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Amount</label>
                          </div>
                          <div class="mb-2">
                            <select>
                              <option value="equals">
                                is equal to
                              </option>
                              <option value="between">
                                is between
                              </option>
                              <option value="greaterThan">
                                is greater than
                              </option>
                              <option value="lessThan">
                                is less than
                              </option>
                            </select>
                          </div>
                          <div class="dropdown-next-area mb-2">
                            <div class="next">
                              <i class="bx bx-subdirectory-right"></i>
                            </div>
                            <input type="number" placeholder="0" />
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Status
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Status</label>
                          </div>
                          <div class="mb-2">
                            <ul class="filterByStatusUl">
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck1" />
                                  <label class="form-check-label" for="formCheck1">
                                    Blocked
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck2" />
                                  <label class="form-check-label" for="formCheck2">
                                    Canceled
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck3" />
                                  <label class="form-check-label" for="formCheck3">
                                    Disputed
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck4" />
                                  <label class="form-check-label" for="formCheck4">
                                    Early fraud warning
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck5" />
                                  <label class="form-check-label" for="formCheck5">
                                    Failed
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck6" />
                                  <label class="form-check-label" for="formCheck6">
                                    Incomplete
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck7" />
                                  <label class="form-check-label" for="formCheck7">
                                    Partially refunded
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck8" />
                                  <label class="form-check-label" for="formCheck8">
                                    Pending
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck9" />
                                  <label class="form-check-label" for="formCheck9">
                                    Refund pending
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck10" />
                                  <label class="form-check-label" for="formCheck10">
                                    Refunded
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck11" />
                                  <label class="form-check-label" for="formCheck11">
                                    Succeeded
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck12" />
                                  <label class="form-check-label" for="formCheck12">
                                    Uncaptured
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="formCheck13" />
                                  <label class="form-check-label" for="formCheck13">
                                    Waiting on funding
                                  </label>
                                </div>
                              </li>
                            </ul>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-add-circle-fill"></i>
                        Payment method
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">Filter by Payment method</label>
                          </div>
                          <div class="mb-2">
                            <select>
                              <option value="three_d_secure">
                                3D Secure
                              </option>
                              <option value="three_d_secure_2">
                                3D Secure 2
                              </option>
                              <option value="ach_credit_transfer">
                                ACH Credit Transfer
                              </option>
                              <option value="us_bank_account">
                                ACH Direct Debit
                              </option>
                              <option value="affirm">Affirm</option>
                              <option value="afterpay_clearpay">
                                Afterpay / Clearpay
                              </option>
                              <option value="alipay">Alipay</option>
                              <option value="bancontact">
                                Bancontact
                              </option>
                              <option value="customer_balance">
                                Bank transfer
                              </option>
                              <option value="au_becs_debit">
                                BECS Direct Debit (AU)
                              </option>
                              <option value="acss_debit">
                                Canadian pre-authorized debits
                              </option>
                              <option value="card" selected>
                                Card
                              </option>
                              <option value="card_present">
                                Card Present
                              </option>
                              <option value="cashapp">
                                Cash App Pay
                              </option>
                              <option value="eps">EPS</option>
                              <option value="giropay">
                                giropay
                              </option>
                              <option value="ideal">iDEAL</option>
                              <option value="interac_present">
                                Interac
                              </option>
                              <option value="klarna">Klarna</option>
                              <option value="link">Link</option>
                              <option value="multibanco">
                                Multibanco
                              </option>
                              <option value="p24">P24</option>
                              <option value="paypal">PayPal</option>
                              <option value="sepa_debit">
                                SEPA Direct Debit
                              </option>
                              <option value="sofort">Sofort</option>
                              <option value="wechat_pay">
                                WeChat Pay
                              </option>
                            </select>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            Apply
                          </button>
                        </form>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
              <div class="col-md-6">
                <ul class="payment-columns-filter">
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light">
                        <i data-feather="upload"></i>
                        Export
                      </button>
                    </div>
                  </li>
                  <li>
                    <div class="btn-group">
                      <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="ri-settings-5-fill"></i>
                        Edit columns
                      </button>
                      <div class="dropdown-menu dropdown-menu-md">
                        <div class="dropdown-top-caret">
                          <svg xmlns="http://www.w3.org/2000/svg" width="21" height="9" role="presentation">
                            <g fill="#fff" fill-rule="evenodd">
                              <path fill="#fff" fill-opacity="0.1" d="M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"></path>
                              <path fill="currentcolor" d="M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"></path>
                            </g>
                          </svg>
                        </div>
                        <form class="activeColumnsForm">
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">FIXED COLUMNS</label>
                            <ul class="activeColumnsUl">
                              <li>Amount</li>
                            </ul>
                          </div>
                          <div class="mb-2">
                            <label class="form-label" for="exampleDropdownFormEmail">ACTIVE COLUMNS</label>
                            <ul class="activeColumnsUl">
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns1" checked />
                                  <label class="form-check-label" for="activeColumns1">
                                    Description
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns2" checked />
                                  <label class="form-check-label" for="activeColumns2">
                                    Customer
                                  </label>
                                </div>
                              </li>
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns3" checked />
                                  <label class="form-check-label" for="activeColumns3">
                                    Date
                                  </label>
                                </div>
                              </li>
                            </ul>
                          </div>
                          <div>
                            <label class="form-label" for="exampleDropdownFormEmail">AVAILABLE COLUMNS</label>
                            <ul class="activeColumnsUl">
                              <li>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" id="activeColumns4" />
                                  <label class="form-check-label" for="activeColumns4">
                                    Decline Reason
                                  </label>
                                </div>
                              </li>
                            </ul>
                          </div>
                        </form>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <table id="scroll-horizontal" class="table nowrap align-middle" style="width: 100%">
              <thead>
                <tr>
                  <th scope="col" style="width: 10px">
                    <div class="form-check">
                      <input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option" />
                    </div>
                  </th>
                  <th style="width: 10px">Amount</th>
                  <th style="width: 10px"></th>
                  <th style="width: 10px"></th>
                  <th style="width: 10px">Description</th>
                  <th style="width: 10px">Customer</th>
                  <th>Date</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th scope="row">
                    <div class="form-check">
                      <input class="form-check-input fs-15" type="checkbox" name="checkAll" value="option1" />
                    </div>
                  </th>
                  <td><b>$2,222.00</b></td>
                  <td>USD</td>
                  <td>
                    <span class="badge badge-soft-success">
                      Succeeded
                      <i class="ri-check-line"></i>
                    </span>
                  </td>
                  <td>sssssss</td>
                  <td>shawn.logoorbit@gmail.com</td>
                  <td>Aug 2, 8:50 AM</td>
                  <td>
                    <ul class="payment-actionListUl">
                      <li>
                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button">
                          <i class="ri-arrow-go-back-line align-middle"></i>
                        </button>
                      </li>
                      <li>
                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button">
                          <i class="mdi mdi-email"></i>
                        </button>
                      </li>
                      <li>
                        <div class="dropdown d-inline-block">
                          <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-fill align-middle"></i>
                          </button>
                          <ul class="dropdown-menu dropdown-menu-end">
                            <li class="dropHead">
                              <a href="#!" class="dropdown-item">Actions</a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Refund payment
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Send receipt
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Copy payment ID
                              </a>
                            </li>
                            <li class="dropHead">
                              <a href="#!" class="dropdown-item">Connections</a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                View customer
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                View payment details
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </td>
                </tr>
                <tr>
                  <th scope="row">
                    <div class="form-check">
                      <input class="form-check-input fs-15" type="checkbox" name="checkAll" value="option1" />
                    </div>
                  </th>
                  <td><b>$2,222.00</b></td>
                  <td>USD</td>
                  <td>
                    <span class="badge badge-soft-danger">
                      Failed
                      <i class="ri-check-line"></i>
                    </span>
                  </td>
                  <td>sssssss</td>
                  <td>shawn.logoorbit@gmail.com</td>
                  <td>Aug 2, 8:50 AM</td>
                  <td>
                    <ul class="payment-actionListUl">
                      <li>
                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button">
                          <i class="ri-arrow-go-back-line align-middle"></i>
                        </button>
                      </li>
                      <li>
                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button">
                          <i class="mdi mdi-email"></i>
                        </button>
                      </li>
                      <li>
                        <div class="dropdown d-inline-block">
                          <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-fill align-middle"></i>
                          </button>
                          <ul class="dropdown-menu dropdown-menu-end">
                            <li class="dropHead">
                              <a href="#!" class="dropdown-item">Actions</a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Refund payment
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Send receipt
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                Copy payment ID
                              </a>
                            </li>
                            <li class="dropHead">
                              <a href="#!" class="dropdown-item">Connections</a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                View customer
                              </a>
                            </li>
                            <li>
                              <a href="#!" class="dropdown-item">
                                View payment details
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--end col-->
</div>
<!--end row-->
@endsection