import { router } from "@inertiajs/vue3";
import axios from "axios";

export function useStripe(stripe, error, loading) {
  // Creating customer
  const createCustomer = async (payload) => {
    try {
      const response = await axios.post(
          route("paynow.stripe.createCustomer"),
          payload
      );

      return response.data; // Return data from successful response
    } catch (responseError) {
      if (
        responseError?.response &&
        responseError?.response?.data &&
        responseError?.response?.data?.errors
      ) {
        if (
          Object.keys(responseError.response.data.errors)[0] ==
          "cardValidity"
        ) {
          error.value.key = "cardNo";
          error.value.msg = responseError.response.data.errors[Object.keys(responseError.response.data.errors)[0]][0];
        } else {
          error.value.key = Object.keys(responseError.response.data.errors)[0];
          error.value.msg = responseError.response.data.errors[error.value.key][0];
        }
      }
      throw responseError; // Re-throw the error to handle it elsewhere if needed
    }
  };

  // Processing Payment
  const processPayment = async (payload) => {
    try {
      const response = await axios.post(
          route("paynow.stripe.createPaymentMethod"),
          payload
      );
      return response.data; // Return data from successful response
    } catch (responseError) {
      throw responseError; // Re-throw the error to handle it elsewhere if needed
    }
  };

  // Processing AfterPay Payment
  const processAfterPay = async (payload) => {
    try {
      const response = await axios.post(
          route("paynow.stripe.afterpay"),
          payload
      );
      return response.data; // Return data from successful response
    } catch (responseError) {
      throw responseError; // Re-throw the error to handle it elsewhere if needed
    }
  };

  // Verifying Payment
  const verifyPayment = async (payload) => {
    try {
      const response = await axios.post(
          route("paynow.stripe.verifyPayment"),
          payload
      );
      return response.data; // Return data from successful response
    } catch (responseError) {
      throw responseError; // Re-throw the error to handle it elsewhere if needed
    }
  };

  const verifyAndHandlePayment = async (data) => {
    try {
      const verifyResponse = await verifyPayment(data);
      console.log("Verification successful");

      // Redirect to the verification route
      router.visit(verifyResponse.route);
    } catch (errorResponse) {
      console.log("Verification failed");
      // Handle verification failure

      // need to handle this case
    }
  };

  // verifying 3D Secure payments
  const verify3DSecurePayment = async (payload) => {
    try {
      const response = await axios.post(
          route("paynow.stripe.verify.3DSecure"),
          payload
      );
      return response.data;
    } catch (errorResponse) {
        throw errorResponse;
    }
  };

  const threeDSecureRequest = async (stripeData) => {
    try {
      const threeDRequest = await stripe.value;
      const result = await threeDRequest.confirmCardPayment(
          stripeData.client_secret,
          {
              payment_method: stripeData.payment_method_id,
          }
      );

      const paymentIntentID = result.paymentIntent?.id
          ? result.paymentIntent.id
          : result.error?.payment_intent?.id;
      const verify3D = await verify3DSecurePayment({
          ...stripeData,
          payment_intent_id: paymentIntentID,
          userID: props.item?.created_by,
      });

      return result;
    } catch (error) {
      console.log(error.response);

      throw error;
    }
  };

  const handleServerResponse = async (response, stripeData, data) => {
    try {
      if (response.success) {
          // Success payment -> insert the payment
          await verifyAndHandlePayment(data);
      } else if (response.requires_action) {
          loading.value.message = "Bank verification...";

          // Action is required -> 3D Secure
          const threeD = await threeDSecureRequest(stripeData);

          if (threeD?.error) {
            handleServerResponse(threeD, stripeData, {
                ...data,
                ...threeD,
            });
          } else {
            paymentData.value.ThreeDSecure_Popup = 1;
            data.ThreeDSecure_Popup = 1;
            handleServerResponse(threeD, stripeData, data);
          }
      } else {
        // Error in payment -> show the error message
        await verifyAndHandlePayment(data);
      }
    } catch (error) {
      console.log("handle response");

      throw error;
    }
  };

  return {
    createCustomer,
    processPayment,
    processAfterPay,
    verifyPayment,
    verifyAndHandlePayment,
    verify3DSecurePayment,
    threeDSecureRequest,
    handleServerResponse
  };
}
