import { downloadFile } from "../downloadFile";
import { useNotification } from "../useNotification";

export function useDownload() {
  const { success: notifySuccess, error: notifyError } = useNotification();

  const download = (encoded_id, cus_name) => {
   
    downloadFile(route("brief.download", encoded_id), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);  
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  const downloadWebBrief = (encoded_id, cus_name) => {
   
    downloadFile(route("web.brief.download", encoded_id), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);  
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  
  return {
    download,
    downloadWebBrief
  }
}
