import { downloadFile } from "../downloadFile";
import { useNotification } from "../useNotification";

export function useDownload() {
  const { success: notifySuccess, error: notifyError } = useNotification();

  const download = (encoded_id, cus_name, fingerprint) => {

    downloadFile(route("brief.download", {id: encoded_id, fingerprint }), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  const downloadWebBrief = (encoded_id, cus_name, fingerprint) => {

    downloadFile(route("web.brief.download", {id: encoded_id, fingerprint }), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  const downloadVideoBrief = (encoded_id, cus_name, fingerprint) => {

    downloadFile(route("video.brief.download", {id: encoded_id, fingerprint }), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  const downloadSmmBrief = (encoded_id, cus_name, fingerprint) => {

    downloadFile(route("smm.brief.download", {id: encoded_id, fingerprint }), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };

  const downloadAppBrief = (encoded_id, cus_name, fingerprint) => {

    downloadFile(route("app.brief.download", {id: encoded_id, fingerprint }), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };


  const downloadSemBrief = (encoded_id, cus_name, fingerprint) => {

    downloadFile(route("sem.brief.download", {id: encoded_id, fingerprint }), cus_name)
      .then((response) => {
        notifySuccess(`${response.fileName} downloaded successfully`);
      })
      .catch((error) => {
        console.log(error.response);
        notifyError(error.response.data.message);
      });
  };


  return {
    download,
    downloadWebBrief,
    downloadVideoBrief,
    downloadSmmBrief,
    downloadAppBrief,
    downloadSemBrief,
  }
}
