// Error Handler For All Inputs
let lengthErrors = [];
let typeErrors = [];

function sanitizeInput(input, type="") {
  // Remove PHP, XML, HTML, WML, SVG, SGML, and MathML tags
  input = input.replace(/(<([^>]+)>)/gi, "");

  // Remove specific tags
  input = input.replace(/<\/?(?:[a-z]+:)?[a-z0-9_-]+\b[^>]*>/gi, '');  

  // Trim any leading or trailing whitespace
  input = input.trim();

  if(type != "" && type == "email") {
    // Convert the input to lowercase
    input = input.toLowerCase();
  }

  // Replace multiple consecutive spaces with a single space
  input = input.replace(/\s+/g, ' ');

  // Return the sanitized input
  return input;
}

// Error Handler
function errorHandler(errorMsg = "") {
  document.getElementById("error-box").innerHTML = errorMsg
    ? `<p>${errorMsg}</p>`
    : "";
}

const cardInputArea = document.getElementById('cardInputArea');
const allInputs = document.querySelectorAll(".detailsInput input");
const creditCardNumberInput = document.getElementById("cardnumber");
const expiryDateInput = document.getElementById("exp-date");
const CVCInput = document.getElementById("cvc");
const phoneInput = document.getElementById("phone");

/*allInputs.forEach((el) =>
  el.addEventListener("change", (event) => {
    inputErrorHandler(event.target);
  })
);*/

allInputs.forEach((el) => {
  el.addEventListener("focus", (event) => {
    allInputs.forEach((els) => {
      if (els !== event.target) {
        let id = els.getAttribute('id');
        let x = document.querySelector(`#${id}`).closest(".detailsInput");
        let xChild = x.querySelector('#form-error-box');
        if(xChild) {
            xChild.innerHTML = "";
            xChild.style.display = "";
        }
      }
    });
  });
});



function inputErrorHandler(input) {
  let type = input.getAttribute("data-type");
  let maxLength = input.getAttribute("data-maxlength");
  let minLength = input.getAttribute("data-minlength");

  function checkRemove(pushTo, value) {
    pushTo.includes(value) ? pushTo.splice(pushTo.indexOf(value), 1) : null;
  }

  function checkAdd(pushTo, value) {
    pushTo.includes(value) ? null : pushTo.push(value);
  }

  if (type || maxLength) {
    let nameInput = input.getAttribute("placeholder");
    let errorMsg = "";

    if (maxLength) {
      if (maxLength < input.value.length) {
        checkAdd(lengthErrors, "<p>" + nameInput + " has exceeded length</p>");
        errorMsg = "<p>" + nameInput + " has exceeded length</p>"
      } else {
        checkRemove(lengthErrors, "<p>" + nameInput + " has exceeded length</p>");
      }
    }

    if (minLength) {
      if (minLength > input.value.length) {
        checkAdd(lengthErrors, "<p>Please lengthen this text to " + minLength + " characters or more (you are currently using " + input.value.length + " characters</p>");
        errorMsg = "<p>Please lengthen this text to " + minLength + " characters or more (you are currently using " + input.value.length + " characters</p>"
      } else {
        checkRemove(lengthErrors, "<p>Please lengthen this text to " + minLength + " characters or more (you are currently using " + input.value.length + " characters</p>");
      }
    }

    if (type) {
      let number = new RegExp("^[0-9+]+$");
      let alphabetic = new RegExp("^[a-z A-Z]+$");
      let email = new RegExp(/^[^@]+@[^@]+\.[^@]+$/);
      if (type == "number") {
        if (number.test(input.value)) {
          checkRemove(typeErrors, "<p>This field is invalid use numbers only</p>");
        } else {
          checkAdd(typeErrors, "<p>This field is invalid use numbers only</p>");
          errorMsg = "<p>This field is invalid use numbers only</p>";
        }
      }

      if (type == "tel") {
        if (number.test(input.value)) {
          checkRemove(typeErrors, "<p>This field is invalid use numbers only</p>");
        } else {
          checkAdd(typeErrors, "<p>This field is invalid use numbers only</p>");
          errorMsg = "<p>This field is invalid use numbers only</p>";
        }
      }

      if (type == "email") {
        if (email.test(input.value)) {
          checkRemove(typeErrors, "<p>This field is invalid! Please include '@' in the email address.</p>");
        } else {
          checkAdd(typeErrors, "<p>This field is invalid! Please include '@' in the email address.</p>");
          errorMsg = "<p>This field is invalid! Please include '@' in the email address.</p>";
        }
      }

      if (type == "alphabetic") {
        if (alphabetic.test(input.value)) {
          checkRemove(typeErrors, "<p>This field is invalid use alphabets only</p>");
        } else {
          checkAdd(typeErrors, "<p>This field is invalid use alphabets only</p>");
          errorMsg = "<p>This field is invalid use alphabets only</p>";
        }
      }
    }

    let id = input.getAttribute('id');
    var x = document.querySelector(`#${id}`).closest(".detailsInput");
    // console.log(x);    
    let xChild = x.querySelector('#form-error-box');
    // console.log(xChild);
    xChild.innerHTML = errorMsg;
    
    
    if(input.value != "") {
        xChild.style.display = errorMsg ? "block" : "";
    } else {
        xChild.style.display = "";
    }

    if (errorMsg) {
      return true;
    } else {
      return false;
    }
  }
}

// Remove Alphabets
function removeAlphabet(input) {
  return input.value.replace(/\D/g, "");
}

// Remove Numbers
function removeNumber(input) {
  return input.value.replace(/[^A-Z a-z']/g, "");
}

// Remove Plus Sign
function removePlusSign(input) {
  value = input.value.replace(/\+/g, "");
  return input.value = value;
}

// Credit Card Type
function creditCardType(cc) {
  let amex = new RegExp("^3[47]\\d{0,13}");
  let visa = new RegExp("^4\\d{0,15}");
  let cup1 = new RegExp("^62\\d{0,14}");
  let cup2 = new RegExp("^81\\d{0,14}");

  let mastercard = new RegExp(
    "^(5[1-5]\\d{0,2}|22[2-9]\\d{0,1}|2[3-7]\\d{0,2})\\d{0,12}"
  );

  let discover = new RegExp("^(?:6011|65\\d{0,2}|64[4-9]\\d?)\\d{0,12}");

  let diners = new RegExp("^3(?:0([0-5]|9)|[689]\\d?)\\d{0,11}");
  let jcb = new RegExp("^(?:35\\d{0,2})\\d{0,12}");
  let jcb1 = new RegExp("^(?:2131|1800)\\d{0,11}");

  if (visa.test(cc)) {
    return "visa";
  }
  if (amex.test(cc)) {
    return "amex";
  }
  if (mastercard.test(cc)) {
    return "mastercard";
  }
  if (discover.test(cc)) {
    return "discover";
  }
  if (diners.test(cc)) {
    return "diners";
  }
  if (jcb.test(cc) || jcb1.test(cc)) {
    return "jcb";
  }
  if (cup1.test(cc) || cup2.test(cc)) {
    return "unionpay";
  }
  return undefined;
}

// BackSpace Handler
function backspaceHandle(input, e, goBackTo) {
  if (e.key === "Backspace") {
    if (input.value.length === 0) {
      const creditCardInput = document.getElementById(goBackTo);
      creditCardInput.focus();
    }
    return;
  } else {
    return;
  }
}

// Credit Card Formater
function formatCreditCardNumber(input) {
  let value = removeAlphabet(input);
  let type = creditCardType(value);

  function removeClass() {
    let allTypes = ["paypal", "discover", "visa", "amex", "mastercard"];
    for (let i = 0; i < allTypes.length; i++) {
      document.getElementById("cardInputArea").classList.remove(allTypes[i]);
    }
  }

  removeClass();

  if (type) {
    document.getElementById("cardInputArea").classList.add(type);
  }

  value = value.slice(0, 19);
  value = value.replace(/(\d{4})(?=\d)/g, "$1 ");
  input.value = value;

  if (value.length === 23) {
    document.getElementById("exp-date").focus();
    
    if(!validateCardNumber(input)) {
      cardInputArea.style.borderColor = "#FF0000";
      creditCardNumberInput.style.color = "#FF0000";
    } else {
      creditCardNumberInput.style.color = "";
      cardInputArea.style.borderColor = "";
    }
  } else {
    creditCardNumberInput.style.color = "";
    cardInputArea.style.borderColor = "";
  }
}

// Expiry Date Formater
function formatExpiryDate(input) {
  let value = removeAlphabet(input);
  value = value.slice(0, 4);
  if (value.length > 0) {
    if (value.charAt(0) > "1") {
      value = `0${value.charAt(0)}/${value.slice(1)}`;
    } else {
      value = value.replace(/(\d{2})(?=\d)/g, "$1/");
    }
  }

  const month = value.slice(0, 2);
  const year = value.slice(2).split("/").join("");
  
  if (month == "00") {
    value = `01/${year}`;
  }
  
  if (month > 12) {
    value = `12/${year}`;
  }


  input.value = value;
  if (value.length === 5) {
    console.log("Expiry: "+input.value);
    validateExpiry(input);
    document.getElementById("cvc").focus();
  }
}

function validateExpiry(input) {
  const expiryDate = input.value.split("/");
  const expiryYear = parseInt(expiryDate[1]) + 2000; 
  const date = new Date();
  const eDate = new Date(`${expiryYear}-${parseInt(expiryDate[0])}-${date.getDate()}`);
  eDate.setMonth(eDate.getMonth() + 1);;

  if(eDate.getTime() >= date.getTime()) {
    cardInputArea.style.borderColor = "";
    input.style.color = "";
  } else {
    cardInputArea.style.borderColor = "#FF0000";
    input.style.color = "#FF0000";
  }
}

// Expiry CVC Formater
function formatCVC(input) {
  let value = removeAlphabet(input);
  value = value.slice(0, 4);
  input.value = value;
}

// Alphanumeric Input Formater
function formatAlphanumericInput(input) {
  let value = removeNumber(input);
  input.value = value;
}


// Phone Formater
function formatPhone(input) {
  let value = input.value.replace(/[^0-9+]/g, '');
  input.value = value;
}

// Validate Card Number through Luhn Algorithm
function validateCardNumber(cardNumber) {
  cardNumber = cardNumber.value;
  if(cardNumber) {
    // Remove any non-digit characters from the card number
    const cleanedCardNumber = cardNumber.replace(/\D/g, '');
    
    // Convert the card number to an array of digits
    const digits = Array.from(cleanedCardNumber, Number);
  
    // Double every second digit starting from the right
    for (let i = digits.length - 2; i >= 0; i -= 2) {
      digits[i] *= 2;
      if (digits[i] > 9) {
        digits[i] -= 9;
      }
    }
  
    // Sum all the digits
    const sum = digits.reduce((accumulator, currentValue) => accumulator + currentValue);
  
    // Check if the sum is divisible by 10
    return sum % 10 === 0;
  } else {
    return 0===0;
  }
}

creditCardNumberInput.addEventListener("input", (event) => {
  formatCreditCardNumber(event.target);
});

creditCardNumberInput.addEventListener("blur", (event) => {
  creditCardNumberInput.style.color = "#FF0000";
  console.log(event.target.value + validateCardNumber(event.target));
  if(!validateCardNumber(event.target)) {
    cardInputArea.style.borderColor = "#FF0000";
    event.target.style.color = "#FF0000";
  } else {
    event.target.style.color = "";
    cardInputArea.style.borderColor = "";
  }
});

expiryDateInput.addEventListener("keyup", (event) => {
  backspaceHandle(event.target, event, "cardnumber");
});

expiryDateInput.addEventListener("input", (event) => {
  formatExpiryDate(event.target, event);
});

CVCInput.addEventListener("keyup", (event) => {
  backspaceHandle(event.target, event, "exp-date");
});

CVCInput.addEventListener("input", (event) => {
  formatCVC(event.target, event);
});

phoneInput.addEventListener("input", (event) => {
  formatPhone(event.target, event);
});

// IntlTelInput Phone Number
var input = document.querySelector("#phone");
window.intlTelInput(input, {
  initialCountry: "auto",
  geoIpLookup: function (callback) {
    $.get("https://ipinfo.io", function () {}, "jsonp").always(function (resp) {
      var countryCode = resp && resp.country ? resp.country : "";
      callback(countryCode);
    });
  },
  utilsScript:
    "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.min.js", // just for formatting/placeholders etc
});

// Store Payment to DB and Redirect to Success or Failed
function storePaymentApi(paymentDBData, route) {
  axios({
      url: route,
      method: 'POST',
      headers: {
          'Accept': 'application/json',
          'Content-Type': 'application/json;charset=UTF-8',
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
      data: paymentDBData
  }).then(function (response) { 
      if(response.data.success){
          window.location.href = response.data.route;
      }

      if(response.data.failed){
          window.location.href = response.data.route;
      }
  });
}