<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColorDescToRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('roles', function (Blueprint $table) {
            $table->string('description')->nullable()->after('guard_name');
            $table->string('color')->nullable()->after('description');
            $table->text('metadata')->nullable()->after('color');
            $table->unsignedTinyInteger('status')->default(1)->after('metadata');
            $table->bigInteger('created_by')->unsigned()->index()->after('status');
            $table->bigInteger('updated_by')->unsigned()->index()->nullable()->after('created_by');
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('roles', function (Blueprint $table) {

             $table->dropColumn('description');
             $table->dropColumn('color');
             $table->dropColumn('metadata');
             $table->dropColumn('status');
             $table->dropColumn('created_by');
             $table->dropColumn('updated_by');
        });
    }
}
