<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class VisitedCustomersListTableAndAddingColumnInLink extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visited_links', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('payment_link_id')->unsigned()->index()->nullable();
            $table->foreign('payment_link_id')->references('id')->on('payment_links')->onDelete('cascade')->onUpdate('cascade');
            $table->string('ip', 40)->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visited_links');
    }
}
