<?php

namespace App\Classes;

use Illuminate\Http\Request;
use App\Models\EmailTemplate;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailTemplate;
use App\Jobs\MailTemplateJob;
use App\Models\User;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Blade;


class SendTestInvoice
{
  public $brandSetting;
  public $invoice;
  public $user;
  public $type;
  public $templateName;
  public $template;
  public $pdf;
  public $testEmails;
  public $testEmailsCC;
  
  function __construct($brandSetting, User $user, $templateName, $testData)
  {
    $this->brandSetting = $brandSetting;
    $this->user = $user;
    $this->templateName = $templateName;
    $this->testEmails = $testData['emails'];
    $this->testEmailsCC = $testData['ccEmails'];
    $this->invoiceTemplate();
  }

  function invoiceTemplate()
  {
    $sendmail = EmailTemplate::where('name', "{$this->templateName}");

    if ($sendmail->exists()) {
      $this->template = $sendmail->first();
      $setSMTP = new SmtpConfig('billing', $this->template->from);
    } else {
      throw new \ErrorException("Email template doesn't exists.");
    }
  }

  function render($template)
  {

    $this->invoice = Blade::render($template->content, $this->brandSetting->toArray());
    return Blade::render('admin.emailtemplates.invoice', ['data' => $this->invoice]);
  }

  function generate()
  {
    $parseHTML = Blade::render($this->template->content, $this->brandSetting);
    $downloadPdf = $this->pdf = Pdf::loadHTML($parseHTML);
    return $downloadPdf->download('invoice.pdf');
  }

  function mail()
  {
    $data = Blade::render($this->template->content, $this->brandSetting);
    $mailInvoice = Mail::to($this->testEmails);

    if (!empty($this->testEmailsCC)) {
      $mailInvoice->cc($this->testEmailsCC);
    }

    if (!empty($this->template->bcc)) {
      $mailInvoice->bcc(json_decode($this->template->bcc));
    }

    $mailInvoice->queue(new MailTemplate($data, $this->template->subject));
  }
}
