<?php

namespace App\Services;

use App\Repositories\VideoBrief\VideoBriefRepository;

use Exception;
use Illuminate\Http\Request;

class VideoBriefService
{

    private $videoBriefRepository, $streakService;

    public function __construct(VideoBriefRepository $videoBriefRepository, StreakService $streakService)
    {
        $this->videoBriefRepository = $videoBriefRepository;
        $this->streakService = $streakService;
    }

    public function create($briefDetails)
    {
        try {
            $brief = $this->videoBriefRepository->createBrief($briefDetails);

            $this->streakService->createBox([
                "name" => $data['name'] ?? '',
                "company_name" => '',
                "phone_number" => $brief['phone_number'] ?? '',
                "industry" => $brief['industry'] ?? '',
                "brief_url" => !empty($brief['encoded_id']) ? route('frontend.video.brief.view', $brief['encoded_id']) : '',
                "email" => $brief['email'] ?? '',
            ]);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function list(Request $request)
    {
        try {
            $briefs = $this->videoBriefRepository->getAllBriefs($request);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetchByEncodedID($briefID, $authenticated = false)
    {
        try {
            $brief = $this->videoBriefRepository->getByEncodedID($briefID, $authenticated);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getBrief($id)
    {
        try {
            $briefs = $this->videoBriefRepository->getBrief($id);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

}