<?php

namespace App\Services;

use App\Repositories\Team\TeamInterface;
use Exception;

class TeamService
{
    private $teamRepository;

    public function __construct(TeamInterface $teamRepository)
    {
        $this->teamRepository = $teamRepository;
    }

    public function create($teamDetails)
    {
        try {
            $team = $this->teamRepository->addOrUpdate($teamDetails);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getTeamById($teamID)
    {
        try {
            $team = $this->teamRepository->team($teamID);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function updateTeam($teamDetails)
    {
        try {
            $team = $this->teamRepository->addOrUpdate($teamDetails);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function archiveTeam($teamID)
    {
        try {
            $team = $this->teamRepository->softDeleteTeam($teamID);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function deleteTeam($teamID)
    {
        try {
            $team = $this->teamRepository->forceDeleteTeam($teamID);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function restoreTeam($teamID)
    {
        try {
            $team = $this->teamRepository->restoreTeam($teamID);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function updateTeamMetadata($teamDetails)
    {
        try {
            $team = $this->teamRepository->updateTeamMetadata($teamDetails);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
}
