<?php

namespace App\Services;

use App\Exceptions\StripeException;
use BadMethodCallException;
use Exception;
use Illuminate\Support\Facades\Log;
use Stripe\Exception\AuthenticationException;
use Stripe\Exception\ApiErrorException;
use Stripe\Exception\CardException;
use Stripe\Exception\RateLimitException;
use Stripe\Exception\InvalidRequestException;
use Stripe\Exception\ApiConnectionException;
use Stripe\Exception\IdempotencyException;
use Stripe\Exception\PermissionException;
use Stripe\Exception\UnknownApiErrorException;
use UnexpectedValueException;

class StripeErrorHandler
{
    public static function handle(Exception $e, $token="")
    {
        if (
            $e instanceof AuthenticationException ||
            $e instanceof ApiErrorException ||
            $e instanceof CardException ||
            $e instanceof RateLimitException ||
            $e instanceof InvalidRequestException ||
            $e instanceof ApiConnectionException ||
            $e instanceof BadMethodCallException ||
            $e instanceof IdempotencyException ||
            $e instanceof PermissionException ||
            $e instanceof UnexpectedValueException ||
            $e instanceof UnknownApiErrorException
        ) {
            $errorDetails = [
              'message' => $e->getMessage(),
              'code' => $e->getCode(), 
              'type' => $e->getError()->type,
              'param' => $e->getError()->param,
              'decline_code' => $e->getError()->decline_code,
              'http_status' => $e->getHttpStatus(),
              'request_id' => $e->getRequestId(),
              // Add more details as needed
            ];
            Log::error("Token: ".$token." has an exception on ".get_class($e).".Status code: ".$errorDetails['http_status'].", Code: ".$errorDetails['code']." Message: ".$e->getMessage());
            // throw new Exception($errorDetails['code'].'|'.$errorDetails['type'].'|'.$errorDetails['message'], $errorDetails['http_status']);
            throw new StripeException($e->getMessage(), $e->getError()->type, $e->getHttpStatus(), $e->getRequestId(),$e->getCode(), $e->getError());
        } else {
            Log::error("Token: ".$token." has an exception on ".get_class($e).". Message: ".$e->getMessage());
            throw new StripeException($e->getMessage(), $e->getCode(), 402, '', $e->getCode(), [
                'code'=> $e->getCode(),
                'type'=> 'generic_error',
                'code'=> $e->getCode(),
                'http_status' => 402,
            ]);
        }
    }
}