<?php

namespace App\Services;

use App\Repositories\SemBrief\SemBriefRepository;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SemBriefService
{

    private $semBriefRepository, $streakService;

    public function __construct(SemBriefRepository $semBriefRepository, StreakService $streakService)
    {
        $this->semBriefRepository = $semBriefRepository;
        $this->streakService = $streakService;

    }

    public function create($briefDetails)
    {
        try {
            $brief = $this->semBriefRepository->createBrief($briefDetails);

            $this->streakService->createBox([
                "name" => $data['name'] ?? '',
                "company_name" => $brief['business_name'] ?? '',
                "phone_number" => $brief['phone_number'] ?? '',
                "industry" => '',
                "brief_url" => !empty($brief['encoded_id']) ? route('frontend.sem.brief.view', $brief['encoded_id']) : '',
                "email" => $brief['email'] ?? '',
            ]);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function list(Request $request)
    {
        try {
            $briefs = $this->semBriefRepository->getAllBriefs($request);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetchByEncodedID($briefID, $authenticated = false)
    {
        try {
            $brief = $this->semBriefRepository->getByEncodedID($briefID, $authenticated);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getBrief($id)
    {
        try {
            $brief = $this->semBriefRepository->getBrief($id);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

}