<?php

namespace App\Services\Payment\Stripe;

use App\Services\StripeErrorHandler;
use Exception;

class PaymentIntent extends Stripe
{
    public function get($intentId)
    {
        try {
            $this->paymentSetting();
            $intent = $this->stripe->paymentIntents->retrieve($intentId);

            return $intent;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }

    public function create($itemDetails, $customerID, $metadata, $price=0, $payment_method_id = "")
    {
        try {
            $this->paymentSetting();
            $object = [
                'customer' => $customerID,
                'description' => $itemDetails->item_name,
                'amount' => $itemDetails->price * 100,
                'currency' => $itemDetails->currencyCountry->code,
                'statement_descriptor' => $this->statement_descriptor,
                'metadata'=> $metadata ?? [],
            ];

            if(str_contains($itemDetails->gateway->gateway, 'three_step')) {
                $object['amount'] = ($itemDetails->price - 1) * 100;
            }

            if($itemDetails->gateway->gateway == 'afterpay') {
                $object['payment_method_types'] = ['afterpay_clearpay'];
            } else {
                $object['automatic_payment_methods'] = [
                    'enabled' => true,
                    'allow_redirects' => 'never'
                ];
                $object['setup_future_usage'] = 'off_session';
            }

            if($price > 0) {
                $object['amount'] = $price * 100;
                
                if(!empty($object['setup_future_usage'])) {
                    unset($object['setup_future_usage']);
                }
            }

            if($payment_method_id != "") {
                $object['payment_method'] = $payment_method_id;
            }

            $paymentIntent = $this->stripe->paymentIntents->create($object);

            // Payment Log here

            return $paymentIntent;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }

    public function update($paymentIntentID, $data)
    {
        try {
            $this->paymentSetting();
            $paymentIntent = $this->stripe->paymentIntents->update($paymentIntentID, $data);

            return $paymentIntent;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }

    public function list($limit=5) {
        try {
            $this->paymentSetting();
            $paymentIntents = $this->stripe->paymentIntents->all([]);

            return $paymentIntents;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }
}
