<?php

namespace App\Services\Payment\Stripe;

use App\Services\StripeErrorHandler;
use Exception;

class Customer extends Stripe
{
    public function create($customerData, $item)
    {
        try {
            $this->paymentSetting();

            $customer = $this->stripe->customers->create([
                'description' => $item->item_name,
                'email' => $customerData->email,
                'phone' => $customerData->phone,
                'name' => $customerData->first_name . ' ' . $customerData->last_name,
                'address' => [
                    "line1" => $customerData->address,
                    "city" => $customerData->city,
                    "country" => $customerData->country,
                    "state" => $customerData->state,
                ],
                'metadata' => array(
                    "token" => $item->token,
                    "item" => $item->item_name,
                    "first_name" => $customerData->first_name,
                    "last_name" => $customerData->last_name,
                    "email" => $customerData->email,
                    "phone" => $customerData->phone,
                    "company" => $customerData->company,
                    "address" => $customerData->address,
                    "city" => $customerData->city,
                    "country" => $customerData->country,
                    "zipcode" => $customerData->zipcode,
                )
            ]);

            return $customer;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }

    public function attach($paymentMethodID, $customerID)
    {
        try {
            $this->paymentSetting();
            $payment_method = $this->stripe->paymentMethods->retrieve($paymentMethodID);
            // Attaching Customer with Payment Method
            $payment_method->attach([
                ['customer' => $customerID]
            ]);

            return $payment_method;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }
}
